<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>

<?php
$empreendimentos = $this->get('empreendimentos');
$permissoes = $this->get('permissoes');
$contratos = $this->get('contratos');

$readOnly = $permissoes ? 'readonly' : '';
?>

<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Permisses', 'Acade Portal'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <!-- MENSAGENS -->
            <?php if ($_GET['msg'] == 'success') : ?>
                <div class="alert alert-success alert-dismissable msgSucess">Operao realizada com sucesso.</div>
            <?php elseif ($_GET['msg'] == 'fail'): ?>
                <div class="alert alert-danger alert-dismissable msgErros">No foi possvel realizar esta operao. Verifique se os contrato(s) ou Empreendimento(s) selecionado(s) j possuem permisso.</div>
            <?php else: ?>
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0) : ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message) : ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            <form action="" method="POST" id="form">
                <fieldset>
                    <legend>Informaes das permisses <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span></legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="id_empreendimento">
                                    Empreendimento:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 empreendimento_permissao"
                                        id="empreendimento" name="empreendimento" required="required"
                                        data-placeholder="Selecione o empreendimento" <?= $readOnly; ?>>
                                        <?php if ($permissoes) : ?>
                                            <option value="<?= $permissoes['id_empreendimento']; ?>" selected><?= $permissoes['nm_empreendimento']; ?></option>
                                        <?php else : ?>
                                            <option value=""></option>
                                            <?php foreach ($empreendimentos as $empreendimento) : ?>
                                                <option value=" <?= $empreendimento['id']; ?> "> <?= $empreendimento['nm_empreendimento']; ?> </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <label class="control-label col-sm-6">Permisses:</label>
                        </div>
                        <div class="col-sm-12">
                            <div class="checkbox">
                                <label for="tpPermissaoN" class="control-label">
                                    <input class="checkbox icheck" type="checkbox" name="tipos[]" id="tpPermissaoN" value="N" 
                                    <?= ($permissoes['fl_negociacao'] == '1') ? 'checked' : ''; ?> >
                                    Negociao
                                </label>
                                <label for="tpPermissaoAD" class="control-label">
                                    <input class="checkbox icheck" type="checkbox" name="tipos[]" id="tpPermissaoAD" value="AD"
                                    <?= ($permissoes['fl_altera_dados'] == '1') ? 'checked' : ''; ?> >
                                    Alterar dados
                                </label>
                                <label for="tpPermissaoB" class="control-label">
                                    <input class="checkbox icheck" type="checkbox" name="tipos[]" id="tpPermissaoB" value="B"
                                    <?= ($permissoes['fl_boletos'] == '1') ? 'checked' : ''; ?> >
                                    Boletos
                                </label>
                                <label for="tpPermissaoE" class="control-label">
                                    <input class="checkbox icheck" type="checkbox" name="tipos[]" id="tpPermissaoE" value="E"
                                    <?= ($permissoes['fl_extrato'] == '1') ? 'checked' : ''; ?> >
                                    Extrato
                                </label>
                                <label for="tpPermissaoIR" class="control-label">
                                    <input class="checkbox icheck" type="checkbox" name="tipos[]" id="tpPermissaoIR" value="IR"
                                    <?= ($permissoes['fl_imposto_renda'] == '1') ? 'checked' : ''; ?> >
                                    Imposto de renda
                                </label>
                            </div>
                        </div>
                    </div>
                    <legend class="tituloEmp" style="cursor: pointer; font-size: 20px;margin-top:15px;">Permisses por cliente <i id="seta_1" class="fa fa-caret-up"></i></legend>
                    <div class="row permissaoContrato" hidden>
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="contrato">
                                    Cliente:
                                </label>
                                <select class="form-control select2 contrato_permissao" name="contrato[]"
                                    id="contrato" data-placeholder="Selecione..." multiple="multiple">

                                    <?php if ($contratos) : ?>
                                        <?php foreach ($contratos as $contrato) : ?>
                                            <option value="<?= $contrato['id']; ?>"> 
                                                <?= $contrato['nm_pessoa'] . ' - ' . ($contrato['nr_cpf'] ? 'CPF: ' . $contrato['nr_cpf'] : 'CNPJ: ' . $contrato['nr_cnpj']); ?> 
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>

                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row permissaoContrato" hidden>
                        <div class="col-sm-6">
                            <label class="control-label col-sm-6">Permisses:</label>
                        </div>
                        <div class="col-sm-12">
                            <div class="checkbox">
                                <label for="tpPermissaoClienteN" class="control-label">
                                    <input class="checkbox icheck" type="checkbox" name="tiposCliente[]" id="tpPermissaoClienteN" value="N">
                                    Negociao
                                </label>
                                <label for="tpPermissaoClienteAD" class="control-label">
                                    <input class="checkbox icheck" type="checkbox" name="tiposCliente[]" id="tpPermissaoClienteAD" value="AD">
                                    Alterar dados
                                </label>
                                <label for="tpPermissaoClienteB" class="control-label">
                                    <input class="checkbox icheck" type="checkbox" name="tiposCliente[]" id="tpPermissaoClienteB" value="B">
                                    Boletos
                                </label>
                                <label for="tpPermissaoClienteE" class="control-label">
                                    <input class="checkbox icheck" type="checkbox" name="tiposCliente[]" id="tpPermissaoClienteE" value="E">
                                    Extrato
                                </label>
                                <label for="tpPermissaoClienteIR" class="control-label">
                                    <input class="checkbox icheck" type="checkbox" name="tiposCliente[]" id="tpPermissaoClienteIR" value="IR">
                                    Imposto de renda
                                </label>
                            </div>
                        </div>
                    </div>
                </fieldset>

                <fieldset>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Adicionar">
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>

        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>
