<?php

class PermissoesController extends Controller {

    protected $tb_mpreendimento;
    protected $tb_permissoes_portal;

    public function __construct($request) {
        
        parent::__construct($request);

        $this->tb_empreendimento = new Empreendimento();
        $this->tb_permissoes_portal = new PermissoesPortal();
    }

    public function indexAction () {
        $this->redirect(array('m' => 'portal', 'c' => 'permissoes', 'a' => 'listar'));
    }

    public function listarAction () {

        if (Helper::verificaAjax())
        {
            $listaPermissoes = PermissoesPortal::getListaPermissoes ();
            $lista = array();

            foreach ($listaPermissoes as $item)
            {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';

                $title = "return confirm('Tem certeza que deseja remover esta permisso?')";

                $acoes .= '<a onclick="' . $title . '"  href="?m=portal&c=permissoes&a=remover&id=' . $item['id'] . 
                    '" data-toggle="tooltip" title="REMOVER" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' .
                    $item['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" 
                    style="margin-right:5px"><i class="fa fa-edit"></i></a>';

                $negociacaoStatus = ($item['fl_negociacao'] == '1') ? '<div align="center"><a onclick="mudaTipoTb(this)" name="negociacao" id="' . $item['id'] . '" class="label label-success">Ativo</a></div>' : '<div align="center"><a onclick="mudaTipoTb(this)" name="negociacao" id="' . $item['id'] . '" class="label label-danger">Inativo</a></div>';
                $alteraDadosStatus = ($item['fl_altera_dados'] == '1') ? '<div align="center"><a onclick="mudaTipoTb(this)" name="alteraDados" id="' . $item['id'] . '" class="label label-success">Ativo</a></div>' : '<div align="center"><a onclick="mudaTipoTb(this)" name="alteraDados" id="' . $item['id'] . '" class="label label-danger">Inativo</a></div>';
                $boletoStatus = ($item['fl_boletos'] == '1') ? '<div align="center"><a onclick="mudaTipoTb(this)" name="boleto" id="' . $item['id'] . '" class="label label-success">Ativo</a></div>' : '<div align="center"><a onclick="mudaTipoTb(this)" name="boleto" id="' . $item['id'] . '" class="label label-danger">Inativo</a></div>';
                $extratoStatus = ($item['fl_extrato'] == '1') ? '<div align="center"><a onclick="mudaTipoTb(this)" name="extrato" id="' . $item['id'] . '" class="label label-success">Ativo</a></div>' : '<div align="center"><a onclick="mudaTipoTb(this)" name="extrato" id="' . $item['id'] . '" class="label label-danger">Inativo</a></div>';
                $impostoRenda = ($item['fl_imposto_renda'] == '1') ? '<div align="center"><a onclick="mudaTipoTb(this)" name="impostoRenda" id="' . $item['id'] . '" class="label label-success">Ativo</a></div>' : '<div align="center"><a onclick="mudaTipoTb(this)" name="impostoRenda" id="' . $item['id'] . '" class="label label-danger">Inativo</a></div>';
                
                $acoes .= '</div>';
                $acoes .= '</div>';

                $lista[] = array(
                    'codigo' => utf8_encode($item['id']),
                    'empreendimento' => utf8_encode($item['nm_empreendimento']),
                    'boleto' => utf8_encode($boletoStatus),
                    'alteraDados' => utf8_encode($alteraDadosStatus),
                    'negociacao' => utf8_encode($negociacaoStatus),
                    'extrato' => utf8_encode($extratoStatus),
                    'impostoRenda' => utf8_encode($impostoRenda),
                    'acoes' => utf8_encode($acoes)
                );
            }

            echo json_encode(array(
                'draw' => $_POST['draw'],
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function alterarAction () {

        $empreendimentos = $this->tb_empreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), '*');

        //Busca somente os empreendimentos do qual o usurio tem acesso.
        if ($_SESSION['usuario']) 
        {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) 
                {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $empreendimentos = $empreendimentos->order('e.nm_empreendimento')
            ->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);
        
        if ($this->_isPost && $this->validaCampos())
        {
            try {
                $permissaoPortal = new PermissoesPortal();
                $transaction = $permissaoPortal->getAdapter()->beginTransaction();                
                
                if (isset($_POST['contrato']) && $_POST['contrato'][0] == '*')
                {
                    $contratos = $this->pessoaByEmpreendimentoPortal($_POST['empreendimento']);
                    
                    $lista = array();
                    
                    foreach ($contratos as $contrato)
                    {
                        $lista[] = $contrato['id'];
                    }
                    
                    $contratos = $this->removeContratosRepetidos($lista, $_POST['empreendimento']);

                } elseif (isset($_POST['contrato'])) {
                    $contratos = $this->removeContratosRepetidos($_POST['contrato'], $_POST['empreendimento']);
                }   
                
                if ($contratos)
                {
                    if (!$this->buscaPermissoesPorEmpreendimento($_POST['empreendimento']))
                    {
                        //Salva permisses do empreendimento
                        $permissaoPortal = $permissaoPortal->createRow();
                        $permissaoPortal->id_pessoa = null;
                        $permissaoPortal->id_empreendimento = $_POST['empreendimento'];
                        $permissaoPortal->fl_negociacao = '0';
                        $permissaoPortal->fl_altera_dados = '0';
                        $permissaoPortal->fl_boletos = '0';
                        $permissaoPortal->fl_extrato = '0';
                        $permissaoPortal->fl_imposto_renda = '0';
    
                        foreach ($_POST['tipos'] as $tipo)
                        {
                            switch ($tipo) 
                            {
                                case 'N' :
                                    $permissaoPortal->fl_negociacao = '1';
                                    break;
                                case 'AD' :
                                    $permissaoPortal->fl_altera_dados = '1';
                                    break;
                                case 'B' :
                                    $permissaoPortal->fl_boletos = '1';
                                    break;
                                case 'E' :
                                    $permissaoPortal->fl_extrato = '1';
                                    break;
                                case 'IR' :
                                    $permissaoPortal->fl_imposto_renda = '1';
                                    break;
                            }
                        }
    
                        $permissaoPortal->log = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';
                        $permissaoPortal->save();
                    }
                    
                    $permissaoPortal = new PermissoesPortal();
                    
                    //Salva permissao dos clientes
                    foreach ($contratos as $contrato)
                    {
                        $permissaoPortal = $permissaoPortal->createRow();
                        $permissaoPortal->id_pessoa = $contrato;
                        $permissaoPortal->id_empreendimento = $_POST['empreendimento'];
                        $permissaoPortal->fl_negociacao = '0';
                        $permissaoPortal->fl_altera_dados = '0';
                        $permissaoPortal->fl_boletos = '0';
                        $permissaoPortal->fl_imposto_renda = '0';
    
                        foreach ($_POST['tiposCliente'] as $tipo)
                        {
                            switch ($tipo) 
                            {
                                case 'N' :
                                    $permissaoPortal->fl_negociacao = '1';
                                    break;
                                case 'AD' :
                                    $permissaoPortal->fl_altera_dados = '1';
                                    break;
                                case 'B' :
                                    $permissaoPortal->fl_boletos = '1';
                                    break;
                                case 'E' :
                                    $permissaoPortal->fl_extrato = '1';
                                    break;
                                case 'IR' :
                                    $permissaoPortal->fl_imposto_renda = '1';
                                    break;
                            }
                        }
    
                        $permissaoPortal->log = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';
                        $permissaoPortal->save();
    
                        $permissaoPortal = new PermissoesPortal();
                    }
                } else {
                        $empreendimentoNaoCadastrado = $this->buscaPermissoesPorEmpreendimento($_POST['empreendimento']);

                        if (!$empreendimentoNaoCadastrado)
                        {
                            $permissaoPortal = $permissaoPortal->createRow();
                            $permissaoPortal->id_pessoa = null;
                            $permissaoPortal->id_empreendimento = $_POST['empreendimento'];
                            $permissaoPortal->fl_negociacao = '0';
                            $permissaoPortal->fl_altera_dados = '0';
                            $permissaoPortal->fl_boletos = '0';
                            $permissaoPortal->fl_extrato = '0';
                            $permissaoPortal->fl_imposto_renda = '0';
        
                            foreach ($_POST['tipos'] as $tipo)
                            {
                                switch ($tipo) 
                                {
                                    case 'N' :
                                        $permissaoPortal->fl_negociacao = '1';
                                        break;
                                    case 'AD' :
                                        $permissaoPortal->fl_altera_dados = '1';
                                        break;
                                    case 'B' :
                                        $permissaoPortal->fl_boletos = '1';
                                        break;
                                    case 'E' :
                                        $permissaoPortal->fl_extrato = '1';
                                        break;
                                    case 'IR' :
                                        $permissaoPortal->fl_imposto_renda = '1';
                                        break;
                                }
                            }
        
                            $permissaoPortal->log = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';
                            $permissaoPortal->save();
                        }
                    }

                $transaction->commit();

                if ((isset($_POST['contrato']) == true && !$contratos) || $empreendimentoNaoCadastrado) 
                    $this->redir(array("modulo" => "portal", "controller" => "permissoes", "action" => "alterar"), array("msg" => "fail"));
                else
                    $this->redir(array("modulo" => "portal", "controller" => "permissoes", "action" => "alterar"), array("msg" => "success"));

            } catch (Exception $e) {
                $transaction->rollBack();
                $this->_helper->addMensagem('erro', 'No foi possvel realizar esta operao.', array("msg" => "fail"));
            }
        }

        $this->display('form');
    }

    public function editarAction ()
    {
        $permissoes = $this->buscaPermissoesPorEmpreendimento(null, $_GET['id']);
        $contratos = $this->pessoaByEmpreendimentoPortal($permissoes['id_empreendimento']);
        
        if ($this->_isPost)
        {
            $db = Zend_Db_Table::getDefaultAdapter();
            $db->beginTransaction();

            if ($_POST['contrato'])
            {
                foreach ($_POST['contrato'] as $contrato)
                {
                    $permissaoContrato = new PermissoesPortal();

                    $verificaContrato = (new PermissoesPortal())->fetchRow('id_pessoa = ' . $contrato);

                    if (!$verificaContrato)
                    {
                        $permissaoContrato = $permissaoContrato->createRow();
                        $permissaoContrato->id_pessoa = $contrato;
                        $permissaoContrato->id_empreendimento =  $permissoes['id_empreendimento'];
                    } else {
                        $permissaoContrato = $verificaContrato;
                    }
                    
                    $permissaoContrato->fl_negociacao = '0';
                    $permissaoContrato->fl_altera_dados = '0';
                    $permissaoContrato->fl_boletos = '0';
                    $permissaoContrato->fl_extrato = '0';
                    $permissaoContrato->fl_imposto_renda = '0';

                    foreach ($_POST['tiposCliente'] as $tipo)
                    {
                        switch ($tipo) 
                        {
                            case 'N' :
                                $permissaoContrato->fl_negociacao = '1';
                                break;
                            case 'AD' :
                                $permissaoContrato->fl_altera_dados = '1';
                                break;
                            case 'B' :
                                $permissaoContrato->fl_boletos = '1';
                                break;
                            case 'E' :
                                $permissaoContrato->fl_extrato = '1';
                                break;
                            case 'IR' :
                                $permissaoContrato->fl_imposto_renda = '1';
                                break;
                        }
                    }

                    $permissaoContrato->log = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';
                    $permissaoContrato->save();
                }
            }

            $permissao = (new PermissoesPortal())->fetchRow('id = '.$this->_helper->filters($_GET['id']) . ' AND id_pessoa is null');
            
            $permissao->fl_negociacao = '0';
            $permissao->fl_altera_dados = '0';
            $permissao->fl_boletos = '0';
            $permissao->fl_extrato = '0';
            $permissao->fl_imposto_renda = '0';

            foreach ($_POST['tipos'] as $tipo)
            {
                switch ($tipo) 
                {
                    case 'N' :
                        $permissao->fl_negociacao = '1';
                        break;
                    case 'AD' :
                        $permissao->fl_altera_dados = '1';
                        break;
                    case 'B' :
                        $permissao->fl_boletos = '1';
                        break;
                    case 'E' :
                        $permissao->fl_extrato = '1';
                        break;
                    case 'IR' :
                        $permissao->fl_imposto_renda = '1';
                        break;
                }
            }

            $permissao->log = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';
            $permissao->save();
            
            $db->commit();
            $this->redir(array("modulo" => "portal", "controller" => "permissoes", "action" => "listar"), array("msg" => "success"));
        }

        $this->set('permissoes', $permissoes);
        $this->set('contratos', $contratos);
        $this->display('form');
    }

    public function pessoasByEmpreendimentoAction() {

        $contratos = $this->pessoaByEmpreendimentoPortal($_POST['idEmpreendimento']);
        $lista[] = array('id' => '*', 'text' => 'Todos');
        $documento = '';

        foreach ($contratos as $contrato) {
            $documento = $contrato['nr_cpf'] ? ' - CPF: ' . $contrato['nr_cpf'] : ' - CNPJ: ' . $contrato['nr_cnpj'];

            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa'] . $documento));
        }

        echo json_encode($lista);
    }

    private function pessoaByEmpreendimentoPortal ($idEmpreendimento)
    {
        $empreendimento = new Empreendimento();
        $pessoas = $empreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), '')
            ->join(array('ps' => TB_PORTAL_SENHA), 'ps.id_empreendimento = e.id', '')
            ->join(array('p' => TB_PESSOA), 'p.id = ps.id_cliente', array('p.id', 'p.nm_pessoa'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'ps.id_cliente = pf.id_pessoa', 'nr_cpf')
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'ps.id_cliente = pj.id_pessoa', 'nr_cnpj')
            ->where('e.id = '. $idEmpreendimento)
            ->order('p.nm_pessoa')
            ->query()->fetchAll();

        return $pessoas;
    }

    public function mudaTipoTbAction()
    {
        if ($this->isAjax()) 
        {
            $permissoes = $this->tb_permissoes_portal->fetchRow('id = ' . $_POST['idPermissao']);
            $statusCampo = '';

            switch ($_POST['tipo'])
            {
                case 'boleto' :
                    if ($permissoes['fl_boletos'] == '0') {
                        $permissoes->fl_boletos = '1';
                        $statusCampo = 'Ativo';
                    }
                    else {
                        $permissoes->fl_boletos = '0';
                        $statusCampo = 'Inativo';
                    }

                    break;
                
                case 'alteraDados' :
                    if ($permissoes['fl_altera_dados'] == '0') {
                        $permissoes->fl_altera_dados = '1';
                        $statusCampo = 'Ativo';
                    }
                    else {
                        $permissoes->fl_altera_dados = '0';
                        $statusCampo = 'Inativo';
                    }

                    break;
                
                case 'negociacao' :
                    if ($permissoes['fl_negociacao'] == '0') {
                        $permissoes->fl_negociacao = '1';
                        $statusCampo = 'Ativo';
                    }
                    else {
                        $permissoes->fl_negociacao = '0';
                        $statusCampo = 'Inativo';
                    }

                    break;

                case 'extrato' :
                    if ($permissoes['fl_extrato'] == '0') {
                        $permissoes->fl_extrato = '1';
                        $statusCampo = 'Ativo';
                    }
                    else {
                        $permissoes->fl_extrato = '0';
                        $statusCampo = 'Inativo';
                    }

                    break;

                case 'impostoRenda' :
                    if ($permissoes['fl_imposto_renda'] == '0') {
                        $permissoes->fl_imposto_renda = '1';
                        $statusCampo = 'Ativo';
                    }
                    else {
                        $permissoes->fl_imposto_renda = '0';
                        $statusCampo = 'Inativo';
                    }

                    break;
            }

            //guarda o status anterior e a pessoa que alterou o mesmo no Contato.
            $statusAnterior = ($statusCampo == '1') ? 'Inativo' : 'Ativo';

            (new Relacionamento())->saveContato(200, date('Y-m-d'), $_POST['idPermissao'], 'Log: Permisso Acade Portal alterada - De: ' . $statusAnterior . ' - Para: ' . $statusCampo . ' - Por: ' . Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s'));

            echo json_encode(array('save' => $permissoes->save() ? 1 : 0, 'value' => $statusCampo));
        }
    }

    public function removerAction ()
    {
        try {
            (new PermissoesPortal())->delete('id = "' . $_GET['id'] . '"');

            $this->redir(array("modulo" => "portal", "controller" => "permissoes", "action" => "listar"), array("msg" => "success"));
        } catch (Exception $e) {
            $this->redir(array("modulo" => "portal", "controller" => "permissoes", "action" => "listar"), array("msg" => "fail"));
        }
    }

    public function validaCampos ()
    {
        if (!$_POST['empreendimento'])
        {
            $this->_helper->addMensagem('empreendimento', 'Selecione o empreendimento');
        } elseif (isset($_POST['contrato'])) {
            if (count($_POST['contrato']) < 1 && $_POST['contrato'] != '*') {
                $this->_helper->addMensagem('contrato', 'Selecione pelo menos um contrato.');
            }
        }

        return (!count($this->_helper->getMensagens()) > 0);
    }

    //Mtodo para retornar somente os contratos selecionados que no esto salvos na tabela PERMISSOES_PORTAL.
    public function removeContratosRepetidos ($contratos, $empreendimento) 
    {
        $contratosPermissoes = (new PermissoesPortal())->fetchAll('id_empreendimento = ' . $empreendimento);

        if ($contratosPermissoes)
        {
            $listaPermissoes = array();
            $listaContratos = array();

            foreach ($contratosPermissoes as $contrato)
            {
                $listaPermissoes[] = $contrato['id_pessoa'];
            }
            
            foreach ($contratos as $contrato2)
            {
                $listaContratos[] = $contrato2;
            }
            
            return array_diff($listaContratos, $listaPermissoes);
        }
    }

    public function buscaPermissoesPorEmpreendimento($idEmpreendimento = null, $idPermissao = null)
    {
        $permissao = $this->tb_permissoes_portal->getDefaultAdapter()->select()
            ->from(['p' => TB_PERMISSOES_PORTAL], '*');

        if ($idEmpreendimento)
            $permissao = $permissao->where('p.id_empreendimento = ' . $idEmpreendimento . ' AND id_pessoa is null');
        elseif ($idPermissao)
            $permissao = $permissao->where('p.id = ' . $idPermissao);

        $permissao = $permissao->join(['e' => TB_EMPREENDIMENTO], 'p.id_empreendimento = e.id', 'nm_empreendimento')
            ->order('e.nm_empreendimento')->query()->fetch();
           
        return $permissao;
    }

    public function buscaPermissoesPorPessoaAction()
    {
        $idPessoa = explode(',', $_POST['idPessoa']);
        $permissao = new PermissoesPortal();
        $pessoa = null;
        $tamanhoArray = count($idPessoa);

        if ($tamanhoArray == 1)
        {
            $pessoa = $permissao->getDefaultAdapter()->select()
                ->from(array('p' => TB_PERMISSOES_PORTAL), array('fl_negociacao', 'fl_altera_dados', 'fl_boletos', 'fl_extrato', 'fl_imposto_renda'))
                ->where('p.id_pessoa = ' . $idPessoa[0])
                ->query()->fetch();
        }

        echo json_encode(array('pessoa' => $pessoa, 'tamanho' => $tamanhoArray));
    }
}