<?php

class LoginController extends Controller
{

    private $tb_empreendimento;
    private $tb_usuarios;
    private $tb_contratos;
    private $tb_pessoa;
    private $tb_cidade;
    private $tb_portal_senha;

	public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_usuarios = new PortalSenha();
        $this->tb_contratos = new Contrato();
        $this->tb_pessoa = new Pessoa();
        $this->tb_cidade = new Db_Cidade();
        $this->tb_modeloArquivo = new ModeloArquivo();
        $this->tb_portal_senha = new PortalSenha();
    }

	    public function indexAction()
    {
        $this->redir(array("modulo" => "portal", "controller" => "login", "action" => "listar"));
    }

    public function listarAction()
    {
        $tb_cliente = new Db_Cliente();
        $nomeCliente = $tb_cliente->fetchRow();
        
        $this->set('nomeCliente', $nomeCliente);
        $this->display('listar');
    }

    public function editarAction()
    {
        $this->display('resetar');
    }

    //Lista todos os login gerardos que estão ativos
    public function listaLoginAction()
    {
        $users = [];
        if ($this->isAjax()) {

            $usuarios = $this->tb_usuarios->getAdapter()->select()
                ->from(array("po" => TB_PORTAL_SENHA), array('codigo'=>'id','login', 'id_cliente'))
                ->join(array('p' =>  TB_PESSOA), 'p.id = po.id_cliente', array('nm_pessoa'))
                ->join(array("em" => TB_EMPREENDIMENTO), 'em.id = po.id_empreendimento', array('nm_empreendimento'))
                ->join(array('co' =>  TB_CONTRATO), 'co.id = po.id_contrato', array('id_contrato'=>'id'))
                ->join(array('lo' =>  TB_LOTES), 'lo.id = co.id_lote', array('quadra','lote'))
                ->where("po.status = '1'");

            $usuarios = $usuarios->query()->fetchAll();
            
            foreach ($usuarios as &$users) {
                $users['nm_empreendimento'] = utf8_encode($users['nm_empreendimento']);
                $users['quadra'] = $users['quadra'];
                $users['lote'] = $users['lote'];
                $users['nm_pessoa'] =  utf8_encode($users['nm_pessoa']);
                $users['login'] = $users['login'];
                $contratoid = $users["id_contrato"];

                $codigoId = $users['codigo'];
                $codigoLogin = $users['login'];
                $users['acoes'] = "<div style='width: 130px'></div><div style='width: 100%;' align='center'>" //Boto Resetar
                    ."<a class='btn btn-default btn-sm' data-toggle='tooltip' title='RESETAR' value='$codigoId' onClick='resetar(" . $codigoId . ")'><i class='fa fa-repeat'></i></a>"
                    //Boto Visualizar
                    ." <a data-target='.modalView' id='link_" . $contratoid . "' onClick='visualizar( " . $codigoId . " )' data-toggle='tooltip' title='VISUALIZAR' class='btn btn-default btn-sm'><i class='fa fa-eye'></i></a></span>"
                    //Boto Imprimir
                    ." <a data-target='.modalVisualizar' id='link_" . $contratoid . "' onClick='imprimeWord( " . $codigoId . " )' data-toggle='tooltip' title='IMPRIMIR' class='btn btn-default btn-sm'><i class='fa fa-file-o'></i></a></span>"
                    //Boto Deletar
                   ." <a class='btn btn-default btn-sm' data-toggle='tooltip' title='DELETAR' value='$codigoId'"
                   . " onclick='deletar(this);return false;'><i class='fa fa-times'></i></a>"
                   ."</div>";
            }
            
            echo json_encode([
                'data' => $usuarios
            ]);
        }
        
    }
    public function viewAction()
    {
        $dadosPortal = $this -> tb_portal_senha ->getDefaultAdapter()->select()
        ->from(['p'=> TB_PORTAL_SENHA],'*')
        ->join(['pe'=>TB_PESSOA], 'p.id_cliente = pe.id', 'nm_pessoa')
        ->join(['co' =>  TB_CONTRATO], 'co.id = p.id_contrato', ['id_contrato'=>'id'])
        ->join(['lo' =>  TB_LOTES], 'lo.id = co.id_lote', ['quadra','lote'])
        ->where('p.id ='. $_GET['id'])
        ->query()->fetch();

        //descriptografa a senha
        $ciphering = "AES-128-CTR";
        $options = 0;
        $decryption_iv = '1234567891011121';
        $decryption_key = "EncryptedKey";
        $decryption = openssl_decrypt ($dadosPortal['senha'], $ciphering, 
        $decryption_key, $options, $decryption_iv);

        $dadosPortal['senha'] = $decryption;
        $dadosPortal['nm_pessoa'] = utf8_encode($dadosPortal['nm_pessoa']);

        echo json_encode([
            'data' => $dadosPortal
        ]);
    }

    //Lista todos os empreendimento e renderiza a formulário
    public function formAction()
    {

        $empreendimentos = $this->tb_empreendimento->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));

        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimentos);

        $this->display('form');
    }

    //Busca todos os contratos do empreendimento
    public function pessoasByEmpreendimentoAction()
    {
        $contratosComLogin = $this->tb_usuarios->getDefaultAdapter()->select()
            ->from(array('p' => TB_PORTAL_SENHA), 'p.id_cliente')
            ->where('p.id_empreendimento = ' . $_POST['id_empreendimento'])
            ->query()->fetchAll();
        
        foreach ($contratosComLogin as $contrato)
        {
            $listaPessoas[] = $contrato['id_cliente'];
        }

        $listaPessoas = implode('","', $listaPessoas);
        
        $contrato = new Contrato();

        $contratos = $contrato->getDefaultAdapter()->select()
            ->from(array('c' => TB_CONTRATO), 'id')
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', '')
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', '')
            ->join(array('p' => TB_PESSOA), 'p.id = c.id_pessoa', array('p.nm_pessoa'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', 'pf.nr_cpf')
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', 'pj.nr_cnpj')
            ->where('e.id = ' . $_POST['id_empreendimento'])
            ->where('c.id_pessoa NOT IN ("' . $listaPessoas . '")')
            ->where('c.fl_distrato = "0"')
            ->order('p.nm_pessoa')
            ->group('p.nm_pessoa')
            ->query()->fetchAll();
        
        foreach ($contratos as $contrato)
        {
            $documento = $contrato['nr_cpf'] ? ' - CPF: ' . $contrato['nr_cpf'] : ' - CNPJ: ' . $contrato['nr_cnpj'];

            $lista[] = array(
                'id' => $contrato['id'],
                'text' => utf8_encode($contrato['nm_pessoa'] . $documento)
            );
        }
        
        echo json_encode($lista);
    }

    public function gerarsenha()
    {
        return chr(rand(65,90)) . rand(0,9) . chr(rand(65,90)) . chr(rand(65,90)) . rand(0,9) . chr(rand(65,90)) . rand(0,9) . chr(rand(65,90));
    }
    
    //Gerar um login e senha para um usuário e para todos os usuários
    public function adicionarAction()
    {
        if (!$this->_isPost) {
            $this->redir(array('modulo' => 'portal', 'controller' => 'login', 'action' => 'form'), array('msg' => 'fail', 'exception' => 'Preencha os campos'));
        }

        if ($_POST['contrato'] == 'all') {

            $getEmpreendimentoPessoa =  Contrato::getAllContratos($_POST['empreendimento']);
            
            foreach ($getEmpreendimentoPessoa as $get) {
                //Criptografia da senha
                $simple_string = $this->gerarsenha();
                $ciphering = "AES-128-CTR";
                $iv_length = openssl_cipher_iv_length($ciphering);
                $options = 0;
                $encryption_iv = '1234567891011121';
                $encryption_key = "EncryptedKey";
                $encryption = openssl_encrypt($simple_string, $ciphering,
                $encryption_key, $options, $encryption_iv);

                if ($get['fl_distrato'] == '1' || PortalSenha::buscaUsuarioPortalPorIdPessoa($get['id_pessoa'])) {
                    continue;
                }
                $cpfcnpj = str_replace([".","-"],"",$get['nr_cpf']);/*$get['nr_cpf'] ? str_replace([".","-"],"",$get['nr_cpf']) : str_replace([".","-", "/"],"",$get['nr_cnpj']);*/

                $usuario = $this->tb_usuarios->createRow();
                $usuario->id_empreendimento = $_POST['empreendimento'];
                $usuario->id_contrato = $get['id'];
                $usuario->login = $cpfcnpj;
                $usuario->senha = $encryption;
                $usuario->hash = base64_encode($get['id_pessoa']);
                $usuario->status = '1';
                $usuario->id_cliente = $get['id_pessoa'];
                $usuario->save();
                $this->salvaLogContrato($get['id']);

                (new Relacionamento())->saveContato(79, date('Y-m-d'), $get['id'], 'Login e senha do Portal');

                
            }

            $this->redir(array('modulo' => 'portal', 'controller' => 'login', 'action' => 'listar'), array('msg' => 'success'));

            if ($_POST['contrato'] == 'all') {

                $getEmpreendimentoPessoa =  Contrato::getAllContratosPj($_POST['empreendimento']);
                
                foreach ($getEmpreendimentoPessoa as $get) {
                    //Criptografia da senha
                    $simple_string = $this->gerarsenha();
                    $ciphering = "AES-128-CTR";
                    $iv_length = openssl_cipher_iv_length($ciphering);
                    $options = 0;
                    $encryption_iv = '1234567891011121';
                    $encryption_key = "EncryptedKey";
                    $encryption = openssl_encrypt($simple_string, $ciphering,
                    $encryption_key, $options, $encryption_iv);
    
                    if ($get['fl_distrato'] == '1' || PortalSenha::buscaUsuarioPortalPorIdPessoa($get['id_pessoa'])) {
                        continue;
                    }
                    $cpfcnpj = str_replace([".","-"],"",$get['nr_cpf']);
    
                    $usuario = $this->tb_usuarios->createRow();
                    $usuario->id_empreendimento = $_POST['empreendimento'];
                    $usuario->id_contrato = $get['id'];
                    $usuario->login = $cpfcnpj;
                    $usuario->senha = $encryption;
                    $usuario->hash = base64_encode($get['idpessoa']);
                    $usuario->status = '1';
                    $usuario->id_cliente = $get['idpessoa'];
                    $usuario->save();
                    $this->salvaLogContrato($get['id']);
    
                    (new Relacionamento())->saveContato(79, date('Y-m-d'), $get['id'], 'Login e senha do Portal');
                }
    
                $this->redir(array('modulo' => 'portal', 'controller' => 'login', 'action' => 'listar'), array('msg' => 'success'));
            }
        }


        //Criptografia da senha
        $simple_string = $this->gerarsenha();
        $ciphering = "AES-128-CTR";
        $iv_length = openssl_cipher_iv_length($ciphering);
        $options = 0;
        $encryption_iv = '1234567891011121';
        $encryption_key = "EncryptedKey";
        $encryption = openssl_encrypt($simple_string, $ciphering,
        $encryption_key, $options, $encryption_iv);
    
        $getEmpreendimentoPessoa = Contrato::getPessoaContratoEmpreendimento($_POST['contrato']);
        
        $cpfcnpj = str_replace([".","-"],"",$getEmpreendimentoPessoa['nr_cpf']);/*$getEmpreendimentoPessoa['nr_cpf'] ? str_replace([".","-"],"",$getEmpreendimentoPessoa['nr_cpf']) : str_replace([".","-", "/"],"",$getEmpreendimentoPessoa['nr_cnpj']);*/

        if ($cpfcnpj == NULL) {
            $getEmpreendimentoPessoa = Contrato::getPessoaContratoEmpreendimentoPj($_POST['contrato']);
            $cpfcnpj = str_replace([".","-"],"",$getEmpreendimentoPessoa['nr_cpf']);
        }

        $usuario = $this->tb_usuarios->createRow();
        $usuario->id_empreendimento = $_POST['empreendimento'];
        $usuario->id_contrato = $getEmpreendimentoPessoa['idcontrato'];
        $usuario->login = $cpfcnpj;
        $usuario->senha = $encryption;
        $usuario->hash = base64_encode($getEmpreendimentoPessoa['idpessoa']);
        $usuario->status = '1';
        $usuario->id_cliente = $getEmpreendimentoPessoa['idpessoa'];
        $usuario->save();

        $this->salvaLogContrato($getEmpreendimentoPessoa['idcontrato']);
        (new Relacionamento())->saveContato(79, date('Y-m-d'), $getEmpreendimentoPessoa['idcontrato'], 'Login e senha do Portal');

        $this->redir(array('modulo' => 'portal', 'controller' => 'login', 'action' => 'listar'), array('msg' => 'success'));
    }

    // Atualiza a senha do usuário no banco tabela PORTAL SENHA
    public function resetarAction ()
    {
        if ($this->isAjax()) {
            try {

                //Criptografia da senha
                $simple_string = $this->gerarsenha();
                $ciphering = "AES-128-CTR";
                $iv_length = openssl_cipher_iv_length($ciphering);
                $options = 0;
                $encryption_iv = '1234567891011121';
                $encryption_key = "EncryptedKey";
                $encryption = openssl_encrypt($simple_string, $ciphering,
                $encryption_key, $options, $encryption_iv);
                
                $usuario = $this->tb_usuarios->fetchRow('id =' . $_GET['id']);
                $usuario->senha = $encryption;
                $usuario->alterado = 0;
                $usuario->save();
                
            } catch (Exception $e) {
                 echo json_encode(array('response' => 'false'));
                return;
            }

            echo json_encode(array('response' => 'true'));
        } 
    }

    //Deletar o login do usuário
    public function deletarAction()
    {
        if ($this->isAjax()) {
            try {
                $this->tb_usuarios->delete('id = ' . $_POST['codigo']);
            } catch (Exception $ex) {
                echo json_encode(array('response' => 'false'));
                return;
            }

            echo json_encode(array('response' => 'true'));
        }
    }

    public function imprimeAction()
    {
        $path = $this->tb_modeloArquivo->getAdapter()->select()
            ->from(['mw' => TB_MODELO_ARQUIVO], '*')
            ->where('mw.cd_modelo = ?', $_GET['tpcarta'])
            ->query()->fetch();

        $portal = $this->tb_portal_senha->getDefaultAdapter()->select()
            ->from(array('p' => TB_PORTAL_SENHA), array('id_contrato'))
            ->where('p.id = ' . $_GET['id'])
            ->query()->fetch();

            $templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor(__ROOT__ . '/' . $path['ds_path_modelo']);
            $variaveis = $this->adicionarValoresTemplate($portal['id_contrato'], $templateProcessor);
            $filename = 'portalCliente' . $portal['id_contrato'] . '.docx';
            $variaveis['templateProcessor']->saveAs($filename);

            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename='.$filename);
            header('Content-Transfer-Encoding: binary');
            header('Expires: 0');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Pragma: public');
            header('Content-Length: ' . filesize($filename));
            flush();

            readfile($filename);
            unlink($filename);
    }

    //Relatório  login e senha do cliente
    public function imprimeWordAction()
    {
        if($this->isAjax()) {
            try {
                $modeloWord = $this->tb_modeloArquivo->getAdapter()->select()
                ->from(['mw' => TB_MODELO_ARQUIVO], ['cd_modelo', 'nm_titulo'])
                ->where('fl_status = "1"')
                ->where('tp_modelo = "PC"')
                ->query()->fetchAll();


                foreach($modeloWord as $modelo) {
                    $retorno['arquivos'][] = ['value' => $modelo['cd_modelo'], 'text' => utf8_encode($modelo['nm_titulo'])];
                }

                header('Content-Type: application/json');

                echo (json_encode($retorno));
            } catch (Exception $e) {
                die();
            }
        }

    }

    //Download  login e senha do cliente
    public function gerarAction()
    {

            try {

                $getUsuario = PortalSenha::findUserById($_GET['codigo']);

            } catch (Exception $ex) {
                echo json_encode(array('response' => 'false'));
                return;
            }

            $this->set('relatorio', $getUsuario);

            $this->display("gerar");
            $this->displayMPDF('Login_e_Senha' . time() . '.pdf');
            exit;

    }

    //gerar um hash para senha
    public function passwdhash($pass)
    {
        return md5($pass);
    }

    //salvar o log senhaportal na tabela de contrato
    public function salvaLogContrato($id)
    {
        $contrato = $this->tb_contratos->fetchRow('id = ' .$id);
        $contrato->fl_senhaportal = '1';
        $contrato->save();
    }

     //desaprovar dados alterados no portal
     public function desaprovarAction()
     {

         if ($this->isAjax()) {
             try {

                 $tmp = TmpPortal::findUserByTmpId($_POST['desaprovar']);
                 $data = (new TmpPortal())->delete($tmp['id']);


             } catch (Exception $ex) {
                 echo json_encode(array('response' => 'false'));
                 return;
             }

              echo json_encode(array('response' => 'true'));

         }

     }

}

 ?>
