<?php

class AprovarController extends Controller
{

        private $tb_empreendimento;
        private $tb_usuarios;
        private $tb_contratos;
        private $tb_pessoa;
        private $tb_cidade;


	    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_usuarios = new PortalSenha();
        $this->tb_contratos = new Contrato();
        $this->tb_pessoa = new Pessoa();
        $this->tb_cidade = new Db_Cidade();
    }


	    public function indexAction()
    {
        $this->redir(array("modulo" => "portal", "controller" => "aprovar", "action" => "listar"));
    }

    public function listarAction()
    {
         $this->display('listar');
    }

    //Lista todos os login gerardos que estão ativos
    public function listaAprovarAction()
    {
        $users = [];
        if ($this->isAjax()) {
            $usuarios = $this->tb_usuarios->getAdapter()->select()
                ->from(array("po" => TB_TMP_PORTAL), array('codigo'=>'id_cliente','cd_cidade','endereco','nr_cep','nm_bairro','nr_telefone', 'email'))
                ->join(array('pe' => TB_PESSOA), 'po.id_cliente = pe.id', array('codigoCliente'=>'id','nm_pessoa'))
                ->join(array('pj' => TB_PESSOA_FISICA), 'po.id_cliente = pj.id_pessoa', array('id_pessoa','nr_cpf'))
                ->query()->fetchAll();

            foreach ($usuarios as &$users) {
                $users['nm_pessoa'] = utf8_encode($users['nm_pessoa']);
                $users['endereco'] = utf8_encode($users['endereco']);
                $users['nm_bairro'] = utf8_encode($users['nm_bairro']);

                $codigoId = $users['codigo'];
                $users['acoes'] = "<div style='width: 40px'></div><div style='width: 100%;' align='left'>"
                ."<span style='margin-left: 5px;' data-toggle='modal' data-target='.modalVisualizar'>"
                ."<a target='_blank'  type='button' value='$codigoId' onclick='visualizar(this);' data-toggle='tooltip' title='EDITAR' class='btn btn-default btn-sm' style='margin-right:5px'><i class='fa fa-edit'></i></a></span>"
                     ."</div>";
            }

            echo json_encode([
                'data' => $usuarios
            ]);
        }
    }

    //Visualizar os dados Alterados
    public function visualizarAprovarAction()
    {
        header('Content-type: text/html; charset=UTF-8');
        if ($this->isAjax()) {
            $codigoId = $_POST['codigo'];
            $tmpPortal = $this->tb_usuarios->getAdapter()->select()
                ->from(array("po" => TB_TMP_PORTAL), array('codigo'=>'id','id_cliente','cd_cidade','endereco','nr_cep','nm_bairro','nr_telefone', 'email'))
                ->join(array('cd'=> TB_CIDADE), 'po.cd_cidade = cd.id', array('nome','uf'))
                ->join(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = po.id_cliente', array('pf_id'=>'pf.id_pessoa','cpf'=>'nr_cpf'))
                ->where("po.id_cliente = ?", $codigoId)
                ->query()->fetch();

            $this->set('tmp_portal', $tmpPortal);

            $contrato =  $this->tb_contratos->getAdapter()->select()
            ->from(array('c' => TB_CONTRATO), array('c.id as id', 'c.id_pessoa', 'c.fl_distrato'))
            ->join(array('p' => TB_PORTAL_SENHA), 'p.login = '.str_replace(['.','-'], '', $tmpPortal['cpf']), array('p_id'=>'p.id','empreendimento'=>'id_empreendimento'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'p.id_empreendimento = e.id', array('e.id as id_empreendimento', 'nm_empreendimento'))
            ->where("c.id_pessoa = ?", $codigoId);
            $contrato = $contrato->query()->fetchAll();

            $this->set("contratos", $contrato);
            $this->display("visualizar");
        }
    }

    //aprovar dados alterados no portal
    public function aprovarAction()
    {
        if ($this->isAjax()) {
            try {

                $tmp = TmpPortal::findUserByTmpId($_POST['aprovar']);
                $pessoa = $this->tb_pessoa->fetchRow('id = ' .$tmp['id_cliente']);
                $pessoa->cd_cidade =  $tmp['cd_cidade'];
                $pessoa->nr_telefone =  $tmp['nr_telefone'];
                $pessoa->nr_celular =  $tmp['nr_celular'];
                $pessoa->nr_recado =  $tmp['nr_recado'];
                $pessoa->nr_cep =  $tmp['nr_cep'];
                $pessoa->nr_endereco =  $tmp['nr_endereco'];
                $pessoa->endereco =  $tmp['endereco'];
                $pessoa->nm_bairro =  $tmp['nm_bairro'];
                $pessoa->ds_complemento =  $tmp['ds_complemento'];
                $pessoa->email =  $tmp['email'];
                $pessoa->save();

                (new TmpPortal())->delete($tmp['id']);

            } catch (Exception $ex) {
                echo json_encode(array('response' => 'false'));
                return;
            }

             echo json_encode(array('response' => 'true'));
        }
    }

    //desaprovar dados alterados no portal
    public function desaprovarAction()
    {
        if ($this->isAjax()) {
        try {

            $tmp = TmpPortal::findUserByTmpId($_POST['desaprovar']);
            $data = (new TmpPortal())->delete($tmp['id']);
        } catch (Exception $ex) {
            echo json_encode(array('response' => 'false'));
            return;
        }

        echo json_encode(array('response' => 'true'));
        }
    }
}

?>
