<?php

$relatorios = $this->get("relatorios");
$estado = $this->get("estado");

setlocale(LC_TIME,"pt_BR.utf8");
$dataAtual = utf8_decode( strftime("%d de %B de %Y", strtotime(date("Y-m-d"))));
$local = $cidade;

?>
<page backtop="10mm" backbottom="10mm">


    <style type="text/css">
        div.corpo{
            margin: inherit;
            margin-top: 20px;
            margin-bottom: 20px;
            margin-left: 10px;
            margin-right: 10px;
        }
        .espaco{
            padding-left: 5px;
            padding-right: 5px;
        }

        .topo{
            font-size: 10px;
        }
        div.br{
            padding-top: 10px;
            padding-bottom: 10px;
        }

        .conteudo_borda{
            border-bottom: 1px black solid;
        }

        table{
            font-size: 10px;
        }

        .header td{
            background-color: #cccccc;
            border: 1px #000000 solid;
            font-weight: bold;
        }

        .linhaEscura td{
            background-color: #dedede

        }

        .contrato{
            border-top: 1px black solid;
            border-right: 1px black solid;
            border-left: 1px black solid;
            border-bottom: 1px black solid;
            width: 500px;
            border-collapse: collapse;
        }
        td{
            font-size: 8pt;
        }
    </style>
    <div style="width:670px;">
        <table style="font-family: arial;">
            <tr>
                <td valign="top" style="margin-right: 10px;" rowspan="2">
                    <!-- Logomarca Cliente Acade -->
                    <?php
                        echo '<img style="float: left; " src="'.LOGOMARCA_DEFAULT.'" alt="LogoPadrao" height="80">';
                    ?>
                </td>
                <td align="center" width="400" style="font-size: 11pt;">
                    <strong style="text-align: center;margin-top: 20px;">RELATRIO DE CLIENTES</strong><br />
                    <strong style="text-align: center;margin-top: 20px;">Estado: </strong><?= $estado?><br />
                    <span style="font-size: 8pt;"> </span><br />
                </td>
            </tr>
        </table>
    </div>
    <br />
    <?php if($relatorios): ?>
        <table name="informacao" class="informacao" style="border-collapse: collapse">
            <?php
            $total = 0;
            foreach ($relatorios AS $relatorio):
                switch($relatorio['fl_situacao']){
                    case 'N':
                        $situacao = 'Normal';
                        break;
                    case 'S':
                        $situacao = 'Suspenso';
                        break;
                    case 'M':
                        $situacao = 'Manuteno';
                        break;
                    default:
                        $situacao = 'Normal';
                        break;
                }
            ?>
                <tr>
                    <td width='300' colspan="2"><strong>Razo Social:</strong><?= " {$relatorio['nm_razao_social']}." ?></td>
                    <td colspan="2"><strong>Situao:</strong><?= " {$situacao}." ?></td>
                    
                </tr>
                <tr>
                    <td width='300'><strong>CNPJ:</strong><?= " {$relatorio['nr_cnpj']}." ?></td>
                    <td colspan="2"><strong>Link:</strong><?= " {$relatorio['ds_url']}." ?></td>
                    
                </tr>
                <tr>
                    <td width='300'><strong>Email:</strong><?= " {$relatorio['ds_email']}." ?></td>
                    <td><strong>Telefone:</strong><?= " {$relatorio['nr_telefone']}." ?></td>
                    <td><strong>Dt do contrato:</strong><?= Helper::dataParaBrasil($relatorio['dt_contrato']) ?></td>
                </tr>
                <tr>
                <td colspan="3"><strong>INFORMAES DE ACESSO</td>
                </tr>
                <tr>
                    <td width='300'><strong>Id usurio:</strong><?= " {$relatorio['id_usuario']}." ?></td>
                    <td><strong>Login:</strong><?= " {$relatorio['login']}." ?></td>
                    <td><strong>IP:</strong><?= " {$relatorio['ip_acesso']}." ?></td>
                </tr>
                
                <tr>
                    <td width='300'><strong>Dt do acesso:</strong><?= Helper::dataParaBrasil($relatorio['dt_acesso']) ?></td>
                    <td colspan="2"><strong>Hora do acesso:</strong><?= " {$relatorio['hr_acesso']}." ?></td>
                </tr>
                <tr>
                    <td class="conteudo_borda" width='300'>&nbsp;</td>
                    <td class="conteudo_borda" width='150'>&nbsp;</td>
                    <td class="conteudo_borda" width='150'>&nbsp;</td>
                </tr>
            <?php endforeach;
            $total = count($relatorios);?>
            <tr>
                <td><strong>Quantidade de Clientes: </strong><?= $total ?></td>
            </tr>
        </table>
    <?php endif;?>
</page>