<?php
class RelatorioController extends Controller {

    private $cliente;
    private $acesso;

    public function __construct($request)
    {
        parent::__construct($request);

        $this->cliente = new ClienteAcade();
        $this->acesso = new LogAcesso();

    }

    public function indexAction() {
        
        if(!Login::getUsuario()||Login::getUsuario()->getSuper()!="1"){
            $this->redir(array("modulo" => "sc", "controller" => "login"), array());
        }

        $estados = [ '*' => 'Todos', 'AC' => 'Acre', 'AL' => 'Alagoas', 'AP' => 'Amap', 'AM' => 'Amazonas','BA' => 'Bahia', 'CE' => 'Cear', 'ES' => 'Esprito Santo', 'GO' => 'Gois', 'MA' => 'Maranho', 'MT' => 'Mato Grosso', 'MS' => 'Mato Grosso do Sul', 'MG' => 'Minas Gerais', 'PA' => 'Par', 'PB' => 'Paraba', 'PR' => 'Paran', 'PE' => 'Pernambuco', 'PI' => 'Piau', 'RJ' => 'Rio de Janeiro','RN' => 'Rio Grande do Norte', 'RS' => 'Rio Grande do Sul', 'RO' => 'Rondnia', 'RR' => 'Roraima','SC' => 'Santa Catarina', 'SP' => 'So Paulo', 'SE' => 'Sergipe', 'TO' => 'Tocantins', 'DF' => 'Distrito Federal'];
        $this->set('estados', $estados);
        
        $this->display("index");
    }

    private function carregarDados() {
        $instanceEmpreendimento = new Empreendimento();

        $empreendimentos = $instanceEmpreendimento->getDefaultAdapter()->select()
            ->from(array('e'=>TB_EMPREENDIMENTO), array('nm_empreendimento'))
            ->join(array('l'=>TB_LOTES), 'e.id = l.id_empreendimento', array('id_lote'=>'id', 'id_empreendimento'))
            ->join(array('c'=>TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato'=>'id', 'id_lote'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']->getSuper() != '1') {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos',$empreendimentos);
    }

    public function relatorioAction() {
        ini_set("memory_limit", "1024M");
        set_time_limit(0);

        if($this->validar()) {
            
            $clientes_acade = Controller::getAdapterAcadeGeral()->select()
                ->from(array('s' => TB_CLIENTE_ACADE), '*')
                ->where("status_painel  = 1")
                ->where("ultimo_acesso  is not null");

            if($_POST['estado_relatorio'] == '*'){
                $clientes_acade->where("estado_cliente  is not null");
            }else{
                $clientes_acade->where("estado_cliente = ?", $_POST['estado_relatorio']);
            }

            if($_POST['cliente_relatorio_clientes'] != '*'){
                $clientes_acade->where("id_cliente = ?", $_POST['cliente_relatorio_clientes']);
            }

            $clientes_acade = $clientes_acade->query()->fetchAll();

            foreach($clientes_acade as $n => $clientes){
                $bd = controller::getAdapterPainel($clientes['nm_dominio']);
                if($bd){
                    $item = $bd->select()
                        ->from(TB_CLIENTE,array('*'))
                        ->query()->fetch();

                    $ultimo_acesso = $bd->select()
                        ->from(['l'=> TB_LOG_ACESSO], '*')
                        ->join(array('c'=>TB_USUARIO),'l.id_usuario = c.id','*')
                        ->where('c.super != "1"')
                        ->order('dt_acesso desc')
                        ->query()->fetch();

                        if($item['fl_situacao'] == $_POST['situacao'][0] || $item['fl_situacao'] == $_POST['situacao'][1] || $item['fl_situacao'] == $_POST['situacao'][2]){
                            $novoArray[$n] = array_merge($item, $ultimo_acesso);
                            $novoArray[$n] = array_merge($clientes, $novoArray[$n]);
                            sort($novoArray);
                        }
                }
                
                $valorMinimo = 0;
                $valorMaximo = 0;
                foreach($_POST['opcao'] as $opcao){
                    switch ($opcao)
                    {
                        case 'cinco': //At 5 dias de atraso
                            $valorMinimo = 1;
                            $valorMaximo = 5;
                            break;

                        case 'dez': //Entre 5 e 10 dias de atraso
                            $valorMinimo = ($valorMinimo == 0) ? $valorMinimo = 6 : $valorMinimo = $valorMinimo;
                            $valorMaximo = ($valorMaximo >= 0) ? $valorMaximo = 10 : $valorMaximo = $valorMaximo;
                            break;
                        
                        case 'mais': //Acima de 10 dias de atraso
                            $valorMinimo = ($valorMinimo == 0) ? $valorMinimo = 11 : $valorMinimo = $valorMinimo;
                            $valorMaximo = ($valorMaximo >= 0) ? $valorMaximo = 11 : $valorMaximo = $valorMaximo;
                            break;
                    }
                }
                $diferencaDatas = Helper::date_diff(Helper::dataParaAmericano($novoArray[$n]['dt_acesso']), Helper::dataParaAmericano(date('Y-m-d')));
                
                if ($valorMinimo < 11 && $valorMaximo < 11)
                {
                    if ($diferencaDatas > $valorMaximo || $diferencaDatas < $valorMinimo)
                    {
                        unset($novoArray[$n]);
                    }
                } else {
                    if ($diferencaDatas < $valorMinimo)
                    {
                        unset($novoArray[$n]);
                    }
                }
            }
            
            if(!$novoArray){
                $this->_helper->addMensagem ( 'index', 'No existem clientes para esses filtros.');
                $this->carregarDados();
                $this->display("index");
            }
            //Remove os itens duplicados do array
            function sortByOrder($a, $b) {
                return $a['id_cliente'] >= $b['id_cliente'];
            }
            $id_cliente = 0;
            for($k = 0; $k< count($novoArray); $k++){
                if($novoArray[$k]['id_cliente'] == $id_cliente){
                    $id_cliente = $clientes_acade[$k]['id_cliente'];
                    
                    unset($novoArray[$k]);
                }
                else{
                    $id_cliente = $clientes_acade[$k]['id_cliente'];
                }
            }
            $estados = [ '*' => 'Todos', 'AC' => 'Acre', 'AL' => 'Alagoas', 'AP' => 'Amap', 'AM' => 'Amazonas','BA' => 'Bahia', 'CE' => 'Cear', 'ES' => 'Esprito Santo', 'GO' => 'Gois', 'MA' => 'Maranho', 'MT' => 'Mato Grosso', 'MS' => 'Mato Grosso do Sul', 'MG' => 'Minas Gerais', 'PA' => 'Par', 'PB' => 'Paraba', 'PR' => 'Paran', 'PE' => 'Pernambuco', 'PI' => 'Piau', 'RJ' => 'Rio de Janeiro','RN' => 'Rio Grande do Norte', 'RS' => 'Rio Grande do Sul', 'RO' => 'Rondnia', 'RR' => 'Roraima','SC' => 'Santa Catarina', 'SP' => 'So Paulo', 'SE' => 'Sergipe', 'TO' => 'Tocantins', 'DF' => 'Distrito Federal'];
            $estado = $estados[$_POST['estado_relatorio']];

            if(count($novoArray)) {
                $this->set('relatorios', $novoArray);
                $this->set('estado', $estado);
                $this->displayMPDF(rand().'.pdf');

            } else {
                $this->_helper->addMensagem ( 'index', 'No existem clientes para esses filtros.');
                $this->carregarDados();
                $this->display("index");
            }

        } else {
            $this->carregarDados();
            $this->display("index");
        }
    }

    private function validar() {
        //validao vazio
        $campos = array ("estado_relatorio", "cliente_relatorio_clientes");
        foreach ( $campos as $cp ) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "estado_relatorio" :
                        $msg = "O campo Estado  obrigatrio.";
                        break;
                    case "cliente_relatorio_clientes" :
                        $msg = "O campo Clientes  obrigatrio.";
                        break;
                }
                $this->_helper->addMensagem ( $cp, $msg );
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }
    public function relatorioDeClientesAction()
    {

        if($_POST['estado'] != '*'){
            $clientes_acade = Controller::getAdapterAcadeGeral()->select()
                ->from(array('s' => TB_CLIENTE_ACADE), '*')
                ->where("status_painel  = 1")
                ->where("estado_cliente  is not null")
                ->where("ultimo_acesso  is not null")
                ->where("estado_cliente = ?", $_POST['estado'])
                ->query()->fetchAll();
        }else{
            $clientes_acade = Controller::getAdapterAcadeGeral()->select()
                ->from(array('s' => TB_CLIENTE_ACADE), '*')
                ->where("status_painel  = 1")
                ->where("estado_cliente  is not null")
                ->where("ultimo_acesso  is not null")
                ->query()->fetchAll();
        }

        $buscaCliente[] = ['id' =>  '*', 'text' => 'Todos'];
        foreach ($clientes_acade as $cliente) {
            $buscaCliente[] = array (
                'id' => $cliente['id_cliente'],
                'text' => utf8_encode($cliente['nm_dominio'])
            );
        }
        echo json_encode($buscaCliente);
    }
}