<?php

class DashboardController extends Controller
{

    private $cliente;
    private $acesso;

    public function __construct($request)
    {
        parent::__construct($request);

        $this->cliente = new ClienteAcade();
        $this->acesso = new LogAcesso();

    }

    public function indexAction()
    {

        if(!Login::getUsuario()||Login::getUsuario()->getSuper()!="1"){
            $this->redir(array("modulo" => "sc", "controller" => "login"), array());
        }
        $clientes_acade = Controller::getAdapterAcadeGeral()->select()
            ->from(array('s' => TB_CLIENTE_ACADE), '*')
            ->where("status_painel  = 1")
            ->where("estado_cliente  is not null")
            ->where("ultimo_acesso  is not null")
            ->query()->fetchAll();
        $imgSlide = Controller::getAdapterAcadeGeral()->select()
            ->from(array('s' => TB_SLIDESHOW), '*')
            ->join(array('si' => TB_SLIDESHOW_SISTEMA), 's.id_slideshow = si.id_slideshow','*')
            ->where('id_sistema = 1')
            ->where('fl_ativo = 1')
            ->where('mapa = 1')
            ->query()->fetchAll();

        $this->set('imgSlide', $imgSlide);
        $this->set('listaClientes', $clientes_acade);
        $this->display('indexNovoMapa');
    }

    public function getInfoPainelAction()
    {
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Headers: *");
        header('Content-Type: application/json; charset=utf-8');
        $endereco = $_GET["endereco"]?true:false;
        $cliente = $this->cliente->get($endereco);
        foreach($cliente as $key=>$c){
            $cliente[$key] = utf8_encode($c);
        }
        
        if($_GET['ultimoAcesso']){
            $cliente['ultimoAcesso'] = $this->acesso->ultimoAcesso();
        }
        $cliente['nomeDominio']=$_GET['nomeDominio'];
        foreach($cliente['ultimoAcesso'] as $key=>$c){
            $cliente['ultimoAcesso'][$key] = utf8_encode($c);
        }
        echo(json_encode($cliente));
    }

    public function visualizarAction()
    {
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Headers: *");
        header('Content-Type: application/json; charset=utf-8');
        if ($_POST['cdItem']) {
            $item = $this->cliente->get();
            $ultimo_acesso = $this->cliente->ultimoAcesso();
            $item['fl_situacao'] == 'N' ? $situacao = 'Normal' : ($item['fl_situacao'] == 'S' ? $situacao = 'Suspenso': $situacao = 'Em manuteno');
            //Dados do cliente
            $dados['nm_razao_social'] = utf8_encode($item['nm_razao_social']);
            $dados['dt_contrato'] = Helper::dataParaBrasil($item['dt_contrato']);
            $dados['link'] = utf8_encode("https://".$_POST['cdItem'].".acadeone.com.br/");
            $dados['cnpj'] = (new Helper)->cnpjMask(preg_replace('/[^0-9]/', '', $item['nr_cnpj']));
            $dados['telefone'] = '(' . $item['nr_uf_telefone'] . ') - ' .  $item['nr_telefone'];
            $dados['email'] = utf8_encode($item['ds_email']);
            $dados['situacao'] = utf8_encode($situacao);
            //Dados do ultimo acesso
            $dados['id_usuario'] = $ultimo_acesso['id_usuario'];
            $dados['dt_acesso'] =  Helper::dataParaBrasil($ultimo_acesso['dt_acesso']);
            $dados['hr_acesso'] = $ultimo_acesso['hr_acesso'];
            $dados['ip_acesso'] = $ultimo_acesso['ip_acesso'];
            $dados['login'] =  utf8_encode($ultimo_acesso['login']);

            echo json_encode($dados);
        }
        else{
            echo json_encode(array("erro"=>"faltando cdItem"));
        }
    }
}