<?php 
$oportunidade = $this->get('oportunidade');
$lista_oportunidades = $this->get('lista_oportunidades');
$tipo_oportunidade = $this->get('tipo_oportunidade');
$tipo_servicos_oportunidade = $this->get('tipo_servicos_oportunidade');
$fotos = $this->get('fotos');
$path = explode('.', $_SERVER['HTTP_HOST']);
if ($path[0] == 'www') {
    $path = $path[1];
} else {
    $path = $path[0];
}
?>
<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>

    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader('Cadastro', 'Oportunidades'); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?= ($_GET["msg"] == "success") ? '<div class="alert alert-success alert-dismissable">Operao realizada com sucesso.</div>'
                    : (($_GET['exception'] != '') ? '<div class="alert alert-danger alert-dismissable">' . $_GET['exception'] . '</div>' : '');
                ?>
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form">
                    <input type="hidden" id="contrato" value="<?= $_GET['id'] ?>">
                    <fieldset>
                        <legend>
                        Informaes da Oportunidade <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span></legend>
                        <div class="row">
                            <div class="form-group col-sm-6">
                                    <label class="control-label" for="oportuniade">
                                        Oportunidade:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2"
                                            required="required"
                                            id="oportunidade" name="oportunidade"
                                            data-placeholder="Escolha a oportunidade" onchange="alterar_tipo_oportunidade(this)">
                                        <option value=""></option>
                                        <?php foreach ($lista_oportunidades as $e): ?>
                                            <option value="<?= $e['idCampo']; ?>" <?= ($oportunidade['oportunidade'] == $e['idCampo'])?'selected':''?>>
                                                <?= $e['descricao']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6" id="card_tipo_oportunidade" style="<?=($oportunidade['oportunidade']&&$oportunidade['oportunidade']!=5)?"":"display:none;"?>">
                                    <label class="control-label" for="tipo_oportunidade">
                                        Tipo de oportunidade:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2"
                                            id="tipo_oportunidade" name="tipo_oportunidade"
                                            data-placeholder="Escolha o tipo da oportunidade">
                                        <option value=""></option>
                                        <?php foreach ($tipo_oportunidade as $e): ?>
                                            <option value="<?= $e['idCampo']; ?>" <?= ($oportunidade['tipo_oportunidade'] == $e['idCampo'])?'selected':''?>>
                                                <?= $e['descricao']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6" id="card_tipo_servico_oportunidade" style="<?=($oportunidade['oportunidade']==5)?"":"display:none;"?>">
                                    <label class="control-label" for="tipo_oportunidade">
                                        Tipo de oportunidade:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2"
                                            id="tipo_servico_oportunidade" name="tipo_servico_oportunidade"
                                            data-placeholder="Escolha o tipo da oportunidade">
                                        <option value=""></option>
                                        <?php foreach ($tipo_servicos_oportunidade as $e): ?>
                                            <option value="<?= $e['idCampo']; ?>" <?= ($oportunidade['tipo_oportunidade'] == $e['idCampo'])?'selected':''?>>
                                                <?= $e['descricao']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <!--<div class="form-group col-sm-3" >
                                    <label class="control-label" for="valor_participacao"> Oportunidade:<span class="require" style="color: red">*</span></label>
                                    <input type="text" class="form-control" id='oportunidade'
                                           name="oportunidade" value="<?= $oportunidade['oportunidade']?>"
                                           placeholder="Descreva a oportunidade">
                                </div>-->
                                
                            </div>
                            <div class="row">
                                
                                <div class="form-group col-sm-3" >
                                    <label class="control-label" for="valor"> Valor:</label>
                                    <input type="text" class="form-control money" id="valor" 
                                           name="valor" value="<?= $oportunidade['valor']?>"
                                           placeholder="Valor da oportunidade">
                                </div>
                                <div class="form-group col-sm-3" >
                                    <label class="control-label" for="area"> rea:</label>
                                    <input type="text" class="form-control" id="area"
                                           name="area" value="<?= $oportunidade['area']?>"
                                           placeholder="Area oportunidade">
                                </div>
                                
                                <div class="form-group col-sm-3" >
                                    <label class="control-label" for="nr_cep"> CEP:</label>
                                    <input type="text" class="form-control " id="nr_cep" 
                                           name="nr_cep" value="<?= $oportunidade['nr_cep']?>"
                                           placeholder="CEP da oportunidade">
                                           <div class="result" id="result">
                                            </div>
                                </div>
                                
                                <div class="form-group col-sm-3" >
                                    <label class="control-label" for="endereco"> Endereo:</label>
                                    <input type="text" class="form-control" id="endereco"   
                                           name="endereco" value="<?= $oportunidade['endereco']?>"
                                           placeholder="Endereo da oportunidade">
                                </div>
                                
                            </div>
                            <div class="row">
                                <div class="form-group col-sm-3" >
                                    <label class="control-label" for="bairro"> Bairro:</label>
                                    <input type="text" class="form-control" id="bairro" 
                                           name="bairro" value="<?= $oportunidade['bairro']?>"
                                           placeholder="Bairro da oportunidade">
                                </div>
                                <div class="form-group col-sm-3" >
                                    <label class="control-label" for="cidade"> Cidade:</label>
                                    <input type="text" class="form-control" id="cidade"  
                                           name="cidade" value="<?= $oportunidade['cidade']?>"
                                           placeholder="Cidade da oportunidade">
                                </div>
                                <div class="form-group col-sm-6" >
                                    <label class="control-label" for="estado"> Estado:</label>
                                    
                                    <select class="form-control select2" 
                                            id="estado" name="estado[]" multiple="multiple"
                                            data-placeholder="Estado da oportunidade">
                                        <option value=""></option>
                                        <option value="AC">Acre (AC)</option>
                                        <option value="AL">Alagoas (AL)</option>
                                        <option value="AP">Amap (AP)</option>
                                        <option value="AM">Amazonas (AM)</option>
                                        <option value="BA">Bahia (BA)</option>
                                        <option value="CE">Cear (CE)</option>
                                        <option value="DF">Distrito Federal (DF)</option>
                                        <option value="ES">Esprito Santo (ES)</option>
                                        <option value="GO">Gois (GO)</option>
                                        <option value="MA">Maranho (MA)</option>
                                        <option value="MT">Mato Grosso (MT)</option>
                                        <option value="MS">Mato Grosso do Sul (MS)</option>
                                        <option value="MG">Minas Gerais (MG)</option>
                                        <option value="PA">Par (PA)</option>
                                        <option value="PB">Paraba (PB)</option>
                                        <option value="PR">Paran (PR)</option>
                                        <option value="PE">Pernambuco (PE)</option>
                                        <option value="PI">Piau (PI)</option>
                                        <option value="RJ">Rio de Janeiro (RJ)</option>
                                        <option value="RN">Rio Grande do Norte (RN)</option>
                                        <option value="RS">Rio Grande do Sul (RS)</option>
                                        <option value="RO">Rondnia (RO)</option>
                                        <option value="RR">Roraima (RR)</option>
                                        <option value="SC">Santa Catarina (SC)</option>
                                        <option value="SP">So Paulo (SP)</option>
                                        <option value="SE">Sergipe (SE)</option>
                                        <option value="TO">Tocantins (TO)</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-sm-6" >
                                    <label class="control-label" for="titulo"> Titulo:</label>
                                    <input type="text" class="form-control" id="titulo"  
                                           name="titulo" value="<?= $oportunidade['titulo']?>"
                                           placeholder="Titulo da oportunidade">
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label">
                                        Status? <span class="require" style="color: red">*</span>
                                    </label><br>
                                    <div class="checkbox">
                                        <label>
                                            <input id="ativo" class="form-control icheck"
                                                   type="radio" name="status" value="1"
                                                <?= ($oportunidade['status'] != '0')?'checked':''?>/>
                                            Ativo
                                        </label>
                                        <label>
                                            <input id="inativo" class="form-control icheck" type="radio" name="status" value="0"
                                                <?= ($oportunidade['status'] == '0')?'checked':''?>/>
                                            Inativo
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-12" >
                                    <label class="control-label" for="ds_oportunidade"> Descrio da oportunidade:<span class="require" style="color: red">*</span></label>
                                    <textarea class="form-control" id="ds_oportunidade" name="ds_oportunidade" cols="50"
                                              rows="5"><?= $oportunidade['ds_oportunidade']?></textarea>
                                </div> 
                        </div>
                    </fieldset>
                    
                    <fieldset>
                        <legend>
                        Informaes de Contato </legend>
                        <div>
                            <div class="form-group col-sm-6" >
                                <label class="control-label" for="nm_pessoa"> Pessoa responsvel:<span class="require" style="color: red">*</span></label>
                                <input type="text" class="form-control" id="nm_pessoa"  required="required"
                                        name="nm_pessoa" value="<?= $oportunidade['nm_pessoa']?>"
                                        placeholder="Nome da pessoa responsvel pela oportunidade">
                            </div>
                            <?php if($oportunidade&&$path!=$oportunidade['nm_dominio']&& $path!="oportunidades"):?>
                                <div class="form-group col-sm-6" >
                                    <label class="control-label" for="email"> E-mail:</label>
                                    <input type="text" class="form-control" id="email" 
                                            name="email" value="assessoria@acade.com.br"
                                            placeholder="Email">
                                </div>
                                <div class="form-group col-sm-6" >
                                    <label class="control-label" for="celular"> Celular:<span class="require" style="color: red">*</span></label>
                                    <input type="text" class="form-control" id="celular" required="required"
                                            name="celular" value="(81) 9 7102-6454"
                                            placeholder="Celular">
                                </div>
                                <div class="form-group col-sm-6" >
                                    <label class="control-label" for="whatsapp"> WhatsApp:</label>
                                    <input type="text" class="form-control " id="whatsapp" 
                                            name="whatsapp" value="(81) 9 7102-6454"
                                            placeholder="Whastapp">
                                </div>
                            <?php else:?>
                                <div class="form-group col-sm-6" >
                                    <label class="control-label" for="email"> E-mail:</label>
                                    <input type="text" class="form-control" id="email" 
                                            name="email" value="<?= $oportunidade['email']?>"
                                            placeholder="Email">
                                </div>
                                <div class="form-group col-sm-4" >
                                    <label class="control-label" for="telefone"> Telefone:</label>
                                    <input type="text" class="form-control " id="telefone" 
                                            name="telefone" value="<?= $oportunidade['telefone']?>"
                                            placeholder="Telefone">
                                </div>
                                <div class="form-group col-sm-4" >
                                    <label class="control-label" for="celular"> Celular:<span class="require" style="color: red">*</span></label>
                                    <input type="text" class="form-control" id="celular" required="required"
                                            name="celular" value="<?= $oportunidade['celular']?>"
                                            placeholder="Celular">
                                </div>
                                <div class="form-group col-sm-4" >
                                    <label class="control-label" for="whatsapp"> WhatsApp:</label>
                                    <input type="text" class="form-control " id="whatsapp" 
                                            name="whatsapp" value="<?= $oportunidade['whatsapp']?>"
                                            placeholder="Whastapp">
                                </div>
                            <?php endif;?>
                            
                        </div>
                    
                    </fieldset>

                   
                    
                    
                    <fieldset style='<?= $oportunidade['id_oportunidade']?"":"display:none"?>'>
                        <legend>Fotos</legend>
                        
                        <div class="row">
                            <div class="form-group col-sm-6" >
                                <input type="file"  class="form-control " id="fileInput" accept="image/*">
                            </div>
                            <div class="form-group col-sm-12" >
                                <div class="image-preview" id="imagePreview">
                                    <!-- As pr-visualizaes das imagens sero adicionadas aqui -->
                                <?php foreach($fotos as $foto):?>
                                    <div>
                                        <img src="<?=$foto['diretorio']?>">
                                        <button type="button" class="remove-btn" onclick="removerImagem(this);" data-id="<?=$foto['idFoto']?>">X</button>
                                    </div>
                                    <?php endforeach;?>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <div id="map" class="map"></div>
                    
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" id="btnSalvar" class="btn btn-primary col-sm-12 fDesabilitaBtn"
                                           value="Salvar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a type="button" href="?m=oportunidades&c=cadastro" id="btnVoltar" class="btn btn-primary col-sm-12 fDesabilitaBtn">
                                        Voltar
                                    </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <input type="hidden" name="lat" id="lat" value="<?= $oportunidade['lat']?$oportunidade['lat']:0?>">
                    <input type="hidden" name="long" id="long" value="<?= $oportunidade['long']?$oportunidade['long']:0?>">
                    <input type="hidden" name="id_oportunidade" id="id_oportunidade" value="<?= $oportunidade['id_oportunidade']?>">
                </form>

            </div>
        </div>
    </div>
    <script>
        var latitude = <?= $oportunidade['lat']?$oportunidade['lat']:0?>;
        var longitude = <?= $oportunidade['long']?$oportunidade['long']:0?>;
        var estadoOportunidade = "<?= $oportunidade['estado']?>";
        if(estadoOportunidade){
            estadoOportunidade=estadoOportunidade.split(',');
        }
        else{
            estadoOportunidade=[];
        }
    </script>
    <style>
        .image-preview {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-top: 10px;
        }

        .image-preview div {
            position: relative;
            border: 1px solid #ddd;
            padding: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .image-preview img {
            max-width: 100px;
            max-height: 100px;
        }

        .remove-btn {
            position: absolute;
            top: 5px;
            right: 5px;
            background-color: red;
            color: white;
            border: none;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            text-align: center;
            cursor: pointer;
            font-size: 14px;
        }
    </style>
<link href="public/css/ol.css" rel="stylesheet">
<script type="text/javascript" src="public/js/ol.js"></script>
<?php require_once 'layout/includes/footer.php'; ?>
<?php if(!$oportunidade['id_oportunidade']):?>
<script type="text/javascript" src="public/js/modulo/oportunidades/cadastro/formulario.js?1723199726"></script>
<?php elseif($path!=$oportunidade['nm_dominio']):?>
<script>
    $('input, select, textarea, button').prop('disabled', true);
</script>
<?php endif;?>