<?php
class CadastroController extends Controller
{
    private $cliente;
    private $dbGeral;
    public function __construct($request)
    {
        parent::__construct($request);
        
        $tb_cliente = new Db_Cliente();
        $this->cliente = $tb_cliente->fetchRow();
        if($this->cliente->fl_oportunidades=='0'){
            header("Location: ?m=&c=admin&a=index");
        }
        
        $this->dbGeral = Controller::getAdapterAcadeGeral();
        
    }
    public function listarAction()
    {
        $dbGeral = Controller::getAdapterAcadeGeral();
        $path = explode('.', $_SERVER['HTTP_HOST']);
        if ($path[0] == 'www') {
            $path = $path[1];
        } else {
            $path = $path[0];
        }
        $where=[];
        if($_GET['search']['value']){//&&$_GET["todos"] ){
            $where[] = "co.id_oportunidade = '".$_GET['search']['value']."'";
        }
        if($_GET['minhasOportunidades']=="true"){
            $where[] = "co.usuario = " .Login::getUsuario()->getId();
        }
        if($_GET['favoritos']=="true"){
            $where[] = "fo.id is not null";
        }
        if($_GET['status']!=""){
            $where[] = "co.status = ".$_GET['status'];
        }
        if($_GET['estado']){
            $where[] = "co.estado like '%".$_GET['estado']."%'";
        }
        if($_GET['cidade']){
            $where[] = "co.cidade like '%".$_GET['cidade']."%'";
        }
        if($_GET['tipo']){
            $where[] = "co.oportunidade = ".$_GET['tipo'];
        }
        if($_GET['titulo']){
            $where[] = "co.titulo  like '%".$_GET['titulo']."%'";
        }
        if($where){
            $where = 'where '.implode(' and ',$where);
        }
        else{
            $where = "";
        }
        /*elseif(!$_GET["todos"]){
            $where = "where nm_dominio = '".$path."'";
            if($_GET['search']['value']){
                $where .=" and ds_oportunidade like '%".utf8_encode($_GET['search']['value'])."%'";
            }
        }*/
        $group = "";
        $limit =$_GET['length'];
        $offset = $_GET['start'];
        $login = Login::getUsuario()->getId();
        
        $data = $dbGeral->query("SELECT SQL_CALC_FOUND_ROWS co.*,concat(co.id_oportunidade,'-',IFNULL(fo.id, 0)) as favorito,ta.descricao as descricao_tipo_oportunidade,ta1.descricao as descricao_oportunidade, concat(ta1.descricao,'/', ta.descricao) as op, concat(co.id_oportunidade,'-', co.status) as idStatus
        FROM `cadastro_oportunidades` co
        left join favoritos_oportunidades fo on fo.oportunidade = co.id_oportunidade and fo.cliente = '$path' and fo.usuario = $login
        left join  tabela_agrupada ta on ta.idTabela = CASE 
                           WHEN co.oportunidade = 5 THEN 31 
                           ELSE 30 
                        END and ta.idCampo = co.tipo_oportunidade
        left join tabela_agrupada ta1 on ta1.idTabela = 29 and ta1.idCampo = co.oportunidade
        $where
        $group
        ORDER BY id_oportunidade DESC
        LIMIT 	$limit OFFSET $offset;")->fetchAll();
        $count = $dbGeral->fetchOne("select FOUND_ROWS();");
        foreach ($data as $index => $op) {
            foreach ($op as $atributo => $valor) {
                if (is_string($valor)) {
                    $data[$index][$atributo] = utf8_encode($valor);
                }
            }
        }
        echo json_encode( array('data'=>$data,'recordsTotal'=>$count,'recordsFiltered'=> $count));
    
    }
    public function oportunidadeAction(){
        $dbGeral = Controller::getAdapterAcadeGeral();
        $path = explode('.', $_SERVER['HTTP_HOST']);
        if ($path[0] == 'www') {
            $path = $path[1];
        } else {
            $path = $path[0];
        }
        $where = "where nm_dominio = '".$path."' and id_oportunidade = ".$_GET['id'];
        $resultado = $dbGeral->query("SELECT co.*,ta.descricao as descricao_tipo_oportunidade,ta1.descricao as descricao_oportunidade, concat(ta1.descricao,'/', ta.descricao) as op, concat(co.id_oportunidade,'-', co.status) as idStatus
        FROM `cadastro_oportunidades` co
        left join  tabela_agrupada ta on ta.idTabela = CASE 
                           WHEN co.oportunidade = 5 THEN 31 
                           ELSE 30 
                        END and ta.idCampo = co.tipo_oportunidade
        left join tabela_agrupada ta1 on ta1.idTabela = 29 and ta1.idCampo = co.oportunidade
        $where;")->fetch();
        foreach ($resultado as $atributo => $valor) {
            if (is_string($valor)) {
                $resultado[$atributo] = utf8_encode($valor);
            }
        }
        echo json_encode($resultado);
    }

    public function visualizarAction(){
        $id = explode(",",$_POST['id']);

        $dbGeral = Controller::getAdapterAcadeGeral();
        $path = explode('.', $_SERVER['HTTP_HOST']);
        if ($path[0] == 'www') {
            $path = $path[1];
        } else {
            $path = $path[0];
        }
        if($id[0]=="fotos"){
            $resultado = $dbGeral->query("SELECT *
            FROM `fotos_oportunidade`  where idOportunidade = ".$id[1]."
            ;")->fetchAll();
            $this->set('fotos', $resultado);
            $this->display('visualizarFotos');
        }
        elseif($id[0]=="visualizar"){
            $where = "where id_oportunidade = ".$id[1];
            $resultado = $dbGeral->query("SELECT co.*,ta.descricao as descricao_tipo_oportunidade,ta1.descricao as descricao_oportunidade, concat(ta1.descricao,'/', ta.descricao) as op, concat(co.id_oportunidade,'-', co.status) as idStatus
            FROM `cadastro_oportunidades` co
            left join  tabela_agrupada ta on ta.idTabela = CASE 
                            WHEN co.oportunidade = 5 THEN 31 
                            ELSE 30 
                            END and ta.idCampo = co.tipo_oportunidade
            left join tabela_agrupada ta1 on ta1.idTabela = 29 and ta1.idCampo = co.oportunidade
            $where;")->fetch();
            if($resultado['nm_dominio']!=$path && $path!="oportunidades"){
                $resultado['telefone']='(81) 9 7102-6454';
                $resultado['whatsapp']='(81) 9 7102-6454';
                $resultado['celular']='(81) 9 7102-6454';
                $resultado['email']='assessoria@acade.com.br';
            }
            $this->set('dados', $resultado);
            if($path!=$resultado['nm_dominio']){
                $this->dbGeral->update(array('op' => TB_OPORTUNIDADES), array(
                    'visualizacoes'=>$resultado['visualizacoes']+1
                ), 'id_oportunidade = ' .$resultado['id_oportunidade']);
            }
            $this->display('visualizar');
        }
    }
    public function fotosOportunidadeAction(){
        $dbGeral = Controller::getAdapterAcadeGeral();

        $resultado = $dbGeral->query("SELECT *
        FROM `fotos_oportunidade`  where idOportunidade = ".$_GET['id']."
        ;")->fetchAll();
        foreach ($resultado as $index => $op) {
            foreach ($op as $atributo => $valor) {
                if (is_string($valor)) {
                    $resultado[$index][$atributo] = utf8_encode($valor);
                }
            }
        }
        echo json_encode($resultado);
    }
    public function indexAction()
    {
        $this->display('listar');
    }
    public function cadastroAction()
    {
        if($_POST){
            /*if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'cadastroOportunidades')) {
                $this->redir(array('modulo' => '', 'controller' => 'admin', 'action' => 'index'), array('msg' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            }*/
            $path = explode('.', $_SERVER['HTTP_HOST']);
            if ($path[0] == 'www') {
                $path = $path[1];
            } else {
                $path = $path[0];
            }
            $insert = $this->dbGeral->insert(array('op' => TB_OPORTUNIDADES), array(
                'oportunidade' => $_POST['oportunidade'],
                'tipo_oportunidade' => $_POST['tipo_oportunidade']?$_POST['tipo_oportunidade']:$_POST['tipo_servico_oportunidade'],
                'valor' =>$_POST['valor']?Helper::getInputMoney($_POST['valor']):0,
                'nm_dominio'=>$path,
                'area' => $_POST['area'],
                'nr_cep' => $_POST['nr_cep'],
                'endereco' => $_POST['endereco'],
                'bairro' =>$_POST['bairro'],
                'cidade' => $_POST['cidade'],
                'estado' => implode(',',$_POST['estado']),
                'ds_oportunidade' => $_POST['ds_oportunidade'],
                'status' => $_POST['status'],
                'nm_pessoa' => $_POST['nm_pessoa'],
                'email' => $_POST['email'],
                'telefone' => $_POST['telefone'],
                'celular' => $_POST['celular'],
                'whatsapp' => $_POST['whatsapp'],
                'lat' => $_POST['lat'],
                'long' => $_POST['long'],
                'titulo' => $_POST['titulo'],
                'log' => 'Adicionado '.date('Y-m-d H:i:s').' por '.Login::getUsuario()->getLogin(),
                'usuario' => Login::getUsuario()->getId(),
            ));
            $id = $this->dbGeral->query('SELECT LAST_INSERT_ID() as id;')->fetch()['id'];
            $this->redirect(['modulo' => 'oportunidades', 'controller' => 'cadastro', 'action' => 'index','msg'=>'success']);
        }
        $oportunidade = $this->dbGeral->query("SELECT ta.idCampo,ta.descricao
        FROM tabela_agrupada ta where ta.idTabela = 29;")->fetchAll();
        $this->set('lista_oportunidades', $oportunidade);

        $tipo_oportunidade = $this->dbGeral->query("SELECT ta.idCampo,ta.descricao
        FROM tabela_agrupada ta where ta.idTabela = 30;")->fetchAll();
        $this->set('tipo_oportunidade', $tipo_oportunidade);

        
        $tipo_servicos_oportunidade = $this->dbGeral->query("SELECT ta.idCampo,ta.descricao
        FROM tabela_agrupada ta where ta.idTabela = 31;")->fetchAll();
        $this->set('tipo_servicos_oportunidade', $tipo_servicos_oportunidade);
        
        $this->display('editar');
    }
    public function favoritarAction(){
        if($_POST){
            
            $path = explode('.', $_SERVER['HTTP_HOST']);
            if ($path[0] == 'www') {
                $path = $path[1];
            } else {
                $path = $path[0];
            }
            $data = $this->dbGeral->query("SELECT * from favoritos_oportunidades
            where oportunidade = ".$_POST['oportunidade']." and cliente = '".$path."' and usuario = ".Login::getUsuario()->getId()."
            ;")->fetch();
            
            if(!$data){
                
                $insert = $this->dbGeral->insert(array('op' => TB_FAVORITOS_OPORTUNIDADES), array(
                    'usuario' => Login::getUsuario()->getId(),
                    'cliente' => $path,
                    'oportunidade' =>$_POST['oportunidade']
                ));
                echo json_encode(array("msg"=>"Sucesso",'status'=>1,'id'=>$insert));
            }
            else{
                $this->dbGeral->delete("favoritos_oportunidades",array("id = ?" => $data['id']));
                echo json_encode(array("msg"=>"Sucesso",'status'=>1,'id'=>"-1"));
            }
        }
        else{
            echo json_encode(array("msg"=>"falha",'status'=>0));
        }
    }
    public function editarAction()
    {
        $path = explode('.', $_SERVER['HTTP_HOST']);
        if ($path[0] == 'www') {
            $path = $path[1];
        } else {
            $path = $path[0];
        }
        
        $data = $this->dbGeral->query("SELECT co.*,ta.descricao as descricao_tipo_oportunidade,ta1.descricao as descricao_oportunidade
        FROM `cadastro_oportunidades` co
        left join  tabela_agrupada ta on  ta.idTabela = CASE 
                           WHEN co.oportunidade = 5 THEN 31 
                           ELSE 30 
                        END  and ta.idCampo = co.tipo_oportunidade
        left join tabela_agrupada ta1 on ta1.idTabela = 29 and ta1.idCampo = co.oportunidade
        where id_oportunidade = ".$_GET['id'].";")->fetch();
        
        if($path!=$data['nm_dominio']){
            $this->dbGeral->update(array('op' => TB_OPORTUNIDADES), array(
                'visualizacoes'=>$data['visualizacoes']+1
            ), 'id_oportunidade = ' .$data['id_oportunidade']);
        }
        if($_POST){
            /*if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'cadastroOportunidades')) {
                $this->redir(array('modulo' => '', 'controller' => 'admin', 'action' => 'index'), array('msg' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            }*/
            if($_POST['id_oportunidade']){
                $this->dbGeral->update(array('op' => TB_OPORTUNIDADES), array(
                    'oportunidade' => $_POST['oportunidade'],
                    'tipo_oportunidade' => $_POST['tipo_oportunidade']?$_POST['tipo_oportunidade']:$_POST['tipo_servico_oportunidade'],
                    'valor' =>Helper::getInputMoney($_POST['valor']),
                    'area' => $_POST['area'],
                    'nr_cep' => $_POST['nr_cep'],
                    'endereco' => $_POST['endereco'],
                    'bairro' =>$_POST['bairro'],
                    'cidade' => $_POST['cidade'],
                    'estado' => implode(',',$_POST['estado']),
                    'ds_oportunidade' => $_POST['ds_oportunidade'],
                    'status' => $_POST['status'],
                    'nm_pessoa' => $_POST['nm_pessoa'],
                    'email' => $_POST['email'],
                    'telefone' => $_POST['telefone'],
                    'celular' => $_POST['celular'],
                    'whatsapp' => $_POST['whatsapp'],
                    'lat' => $_POST['lat'],
                    'long' => $_POST['long'],
                    'log' => 'Atualizado '.date('Y-m-d H:i:s').' por '.Login::getUsuario()->getLogin(),
                    'titulo' => $_POST['titulo'],
                ), 'id_oportunidade = ' .$_POST['id_oportunidade']);
                
                $this->redirect(['modulo' => 'oportunidades', 'controller' => 'cadastro', 'action' => 'index', 'msg'=>'success']);
            }
            
        }
        $this->set('oportunidade', $data);

        $oportunidade = $this->dbGeral->query("SELECT ta.idCampo,ta.descricao
        FROM tabela_agrupada ta where ta.idTabela = 29;")->fetchAll();
        $this->set('lista_oportunidades', $oportunidade);

        
        $fotos = $this->dbGeral->query("SELECT *
        FROM fotos_oportunidade where idOportunidade =".$_GET['id'].";")->fetchAll();
        $this->set('fotos', $fotos);

        $tipo_oportunidade = $this->dbGeral->query("SELECT ta.idCampo,ta.descricao
        FROM tabela_agrupada ta where ta.idTabela = 30;")->fetchAll();
        $this->set('tipo_oportunidade', $tipo_oportunidade);

        $tipo_servicos_oportunidade = $this->dbGeral->query("SELECT ta.idCampo,ta.descricao
        FROM tabela_agrupada ta where ta.idTabela = 31;")->fetchAll();
        $this->set('tipo_servicos_oportunidade', $tipo_servicos_oportunidade);
        $this->display('editar');
    }
    public function mudarStatusAction()
    {
        if($_POST){
            if($_POST['id_oportunidade']){
                $this->dbGeral->update(array('op' => TB_OPORTUNIDADES), array(
                    'status' => $_POST['status'],
                    'log' => 'Status atualizado '.date('Y-m-d H:i:s').' por '.Login::getUsuario()->getLogin(),
                ), 'id_oportunidade = ' .$_POST['id_oportunidade']);
                
               echo json_encode(array("msg"=>"Sucesso",'status'=>1));
            }
            
        }
    }
    public function adicionarImagemAction(){
        $path = explode('.', $_SERVER['HTTP_HOST']);
            if ($path[0] == 'www') {
                $path = $path[1];
            } else {
                $path = $path[0];
            }
            $diretorio = getcwd()."/upload/cliente/".$path."/oportunidades/";
            if (!is_dir($diretorio)) {
                mkdir($diretorio, 0777, true);
            }
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['file'])) {
    $targetFile =  $diretorio . date('YmdHis').basename($_FILES["file"]["name"]);
    $uploadOk = 1;
    $imageFileType = strtolower(pathinfo($targetFile, PATHINFO_EXTENSION));

    // Verificar se o arquivo  uma imagem real ou uma imagem falsa
    $check = getimagesize($_FILES["file"]["tmp_name"]);
    if($check !== false) {
        $uploadOk = 1;
    } else {
        echo json_encode(array("status"=>0,"msg"=>"O arquivo no  uma imagem."));
        return false;
        $uploadOk = 0;
    }

    // Verificar se o arquivo j existe
    if (file_exists($targetFile)) {
        echo json_encode(array("status"=>0,"msg"=>"Desculpe, o arquivo j existe."));
        return false;
        $uploadOk = 0;
    }

    // Verificar o tamanho do arquivo
    if ($_FILES["file"]["size"] > 500000) {
        echo json_encode(array("status"=>0,"msg"=>"Desculpe, o arquivo  muito grande."));
return false;
        $uploadOk = 0;
    }

    // Verificar se $uploadOk est definido como 0 por um erro
    if ($uploadOk == 0) {
        echo json_encode(array("status"=>0,"msg"=>"Desculpe, seu arquivo no foi enviado."));
return false;
    // Se tudo estiver ok, tentar fazer o upload do arquivo
    } else {
        if (move_uploaded_file($_FILES["file"]["tmp_name"], $targetFile)) {
            
            $this->dbGeral->insert(array('fo' => 'fotos_oportunidade'), array(
                'idOportunidade' => $_POST['id_oportunidade'],
                'diretorio'=>str_replace(getcwd()."/",'',$targetFile)

            ));
            $id = $this->dbGeral->query('SELECT LAST_INSERT_ID() as id;')->fetch()['id'];
            echo json_encode(array("id"=>$id,"status"=>1,"msg"=>"Sucesso"));
        } else {
            echo json_encode(array("status"=>0,"msg"=>"Desculpe, houve um erro ao enviar seu arquivo"));
        }
    }
} else {
    
    echo json_encode(array("status"=>0,"msg"=>"Nenhum arquivo foi enviado."));
}


    }
    public function removerImagemAction(){
        
        $foto = $this->dbGeral->query("SELECT *
        FROM fotos_oportunidade where idFoto =".$_POST['idFoto'].";")->fetch();

        $file = getcwd()."/".$foto['diretorio'];

        if (file_exists($file)) {
            if (unlink($file)) {
                $this->dbGeral->delete("fotos_oportunidade",array("idFoto = ?" => $_POST['idFoto']));
                echo json_encode(array("status"=>1,"msg"=>"O arquivo foi apagado com sucesso"));
            return;
            } else {
                echo json_encode(array("status"=>0,"msg"=>"Ocorreu um erro ao tentar apagar o arquivo"));
return;
            }
        } else {
            $this->dbGeral->delete("fotos_oportunidade",array("idFoto = ?" => $_POST['idFoto']));
                
            echo json_encode(array("status"=>1,"msg"=>"O arquivo no existe."));
        }
    }
}