<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$listaEmpreendimento = $this->get('empreendimentos');
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader(); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form">
                    <fieldset>
                        <legend>Informaes da Reserva de Lotes <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                            <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                </svg>
                            </span>
                        </legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="id_contrato">
                                        Tipo:<span class="text-danger" title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <select class="form-control tipoLote select2" data-placeholder='Escolha o Tipo' id="tipoLote" name="tipoLote">                                        
                                        <option value="I">Individual</option>
                                        <option value="G">Grupo</option>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="id_empreendimento">
                                        Empreendimento:<span class="text-danger"
                                                             title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <select class="form-control select2 empreendimento_reserva"
                                            id="id_empreendimento" name="id_empreendimento"
                                            data-placeholder="Selecione o empreendimento" required="required">
                                        <option value=""></option>
                                        <?php foreach ($listaEmpreendimento as $k => $empreendimento) : ?>
                                            <option value="<?= $empreendimento['id']; ?>">
                                                <?= $empreendimento['nm_empreendimento']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label">
                                        Lotes:
                                    </label><br>
                                    <div class="col-sm-5">
                                        <input id="tipoDeLoteD" class="form-control icheck"
                                               style="margin-left: 20px" checked type="radio" name="tipoDeLote"
                                               value="disponiveis"/>
                                        <label for="tipoDeLoteD">Disponveis</label>
                                    </div>
                                    <div class="col-sm-5">
                                        
                                        <input id="tipoDeLoteT" class="form-control icheck"
                                               style="margin-left: 20px" type="radio" name="tipoDeLote"
                                               value="todos"/>
                                        <label for="tipoDeLoteT">Todos</label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="id_contrato">
                                        Lote:<span class="text-danger" title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <select class="form-control select2 lotes" name="lote[]" required="required"
                                            id="selectLote" data-placeholder="Escolha o Lote">
                                        <option value=""></option>
                                    </select>
                                </div>
                                
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label">
                                        Tipo de reserva:
                                    </label><br>
                                    <div class="col-sm-5">
                                        <input id="tipoReservaC" class="form-control icheck"
                                               style="margin-left: 20px" checked type="radio" name="tipoReserva"
                                               value="cliente"/>
                                        <label for="tipoReservaC">Cliente</label>
                                    </div>
                                    <div class="col-sm-5">
                                        <input id="tipoReservaT" class="form-control icheck"
                                               style="margin-left: 20px" type="radio" name="tipoReserva"
                                               value="construtor"/>
                                        <label for="tipoReservaT">Tcnica</label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-6 clienteDados" >
                                    <label for="idCorretor" class="control-label">Corretor:
                                        <span class="text-danger" title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <select class="form-control select2 corretores" required="required"
                                            data-placeholder="Escolha o corretor" name="corretor" id="idCorretor">
                                        <option></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row clienteDados">
                            <div class="col-sm-12">
                                
                            </div>
                        </div>
                        <div class="row clienteDados">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="nome_pessoa" class="control-label">Nome do cliente:
                                        <span class="text-danger" title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <input id="nome_pessoa" class="form-control" name="nome_pessoa" type="text">
                                </div>
                                <div class="form-group col-sm-3">
                                    <label for="telefone_pessoa" class="control-label">Telefone:
                                        <span class="text-danger" title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <input id="nome_pessoa" class="form-control phone" name="telefone_pessoa"
                                           type="text">
                                </div>
                            </div>
                        </div>
                        <div class="row tecnicaDados" hidden>
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="dsObservacao" class="control-label">Observao:
                                        <span class="text-danger" title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <textarea name="observacao" class="form-control" id="dsObservacao"></textarea>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="dt_final">
                                        Data final:
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="dt_final" placeholder="Data final da reserva"
                                        name="dt_final" value = ""/>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=<?= $_GET['m'] ?>&c=<?= ($_GET['c']); ?>&a=listar"
                                       class="btn btn-danger col-sm-12">Cancelar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>

            </div>
        </div>
    </div>
    <div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg ">
            <div class="modal-content">

                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;</button>
                    <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                        Tutorial</h2>
                </div>

                <div class="modal-body tableFix" style="max-height:600px;">
                    <fieldset >
                        <legend>Reserva de Lote - Cadastro, edio e excluso de Reserva Lotes</legend>
                        <div class="row" style="margin-right: 0px;margin-left: 0px;">
                            <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/ob3oO488uB0?si=2f4Cn6oyIp2Xd9tq" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>                            
                        </div>
                        <div></div>
                    </fieldset>
                </div>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>