<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$dados = $this->get("pessoa");
$representantes = $this->get("representantes");
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader('', 'Pessoa Jurdica'); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form">
                    <fieldset>
                        <legend>Informaes da Empresa <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                            <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                </svg>
                            </span>
                        </legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="CNPJCadastrado">
                                        CNPJ:<span id="spanCnpj" class="text-danger"
                                                   title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <input type="hidden" name="hiddenCnpj" value="<?= $dados['nr_cnpj'] ?>"/>
                                    <input type="text" class="form-control cnpj" id="CNPJCadastrado" placeholder="Digite o CNPJ"
                                           name="nr_cnpj" required="required" value="<?= $dados['nr_cnpj'] ?>"/>
                                </div>
                                <div class="form-group col-sm-5">
                                    <label class="control-label" for="nm_pessoa">
                                        Razo social:<span class="text-danger"
                                                           title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="nm_pessoa" maxlength="100" placeholder="Digite a razo social"
                                           name="nm_pessoa" required="required" value="<?= $dados['nm_pessoa'] ?>"/>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="nm_fantasia">
                                        Nome fantasia:<span class="text-danger"
                                                            title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="nm_fantasia" maxlength="45"
                                           name="nm_fantasia" required="required" placeholder="Digite o nome fantasia"
                                           value="<?= $dados['nm_fantasia'] ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nr_inscricao_municipal">
                                        Inscrio municipal:
                                    </label>
                                    <input type="text" class="form-control" id="nr_inscricao_municipal" maxlength="40"
                                           name="nr_inscricao_municipal" placeholder="Digite a inscrio municipal"
                                           value="<?= $dados['nr_inscricao_municipal'] ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nr_inscricao_estadual">
                                        Inscrio estadual:
                                    </label>
                                    <input type="text" class="form-control" id="nr_inscricao_estadual" maxlength="40"
                                           name="nr_inscricao_estadual" placeholder="Digite a inscrio estadual"
                                           value="<?= $dados['nr_inscricao_estadual'] ?>"/>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Informaes de contato</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="email">
                                        E-mail
                                    </label>
                                    <input type="text" class="form-control email" maxlength="45"
                                           id="email" name="email" placeholder="Digite o e-mail"
                                           value="<?= $dados['email'] ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nr_telefone">
                                        Telefone:
                                    </label>
                                    <input type="text" class="form-control"
                                           id="nr_telefone" name="nr_telefone" placeholder="Digite o telefone"
                                           value="<?= preg_replace('/[^\d+]/', '',$dados['nr_telefone']) ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nr_celular">
                                        Celular:
                                    </label>
                                    <input type="text" class="form-control"
                                           id="nr_celular" name="nr_celular" placeholder="Digite o celular"
                                           value="<?= preg_replace('/[^\d+]/', '',$dados['nr_celular']) ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nr_recado">
                                        Telefone de recado:
                                    </label>
                                    <input type="text" class="form-control"
                                           id="nr_recado" name="nr_recado" placeholder="Digite o telefone de recado"
                                           value="<?= preg_replace('/[^\d+]/', '',$dados['nr_recado']) ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nr_cep">
                                        CEP<span class="text-danger"
                                                 title="Este campo  obrigatrio.">*</span>:
                                        <span id="cepDesconhecido"></span>
                                    </label>
                                    <input type="text" class="form-control cepPj"
                                           id="nr_cep" name="nr_cep" placeholder="Digite o CEP"
                                           value="<?= $dados['nr_cep'] ?>"/>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="endereco">
                                        Endereo:
                                    </label>
                                    <input type="text" class="form-control" maxlength="45"
                                           id="endereco" name="endereco" placeholder="Digite o endereo"
                                           value="<?= $dados['endereco'] ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nr_endereco">
                                        Nmero:
                                    </label>
                                    <input type="text" class="form-control" maxlength="10"
                                           id="nr_endereco" name="nr_endereco" placeholder="Digite o nmero"
                                           value="<?= $dados['nr_endereco'] ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="ds_complemento">
                                        Complemento:
                                    </label>
                                    <input type="text" class="form-control" maxlength="45"
                                           id="ds_complemento" name="ds_complemento" placeholder="Digite o complemento"
                                           value="<?= $dados['ds_complemento'] ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nm_bairro">
                                        Bairro:
                                    </label>
                                    <input type="text" class="form-control" maxlength="45"
                                           id="nm_bairro" name="nm_bairro" placeholder="Digite o bairro"
                                           value="<?= $dados['nm_bairro'] ?>"/>
                                </div>
                                <div class="col-sm-3 form-group" id="cidade" style='<?= $dados['cd_cidade']=="9999999"?"display:none":""?>'>
                                    <label class="control-label" for="cd_cidade">
                                        Cidade:
                                    </label>
                                    <select class="form-control" name="cd_cidade" id="cd_cidade">
                                        <?php if (isset($dados['cd_cidade'])): ?>
                                            <option value="<?= $dados['cd_cidade'] ?>">
                                                <?= Cidade::getNomeById($dados['cd_cidade']) ?>
                                            </option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="col-sm-3 form-group" id="cidade_estrangeira"  style='<?= $dados['cd_cidade']!="9999999"?"display:none":""?>'>
                                    <label class="control-label" for="nm_cd_internacional">
                                        Cidade estrangeira:
                                    </label>
                                    <input type="text" class="form-control" maxlength="45"
                                           id="nm_cd_internacional" name="nm_cd_internacional"
                                           value="<?= $dados['nm_cd_internacional']?>"/>
                                </div>
                                <div class="form-group col-sm-3" style="text-align:center;">
                                    <label for="estrangeiro" class="control-label">
                                        Reside fora do pas
                                    </label>
                                    <div><input class="checkbox icheck" type="checkbox"  id="estrangeiro" <?= $dados['cd_cidade']=="9999999"?"checked":""?>></div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-12">
                                    <label class="control-label" for="ds_observacao">
                                        Observao:
                                    </label>
                                        <textarea class="form-control" id="ds_observacao" maxlength="300" placeholder="Digite a observao "
                                                  name="ds_observacao"><?= $dados['ds_observacao'] ?></textarea>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Representantes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-12">
                                    <label for="representantes" class="control-label">Representantes:<span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span>
                                            <span class="text-danger" title="O cliente j foi selecionado."
                                                  id="msgCompradores" hidden="hidden">
                                                O cliente s pode ser selecionado uma vez.
                                            </span>
                                    </label>
                                    <select class="form-control" name="representantes[]" required="required"
                                            id="representantes" multiple="multiple">
                                        <?php if (isset($representantes)): ?>
                                            <?php foreach ($representantes as $pessoa) : ?>
                                                <option selected value="<?= $pessoa['id'] ?>">
                                                    <?= $pessoa['nm_pessoa'] . ' (' . $pessoa['nr_cpf'] . $pessoa['nr_cnpj'] . ')' ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=<?= $_GET['m'] ?>&c=<?= ($_GET['c']); ?>&a=listar"
                                       class="btn btn-danger col-sm-12">Cancelar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>

            </div>
        </div>
    </div>
    <div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg ">
            <div class="modal-content">

                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;</button>
                    <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                        Tutorial</h2>
                </div>

                <div class="modal-body tableFix" style="max-height:600px;">
                    <fieldset >
                        <legend>Cadastro de pessoa jurdica</legend>
                        <div class="row" style="margin-right: 0px;margin-left: 0px;">
                            <iframe width="560" height="500" src="https://www.youtube.com/embed/YvLmqehXll8?si=s_RpwjXrxn3_DS-C" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                        </div>
                        <div></div>
                    </fieldset>
                </div>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>