<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$sexoOptions = $this->get("sexos");
$estCivilOptions = $this->get("estCivis");
$regCasamento = $this->get("regCasamento");
$cidadeOptions = $this->get("cidades");
$tpDocumentoOpt = $this->get("tpDocumentos");
$tipoArquivoOptions = $this->get("tipoArquivos");

$dados = $this->get('pessoa');
$conjuge = $this->get('conjuge');
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader('', 'Pessoa Fsica'); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form">
                    <fieldset>
                        <legend>
                            Informaes Pessoais <span style=" font-size: 10pt">(Campos com <span style="color: red">*</span> so obrigatrios)</span>
                            <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                </svg>
                            </span>
                        </legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="CPFCadastrado">
                                        CPF:<span class="text-danger"
                                                  title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <input type="hidden" name="hiddenCpf" value="<?= $dados['nr_cpf'] ?>"/>
                                    <input type="text" class="form-control cpf" id="CPFCadastrado"
                                           name="nr_cpf" required="required" value="<?= $dados['nr_cpf'] ?>"/>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="nm_pessoa">
                                        Nome:<span class="text-danger" title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="nm_pessoa" class="limitarNome" maxlength="60"
                                           name="nm_pessoa" required="required" value="<?= $dados['nm_pessoa'] ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="tpDocumento">
                                        Tipo de documento:<span class="text-danger"
                                                                title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <select class="form-control select2 tpDocumento" id="tpDocumento"
                                            name="tpDocumento" data-placeholder="Selecione o tipo de documento"
                                            required="required">
                                        <option value=""></option>
                                        <?php foreach ($tpDocumentoOpt as $k => $tpDocumento) : ?>
                                            <option value="<?= $tpDocumento['idCampo']; ?>" <?= ($dados['cd_documento'] == $tpDocumento['idCampo']) ? 'selected' : '' ?>>
                                                <?= $tpDocumento['descricao']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="nr_rg">
                                        Documento:<span class="text-danger"
                                                        title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="nr_rg" maxlength="40"
                                           name="nr_rg" required="required" value="<?= $dados['nr_rg'] ?>"/>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="control-label">
                                        Nacionalidade:<span style=" color: red">*</span>
                                    </label><br>
                                    <div class="col-sm-6">
                                        <input id="tpNacionalidadeB" class="form-control icheck" required="required"
                                               style="margin-left: 20px" <?= (!isset($dados['tp_nacionalidade']) || $dados['tp_nacionalidade'] == 'B') ? 'checked' : '' ?>
                                               type="radio" name="tpNacionalidade" value="B"/>
                                        <label for="tpNacionalidadeB">Brasileiro</label>
                                    </div>
                                    <div class="col-sm-6">
                                        <input id="tpNacionalidadeE" class="form-control icheck" required="required"
                                               style="margin-left: 20px" <?= ($dados['tp_nacionalidade'] == 'E') ? 'checked' : '' ?>
                                               type="radio" name="tpNacionalidade" value="E"/>
                                        <label for="tpNacionalidadeE">Estrangeiro</label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-3"
                                     id="divNacionalidade" <?= ($dados['tp_nacionalidade'] == 'E') ? '' : 'hidden' ?>>
                                    <label class="control-label" for="nm_nacionalidade">
                                        Nacionalidade:<span class="text-danger"
                                                            title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="nm_nacionalidade"
                                           placeholder="Digite a nacionalidade"
                                           name="nm_nacionalidade" maxlength="45"
                                           value="<?= $dados['nm_nacionalidade'] ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="sexo">
                                        Sexo:<span style=" color: red">*</span>
                                    </label>
                                    <select class="form-control select2 sexo" id="sexo"
                                            name="sexo" data-placeholder="Selecione o sexo." required="required">
                                        <option value=""></option>
                                        <?php foreach ($sexoOptions as $sexo) : ?>
                                            <option value="<?= $sexo['idCampo']; ?>" <?= ($dados['sexo'] == $sexo['idCampo']) ? 'selected' : '' ?>>
                                                <?= $sexo['descricao']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="est_civil">
                                        Estado civil:<span class="text-danger"
                                                           title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <select class="form-control select2 est_civil" id="est_civil"
                                            name="est_civil" data-placeholder="Selecione o estado civil"
                                            required="required">
                                        <option value=""></option>
                                        <?php foreach ($estCivilOptions as $estCivil) : ?>
                                            <option value="<?= $estCivil['idCampo']; ?>" <?= ($dados['est_civil'] == $estCivil['idCampo']) ? 'selected' : '' ?>>
                                                <?= $estCivil['descricao']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="est_civil">
                                        Regime de casamento:
                                    </label>
                                    <select class="form-control select2 est_civil" id="est_civil"
                                            name="reg_casamento" data-placeholder="Selecione o regime de casamento">
                                        <option value=""></option>
                                        <?php foreach ($regCasamento as $reg) : ?>
                                            <option value="<?= $reg['idCampo']; ?>" <?= ($dados['reg_casamento'] == $reg['idCampo']) ? 'selected' : '' ?>>
                                                <?= $reg['descricao']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>                        
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nm_profissao">
                                        Profisso:
                                    </label>
                                    <input type="text" class="form-control" id="nm_profissao" maxlength="45"
                                           name="nm_profissao" value="<?= $dados['nm_profissao'] ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="dt_nascimento">
                                        Data de nascimento:
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="dt_nascimento"
                                           name="dt_nascimento"
                                           value="<?= Helper::getDate($dados['dt_nascimento']) ?>"/>
                                </div>
                                <div class="col-sm-3 form-group">
                                    <label class="control-label" for="cidade_nasc">
                                        Cidade de nascimento:
                                    </label>
                                    <select class="form-control" name="cidade_nasc" id="cidade_nasc">
                                        <?php if (isset($dados['cd_cidade_nasc'])): ?>
                                            <option selected value="<?= $dados['cd_cidade_nasc'] ?>">
                                                <?= Cidade::getNomeById($dados['cd_cidade_nasc']) ?>
                                            </option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="nm_pai">
                                        Nome do pai:
                                    </label>
                                    <input type="text" class="form-control" id="nm_pai" maxlength="45"
                                           name="nm_pai" value="<?= $dados['nm_pai'] ?>"/>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="nm_mae">
                                        Nome da me:
                                    </label>
                                    <input type="text" class="form-control" id="nm_mae" maxlength="45"
                                           name="nm_mae" value="<?= $dados['nm_mae'] ?>"/>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <p> </p>
                        <legend>Informaes de Contato</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="email">
                                        E-mail:
                                    </label>
                                    <input type="text" class="form-control email"
                                           id="email" name="email" maxlength="45"
                                           value="<?= $dados['email'] ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nr_telefone">
                                        Telefone:
                                    </label>
                                    <input type="text" class="form-control"
                                           id="nr_telefone" name="nr_telefone" placeholder="Digite o telefone"
                                           value="<?= preg_replace('/[^\d+]/', '',$dados['nr_telefone']) ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nr_celular">
                                        Celular:
                                    </label>
                                    <input type="text" class="form-control "
                                           id="nr_celular" name="nr_celular" placeholder="Digite o celular"
                                           value="<?= preg_replace('/[^\d+]/', '',$dados['nr_celular']) ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nr_recado">
                                        Telefone de recado:
                                    </label>
                                    <input type="text" class="form-control"
                                           id="nr_recado" name="nr_recado" placeholder="Digite o telefone de recado"
                                           value="<?= preg_replace('/[^\d+]/', '',$dados['nr_recado']) ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3" id="cep" style='<?= $dados['cd_cidade']=="9999999"?"display:none":""?>'>
                                    <label class="control-label" for="nr_cep">
                                        CEP:
                                    </label>
                                    <input type="text" class="form-control cepPf"
                                           id="nr_cep" name="nr_cep"
                                           value="<?= $dados['nr_cep'] ?>"/>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="endereco">
                                        Endereo:
                                    </label>
                                    <input type="text" class="form-control"
                                           id="endereco" name="endereco" maxlength="45"
                                           value="<?= $dados['endereco'] ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nr_endereco">
                                        Nmero:
                                    </label>
                                    <input type="text" class="form-control" maxlength="10"
                                           id="nr_endereco" name="nr_endereco"
                                           value="<?= $dados['nr_endereco'] ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="ds_complemento">
                                        Complemento:
                                    </label>
                                    <input type="text" class="form-control" maxlength="60"
                                           id="ds_complemento" name="ds_complemento"
                                           value="<?= $dados['ds_complemento'] ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nm_bairro">
                                        Bairro:
                                    </label>
                                    <input type="text" class="form-control" maxlength="45"
                                           id="nm_bairro" name="nm_bairro"
                                           value="<?= $dados['nm_bairro'] ?>"/>
                                </div>
                                
                                <div class="col-sm-3 form-group" id="cidade" style='<?= $dados['cd_cidade']=="9999999"?"display:none":""?>'>
                                    <label class="control-label" for="cd_cidade">
                                        Cidade:
                                    </label>
                                    <select class="form-control" name="cd_cidade" id="cd_cidade">
                                        <?php if (isset($dados['cd_cidade'])): ?>
                                            <option value="<?= $dados['cd_cidade'] ?>">
                                                <?= Cidade::getNomeById($dados['cd_cidade']) ?>
                                            </option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="col-sm-3 form-group" id="cidade_estrangeira"  style='<?= $dados['cd_cidade']!="9999999"?"display:none":""?>'>
                                    <label class="control-label" for="nm_cd_internacional">
                                        Cidade estrangeira:
                                    </label>
                                    <input type="text" class="form-control" maxlength="45"
                                           id="nm_cd_internacional" name="nm_cd_internacional"
                                           value="<?= $dados['nm_cd_internacional']?>"/>
                                </div>
                                <div class="form-group col-sm-3" style="text-align:center;">
                                    <label for="estrangeiro" class="control-label">
                                        Reside fora do pas
                                    </label>
                                    <div><input class="checkbox icheck" type="checkbox"  id="estrangeiro" <?= $dados['cd_cidade']=="9999999"?"checked":""?>></div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-12">
                                    <label class="control-label" for="ds_observacao">
                                        Observao:
                                    </label>
                                        <textarea class="form-control" id="ds_observacao" maxlength="300"
                                                  name="ds_observacao"><?= $dados['ds_observacao'] ?></textarea>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset><br>
                        <div class="camposConjuge" <?= in_array($dados['est_civil'], array('CAS', 'UNE')) ? 'style="display: block;"' : '' ?>>
                            <legend>Informaes do Cnjuge:</legend>
                            <input type="hidden" name="idConjuge" id="idConjuge" value="<?= $conjuge['pessoa']['id'] ?>">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="nrCpfConjuge">
                                            CPF cnjuge:<span style=" color: red" class="text-danger"
                                                              title="Este campo  obrigatrio.">*</span>
                                        </label>
                                        <input type="text" class="form-control cpf" id="nrCpfConjuge"
                                               name="nrCpfConjuge" value="<?= $conjuge['pessoa']['nr_cpf']; ?>"/>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="nmConjuge">
                                            Nome:<span style=" color: red" class="text-danger"
                                                       title="Este campo  obrigatrio.">*</span>
                                        </label>
                                        <input type="text" class="form-control" id="nmConjuge" maxlength="60"
                                               name="nmConjuge" value="<?= $conjuge['pessoa']['nm_pessoa'] ?>"/>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="sexoConjuge">
                                            Sexo do cnjuge:<span style=" color: red" class="text-danger"
                                                                  title="Este campo  obrigatrio.">*</span>
                                        </label>
                                        <select class="form-control select2 sexo" id="sexoConjuge"
                                                name="sexoConjuge" data-placeholder="Selecione o sexo.">
                                            <option value=""></option>
                                            <?php foreach ($sexoOptions as $sexo) : ?>
                                                <option value="<?= $sexo['idCampo']; ?>" <?= ($conjuge['pessoa']['sexo'] == $sexo['idCampo']) ? 'selected' : '' ?>>
                                                    <?= $sexo['descricao']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="tpDocumentoConjuge">
                                            Tipo de documento:
                                        </label>
                                        <select class="form-control select2 tpDocumentoConjuge"
                                                id="tpDocumentoConjuge"
                                                name="tpDocumentoConjuge"
                                                data-placeholder="Selecione o tipo de documento">
                                            <option value=""></option>
                                            <?php foreach ($tpDocumentoOpt as $k => $tpDocumento) : ?>
                                                <option value="<?= $tpDocumento['idCampo']; ?>" <?= ($dados['cd_documento'] == $tpDocumento['idCampo']) ? 'selected' : '' ?>>
                                                    <?= $tpDocumento['descricao']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="nrRgConjuge">
                                            Documento:
                                        </label>
                                        <input type="text" class="form-control" id="nrRgConjuge"
                                               name="nrRgConjuge" maxlength="40"
                                               value="<?= $conjuge['pessoa']['nr_rg'] ?>"/>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label">
                                            Nacionalidade:
                                        </label><br>
                                        <div class="col-sm-6">
                                            <label for="tpNacionalidadeConjugeB">Brasileiro</label>
                                            <input id="tpNacionalidadeConjugeB" class="form-control icheck"
                                                   style="margin-left: 20px" <?= (!isset($conjuge['pessoa']['tp_nacionalidade']) || $conjuge['pessoa']['tp_nacionalidade'] == 'B') ? 'checked' : '' ?>
                                                   type="radio" name="tpNacionalidadeConjuge" value="B"/>
                                        </div>
                                        <div class="col-sm-6">
                                            <label for="tpNacionalidadeConjugeE">Estrangeiro</label>
                                            <input id="tpNacionalidadeConjugeE" class="form-control icheck"
                                                   style="margin-left: 20px" <?= ($conjuge['pessoa']['tp_nacionalidade'] == 'E') ? 'checked' : '' ?>
                                                   type="radio" name="tpNacionalidadeConjuge" value="E"/>
                                        </div>
                                    </div>
                                    <div class="form-group col-sm-3"
                                         id="divNacionalidadeConjuge" <?= ($conjuge['pessoa']['tp_nacionalidade'] == 'E') ? '' : 'hidden' ?>>
                                        <label class="control-label" for="nmNacionalidadeConjuge">
                                            Nacionalidade do cnjuge:
                                        </label>
                                        <input type="text" class="form-control" id="nmNacionalidadeConjuge"
                                               placeholder="Digite a nacionalidade" maxlength="45"
                                               name="nmNacionalidadeConjuge"
                                               value="<?= $conjuge['pessoa']['nm_nacionalidade'] ?>"/>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="nmProfissaoConjuge">
                                            Profisso cnjuge:
                                        </label>
                                        <input type="text" class="form-control" id="nmProfissaoConjuge"
                                               name="nmProfissaoConjuge" maxlength="40"
                                               value="<?= $conjuge['pessoa']['nm_profissao'] ?>"/>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="dtNascimentoConjuge">
                                            Data de nascimento do cnjuge:
                                        </label>
                                        <input type="text" class="form-control data datepicker-input"
                                               id="dtNascimentoConjuge" name="dtNascimentoConjuge"
                                               value="<?= Helper::getDate($conjuge['pessoa']['dt_nascimento']) ?>"/>
                                    </div>
                                    <div class="col-sm-3 form-group">
                                        <label class="control-label" for="cidade_nascConjuge">
                                            Cidade de nascimento:
                                        </label>
                                        <select class="form-control" name="cidade_nascConjuge"
                                                id="cidade_nascConjuge">
                                            <?php if (isset($conjuge['pessoa']['cd_cidade_nasc'])): ?>
                                                <option selected
                                                        value="<?= $conjuge['pessoa']['cd_cidade_nasc'] ?>">
                                                    <?= Cidade::getNomeById($conjuge['pessoa']['cd_cidade_nasc']) ?>
                                                </option>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label">
                                            Utilizar o mesmo endereo da pessoa fsica?
                                        </label><br>
                                        <div class="col-sm-6">
                                            <label for="enderecoConjugeS">Sim</label>
                                            <input id="enderecoConjugeS" class="form-control icheck"
                                                   style="margin-left: 20px" <?= ($conjuge['conjugeEndereco'] === 1) ? 'checked' : '' ?>
                                                   type="radio" name="utilizarEnderecoConjuge" value="1"/>
                                        </div>
                                        <div class="col-sm-6">
                                            <label for="enderecoConjugeN">No</label>
                                            <input id="enderecoConjugeN" class="form-control icheck"
                                                   style="margin-left: 20px" <?= (!isset($conjuge['conjugeEndereco']) || $conjuge['conjugeEndereco'] === 0) ? 'checked' : '' ?>
                                                   type="radio" name="utilizarEnderecoConjuge" value="0"/>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <div class="enderecoConjuge" <?= $conjuge['conjugeEndereco'] === 0 ? 'style="display: block;"' : 'style="display: none;"' ?>>
                            <legend>Endereo do conjuge</legend>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="nrCepConjuge">
                                            CEP do cnjuge: <span id="cepDesconhecidoConjuge"></span>
                                        </label>
                                        <input type="text" class="form-control cepPfConjuge"
                                               id="nrCepConjuge" name="nrCepConjuge"
                                               value="<?= $conjuge['pessoa']['nr_cep'] ?>"/>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="enderecoConjuge">
                                            Endereo do cnjuge:
                                        </label>
                                        <input type="text" class="form-control" maxlength="45"
                                               id="enderecoConjuge" name="enderecoConjuge"
                                               value="<?= $conjuge['pessoa']['endereco'] ?>"/>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="nr_enderecoConjuge">
                                            Nmero do cnjuge:
                                        </label>
                                        <input type="text" class="form-control" maxlength="10"
                                               id="nr_enderecoConjuge" name="nr_enderecoConjuge"
                                               value="<?= $conjuge['pessoa']['nr_endereco'] ?>"/>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="ds_complementoConjuge">
                                            Complemento do cnjuge:
                                        </label>
                                        <input type="text" class="form-control" maxlength="40"
                                               id="ds_complementoConjuge" name="ds_complementoConjuge"
                                               value="<?= $conjuge['pessoa']['ds_complemento'] ?>"/>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="nmBairroConjuge">
                                            Bairro do cnjuge:
                                        </label>
                                        <input type="text" class="form-control" maxlength="40"
                                               id="nmBairroConjuge" name="nmBairroConjuge"
                                               value="<?= $conjuge['pessoa']['nm_bairro'] ?>"/>
                                    </div>
                                    <div class="col-sm-3 form-group">
                                        <label class="control-label" for="cidadeConjuge">
                                            Cidade do cnjuge:
                                        </label>
                                        <select class="form-control" name="cidadeConjuge"
                                                id="cidadeConjuge">
                                            <?php if (isset($conjuge['pessoa']['cd_cidade'])): ?>
                                                <option selected value="<?= $conjuge['pessoa']['cd_cidade'] ?>">
                                                    <?= Cidade::getNomeById($conjuge['pessoa']['cd_cidade']) ?>
                                                </option>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=<?= $_GET['m'] ?>&c=<?= ($_GET['c']); ?>&a=listar"
                                       class="btn btn-danger col-sm-12">Cancelar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>

            </div>
        </div>
    </div>
    <div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg ">
            <div class="modal-content">

                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;</button>
                    <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                        Tutorial</h2>
                </div>

                <div class="modal-body tableFix" style="max-height:600px;">
                    <fieldset >
                        <legend>Cadastro de pessoa fsica - Dados Para cadastro de Clientes</legend>
                        <div class="row" style="margin-right: 0px;margin-left: 0px;">
                            <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/o9AsoMHD7sA?si=d625buwfukWFYGsp" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                        </div>
                        <div></div>
                    </fieldset>
                </div>
            </div>
        </div>
    </div>
    <style>
        .telefone {
            background: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="40" height="30"><text x="5" y="19" style="font: bold 16px Arial;">+</text></svg>') no-repeat;
            padding-left: 16px;
        }
    </style>
<?php require_once 'layout/includes/footer.php'; ?>