<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';
$cartaCobranca = $this->get('cartaCobranca');
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader(); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="formContato">
                    <fieldset>
                        <legend>Informaes do Modelo <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                            <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                </svg>
                            </span>
                        </legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="tp_carta">
                                        Tipo de modelo:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2" name="tp_carta" id="tp_carta" required="required"
                                            data-placeholder="Selecione o tipo de carta">
                                        <option value=""></option>
                                        <?php foreach ($this->get('tpCarta') as $k => $carta) : ?>
                                            <option
                                                value="<?= $k ?>" <?= ($k == $cartaCobranca['tp_modelo']) ? 'selected' : '' ?>>
                                                <?= $carta ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="nm_titulo_carta">
                                        Ttulo:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input class="form-control" name="nm_titulo_carta" id="nm_titulo_carta" required="required"
                                           type="text" maxlength="100" placeholder="Digite o ttulo da carta"
                                           value="<?= ($cartaCobranca['nm_titulo']) ? $cartaCobranca['nm_titulo'] : ''; ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6" <?= $cartaCobranca['tp_modelo'] == 'CD' ? '' : 'hidden' ?>>
                                    <label class="control-label" for="tp_carta_cobranca">
                                        Modelo da carta:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2" name="tp_carta_cobranca" id="tp_carta_cobranca"
                                            style="width: 100%" data-placeholder="Selecione o modelo da carta">
                                        <option value=""></option>
                                        <?php if ($cartaCobranca): ?>
                                            <?php foreach ($this->get('cartas') as $k => $carta) : ?>
                                                <option
                                                    value="<?= $k ?>" <?= ($k == $cartaCobranca['tp_carta_distrato']) ? 'selected' : '' ?>>
                                                    <?= $carta ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row" id="divTextoCima" <?= ($cartaCobranca['tp_modelo'])?'':'hidden'?>>
                            <div class="col-sm-12">
                                <div class="form-group col-sm-12" >
                                    <label class="control-label" for="ds_texto_cima">
                                        Texto da parte superior:
                                    </label>
                                        <textarea class="ckeditor form-control" cols="40" rows="7" id="ds_texto_cima"
                                                  name="ds_texto_cima"><?= ($cartaCobranca['ds_texto_cima']) ? $cartaCobranca['ds_texto_cima'] : ''; ?></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row" id="divTextoBaixo" <?= ($cartaCobranca['tp_modelo'] && ($cartaCobranca['tp_modelo']=='CD' || $cartaCobranca['tp_modelo']=='CC'))?'':'hidden'?>>
                            <div class="col-sm-12">
                                <div class="form-group col-sm-12" >
                                    <label class="control-label" for="ds_texto_baixo">
                                        Texto da parte inferior:
                                    </label>
                                        <textarea class="ckeditor form-control" cols="40" rows="7" id="ds_texto_baixo"
                                                  name="ds_texto_baixo"><?= ($cartaCobranca['ds_texto_baixo']) ? $cartaCobranca['ds_texto_baixo'] : ''; ?></textarea>
                                </div>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=lo&c=modelo&a=listar" class="btn btn-danger col-sm-12">Cancelar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>

            </div>
        </div>
    </div>
    <div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg ">
            <div class="modal-content">

                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;</button>
                    <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                        Tutorial</h2>
                </div>

                <div class="modal-body tableFix" style="max-height:600px;">
                    <fieldset >
                        <legend>Modelo - Adio e Edio e Excluso de Cadastros de Relatrios e Documentos Impressos</legend>
                        <div class="row" style="margin-right: 0px;margin-left: 0px;">
                            <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/MvLqc_qpC9Y?si=jDpBiDpSuWmzLI6w" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                        </div>
                        <div></div>
                    </fieldset>
                </div>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>