<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$dados = $this->get('lote');
$listaEmpreendimento = $this->get('empreendimentos');
$listaTipoImovel = $this->get('tb_agrupada');
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader(); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form">
                    <input type="hidden" id="editarLote" value="<?= $dados['lote']; ?>">
                    <input type="hidden" id="editarQuadra" value="<?= $dados['quadra']; ?>">
                    <fieldset>
                        <legend>Informa&ccedil;&otilde;es do Lote <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> s&atilde;o obrigat&oacute;rios)</span>
                            <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                </svg>
                            </span>
                        </legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="id_empreendimento">
                                        Empreendimento:<span class="text-danger"
                                                             title="Este campo &eacute; obrigat&oacute;rio.">*</span>
                                    </label>
                                    <select class="form-control select2 empreendimento_lote" id="id_empreendimento"
                                            name="id_empreendimento" data-placeholder="Selecione o empreendimento"
                                            required="required">
                                        <option value=""></option>
                                        <?php foreach ($listaEmpreendimento as $k => $empreendimento) : ?>
                                            <option value="<?= $empreendimento['id']; ?>" <?= ($dados['id_empreendimento'] == $empreendimento['id']) ? 'selected' : '' ?>>
                                                <?= $empreendimento['nm_empreendimento']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="quadra">
                                        Quadra:<span class="text-danger" title="Este campo &eacute; obrigat&oacute;rio.">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="quadra" size="5"
                                           name="quadra" required="required" value="<?= $dados['quadra'] ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="lote">
                                        Lote:<span class="text-danger" title="Este campo &eacute; obrigat&oacute;rio.">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="lote" size="5"
                                           name="lote" required="required" value="<?= $dados['lote'] ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label for="valor" class="control-label">Valor: </label>
                                    <input class="form-control money" id="valor" name="valor"
                                           type="text" value="<?= Helper::getMoney($dados['valor']) ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="rgi">
                                        RGI individual:
                                    </label>
                                    <input type="text" class="form-control" id="rgi"
                                           name="rgi" value="<?= $dados['rgi'] ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label">Constru&ccedil;&atilde;o:</label><br>
                                    <div class="checkbox">
                                        <label for="construcaoS">
                                            <input id="construcaoS" class="form-control icheck"
                                                   style="margin-left: 20px" <?= ($dados['fl_construcao'] == '1') ? 'checked' : '' ?>
                                                   type="radio" name="construcao" value="1"/>Sim</label>
                                    </div>
                                    <div class="checkbox">
                                        <label for="construcaoN">
                                            <input id="construcaoN" class="form-control icheck"
                                                   style="margin-left: 20px" <?= (!isset($dados['fl_construcao']) || $dados['fl_construcao'] == '0') ? 'checked' : '' ?>
                                                   type="radio" name="construcao" value="0"/>N&atilde;o</label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label">Caucionado:</label><br>
                                    <div class="checkbox">
                                        <label for="fl_caucionado">
                                            <input id="fl_caucionado" class="form-control icheck"
                                                   style="margin-left: 20px" <?= ($dados['fl_caucionado'] == '1') ? 'checked' : '' ?>
                                                   type="radio" name="fl_caucionado" value="1"/>Sim</label>
                                    </div>
                                    <div class="checkbox">
                                        <label for="fl_caucionado">
                                            <input id="fl_caucionado" class="form-control icheck"
                                                   style="margin-left: 20px" <?= (!isset($dados['fl_caucionado']) || $dados['fl_caucionado'] == '0') ? 'checked' : '' ?>
                                                   type="radio" name="fl_caucionado" value="0"/>N&atilde;o</label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label for="area" class="control-label">&Aacute;rea(m&sup2;):<span class="text-danger"
                                                                                           title="Este campo &eacute; obrigat&oacute;rio.">*</span></label>
                                    <input type="text" class="form-control money" id="area"
                                           name="area" required="required" value="<?= Helper::getMoney($dados['area']) ?>"/>
                                </div>
                            </div>
                    </fieldset>
                    <fieldset>
                        <legend>Medi&ccedil;&atilde;o</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label for="frente" class="control-label">Frente(m):</label>
                                    <input type="text" class="form-control" id="frente"
                                           name="frente" value="<?= Helper::getInputMoney2($dados['frente']) ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label for="fundo" class="control-label">Fundo(m):</label>
                                    <input type="text" class="form-control" id="fundo"
                                           name="fundo" value="<?= Helper::getInputMoney2($dados['fundo']) ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label for="direita" class="control-label">Direita(m):</label>
                                    <input type="text" class="form-control" id="frente"
                                           name="direita" value="<?= Helper::getInputMoney2($dados['direita']) ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label for="esquerda" class="control-label">Esquerda(m):</label>
                                    <input type="text" class="form-control" id="esquerda"
                                           name="esquerda" value="<?= Helper::getInputMoney2($dados['esquerda']) ?>"/>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Confronta&ccedil;&atilde;o</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="conf_frente" class="control-label">Frente com:</label>
                                    <input type="text" class="form-control" id="conf_frente"
                                           name="conf_frente" value="<?= $dados['conf_frente'] ?>"/>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label for="conf_fundo" class="control-label">Fundo com:</label>
                                    <input type="text" class="form-control" id="conf_fundo"
                                           name="conf_fundo" value="<?= $dados['conf_fundo'] ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="conf_direita" class="control-label">Direita com:</label>
                                    <input type="text" class="form-control" id="conf_direita"
                                           name="conf_direita" value="<?= $dados['conf_direita'] ?>"/>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label for="conf_esquerda" class="control-label">Esquerda com:</label>
                                    <input type="text" class="form-control" id="conf_esquerda"
                                           name="conf_esquerda" value="<?= $dados['conf_esquerda'] ?>"/>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Medi&ccedil;&atilde;o e Confronta&ccedil;&atilde;o</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="ds_geral" class="control-label">Descri&ccedil;&atilde;o geral</label>
                                    <textarea class="form-control" name="ds_geral" id="ds_geral" cols="50" rows="5" placeholder="Digite a descri&ccedil;&atilde;o geral do lote"><?= $dados['ds_geral'] ?></textarea>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label"> Tipo do imov&eacute;l:<span class="text-danger" title="Este campo &eacute; obrigat&oacute;rio.">*</span></label>
                                    <select class="form-control select2" name="tipo_imovel" data-placeholder="Selecionar tipo" required="required">
                                        <option value=""></option>
                                        <?php foreach ($listaTipoImovel as $tipoImovel) : ?>
                                        <option value="<?= $tipoImovel['complemento'] ?>" <?= $dados['tipo_imovel']==$tipoImovel['complemento']?"selected":""; ?>><?= $tipoImovel['descricao'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="obsLote" class="control-label">Observa&ccedil;&atilde;o</label>
                                    <textarea class="form-control" name="obsLote" id="obsLote" cols="50" rows="5" placeholder="Informa&ccedil;&otilde;es adicionais do lote"><?= $dados['obs_lote'] ?></textarea>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Localiza&ccedil;&atilde;o</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="latitude" class="control-label">Latitude:</label>
                                    <input type="text" class="form-control" id="latitude"
                                           name="latitude" value="<?= $dados['latitude'] ?>"/>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label for="longitude" class="control-label">Longitude:</label>
                                    <input type="text" class="form-control" id="longitude"
                                           name="longitude" value="<?= $dados['longitude'] ?>"/>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </div>
            <fieldset style="margin: 15px;">
                <legend>Opera&ccedil;&otilde;es</legend>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-2">
                            <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                        </div>
                        <div class="form-group col-sm-2">
                            <a href="?m=<?= $_GET['m'] ?>&c=<?= ($_GET['c']); ?>&a=listar"
                               class="btn btn-danger col-sm-12">Cancelar </a>
                        </div>
                    </div>
                </div>
            </fieldset>
            </form>
        </div>
    </div>
    <div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg ">
            <div class="modal-content">

                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;</button>
                    <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                        Tutorial</h2>
                </div>

                <div class="modal-body tableFix" style="max-height:600px;">
                    <fieldset >
                        <legend>Cadastro de lotes - Cadastro e Importao de Dados referente aos Lotes Memorias Descritivos</legend>
                        <div class="row" style="margin-right: 0px;margin-left: 0px;">
                            <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/o3MXq-msfH8?si=_kRB7a9lnX5TMqpQ" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                        </div>
                        <div></div>
                    </fieldset>
                </div>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>