<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$dados = $this->get('lote');
$listaEmpreendimento = $this->get('empOptions');
?>
    <div class="content">
        <div class="container">
            <div class="page-heading">
                <?= $this->getHeader('Importar', 'Lotes', 'glyphicon glyphicon-import'); ?>
            </div>
            <div class="widget">
                <div class="widget-content padding">
                    <!-- MENSAGENS -->
                    <?php if (count($this->_helper->getMensagens()) > 0): ?>
                        <div class="alert alert-danger alert-dismissable">
                            <?php foreach ($this->_helper->getMensagens() as $message): ?>
                                <?= $message ?><br>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    <form action="" method="POST" id="form" enctype="multipart/form-data">
                        <input type="hidden" id="editarLote" value="<?= $dados['lote']; ?>">
                        <input type="hidden" id="editarQuadra" value="<?= $dados['quadra']; ?>">
                        <fieldset>
                            <legend>Dados:</legend>
                            <div class="row">
                                <div class="col-sm-5">
                                    <div class="form-group col-sm-12">
                                        <label class="control-label" for="empreendimento">
                                            Empreendimento:<span class="text-danger"
                                                                 title="Este campo &eacute; obrigat&oacute;rio.">*</span>
                                        </label>
                                        <select class="form-control select2 empreendimento_importar" id="empreendimento"
                                                name="empreendimento" data-placeholder="Selecione o Empreendimento"
                                                required="required">
                                            <option value=""></option>
                                            <?php foreach ($listaEmpreendimento as $k => $empreendimento) : ?>
                                                <option value="<?= $empreendimento['id']; ?>" <?= ($dados['id_empreendimento'] == $empreendimento['id']) ? 'selected' : '' ?>>
                                                    <?= $empreendimento['nm_empreendimento']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-12">
                                        <input type="file" id="arquivo" class="fileinput" name="arquivo"
                                               title="Escolher Arquivo"/>
                                    </div>
                                    <!--radio box aki-->
                                </div>
                                <div class="col-sm-7">
                                    <div class="form-group col-sm-12">
                                        <strong>Observa&ccedil;&otilde;es</strong><br>
                                        - Regras para importao <span data-toggle="modal" data-target=".mVisualizar" class="glyphicon glyphicon-question-sign" style="font-size: 22px;">
                                        </span>
                                    </div>
                                </div>
                                <div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                                    aria-hidden="true">
                                    <div class="modal-dialog modal-lg ">
                                        <div class="modal-content">

                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal"
                                                        aria-hidden="true">&times;</button>
                                                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-eye"></i>
                                                    Visualizar</h2>
                                            </div>

                                            <div class="modal-body tableFix">
                                                <fieldset>
                                                    <legend>Regras para importao</legend>
                                                    
                                                    <div class="row">
                                                        <div class="form-group col-sm-12">
                                                        <p style="font-weight:bold">Passo a Passo Resumido para Criao e Importao de Planilha de Lotes no Excel</p>
                                                        <p style="font-weight:bold">Configurao Inicial da Planilha:</p>

                                                        <p>Crie uma nova pasta de trabalho em branco no Excel.</p>
                                                        <p>Selecione toda a planilha (Ctrl + A).</p>
                                                        <p>Altere o tipo de dado de todas as clulas para "TEXTO".</p>
                                                        <p style="font-weight:bold">Observaes Importantes:</p>

                                                        <p style="font-weight:bold">Lotes Numricos:</p>
                                                        <p>Devem estar em unidade de centena (Ex.: 001, 010, 100).</p>
                                                        <p style="font-weight:bold">Separador Decimal:</p>
                                                        <p>Use ponto para separar casas decimais (Ex.: 20.25, 20.00).</p>
                                                        <p style="font-weight:bold">Campo Valor:<p>
                                                        <p>No utilize unidade monetria, vrgulas ou pontos para unidades de milhar (Ex.: 100000.00).</p>

                                                        <p style="font-weight:bold">1 Forma:</p> 
                                                        <p>Importar por Medio Individual</p>
                                                        <p style="font-weight:bold">Preparao da Planilha:</p>

                                                        <p>Copie os dados da seo "Importar por Medio individual" e cole na primeira linha da planilha.</p>
                                                        <p style="font-weight:bold">Preencha as colunas:</p>
                                                        <p>Quadra, Lote, Frente, Fundo, Esquerda, Direita, Conf. Frente, Conf. Fundo, Conf. Esquerda, Conf. Direita, rea Total, RGI, Valor, Tipo Imvel (C-comercial, R-residencial, T-terreno).</p>
                                                        <p style="font-weight:bold">Observao:</p>
                                                        <p>Os dados de Confrontaes, RGI e Valor so opcionais.</p>
                                                        <p style="font-weight:bold">Finalizao:</p>

                                                        <p>Exclua a primeira linha (cabealho).</p>
                                                        <p>Salve a planilha como "memorial" no formato Excel 97-2003 (XLS).</p>

                                                        <p style="font-weight:bold">2 Forma:</p>
                                                        <p>Importar por Descrio</p>

                                                        <p>Caso possua os dados dos lotes em um memorial no formato Word ou PDf em Texto, siga os passos a seguir </p>

                                                        <p style="font-weight:bold">Preparao da Planilha:</p>

                                                        <p>Copie os dados da seo "Importar por descrio" e cole na primeira linha da planilha.</p>
                                                        <p style="font-weight:bold">Preencha os campos:</p>
                                                        <p>Quadra, Lote, Descrio (amplie a coluna) e, rea Total, RGI, Valor, Tipo Imvel (C-comercial, R-residencial, T-terreno).</p>
                                                        <p style="font-weight:bold">Observao:</p>
                                                        <p>Os dados de Confrontaes, RGI e Valor so opcionais.</p>
                                                        <p style="font-weight:bold">Observao 2:</p>
                                                        <p>No campo descrio, copie os dados de seu memorial word oi pdf e cole nesse campo.</p>

                                                        <p style="font-weight:bold">Finalizao:</p>

                                                        <p>Exclua a primeira linha (cabealho).</p>
                                                        <p>Salve a planilha como "memorial" no formato Excel 97-2003 (XLS).</p>

                                                        <p style="font-weight:bold">Importao da Planilha</p>

                                                        <p>Selecione o empreendimento desejado.</p>
                                                        <p style="font-weight:bold">Escolha o tipo de planilha:</p>
                                                        <p>"Importar por Medio individual" ou "Importar por descrio".</p>
                                                        <p>Clique em "Escolher arquivo" e selecione a planilha Excel salva.</p>
                                                        <p>Clique em "Abrir".</p>
                                                        <p>Clique no boto "Salvar" para importar os dados.</p>
                                                        <p>Seguindo esses passos, voc conseguir criar, preencher e importar a planilha de lotes corretamente.</p>
                                                        </div>
                                                    </div>
                                                </fieldset>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-default" data-dismiss="modal" id="cancelModal">
                                                    Fechar
                                                </button>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="col-sm-10">
                                        <input id="med_individual" class="form-control icheck"
                                               style="margin-left: 20px" type="radio" name="medicao" value="mi" checked/>
                                        <label for="med_individual">Importar por Medi&ccedil;&atilde;o individual</label>
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <table id="TabelaListar"
                                                       class="table  table-hover table-condensed order-column"
                                                       cellspacing="" width="100%">
                                                    <thead>
                                                    <tr>
                                                        <th style="text-align: center;">Quadra</th>
                                                        <th style="text-align: center;">Lote</th>
                                                        <th style="text-align: center;">Frente</th>
                                                        <th style="text-align: center;">Fundo</th>
                                                        <th style="text-align: center;">Esquerda</th>
                                                        <th style="text-align: center;">Direita</th>
                                                        <th style="text-align: center;">Conf. Frente</th>
                                                        <th style="text-align: center;">Conf. Fundo</th>
                                                        <th style="text-align: center;">Conf. Esquerda</th>
                                                        <th style="text-align: center;">Conf. Direita</th>
                                                        <th style="text-align: center;">&Aacute;rea Total</th>
                                                        <th style="text-align: center;">RGI</th>
                                                        <th style="text-align: center;">Valor</th>
                                                        <th style="text-align: center;">Tipo Im&oacute;vel</th>
                                                    </tr>
                                                    </thead>
                                                </table>
                                            </div>
                                        </div>
                                    </div><br><br><br><br>
                                    <div class="col-sm-10">
                                        <input id="med_descricao" class="form-control icheck"
                                               style="margin-left: 20px;" type="radio" name="medicao" value="md"/>
                                        <label for="med_descricao">Importar por descri&ccedil;&atilde;o</label>
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <table id="TabelaListar"
                                                       class="table  table-hover table-condensed order-column"
                                                       cellspacing="100" width="100%">
                                                    <thead>
                                                    <tr>
                                                        <th style="text-align: center;">Quadra</th>
                                                        <th style="text-align: center;">Lote</th>
                                                        <th style="text-align: center;">descri&ccedil;&atilde;o</th>
                                                        <th style="text-align: center;">&Aacute;rea Total</th>
                                                        <th style="text-align: center;">RGI</th>
                                                        <th style="text-align: center;">Valor</th>
                                                        <th style="text-align: center;">Tipo Im&oacute;vel</th>
                                                    </tr>
                                                    </thead>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                        <fieldset>
                            <legend>Opera&ccedil;&otilde;es</legend>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-2">
                                        <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                    </div>
                                    <div class="form-group col-sm-2">
                                        <a href="?m=<?= $_GET['m'] ?>&c=<?= ($_GET['c']); ?>&a=listar"
                                           class="btn btn-danger col-sm-12">Cancelar </a>
                                    </div>
                                </div>
                            </div>
                </div>
                </fieldset>
                </form>

            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>