<?php
$indice = $this->get("indice");
$mesesOptions = $this->get("meses");
$indicesOptions = $this->get("indices");
?>
<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader(); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form">
                    <fieldset>
                        <legend>Informaes do Indice <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span></legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="agr_descricaoIndice">
                                        Tipo de ndice:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2" name="agr_descricaoIndice"
                                            data-placeholder="Selecione o Tipo de ndice"
                                            id="agr_descricaoIndice" required="required">
                                        <option value=""></option>
                                        <?php foreach ($indicesOptions as $i): ?>
                                            <option value="<?= $i['idCampo']; ?>" <?= ($i['idCampo'] == $indice['agr_descricaoIndice']) ? 'selected' : '' ?>>
                                                <?= $i['descricao']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="mes">
                                        Ms:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2" name="mes" id="mes" required="required"
                                            data-placeholder="Selecione o Ms">
                                        <option value=""></option>
                                        <?php foreach ($mesesOptions as $mes => $detalhe): ?>
                                            <option value="<?= $mes ?>" <?= ($mes == $indice['mes']) ? 'selected' : '' ?>>
                                                <?= $detalhe; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="ano">
                                        Ano:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control soNumero" id="ano" required="required"
                                           placeholder="Digite o Ano completo" maxlength="4"
                                           name="ano" value="<?= $indice['ano'] ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="valor">
                                        Percentual:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control percent" id="valor" required="required"
                                           name="valor" value="<?= Helper::getMoney($indice['valor'], 4) ?>"/>
                                </div>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=<?= $_GET['m'] ?>&c=<?= $_GET['c'] ?>&a=listar"
                                       class="btn btn-danger col-sm-12">Cancelar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>

            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>