<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$empreendimento = $this->get("empreendimento");
$parceiros = $this->get("parcerias");
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader(); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?= ($_GET["msg"] == "success") ? '<div class="alert alert-success alert-dismissable">Operao realizada com sucesso.</div>'
                    : (($_GET['exception'] != '') ? '<div style="width:580px" class="alert alert-error alert-dismissable">' . $_GET['exception'] . '</div>' : '');
                ?>
                <?php if ($this->_helper->getMensagem("erro")): ?>
                    <div style="width:580px"
                         class="alert alert-error alert-dismissable"><?= $this->_helper->getMensagem("erro"); ?></div>
                <?php endif; ?>
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form" enctype="multipart/form-data">
                    <fieldset>
                        <legend>Empreendimento:</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="nm_empreendimento">
                                        Nome:
                                    </label>
                                    <input type="text" class="form-control" id="nm_empreendimento"
                                           name="nm_empreendimento" disabled
                                           value="<?= $empreendimento['nm_empreendimento']; ?>"/>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Parceiros:</legend>
                        <?php if (is_array($parceiros)) : ?>
                            <?php foreach ($parceiros as $parceiro) : ?>
                                <div class="row div<?= $parceiro['id_parceria_comissao'] ?>">
                                    <div class="col-sm-12">
                                        <div class="form-group col-sm-6">
                                            <label class="control-label">
                                                Nome:
                                            </label>
                                            <input type="text" class="form-control"
                                                   value="<?= $parceiro['nm_pessoa']; ?>" disabled/>
                                        </div>
                                        <div class="form-group col-sm-2">
                                            <label class="control-label">
                                                Comisso:
                                            </label>
                                            <input type="text" class="form-control" disabled
                                                   value="<?= ($parceiro['tp_comissao'] == 'F') ?  $_SESSION['simboloMoeda']. ' '. Helper::getMoney($parceiro['pc_comissao'], 2) : Helper::getMoney($parceiro['pc_comissao'], 3) . '%' ?>"/>
                                        </div>
                                        <div class="col-sm-2"><br>
                                            <a class="btn btn-primary col-sm-6 parceiro_rem"
                                               data-toggle="tooltip" title="REMOVER"
                                               parceiro="<?= $parceiro['id_parceria_comissao'] ?>">
                                                <i class="fa fa-times"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="row div<?= $parceiro['id_parceria_comissao'] ?>">
                                
                                    <div class="col-sm-12">
                                        <label class="control-label">
                                            Tipo de comisso:
                                        </label><br>
                                        <div class="checkbox">
                                            <label><input class="form-control icheck" disabled
                                                style="margin-left: 20px" <?= ($parceiro['tp_comissao'] == 'P') ? 'checked' : '' ?>
                                                type="radio" value="P" /> % parcela</label>
                                            <label><input class="form-control icheck" disabled
                                                style="margin-left: 20px" <?= ($parceiro['tp_comissao'] == 'PL') ? 'checked' : '' ?>
                                                type="radio" value="PL" /> % total</label>
                                            <label><input class="form-control icheck" disabled
                                                style="margin-left: 20px" <?= ($parceiro['tp_comissao'] == 'F') ? 'checked' : '' ?>
                                                type="radio" value="F" /> Fixo</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row div<?= $parceiro['id_parceria_comissao'] ?>">
                                    <div class="col-sm-12">
                                        <label class="control-label" style="float: left">
                                            Tipos de parcela:
                                        </label><br>
                                        <div class="checkbox">
                                            <label><input class="form-control icheck" disabled
                                                    <?= $parceiro['fl_parcela_normal'] == 1 ? 'checked' : '' ?>
                                                          type="checkbox" value="1"/> Normal</label>
                                            <label><input class="form-control icheck" disabled
                                                    <?= $parceiro['fl_parcela_intercalada'] == 1 ? 'checked' : '' ?>
                                                          type="checkbox" value="1"/> Intercalada</label>
                                            <label><input class="form-control icheck" disabled
                                                    <?= $parceiro['fl_parcela_chave'] == 1 ? 'checked' : '' ?>
                                                          type="checkbox" value="1"/> Chaves</label>
                                            <label><input class="form-control icheck" disabled
                                                    <?= $parceiro['fl_parcela_sinal'] == 1 ? 'checked' : '' ?>
                                                          type="checkbox" value="1"/> Sinal</label>
                                            <label><input class="form-control icheck" disabled
                                                    <?= $parceiro['fl_parcela_quitacao'] == 1 ? 'checked' : '' ?>
                                                          type="checkbox" value="1"/> Quitao</label>
                                            <label><input class="form-control icheck" disabled
                                                    <?= $parceiro['fl_parcela_negociada'] == 1 ? 'checked' : '' ?>
                                                          type="checkbox" value="1"/> Negociada</label>
                                            <label><input class="form-control icheck" disabled
                                                    <?= $parceiro['fl_parcela_avulsa'] == 1 ? 'checked' : '' ?>
                                                          type="checkbox" value="1"/> Avulsa</label>
                                        </div>
                                    </div>
                                </div>
                                <br>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </fieldset>
                    <fieldset>
                        <legend>Nova Parceria</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-5">
                                    <label for="cdParceiro" class="control-label">Nome:<span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <select class="form-control" name="cdParceiro" required="required"
                                            id="cdParceiro">
                                    </select>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="pcComissao">
                                        Comisso:
                                    </label>
                                    <input type="text" id="pcComissao" class="form-control tamanho"
                                           name="pcComissao"
                                           value=""/>
                                </div>
                                <div class="form-group col-sm-5">
                                    <label class="control-label">
                                        Tipo de comisso:
                                    </label><br>
                                    <div class="checkbox">
                                        <label for="tpComissaoP"><input id="tpComissaoP" class="form-control icheck"
                                                                        style="margin-left: 20px" <?= (!isset($parceiros['tp_comissao']) || $parceiros['tp_comissao'] == 'P') ? 'checked' : '' ?>
                                                                        type="radio" name="tpComissao" value="P"/> % parcela</label>
                                        <label for="tpComissaoPL"><input id="tpComissaoPL" class="form-control icheck"
                                                                         style="margin-left: 20px" <?= ($parceiros['tp_comissao'] == 'PL') ? 'checked' : '' ?>
                                                                         type="radio" name="tpComissao" value="PL"/> % total</label>
                                        <label for="tpComissaoF"><input id="tpComissaoF" class="form-control icheck"
                                                                        style="margin-left: 20px" <?= ($parceiros['tp_comissao'] == 'F') ? 'checked' : '' ?>
                                                                        type="radio" name="tpComissao" value="F"/> Fixo</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <label class="control-label" style="float: left">
                                    Tipos de parcela:
                                </label><br>
                                <div class="checkbox">
                                    <label for="tpParcelaN"><input id="tpParcelaN" class="form-control icheck" checked
                                                                   type="checkbox" name="fl_parcela_normal" value="1"/> Normal</label>
                                    <label for="tpParcelaI"><input id="tpParcelaI" class="form-control icheck" checked
                                                                   type="checkbox" name="fl_parcela_intercalada" value="1"/> Intercalada</label>
                                    <label for="tpParcelaC"><input id="tpParcelaC" class="form-control icheck" checked
                                                                   type="checkbox" name="fl_parcela_chave" value="1"/> Chaves</label>
                                    <label for="tpParcelaS"><input id="tpParcelaS" class="form-control icheck" checked
                                                                   type="checkbox" name="fl_parcela_sinal" value="1"/> Sinal</label>
                                    <label for="tpParcelaQ"><input id="tpParcelaQ" class="form-control icheck" checked
                                                                   type="checkbox" name="fl_parcela_quitacao" value="1"/> Quitao</label>
                                    <label for="tpParcelaG"><input id="tpParcelaG" class="form-control icheck" checked
                                                                   type="checkbox" name="fl_parcela_negociada" value="1"/> Negociada</label>
                                    <label for="tpParcelaA"><input id="tpParcelaA" class="form-control icheck" checked
                                                                   type="checkbox" name="fl_parcela_avulsa" value="1"/> Avulsa</label>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=<?= $_GET['m'] ?>&c=<?= ($_GET['c']); ?>&a=listar"
                                       class="btn btn-danger col-sm-12">Voltar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>