<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$bancos = $this->get('bancos');
$emps = $this->get('empreendimento');
$empsImage = $this->get('empreendimentoImagens');
$socios = $this->get('socios');
$responsaveis = $this->get('responsaveis');
$pessoas_envolvidas = $this->get('pessoas_envolvidas');
$tipoOptions = $this->get('tipos');
$indiceOptions = $this->get('indices');
$periodoOptions = $this->get('periodos');
$listaIndiceEmpreendimento = ($this->get('listaIndiceEmpreendimento'))?$this->get('listaIndiceEmpreendimento'):array();
$infoTipo = $this->get('infoTipo');

$cliente = $this->get('cliente');
$params = $this->get("params");
$nmDominio = "";
$url = explode('.', $_SERVER['HTTP_HOST']);
if ($url[0] == 'www') {
    $nmDominio = $url[1];
} else {
    $nmDominio = $url[0];
}
$nomeUrlEmpreendimento = strtr(str_replace(" ","",strtolower($emps['nm_empreendimento'])), 
" ", 
"aaaaeeiooouucAAAAEEIOOOUUC"); 
$link = "";
$curl = curl_init();
            
curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://acadelotear.com.br/formulario/'.$nmDominio.'/'.$nomeUrlEmpreendimento,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
));
$response = curl_exec($curl);
if (!curl_errno($curl)) {
    $info = curl_getinfo($curl);
    if($info['http_code']==200){
        $link ='https://acadelotear.com.br/formulario/'.$nmDominio.'/'.$nomeUrlEmpreendimento;
    }
  }

?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader(); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form" enctype="multipart/form-data">
                    <fieldset>
                        <legend>Informaes do Empreendimento <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                            <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                </svg>
                            </span>
                        </legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-12">
                                    <label class="control-label" for="nm_empreendimento">
                                        Nome empreedimento:<span class="text-danger" title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="nm_empreendimento"
                                           name="nm_empreendimento" size="60" placeholder="Nome do empreendimento"
                                           value="<?= $emps['nm_empreendimento']; ?>" required="required"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="socios" class="control-label">Partes interessadas:<span
                                                class="text-danger" title="Este campo  obrigatrio.">*</span>
                                        <span class="text-danger" title="O cliente j foi selecionado."
                                              id="msgCompradores" hidden="hidden">
                                                O cliente s pode ser selecionado uma vez.
                                            </span>
                                    </label>
                                    <select class="form-control" name="socios[]" required="required"
                                            id="socios" multiple="multiple">
                                        <?php if (isset($socios)): ?>
                                            <?php foreach ($socios as $pessoa) : ?>
                                                <option selected
                                                        value="<?= $pessoa['id'] ?>"><?= $pessoa['nm_pessoa'] . ' (' . $pessoa['nr_cpf'] . $pessoa['nr_cnpj'] . ')' ?></option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="col-sm-6 form-group">
                                    <label class="control-label">
                                        Pessoas envolvidas:
                                    </label>
                                    <label class="control-label" style="float: right">Responsvel</label>
                                    <div class="dd" id="nestable">
                                        <ol class="dd-list" id="listaResponsavel">
                                            <?php if ($pessoas_envolvidas): ?>
                                                <?php foreach ($pessoas_envolvidas as $pessoa): ?>
                                                    <li class="dd-item listaItem" id="list<?= $pessoa['id'] ?>">
                                                        <label class="dd-handle"
                                                               for="assinatura<?= $pessoa['id'] ?>">
                                                            <?= $pessoa['nm_pessoa'] ?>
                                                            <span style="width: 60px; float: right" align="center">
                                                                    <input type="checkbox" name="assinaturas[]"
                                                                           id="assinatura<?= $pessoa['id'] ?>"
                                                                           value="<?= $pessoa['id'] ?>" <?= in_array($pessoa['id'], $responsaveis) ? 'checked' : '' ?>>
                                                                </span>
                                                        </label>
                                                    </li>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-8">
                                    <label class="control-label" for="fl_assinatura">
                                        Assinam os documentos oficiais:
                                    </label><br>
                                    <div class="col-sm-4">
                                        <input id="fl_assinaturaE" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($emps['fl_assinatura'] == 'E') ? 'checked' : ''; ?>
                                               type="radio" name="fl_assinatura" value="E"/>
                                        <label for="fl_assinaturaE">Nome empreendimento</label>
                                    </div>
                                    <div class="col-sm-4">
                                        <input id="fl_assinaturaPI" class="form-control icheck"
                                               style="margin-left: 20px" <?= ($emps['fl_assinatura'] == 'PI') ? 'checked' : ''; ?>
                                               type="radio" name="fl_assinatura" value="PI"/>
                                        <label for="fl_assinaturaPI">Partes interessadas</label>
                                    </div>
                                    <div class="col-sm-4">
                                        <input id="fl_assinaturaPE" class="form-control icheck"
                                               style="margin-left: 20px" <?= (!in_array($emps['fl_assinatura'], array('E', 'PI'))) ? 'checked' : '' ?>
                                               type="radio" name="fl_assinatura" value="PE"/>
                                        <label for="fl_assinaturaPE">Pessoas envolvidas</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="porcAdmin">
                                        Administrao:
                                    </label>
                                    <input type="text" id="porcAdmin" name="porcAdmin"
                                           value="<?= Helper::getMoney($emps['porcAdmin'], 4); ?>"
                                           size="5" class="porcentagem form-control"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="porcAdmin">
                                        Devoluo <span class="require" style="color: red">(% ao Cliente)</span>:<span class="text-danger"
                                                        title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <input type="text" id="porcDev" name="porcDev" required="required"
                                           value="<?= Helper::getMoney($emps['porcDev'], 4); ?>" size="5"
                                           class="porcentagem form-control"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="porcAdmin">
                                        Devoluo: (% Fruio)
                                    </label>
                                    <input type="text" id="porcFru" name="porcFru"
                                           value="<?= Helper::getMoney($emps['porcFru'], 4); ?>" size="5"
                                           class="porcentagem form-control"/>
                                </div>
                                <div class="col-sm-3 form-group">
                                    <label class="control-label" for="tipo">
                                        Tipo loteamento:<span class="text-danger" title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <select class="form-control select2" id="tipo" name="tipo" required="required"
                                            data-placeholder="Selecione o tipo">
                                        <option value=""></option>
                                        <?php foreach ($infoTipo as $tipo):?>
                                            <option <?= ($tipo['id_tipo_loteamento'] == $emps['id_tipo_loteamento'])?'selected':''?> value="<?= $tipo['id_tipo_loteamento']; ?>">
                                                <?= $tipo['ds_tipo_loteamento'];?> (<?= $tipo['ds_grupo'];?>, <?= $tipo['ds_subgrupo'];?>)
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-6 form-group">
                                    <label class="control-label" for="rgi">
                                        RGI:
                                    </label>
                                    <input name="rgi" id="rgi" class="form-control" placeholder="Rgi"
                                           type="text" value="<?= $emps['rgi'] ?>" size="60"/>
                                </div>
                                <div class="col-sm-6 form-group">
                                    <label class="control-label" for="dt_conclusao">
                                        Data concluso:
                                    </label>
                                    <input name="dt_conclusao" id="dt_conclusao" type="text"
                                           class="data form-control datepicker-input"
                                           placeholder="Data de concluso"
                                           value="<?= $emps['dt_conclusao'] ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="nr_cep">
                                        CEP:
                                    </label>
                                    <input type="text" class="form-control cepEmp"
                                           id="nr_cep" name="nr_cep"
                                           value="<?= $emps['nr_cep'] ?>"/>
                                </div>
                                <div class="col-sm-4 form-group">
                                    <label class="control-label" for="bairro">
                                        Bairro:
                                    </label>
                                    <input class="form-control" type="text" id="bairro" name="bairro"
                                           placeholder="Bairro" value="<?= $emps['bairro']; ?>"/>
                                </div>
                                <div class="col-sm-4 form-group">
                                    <label class="control-label" for="cd_cidade">
                                        Cidade:<span class="text-danger" title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <select class="form-control" name="cd_cidade" id="cd_cidade"
                                            required="required">
                                        <option></option>
                                        <?php if (isset($params['cd_cidade'])): ?>
                                            <option selected value="<?= $params['cd_cidade'] ?>">
                                                <?= $params['cidade'] ?>
                                            </option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="maxParcela">
                                        Qtde mxima de parcela:
                                    </label>
                                    <input type="text" class="form-control soNumero" id="maxParcela"
                                           name="maxParcela" placeholder="N mximo de parcelas"
                                           value="<?= $emps['max_parcela']; ?>"/>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="latitude">
                                        Latitude:
                                    </label>
                                    <input type="text" class="form-control" id="latitude"
                                           name="latitude" placeholder="Latitude do emrpeendimento"
                                           value="<?= $emps['latitude']; ?>"/>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="longitude">
                                        Longitude:
                                    </label>
                                    <input type="text" class="form-control" id="longitude"
                                           name="longitude" placeholder="Longitude do emrpeendimento"
                                           value="<?= $emps['longitude']; ?>"/>
                                </div>
                            </div>
                        </div>
                        <legend>ndices</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-3 form-group">
                                    <label class="control-label" for="indice">
                                        Tipo de ͭndice:<span class="text-danger"
                                                             title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <select class="form-control select2" id="indice" name="indice"
                                            data-placeholder="Selecione o tipo de ndice">
                                        <option value=""></option>
                                        <?php if ($indiceOptions) : ?>
                                            <?php foreach ($indiceOptions as $indice): ?>
                                                <option value="<?= $indice['idCampo']; ?>">
                                                    <?= $indice['descricao']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="col-sm-2 form-group">
                                    <label class="control-label" for="periodoReajuste">
                                        Perodo de reajuste:<span class="text-danger"
                                                                  title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <select class="form-control select2" id="periodoReajuste"
                                            data-placeholder="Selecione o perodo de reajuste"
                                            name="periodoReajuste">
                                        <option value="">Selecione...</option>
                                        <?php if ($periodoOptions) : ?>
                                            <?php foreach ($periodoOptions as $k => $periodo): ?>
                                            <!-- Retirado a opo de 'AM' na listagem dos perodos -->
                                                <?php if ($k != 'AM') : ?>
                                                    <option value="<?= $k ?>">
                                                        <?= $periodo ?>
                                                    </option>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="col-sm-2 form-group" id="divPorcAdc">
                                    <label class="control-label" for="porcAdc">
                                        Porcentagem adicional:
                                    </label>
                                    <input type="text" id="porcAdc" name="porcAdc"
                                           placeholder="Porcentagem"
                                           value="" size="5"
                                           class="porcentagem form-control"/>
                                </div>
                                <div class="col-sm-2 form-group">
                                    <label class="control-label" for="periodoReajusteAdc">
                                        Perodo da porc. adicional:<span class="text-danger"
                                                                  title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <select class="form-control select2" id="periodoReajusteAdc"
                                            data-placeholder="Selecione o perodo de reajuste adicional"
                                            name="periodoReajusteAdc">
                                        <option value="">Selecione...</option>
                                        <option value="A">Anual</option>
                                        <option value="M">Mensal</option>
                                        <option value="S">Semestral</option>
                                    </select>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="fl_tabela_preco">
                                        Calcular resduo?
                                    </label><br>
                                    <div class="checkbox">
                                        <label><input id="calcResidioS" class="form-control icheck calcResidio" <?= ($listaIndiceEmpreendimento['fl_residuo'] == '1') ? 'checked' : ''; ?>
                                                      style="margin-left: 20px" type="radio" name="calcResidio" value="1"/> Sim</label>
                                        <label><input id="calcResidioN" class="form-control icheck calcResidio" <?= ($listaIndiceEmpreendimento['fl_residuo'] == '0') ? 'checked' : ''; ?>
                                                      style="margin-left: 20px" type="radio" name="calcResidio" checked value="0"/> No</label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-1">
                                    <br>
                                    <button class="btn btn-primary tipo_parcela_add" type="button" id="addIndice" data-toggle="tooltip" title="ADICIONAR NA LISTA">
                                        <i class="glyphicon glyphicon-plus-sign"> </i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="row" id="divTabelaIndices" <?= (!$listaIndiceEmpreendimento)?'hidden':''?>>
                            <div class="col-sm-12">
                                <div class="col-sm-7 form-group">
                                    <div class="table-responsive">
                                        <table class="table  table-hover table-condensed order-column"
                                               cellspacing="0" width="100%">
                                            <thead>
                                            <tr>
                                                <th>ndice</th>
                                                <th>Perodo de reajuste</th>
                                                <th>Porc. adicional</th>
                                                <th>Perodo da porc. adicional</th>
                                                <th>Resduo</th>
                                                <th>Status</th>
                                                <th width="55px;">Ao</th>
                                            </tr>
                                            </thead>
                                            <tbody id="tableIndices">
                                            <?php
                                            $contador = 1;
                                            foreach($listaIndiceEmpreendimento as $indiceEmpreendimento):
                                                $idIndice = ($indiceEmpreendimento['idContrato'])?'_'.$indiceEmpreendimento['id_indice_empreendimento']:'';
                                                ?>
                                                <tr id="indice<?= $contador?>">
                                                    <td><?= $indiceEmpreendimento['descricao']?></td>
                                                    <td>
                                                        <?= Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo'])?>
                                                        <?= ($indiceEmpreendimento['fl_periodo'] == 'AM')?' (IPE:'.Helper::getMoney($indiceEmpreendimento['indice_pos_entrega'],4).'%)':''?>
                                                    </td>
                                                    <td><?= ($indiceEmpreendimento['indice_adicional'] != '0')?number_format((float)$indiceEmpreendimento['indice_adicional'], 2, ',', '') . '%':'' ?></td>
                                                    <td>
                                                        <?= Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo_adc'])?>
                                                    </td>
                                                    <td> <?= ($indiceEmpreendimento['fl_residuo'] == '1') ? 'Sim' : 'No'?></td>

                                                    <td>
                                                        <div id="ativo_<?= $indiceEmpreendimento['id_indice_empreendimento'] ?>" >
                                                            <?php if($indiceEmpreendimento['fl_ativo'] == '1'): ?>
                                                                <a onClick="clickAtivo(<?= $indiceEmpreendimento['id_indice_empreendimento'] ?>)" data-toggle="tooltip" title="INATIVAR" class="btn ativar label label-success">
                                                                    Ativo
                                                                </a>
                                                            <?php else: ?>
                                                                <div>
                                                                    <a onClick="clickAtivo(<?= $indiceEmpreendimento['id_indice_empreendimento'] ?>)"  data-toggle="tooltip" title="ATIVAR" class="btn ativar label label-danger">Inativo</a>
                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div align="center" style="width: 100%;">
                                                            <button data-toggle="tooltip" title="REMOVER" class="btn btn-default btn-xs remIndice"  type="button" value="<?= (!$indiceEmpreendimento['idContrato'])?$contador:''?>">
                                                                <i class="fa fa-times"></i>
                                                            </button>
                                                        </div>
                                                    </td>
                                                    <input type="hidden" name="listaIndices[]" class="listaIndices" value="<?= $indiceEmpreendimento['id_indice'] . '_' .
                                                    $indiceEmpreendimento['fl_periodo'] . '_' . str_replace('.',',',$indiceEmpreendimento['indice_adicional']) . '_' .
                                                    $indiceEmpreendimento['fl_residuo'] . '_' . str_replace('.',',',$indiceEmpreendimento['fl_periodo_adc']) . $idIndice?>" />
                                                </tr>
                                                <?php $contador++; endforeach; ?>
                                            <input type="hidden" name="contador" id="contador" value="<?= $contador ?>"/>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <?php if ($cliente['fl_painel_venda'] == '1') : ?>
                        <fieldset>
                            <legend>Painel de vendas</legend>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="tempReserva">
                                            Tempo de reserva em dias:<span class="text-danger"
                                                                           title="Este campo  obrigatrio.">*</span>
                                        </label>
                                        <input type="text" class="form-control soNumero" id="tempReserva"
                                               name="tempReserva" placeholder="Tempo de reserva em dias"
                                               value="<?= $emps['temp_reserva']; ?>"/>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="qtdeReservaCorretor">
                                            Qtde de reserva por corretor:<span class="text-danger"
                                                                               title="Este campo  obrigatrio.">*</span>
                                        </label>
                                        <input type="text" class="form-control soNumero" id="qtdeReservaCorretor"
                                               name="qtdeReservaCorretor" placeholder="Reservas por corretor"
                                               value="<?= $emps['qtde_reserva_corretor']; ?>"/>
                                    </div>
                                    
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="fl_tabela_preco">
                                            Utilizar tabela de preo em contrato?
                                        </label><br>
                                        <div class="col-sm-6">
                                            <input id="fl_tabela_preco1" class="form-control icheck"
                                                   style="margin-left: 20px" <?= ($emps['fl_tabela_preco'] == '1') ? 'checked' : ''; ?>
                                                   type="radio" name="fl_tabela_preco" value="1"/>
                                            <label for="fl_tabela_preco1">Sim</label>
                                        </div>
                                        <div class="col-sm-6">
                                            <input id="fl_tabela_preco0" class="form-control icheck"
                                                   style="margin-left: 20px" <?= ($emps['fl_tabela_preco'] != '1') ? 'checked' : ''; ?>
                                                   type="radio" name="fl_tabela_preco" value="0"/>
                                            <label for="fl_tabela_preco0">No</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                    <?php endif; ?>
                    <?php if ($cliente['fl_senhaportal'] == '1') : ?>
                        <fieldset>
                            <legend>Acade Portal</legend>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="negociacaoPortal">
                                            No abrir negociao:
                                            <span class="fa fa-question-circle" style="font-size: 18px;" data-toggle="tooltip" data-placement="top" 
                                                title="Essa opo permite bloquear a rotina negociao para o seu cliente no Portal caso tenha uma certa quantidade de parcelas em atraso.">
                                            </span>
                                        </label>
                                        <input type="text" class="form-control soNumero" id="negociacaoPortal"
                                               name="negociacaoPortal" placeholder="Limite de parcelas atrasadas"
                                               value="<?= $emps['negociacao_portal']; ?>"
                                        />
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                    <?php endif; ?>
                    <?php if ($cliente['fl_acade_finan'] == '1') : ?>
                        <?php if ($this->get('conneccao')) : ?>
                            <fieldset>
                                <legend>Acade Finan</legend>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group col-sm-3">
                                            <label class="control-label" for="fl_integracao">
                                                Integrao:
                                            </label><br>

                                            <div class="col-sm-6">
                                                <input id="fl_integracao1" class="form-control icheck fl_integracao"
                                                       style="margin-left: 20px" <?= ($emps['fl_integracao'] == '1') ? 'checked' : ''; ?>
                                                       type="radio" name="fl_integracao" value="1"/>
                                                <label for="fl_integracao1">Sim</label>
                                            </div>
                                            <div class="col-sm-6">
                                                <input id="fl_integracao0" class="form-control icheck fl_integracao"
                                                       style="margin-left: 20px" <?= ($emps['fl_integracao'] != '1') ? 'checked' : ''; ?>
                                                       type="radio" name="fl_integracao" value="0"/>
                                                <label for="fl_integracao0">No</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row camposIntegraca" <?= ($emps->fl_integracao != '1') ? 'hidden="hidden"' : '' ?>>
                                    <div class="col-sm-12">
                                        <div class="form-group col-sm-4">
                                            <label class="control-label" for="empFinan">
                                                Empreendimento:
                                            </label>
                                            <select name="empFinan" id="empFinan"
                                                    data-placeholder="Selecione o Empreendimento"
                                                    class="form-control select2">
                                                <option value="">Selecione ...</option>
                                                <?php if ($this->get('empFinan') && count($this->get('empFinan'))) : ?>
                                                    <?php foreach ($this->get('empFinan') as $empFinan) : ?>
                                                        <option value="<?= $empFinan['cd_empreendimento'] ?>"
                                                            <?= ($empFinan['cd_empreendimento'] == $emps['cd_empreendimento']) ? 'selected' : '' ?>>
                                                            <?= $empFinan['ds_empreendimento'] ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                        <div class="form-group col-sm-4">
                                            <label class="control-label" for="centroCusto">
                                                Centro de custo:
                                            </label>
                                            <select name="centroCusto" id="centroCusto"
                                                    data-placeholder="Selecione o centro de custo"
                                                    class="form-control select2">
                                                <option value="">Selecione ...</option>
                                                <?php if ($this->get('centroCusto') && count($this->get('centroCusto'))) : ?>
                                                    <?php foreach ($this->get('centroCusto') as $centroCusto) : ?>
                                                        <option value="<?= $centroCusto['cd_centro_custo'] ?>"
                                                            <?= ($centroCusto['cd_centro_custo'] == $emps['cd_centro_custo']) ? 'selected' : '' ?>>
                                                            <?= $centroCusto['ds_centro_custo'] ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row camposIntegraca" <?= ($emps->fl_integracao != '1') ? 'hidden="hidden"' : '' ?>>
                                    <div class="col-sm-12">
                                        <div class="form-group col-sm-4">
                                            <label class="control-label" for="contaCredito">
                                                Conta crdito:
                                            </label>
                                            <select name="contaCredito" id="contaCredito"
                                                    data-placeholder="Selecione a conta para crdito"
                                                    class="form-control select2">
                                                <option value="">Selecione ...</option>
                                                <?php if ($this->get('listaContaCredito') && count($this->get('listaContaCredito'))) : ?>
                                                    <?php foreach ($this->get('listaContaCredito') as $contaCredito) : ?>
                                                        <option value="<?= $contaCredito['cd_plano_conta'] ?>"
                                                            <?= ($contaCredito['cd_plano_conta'] == $emps['cd_conta_credito']) ? 'selected' : '' ?>>
                                                            <?= $contaCredito['ds_plano_conta'] ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                        <div class="form-group col-sm-4">
                                            <label class="control-label" for="contaDebito">
                                                Conta dbito:
                                            </label>
                                            <select name="contaDebito" id="contaDebito"
                                                    data-placeholder="Selecione a conta para dbito"
                                                    class="form-control select2">
                                                <option value="">Selecione ...</option>
                                                <?php if ($this->get('listaContaDebito') && count($this->get('listaContaDebito'))) : ?>
                                                    <?php foreach ($this->get('listaContaDebito') as $contaDebito) : ?>
                                                        <option value="<?= $contaDebito['cd_plano_conta'] ?>"
                                                            <?= ($contaDebito['cd_plano_conta'] == $emps['cd_conta_debito']) ? 'selected' : '' ?>>
                                                            <?= $contaDebito['ds_plano_conta'] ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>                                  
                                        <div class="form-group col-sm-4">
                                            <label class="control-label" for="contaTesouraria">
                                                Conta tesouraria:
                                            </label>
                                            <select name="contaTesouraria" id="contaTesouraria"
                                                    data-placeholder="Selecione a conta tesouraria"
                                                    class="form-control select2">
                                                <option value="">Selecione ...</option>
                                                <?php if ($this->get('contaMovimento') && count($this->get('contaMovimento'))) : ?>
                                                    <?php foreach ($this->get('contaMovimento') as $contaMovimento) : ?>
                                                        <option value="<?= $contaMovimento['cd_local_pagamento'] ?>"
                                                            <?= ($contaMovimento['cd_local_pagamento'] == $emps->cd_conta_tesouraria) ? 'selected' : '' ?>>
                                                            <?= $contaMovimento['ds_local_pagamento'] ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group col-sm-4">
                                            <label class="control-label" for="contaBanco">
                                                Banco:
                                            </label>
                                            <select name="contaBanco" id="contaBanco"
                                                    data-placeholder="Selecione o banco"
                                                    class="form-control select2">
                                                <option value="">Selecione ...</option>
                                                <?php if ($bancos && count($this->get('contaMovimento'))) : ?>
                                                    <?php foreach ($bancos as $banco) : ?>
                                                        <option value="<?= $banco['id'] ?>">
                                                            <?="Banco: ", $banco['nm_banco'], " - Conta: ", $banco['conta_corrente'], "-", $banco['conta_corrente_dv'] ; ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                        <div class="form-group col-sm-4">
                                            <label class="control-label" for="contaMovimento">
                                                Conta movimento Finan:
                                            </label>
                                            <select name="contaMovimento" id="contaMovimento"
                                                    data-placeholder="Selecione a conta movimento"
                                                    class="form-control select2">
                                                <option value="">Selecione ...</option>
                                                <?php if ($this->get('contaMovimento') && count($this->get('contaMovimento'))) : ?>                                                                                                        
                                                    <?php foreach ($this->get('contaMovimento') as $contaMovimento) : ?>
                                                        <option value="<?= $contaMovimento['cd_local_pagamento'] ?>">
                                                            <?= $contaMovimento['ds_local_pagamento'] ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                        <div class="form-group col-sm-1">
                                            <br>
                                            <button class="btn btn-primary addConta" type="button" id="addConta" data-toggle="tooltip" title="ADICIONAR NA LISTA">
                                                <i class="glyphicon glyphicon-plus-sign"> </i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="col-sm-8 form-group">
                                            <div class="table-responsive">
                                                <table class="table  table-hover table-condensed order-column"
                                                    cellspacing="0" width="100%" id="tableContas">
                                                    <thead>
                                                    <tr>
                                                        <th>Banco</th>
                                                        <th>Conta</th>
                                                        <th>Conta movimento Finan</th>
                                                        <th width="55px;">Ao</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody id="tbodyContas">                                                    
                                                    <?php foreach ($bancos as $key => $banco) : ?>
                                                    <?php if ($banco['id_finan']) : ?>
                                                        <tr id="<?= $banco['id'] ?>">
                                                            <td><?= $banco['nm_banco'] ?></td>
                                                            <td><?=  $banco['conta_corrente'], "-", $banco['conta_corrente_dv'] ;  ?></td>
                                                            <td>
                                                                <?php $contaMovimento = $this->get('contaMovimento'); ?>
                                                                <?php foreach ($contaMovimento as $contaMov) : ?>
                                                                    <?php if ($contaMov['cd_local_pagamento'] == $banco['id_finan']) : ?>
                                                                        <?php echo $contaMov['ds_local_pagamento'] ?>
                                                                    <?php endif; ?>
                                                                <?php endforeach; ?>                                                                                                                       
                                                            </td>
                                                            <td>
                                                                <div align="center" style="width: 100%;">
                                                                    <button data-toggle="tooltip" title="REMOVER" class="btn btn-default btn-xs removeConta" onClick="removeConta(<?= $banco['id'] ?>)" type="button" value="<?= $banco['id'] ?>">
                                                                        <i class="fa fa-times"></i>
                                                                    </button>
                                                                </div>                                                           
                                                            </td>
                                                        </tr>
                                                    <?php endif; ?>
                                                    <?php endforeach; ?>
                                                    <input type="hidden" name="contasFinan" id="inputContasFinan" value=""/>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    
                                </div>
                            </fieldset>
                        <?php endif; ?>
                    <?php endif; ?>
                    
                    <fieldset>
                        <legend>Contrato Digital</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <div class="col-sm-6">
                                        <label for="fl_contrato_digital1" <?=$cliente['fl_contrato_digital'] != '1'?" title='Entre em contato com o suporte para liberar o contrato digital!'":""; ?>>Sim</label>
                                        <input id="fl_contrato_digital1" class="form-control icheck fl_integracao"
                                                style="margin-left: 20px" <?= ($cliente['fl_contrato_digital'] == '1') ? 'checked' : ''; ?>
                                                type="radio" name="fl_contrato_digital" value="1" disabled/>
                                    </div>
                                    <div class="col-sm-6">
                                        <label for="fl_contrato_digital0">No</label>
                                        <input id="fl_contrato_digital0" class="form-control icheck fl_integracao"
                                                style="margin-left: 20px" <?= ($cliente['fl_contrato_digital'] != '1') ? 'checked' : ''; ?>
                                                type="radio" name="fl_contrato_digital" value="0" disabled/>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Comunicao</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="cnpjContato">
                                        CNPJ:
                                    </label>
                                    <input type="text" class="form-control cnpjContato"
                                           id="cnpjContato" name="cnpjContato"
                                           value="<?= $emps['cnpjContato'] ?>"/>
                                </div>
                                <div class="col-sm-3 form-group">
                                    <label class="control-label" for="telefoneContato">
                                        Telefone:
                                    </label>
                                    <input class="form-control" type="text" id="telefoneContato" name="telefoneContato"
                                           placeholder="telefoneContato" value="<?= $emps['telefoneContato']; ?>"/>
                                </div>
                                <div class="col-sm-3 form-group">
                                    <label class="control-label" for="eContato">
                                        E-mail:
                                    </label>
                                    <input class="form-control" type="text" id="emailContato" name="emailContato"
                                           placeholder="emailContato" value="<?= $emps['emailContato']; ?>"/>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Logomarca</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-6">
                                    <label for="dsPathLogo" class="control-label">Anexar arquivo: </label>
                                    <input title="Selecionar ..." name="dsPathLogo" id="dsPathLogo"
                                           type="file" class="fileinput"/>
                                </div>
                                <?php
                                //Pega o nome da imagem
                                $string = $emps['ds_path_logo'];
                                $pieces = explode('/', $string);
                                $last_word = array_pop($pieces);
                                ?>

                                <div class="col-sm-6">
                                    <label for="dsPathLogo" class="control-label">Imagem: </label>
                                    <div class="col-sm-12">
                                        <img height="100px" width="300px" src="<?= $emps['ds_path_logo'] ?>"
                                             alt="<?= $last_word ?>"/>
                                        <br>
                                        <a id="rem_logoEmpreendimento" href="<?= $emps['ds_path_logo'] ?>" download="">Baixar
                                            imagem</a>
                                        <a id="rem_logoEmpreendimento"
                                           href="?m=lo&c=empreendimento&a=excluirImagemLogo&id=<?= $emps['id'] ?>">Excluir
                                            imagem</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=<?= $_GET['m'] ?>&c=<?= ($_GET['c']); ?>&a=listar"
                                       class="btn btn-danger col-sm-12">Cancelar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="divulgacao" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">

                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;
                    </button>
                </div>
                <div class="modal-body tableFix">
                    <fieldset>
                        <input type="hidden" name="idEmpreendimento" value="<?= $_GET['id'];?>" id="idEmpreendimento">
                        <input type="hidden" name="nmDominio" value="<?= $nmDominio;?>" id="nmDominio">
                        <legend>Gerar link</legend>
                        <div class="row">
                            <div class="col-sm-12 form-group">
                                <label class="control-label" for="tituloFormulario">
                                    Ttulo do formulrio:
                                </label>
                                <input class="form-control" type="text" id="tituloFormulario" name="tituloFormulario"
                                        placeholder="Ttulo do formulrio" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12 form-group">
                                <label class="control-label" for="tituloFormulario">
                                    Link do formulrio:
                                </label>
                                <input class="form-control" type="text" disabled value="https://acadelotear.com.br/formulario/<?= $nmDominio."/".$nomeUrlEmpreendimento; ?>" />
                            </div>
                        </div>
                    </fieldset>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal" id="cancelModal">
                        Fechar
                    </button>
                    <input type="submit" class="btn btn-success fDesabilitaBtn" onclick="gerarLink()" value="Confirmar">
                </div>

            </div>
        </div>
    </div>
    <div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg ">
            <div class="modal-content">

                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;</button>
                    <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                        Tutorial</h2>
                </div>

                <div class="modal-body tableFix" style="max-height:600px;">
                    <fieldset >
                        <legend>Cadastro de empreendimento</legend>
                        <div class="row" style="margin-right: 0px;margin-left: 0px;">
                            <iframe width="560" height="500" src="https://www.youtube.com/embed/axAtgln4TRc?si=ybNxlb_ot7QvteU1" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                        </div>
                        <div></div>
                    </fieldset>
                </div>
            </div>
        </div>
    </div>
    <script>
        function gerarLink(){
            $.ajax({
                type: "POST",
                url: "?m=lo&c=empreendimento&a=gerarLink",
                data: {logo:"https://"+$("#nmDominio").val()+".acadeone.com.br/acadelotear/<?=$emps['ds_path_logo']?>",titulo:$("#tituloFormulario").val(),empreendimento:$("#idEmpreendimento").val(),'diretorio':$("#nmDominio").val()+'/<?=$nomeUrlEmpreendimento; ?>/','nomeArquivo':"index.php",'dominio':$("#nmDominio").val()},
                success: function(d){
                    console.log(d);
                    $("#divulgacao").modal('hide');
                    $("#linkEmpreendimento").val("<?='https://acadelotear.com.br/formulario/'.$nmDominio.'/'.$nomeUrlEmpreendimento?>");
                }
            });
        }
    </script>
<?php require_once 'layout/includes/footer.php'; ?>
