<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$dados = $this->get('dados');
$perfis = $this->get('perfis');
$usuario = $this->get('usuario');
if (!isset($dados['tiposParcelas']))
    $dados['tiposParcelas'] = array('N', 'S', 'I', 'Q', 'C', 'G');
$listaEmpreendimento = $this->get('empreendimentos');
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader(); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form">
                    <fieldset>
                        <legend>Informaes do Corretor <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                            <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                </svg>
                            </span>
                        </legend>                   
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="idCorretor" class="control-label">Corretor:
                                        <span class="text-danger" title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <select class="form-control select2 select2BigData corretor"
                                            id="idCorretor" <?= isset($dados['id_corretor']) ? 'disabled' : '' ?>
                                            data-placeholder="Digite o nome do corretor" required="required"
                                            name="corretor">
                                        <option></option>
                                        <?php if (isset($dados['id_corretor'])): ?>
                                            <option selected
                                                    value="<?= $dados['id_corretor'] ?>"><?= $dados['nm_pessoa'] ?></option>
                                        <?php endif; ?>
                                    </select>
                                    <input type="hidden" id="hcorretor" name="corretor_pessoa_fisica"
                                           value="<?= $dados['id_corretor'] ?>">
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="cdCreci">
                                        Creci:<span class="text-danger" title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="cdCreci" required
                                           name="creci" required="required" value="<?= $dados['nr_creci'] ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label">
                                        Status? <span class="require" style="color: red">*</span>
                                    </label><br>
                                    <div class="checkbox">
                                        <label>
                                            <input id="ativo" class="form-control icheck"
                                                   type="radio" name="flStatus" value="1"
                                                <?= ($dados['fl_ativo'] != '0')?'checked':''?>/>
                                            Ativo
                                        </label>
                                        <label>
                                            <input id="inativo" class="form-control icheck" type="radio" name="flStatus" value="0"
                                                <?= ($dados['fl_ativo'] == '0')?'checked':''?>/>
                                            Inativo
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="imobiliaria" class="control-label">Imobiliaria: </label>
                                    <select class="form-control select2BigData"
                                            data-placeholder="Digite o nome da imobiliaria"
                                            name="himobiliaria_corretor" id="imobiliaria">
                                        <option></option>
                                        <?php if (isset($dados['id_imobiliaria'])): ?>
                                            <option selected
                                                    value="<?= $dados['id_imobiliaria'] ?>"><?= $dados['nm_fantasia'] ?></option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="cdCreciPJ">
                                        Creci PJ:
                                    </label>
                                    <input type="text" class="form-control" id="cdCreciPJ"
                                           name="cdCreciPJ" value="<?= $dados['nr_creci_pj'] ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="hempreendimento_corretor" class="control-label">Empreendimento: <span
                                            class="text-danger" title="Este campo  obrigatrio.">*</span></label>
                                    <select class="form-control select2 hempreendimento_corretor"
                                            data-placeholder="Digite o(s) nome(s) do(s) empreendimento(s)" name="hempreendimento_corretor[]"
                                            id="empreendimento" multiple="multiple">
                                        <?php if ($_GET['a'] == 'editar'): ?>
                                            <?php foreach ($listaEmpreendimento as $empreendimento) : ?>
                                                <option selected value="<?= $empreendimento['id'] ?>">
                                                    <?= $empreendimento['nm_empreendimento'] ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Comisses</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <label for="pcComissao" id="spanValorOuDesc" class="control-label"><?= ($dados['tp_comissao'] == 'F') ? 'Valor:' : 'Porcentagem:'?> </label>

                                    <!-- a classe tamanho impede que caracteres como % sejam inseridos no campo abaixo -->
                                    <input class="form-control" id="pcComissao" name="pcComissao"
                                           type="text"
                                           value="<?= ($dados['pc_comissao'])?Helper::getMoney($dados['pc_comissao']):'' ?>"/>
                                </div>
                                <div class="form-group col-sm-10">
                                    <label class="control-label">
                                        Tipo de Comisso:
                                    </label><br>
                                    <div class="col-sm-3">
                                        <input id="tpComissaoF" class="form-control icheck"
                                               style="margin-right: -20px" <?= ($dados['tp_comissao'] == 'F') ? 'checked' : '' ?>
                                               type="radio" name="tpComissao" value="F"/>
                                        <label for="tpComissaoF">Valor fixo</label>
                                    </div>
                                    <div class="col-sm-3">
                                        <input id="tpComissaoP" class="form-control icheck"
                                               style="margin-right: -20px" <?= (!isset($dados['tp_comissao']) || $dados['tp_comissao'] == 'P') ? 'checked' : '' ?>
                                               type="radio" name="tpComissao" value="P"/>
                                        <label for="tpComissaoP">Porc. parcela</label>
                                    </div>
                                    <div class="col-sm-3">
                                        <!--Alterado campos de Porcentagem total, para total de vendas-->
                                        <input id="tpComissaoPL" class="form-control icheck"
                                               style="margin-right: -20px" <?= ($dados['tp_comissao'] == 'PL') ? 'checked' : '' ?>
                                               type="radio" name="tpComissao" value="PL"/>
                                        <label for="tpComissaoPL">Porc. total da venda</label>

                                    </div>
                                    <div class="col-sm-3">
                                        <!--Criado campos de Porcentagem total de parcela, para total de vendas-->
                                        <input id="tpComissaoPT" class="form-control icheck"
                                               style="margin-right: -20px" <?= ($dados['tp_comissao'] == 'PT') ? 'checked' : '' ?>
                                               type="radio" name="tpComissao" value="PT"/>
                                            <label for="tpComissaoPT">Porc. total da tabela</label>
                                    </div>
                                </div>
                            </div>
                            <!-- Campo do select do editar para tabela pre�o-->
                            <div class="row divTabelaPreco" <?= ($dados['tp_comissao'] == 'PT') ? '' : 'hidden' ?>>
                                <div class="col-sm-12">
                                    <div class="col-sm-12">
                                        <div class="form-group col-sm-6">
                                            <label class="control-label">
                                                Tabela de preos:<span class="require" style="color: red">*</span>
                                            </label><br>
                                            <select class="form-control select2 tbPrecos"
                                                    data-placeholder="Tabela a Vista"
                                                    id="tb_precos" name="tb_precos" style="width: 100%">
                                                <option value=""></option>
                                                <?php foreach ($this->get('tabelaPreco') as $tabelaPreco): ?>
                                                    <!-- Todo select que tiver uma marca��o ou retornar para para view editar, fazer a condi��o para deixar marcado-->
                                                    <option value="<?= $tabelaPreco['id_tabela_preco']; ?>" <?= ($tabelaPreco['id_tabela_preco'] == $dados['id_tabela_preco']) ? 'selected' : '' ?>>
                                                        <?= $tabelaPreco['nm_tabela']; ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-12" align="right">
                                    <label class="control-label" style="float: left">
                                        Tipos de parcela:
                                    </label><br>
                                    <div class="col-sm-2">
                                        <input id="tpParcelaN" class="form-control icheck"
                                            <?= (in_array('N', $dados['tiposParcelas'])) ? 'checked' : '' ?>
                                               type="checkbox" name="tpParcelas[]" value="N"/>
                                        <label for="tpParcelaN">Normal</label>
                                    </div>
                                    <div class="col-sm-2">
                                        <input id="tpParcelaI" class="form-control icheck"
                                            <?= (in_array('I', $dados['tiposParcelas'])) ? 'checked' : '' ?>
                                               type="checkbox" name="tpParcelas[]" value="I"/>
                                        <label for="tpParcelaI">Intercalada</label>
                                    </div>
                                    <div class="col-sm-2">
                                        <input id="tpParcelaC" class="form-control icheck"
                                            <?= (in_array('C', $dados['tiposParcelas'])) ? 'checked' : '' ?>
                                               type="checkbox" name="tpParcelas[]" value="C"/>
                                        <label for="tpParcelaC">Chaves</label>
                                    </div>
                                    <div class="col-sm-2">
                                        <input id="tpParcelaS" class="form-control icheck"
                                            <?= (in_array('S', $dados['tiposParcelas'])) ? 'checked' : '' ?>
                                               type="checkbox" name="tpParcelas[]" value="S"/>
                                        <label for="tpParcelaS">Sinal</label>
                                    </div>
                                    <div class="col-sm-2">
                                        <input id="tpParcelaQ" class="form-control icheck"
                                            <?= (in_array('Q', $dados['tiposParcelas'])) ? 'checked' : '' ?>
                                               type="checkbox" name="tpParcelas[]" value="Q"/>
                                        <label for="tpParcelaQ">Quitaes</label>
                                    </div>
                                    <div class="col-sm-2">
                                        <input id="tpParcelaG" class="form-control icheck"
                                            <?= (in_array('G', $dados['tiposParcelas'])) ? 'checked' : '' ?>
                                               type="checkbox" name="tpParcelas[]" value="G"/>
                                        <label for="tpParcelaG">Negociada</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=<?= $_GET['m'] ?>&c=<?= ($_GET['c']); ?>&a=listar"
                                       class="btn btn-danger col-sm-12">Cancelar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>

            </div>
        </div>
    </div>
    <div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg ">
            <div class="modal-content">

                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;</button>
                    <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                        Tutorial</h2>
                </div>

                <div class="modal-body tableFix" style="max-height:600px;">
                    <fieldset >
                        <legend>Cadastro de Corretor - Cadastrar Usurio como Corretor</legend>
                        <div class="row" style="margin-right: 0px;margin-left: 0px;">
                            <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/4UTXe0m5HZo?si=dZIdY5gjXfpGQgwM" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                        </div>
                        <div></div>
                    </fieldset>
                </div>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>