<?php
$bancoConta = $this->get('bancoConta');
$agrupadaBancos = $this->get('agrupadaBancos');
$bancos = $this->get('bancos');
?>
<fieldset>
    <legend>Informaes do Banco</legend>
    <div class="row">
        <div class="col-sm-12">
            <div class="form-group col-sm-3">
                <label class="control-label" for="cdBanco">
                    Banco:
                </label><br>
                <b><?= $bancoConta['descricao'] ?></b>
            </div>

            <div class="form-group col-sm-2">
                <label class="control-label" for="nrAgencia">
                    N Agncia:
                </label><br>
                <b><?= $bancoConta['nr_agencia'].'-'.$bancoConta['nr_agencia_dv'] ?></b>
            </div>
            <div class="form-group col-sm-2">
                <label class="control-label" for="nrConta">
                    N Conta:
                </label><br>
                <b><?= $bancoConta['nr_conta'].'-'.$bancoConta['nr_conta_dv'] ?> </b>
            </div>
            <div class="form-group col-sm-3">
                <label class="control-label" for="nrCedente">
                    Cedente/Contrato:
                </label><br>
                <b><?= $bancoConta['nr_cedente'] ?></b>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="form-group col-sm-1">
                <label class="control-label" for="nrCarteira">
                    Carteira:
                </label><br>
                <b><?= $bancoConta['nr_carteira'] ?></b>
            </div>

            <div class="form-group col-sm-1">
                <label class="control-label" for="nrCarteiraVariacao" id="labelVariacao">
                    <?= ($bancoConta['cd_banco'] == '748')?'Posto (UA)':'Variao'?>:
                </label><br>
                <b><?= $bancoConta['nr_carteira_variacao'] ?></b>
            </div>

            <div class="form-group col-sm-3">
                <label class="control-label" for="nrDiasPermanencia">
                    Dias Permanncia:
                </label><br>
                <b><?= $bancoConta['nr_dias_permanencia'] ?></b>
            </div>
            <div class="form-group col-sm-3">
                <label class="control-label" for="dsEspecie">
                    Espcie Documento:
                </label><br>
                <b><?= $bancoConta['ds_especie'] ?></b>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="form-group col-sm-3">
                <label class="control-label" for="cnpjCedente">
                    <?= ($bancoConta['cnpj_cedente'])?'CNPJ':'CPF'?> Cedente:
                </label><br>
                <b><?= ($bancoConta['cnpj_cedente'])?$bancoConta['cnpj_cedente']:$bancoConta['cpf_cedente']?></b>
            </div>
            <div class="form-group col-sm-6">
                <label class="control-label" for="nmCedente">
                    Nome Cedente:
                </label><br>
                <b><?= $bancoConta['nm_cedente'] ?></b>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="form-group col-sm-3">
                <label class="control-label">
                    N Boleto Atual:
                </label><br>
                <b><?= $bancoConta['nr_boleto']?></b>
            </div>
            <div class="form-group col-sm-3">
                <label class="control-label">
                    N Remessa Atual:
                </label><br>
                <b><?= $bancoConta['nr_remessa']?></b>
            </div>
            <div class="form-group col-sm-3">
                <label class="control-label">
                    Status:
                </label><br>
                <?= ($bancoConta['fl_ativo'] == '1')?'<span class="label label-success">Ativo</span>':'<span class="label label-danger">Inativo</span>'?>
            </div>
        </div>
    </div>

    <legend>Empreendimentos Associados</legend>
    <?php if ($bancos): ?>
    <div class="col-sm-12">
        <?php foreach ($bancos as $b): ?>
            <legend>
                <div class="tituloEmp naoPermiteSelecionar" idEmp="<?= $b['idEmp']?>" style="cursor: pointer;
                                        font-size: 17px;">
                    <?= $b['nm_empreendimento']?> <i id="seta_<?= $b['idEmp']?>" class="fa <?= (count($bancos) > 1)?'fa-caret-up':'fa-caret-down'?>"></i>
                </div>
            </legend>
            <div id="info_<?= $b['idEmp']?>" <?= (count($bancos) > 1)?'hidden':''?>>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-2" >
                            <label class="control-label">
                                Multa:</span>
                            </label><br>
                            <b><?= ($b['tp_multa'] == 'V')? $_SESSION['simboloMoeda']. ' ':''?>
                                <?= Helper::getMoney($b['multa'], 4)?>
                                <?= ($b['tp_multa'] == 'P')?'%':''?></b>
                        </div>
                        <div class="form-group col-sm-2">
                            <label class="control-label">
                                Juros:
                            </label><br>
                            <b><?= ($b['tp_juros'] == 'V')? $_SESSION['simboloMoeda']. ' ':''?>
                                <?= Helper::getMoney($b['juros'], 4)?>
                                <?= ($b['tp_juros'] == 'P')?'%':''?></b>
                        </div>
                        <div class="form-group col-sm-5">
                            <label>
                                Status:
                            </label><br>
                            <?= ($b['fl_ativo'] == '1')?'<span class="label label-success">Ativo Contrato</span>':'<span class="label label-danger">Inativo Contrato</span>'?>
                            <?= ($b['fl_ativo_boleto'] == '1')?'<span class="label label-success">Ativo Boleto</span>':'<span class="label label-danger">Inativo Boleto</span>'?>
                            <?= ($b['fl_ativo_remessa'] == '1')?'<span class="label label-success">Ativo Remessa</span>':'<span class="label label-danger">Inativo Remessa</span>'?>
                            <?= ($b['fl_ativo_baixamanual'] == '1')?'<span class="label label-success">Ativo Baixa Manual</span>':'<span class="label label-danger">Inativo Baixa Manual</span>'?>

                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-6">
                            <label class="control-label" for="dsBoleto1">
                                Mensagem Boleto:
                            </label><br>
                            <b><?= $b['msg_boleto']?></b>
                        </div>
                        <div class="form-group col-sm-6">
                            <label class="control-label" for="dsBoleto2">
                                Mensagem Adicional:
                            </label><br>
                            <b><?= $b['msg_adicional']?></b>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach;?>
        <?php else:?>
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group col-sm-6">
                        <label class="control-label" for="dsBoleto1">
                            Nenhum empreendimento associado.
                        </label>
                    </div>
                </div>
            </div>
        <?php endif;?>
    </div>
</fieldset>

<script>
    //Exibe o campo CPF ou CNPJ de acordo com a opo do tipo de pessoa selecionado
    $('.tituloEmp').on('click', function () {
        var idEmp = $(this).attr('idEmp');
        $('#info_'+idEmp).toggle('fast');
        if ($('#seta_'+idEmp).hasClass('fa-caret-up')) {
            $('#seta_'+idEmp).removeClass('fa-caret-up').addClass('fa-caret-down');
        } else {
            $('#seta_'+idEmp).removeClass('fa-caret-down').addClass('fa-caret-up');
        }
    });
</script>