<?php

require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$bancoConta = $this->get('bancoConta');
$agrupadaBancos = $this->get('agrupadaBancos');
$bancos = $this->get('bancos');
$listaLayoutsRemessa = $this->get('listaLayoutsRem');
$listaLayoutsRetorno = $this->get('listaLayoutsRet');
$listaLayoutsApi = $this->get('listaLayoutsApi');
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader(); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <div class="alert alert-danger alert-dismissable msgErros" hidden></div>
                <!-- MENSAGENS -->
                <?= ($_GET["msg"] == "success") ? '<div class="alert alert-success alert-dismissable">Operao realizada com sucesso.</div>'
                    : (($_GET['exception'] != '') ? '<div class="alert alert-danger alert-dismissable">' . $_GET['exception'] . '</div>' : '');
                ?>
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <input type="hidden" id="idBancoConta" name="idBancoConta" value="<?=$_GET['id']?>">
                <form action="" method="POST" id="form">
                    <fieldset>
                        <legend>Informaes do Banco <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                            <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                </svg>
                            </span>
                        </legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="cdBanco">
                                        Banco:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 associarBanco"
                                            id="cdBanco" name="cdBanco" required
                                            data-placeholder="Selecione o banco" <?= ($_GET['a'] == 'editar')?'readonly':''?> >
                                        <option value=""></option>
                                        <?php foreach ($agrupadaBancos as $ab) : ?>
                                            <option value="<?= $ab['idCampo']; ?>" <?= ($bancoConta['cd_banco'] == $ab['idCampo'])?'selected':''?>>
                                                <?= $ab['descricao']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="nrAgencia">
                                        N agncia:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control soNumero" id="nrAgencia" name="nrAgencia"
                                           placeholder="Ex: 1449" required
                                           value="<?= $bancoConta['nr_agencia'] ?>" maxlength="5"/>
                                </div>
                                <div class="form-group col-sm-1">
                                    <label class="control-label" for="nrAgenciaDv">
                                        Dv:
                                    </label>
                                    <input type="text" class="form-control" id="nrAgenciaDv" name="nrAgenciaDv"
                                           value="<?= $bancoConta['nr_agencia_dv'] ?>" placeholder="Ex: 0" maxlength="1"/>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="nrConta">
                                        N conta:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control soNumero" id="nrConta" required
                                           name="nrConta" value="<?= $bancoConta['nr_conta'] ?>" placeholder="Ex: 13356489" maxlength="10"/>
                                </div>
                                <div class="form-group col-sm-1">
                                    <label class="control-label" for="nrContaDv">
                                        Dv:
                                    </label>
                                    <input type="text" class="form-control" size="1" id="nrContaDv"
                                           name="nrContaDv" value="<?= $bancoConta['nr_conta_dv'] ?>" placeholder="Ex: 7" maxlength="1"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="nrCedente">
                                        Cedente/Contrato:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="nrCedente" name="nrCedente" required
                                           value="<?= $bancoConta['nr_cedente'] ?>" placeholder="Ex: 78954" maxlength="10"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-1">
                                    <label class="control-label" for="nrCarteira">
                                        Carteira:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="nrCarteira" name="nrCarteira" required="required"
                                           value="<?= $bancoConta['nr_carteira'] ?>" placeholder="Ex: 11" maxlength="10"/>
                                </div>

                                <div class="form-group col-sm-1">
                                    <label class="control-label" for="nrCarteiraVariacao" id="labelVariacao">
                                        <?= ($bancoConta['cd_banco'] == '748')?'Posto (UA)':'Variao'?>:
                                    </label>
                                    <input type="text" class="form-control" id="nrCarteiraVariacao"
                                           name="nrCarteiraVariacao"
                                           maxlength="3" value="<?= $bancoConta['nr_carteira_variacao'] ?>" placeholder="Ex: 03"/>
                                </div>

                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="nrDiasPermanencia">
                                        Dias permanncia:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control soNumero" id="nrDiasPermanencia"
                                           name="nrDiasPermanencia" placeholder="Ex: 90" maxlength="3"
                                           value="<?= $bancoConta['nr_dias_permanencia'] ? $bancoConta['nr_dias_permanencia'] : 90 ?>"/>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="dsEspecie">
                                        Espcie documento:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control" id="dsEspecie" required
                                           name="dsEspecie" placeholder="Ex: DM, DMI, CT... "
                                           value="<?= $bancoConta['ds_especie'] ?>"/>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="nr_cooperativa">
                                        Cooperativa:
                                    </label>
                                    <input type="text" class="form-control" id="nr_cooperativa"
                                           name="nr_cooperativa" 
                                           value="<?= $bancoConta['nr_cooperativa'] ?>"/>
                                </div>
                                <?php if (Login::getUsuario()->getSuper() == '1') : ?>
                                    <div class="form-group col-sm-4">
                                        <label for="contratoDigital" class="control-label">
                                            Boletos:
                                        </label></br>
                                        <div class="col-sm-4" style="width:95px">
                                            <label for="fl_boleto0" class="control-label">id parcela contrato </label>
                                            <input id="fl_boleto0" type="radio" class="form-control icheck" <?= ($bancoConta['fl_boleto'] == '0') ? 'checked' : ''; ?> name="fl_boleto" value="0" />
                                        </div>
                                        <div class="col-sm-4" style="width:70px">
                                            <label for="fl_boleto1" class="control-label">Em transio </label>
                                            <input id="fl_boleto1" type="radio" class="form-control icheck" <?= ($bancoConta['fl_boleto'] == '1') ? 'checked' : ''; ?> name="fl_boleto" value="1" />
                                        </div>
                                        <div class="col-sm-4" style="width:80px">
                                            <label for="fl_boleto2" class="control-label">nr boletos </label>
                                            <input id="fl_boleto2" type="radio" class="form-control icheck" <?= ($bancoConta['fl_boleto'] == '2') ? 'checked' : ''; ?> name="fl_boleto" value="2" />
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">

                                    <label class="control-label" for="dsEspecie">
                                        Layout arquivo de remessa:
                                    </label>

                                    <select name="cod_layout_rem" id="cod_layout_rem" class="form-control select2" title="Escolha o layout" emptyText="Escolha o layout" useEmpty="true">
                                        <option value="<?= $bancoConta['cod_layout_rem']?>"><?= Layout::getTabelaById($bancoConta['cod_layout_rem'])['nm_layout']?></option>
                                        <?php
                                        Helper::geraOptionsSelect($listaLayoutsRemessa, 'id', 'nm_layout');
                                        ?>
                                    </select>
                                </div>

                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="dsEspecie">
                                        Layout arquivo de retorno:
                                    </label>

                                    <select name="cod_layout_ret" id="cod_layout_ret" class="form-control select2" title="Escolha o layout" emptyText="Escolha o layout" useEmpty="true">
                                        <option value="<?= $bancoConta['cod_layout_ret']?>"><?= Layout::getTabelaById($bancoConta['cod_layout_ret'])['nm_layout']?></option>
                                        <?php
                                        Helper::geraOptionsSelect($listaLayoutsRetorno, 'id', 'nm_layout');
                                        ?>
                                    </select>

                                </div>

                                <div class="form-group col-sm-2" >
                                    <label class="control-label" for="dsEspecie">
                                        Layout api:
                                    </label>

                                    <select name="cod_layout_api" id="cod_layout_api" class="form-control select2" title="Escolha o layout" emptyText="Escolha o layout" useEmpty="true">
                                        <option value="<?= $bancoConta['cod_layout_api']?>"><?= Layout::getTabelaById($bancoConta['cod_layout_api'])['nm_layout']?></option>
                                        <?php
                                        Helper::geraOptionsSelect($listaLayoutsApi, 'id', 'nm_layout');
                                        ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label">
                                        Pessoa fisica ou juridica?<span class="require" style="color: red">*</span>
                                    </label><br>
                                    <div class="checkbox">
                                        <label>
                                            <input id="ativo" class="form-control icheck" style="margin-left: 20px"
                                                   type="radio" name="cpfcnpj" value="J"
                                                <?= ($bancoConta['cnpj_cedente'] || !$bancoConta['cpf_cedente'])?'checked':''?>/>
                                            Jurdica
                                        </label>
                                        <label>
                                            <input id="inativo" class="form-control icheck"
                                                   style="margin-left: 20px" type="radio" name="cpfcnpj" value="F"
                                                <?= ($bancoConta['cpf_cedente'])?'checked':''?>/>
                                            Fsica
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-3" id="divCNPJ"
                                    <?= (!$bancoConta['cnpj_cedente'] && $bancoConta['cpf_cedente'])?'hidden':''?>>
                                    <label class="control-label" for="cnpjCedente">
                                        CNPJ cedente:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control cnpj" id="cnpjCedente"
                                           name="cnpjCedente" value="<?= $bancoConta['cnpj_cedente'] ?>"
                                           placeholder="Ex: 99.999.999/9999-99"/>
                                </div>
                                <div class="form-group col-sm-3" id="divCPF" <?= (!$bancoConta['cpf_cedente'])?'hidden':''?>>
                                    <label class="control-label" for="cpfCedente">
                                        CPF cedente:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control cpf" id="cpfCedente"
                                           name="cpfCedente" placeholder="Ex: 999.999.999-99"
                                           value="<?= $bancoConta['cpf_cedente'] ?>"/>
                                </div>
                                <div class="form-group col-sm-5">
                                    <label class="control-label" for="nmCedente">
                                        Nome cedente: <span class="require" style="color: red; font-size: smaller">	(Obs.: deve ser igual ao cadastrado na agncia bancria)</span>
                                    </label>
                                    <input type="text" class="form-control" id="nmCedente" name="nmCedente"
                                           value="<?= $bancoConta['nm_cedente'] ?>"
                                           placeholder="Digite o nome do cedente"/>
                                </div>
                                <!-- <div class="form-group col-sm-2">
                                    <label class="control-label" for="nmCedente">
                                        Nmero do Cedente na Api:
                                    </label>
                                    <input type="text" class="form-control" id="codCedenteApi" name="codCedenteApi"
                                           value="<?= $bancoConta['cod_cedente_api'] ?>"
                                           placeholder="Digite o cdigo da Api"/>
                                </div> -->
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label">
                                        N boleto atual:
                                    </label>
                                    <input type="text" class="form-control" id="nrBoleto" name="nrBoleto"
                                           value="<?= ($bancoConta['nr_boleto'])?$bancoConta['nr_boleto']:'0000000000'?>" readonly  tabindex="-1"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label">
                                        N remessa atual:
                                    </label>
                                    <input type="text" class="form-control" id="nrBoleto" name="nrBoleto"
                                           value="<?= ($bancoConta['nr_remessa'])?$bancoConta['nr_remessa']:'0'?>" tabindex="-1" readonly/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label">
                                        Status? <span class="require" style="color: red">*</span>
                                    </label><br>
                                    <div class="checkbox">
                                        <label>
                                            <input id="ativo" class="form-control icheck"
                                                   type="radio" name="flStatus" value="1"
                                                <?= ($bancoConta['fl_ativo'] != '0')?'checked':''?>/>
                                            Ativo
                                        </label>
                                        <label>
                                            <input id="inativo" class="form-control icheck" type="radio" name="flStatus" value="0"
                                                <?= ($bancoConta['fl_ativo'] == '0')?'checked':''?>/>
                                            Inativo
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php if ($_GET['a'] == 'editar'): ?>
                            <legend>Empreendimentos Associados</legend>
                            <?php if ($bancos): ?>
                                <div class="col-sm-12">
                                <?php foreach ($bancos as $b): ?>
                                    <legend>
                                        <div class="tituloEmp naoPermiteSelecionar" idEmp="<?= $b['idEmp']?>" style="cursor: pointer;
                                        font-size: 17px;">
                                            <?= $b['nm_empreendimento']?> <i id="seta_<?= $b['idEmp']?>" class="fa <?= (count($bancos) > 1)?'fa-caret-up':'fa-caret-down'?>"></i>
                                        </div>
                                    </legend>
                                    <div id="info_<?= $b['idEmp']?>" <?= (count($bancos) > 1)?'hidden':''?>>
                                        <input type="hidden" name="idEmpreendimento[]" value="<?= $b['idEmp']?>" />
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="form-group col-sm-4">
                                                    <label class="control-label">
                                                        Tipo de multa:
                                                    </label><br>
                                                    <div class="checkbox">
                                                        <label>
                                                            <input class="icheck tpMulta" type="radio" name="tpMulta_<?= $b['idEmp']?>" value="S"
                                                                   tabindex="-1" <?= ($b['tp_multa'] != 'V' && $b['tp_multa'] == 'S')?'checked':''?>
                                                                   idEmp="<?= $b['idEmp']?>"/>
                                                            Sem multa
                                                        </label>
                                                        <label>
                                                            <input class="icheck tpMulta" type="radio" name="tpMulta_<?= $b['idEmp']?>" value="P"
                                                                   tabindex="-1" <?= ($b['tp_multa'] != 'V' && $b['tp_multa'] != 'S')?'checked':''?>
                                                                   idEmp="<?= $b['idEmp']?>"/>
                                                            Porcentagem
                                                        </label>
                                                        <?php if ($bancoConta['cd_banco'] != '748'): ?>
                                                            <label id="labelValorFixo">
                                                                <input class="icheck tpMulta" type="radio" name="tpMulta_<?= $b['idEmp']?>" value="V"
                                                                       tabindex="-1"  <?= ($b['tp_multa'] != 'S' && $b['tp_multa'] == 'V')?'checked':''?>
                                                                       idEmp="<?= $b['idEmp']?>"/>
                                                                Valor fixo
                                                            </label>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <div class="form-group col-sm-2" id="divMulta_<?= $b['idEmp']?>"
                                                    <?= ($b['tp_multa'] == 'S')?'hidden':''?>>
                                                    <label class="control-label">
                                                        <span id="spanMulta_<?= $b['idEmp']?>">Multa: (%)</span>
                                                    </label>
                                                    <input type="text" class="form-control porcentagem" id="multa_<?= $b['idEmp']?>" name="multa_<?= $b['idEmp']?>"
                                                           placeholder="Ex: 2,0000" value="<?= Helper::getMoney($b['multa'], 4)?>"/>
                                                </div>
                                                <div class="form-group col-sm-4 <?= ($b['tp_multa'] == 'S')?'col-sm-offset-2':''?>" id="divTpJuros_<?= $b['idEmp']?>">
                                                    <label class="control-label">
                                                        Tipo de juros:
                                                    </label><br>
                                                    <div class="checkbox">
                                                        <label>
                                                            <input class="icheck tpJuros" type="radio" name="tpJuros_<?= $b['idEmp']?>"
                                                                   value="S" tabindex="-1" <?= ($b['tp_juros'] != 'V' && $b['tp_juros'] == 'S')?'checked':''?>
                                                                   idEmp="<?= $b['idEmp']?>"/>
                                                            Sem juros
                                                        </label>
                                                        <label>
                                                            <input class="icheck tpJuros" type="radio" name="tpJuros_<?= $b['idEmp']?>"
                                                                   value="P" tabindex="-1" <?= ($b['tp_juros'] != 'V' && $b['tp_juros'] != 'S')?'checked':''?>
                                                                   idEmp="<?= $b['idEmp']?>"/>
                                                            Porcentagem
                                                        </label>
                                                        <label>
                                                            <input class="icheck tpJuros" type="radio" name="tpJuros_<?= $b['idEmp']?>"
                                                                   value="V" tabindex="-1" <?= ($b['tp_juros'] != 'S' && $b['tp_juros'] == 'V')?'checked':''?>
                                                                   idEmp="<?= $b['idEmp']?>"/>
                                                            Valor fixo
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="form-group col-sm-2" id="divJuros_<?= $b['idEmp']?>"
                                                    <?= ($b['tp_juros'] == 'S')?'hidden':''?>>
                                                    <label class="control-label">
                                                        <span id="spanJuros_<?= $b['idEmp']?>">Juros: (%)</span>
                                                    </label>
                                                    <input type="text" class="form-control porcentagem" id="juros_
                                                        <?= $b['idEmp']?>" name="juros_<?= $b['idEmp']?>"
                                                           placeholder="Ex: 0,0330" value="<?= Helper::getMoney($b['juros'], 4)?>"/>
                                                </div>
                                            </div>
                                        </div>
                                        <?php if($bancoConta['cd_banco'] == '274'): ?>
                                            <div class="row jurosMensalGrafeno">
                                                <div class="col-sm-12">
                                                    <div class="form-group col-sm-10"></div>
                                                    <div class="form-group col-sm-2">
                                                        <label class="control-label">
                                                            Juros Mensal: (%)
                                                        </label>
                                                        <input type="text" class="form-control porcentagem" id="jurosMensal" name="jurosMensal"
                                                                placeholder="Ex: 0,0330" value="<?= Helper::getMoney($b['jurosMensal'], 4)?>"/>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="form-group col-sm-6">
                                                    <label class="control-label" for="dsBoleto1">
                                                        Mensagem boleto:
                                                    </label>
                                                    <input type="text" class="form-control" id="dsBoleto1"
                                                           name="dsBoleto1_<?= $b['idEmp']?>"
                                                           placeholder="Digite a mensagem que ser exibida no boleto"
                                                           value="<?= $b['msg_boleto']?>"/>
                                                </div>
                                                <div class="form-group col-sm-6">
                                                    <label class="control-label" for="dsBoleto2">
                                                        Mensagem boleto:
                                                    </label>
                                                    <input type="text" class="form-control" id="dsBoleto2"
                                                           name="dsBoleto2_<?= $b['idEmp']?>"
                                                           placeholder="Digite a mensagem adicional que ser exibida no boleto"
                                                           value="<?= $b['msg_adicional']?>"/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label class="control-label col-sm-6">Status:</label>
                                            </div>
                                            <div class="col-sm-12">
                                                <div class="checkbox">
                                                    <label for="statusC" class="control-label">
                                                        <input class="checkbox icheck" type="checkbox" name="<?= "status_".$b['idEmp'].'[]' ?>"  value="C" <?= $b['fl_ativo_banco'] == '1' ? 'checked' : '' ?> >Ativo contrato
                                                    </label>
                                                    <label for="statusB" class="control-label">
                                                        <input class="checkbox icheck" type="checkbox" name="<?= "status_".$b['idEmp'].'[]' ?>"  value="B" <?= $b['fl_ativo_boleto'] == '1' ? 'checked' : '' ?>>Ativo boleto
                                                    </label>
                                                    <label for="statusR" class="control-label">
                                                        <input class="checkbox icheck" type="checkbox" name="<?= "status_".$b['idEmp'].'[]' ?>"  value="R" <?= $b['fl_ativo_remessa'] == '1' ? 'checked' : '' ?>>Ativo remessa
                                                    </label>
                                                    <label for="statusBM" class="control-label">
                                                        <input class="checkbox icheck" type="checkbox" name="<?= "status_".$b['idEmp'].'[]' ?>"  value="BM" <?= $b['fl_ativo_baixamanual'] == '1' ? 'checked' : '' ?>>Ativo baixa manual
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="form-group col-sm-2 col-sm-offset-10">
                                                    <a href="?m=<?= $_GET['m'] ?>&c=<?= ($_GET['c']); ?>&a=desassociar&id=<?= $_GET['id']?>&idEmp=<?= $b['idEmp']?>"
                                                       class="btn btn-danger col-sm-12 removerAssociacao">Remover Associao</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach;?>
                            <?php else:?>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group col-sm-6">
                                            <label class="control-label" for="dsBoleto1">
                                                Nenhum empreendimento associado.
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            <?php endif;?>
                            </div>
                        <?php endif; ?>
                        <legend>Operaes </legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="button" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar" id="salvar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=<?= $_GET['m'] ?>&c=<?= ($_GET['c']); ?>&a=listar"
                                       class="btn btn-danger col-sm-12">Cancelar </a>
                                </div>
                                <?php if($bancoConta['cd_banco']=="136" && Login::getUsuario()->getSuper() == '1'): ?>
                                <div class="form-group col-sm-2">
                                    <button type="button" onclick="homologarUnicred()"
                                       class="btn btn-warning col-sm-12">Homologar 
                                    </button>
                                </div>
                                <?php endif;?>
                            </div>
                            
                        </div>
                    </fieldset>
                </form>

            </div>
        </div>
    </div>
    <div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg ">
            <div class="modal-content">

                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;</button>
                    <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                        Tutorial</h2>
                </div>

                <div class="modal-body tableFix" style="max-height:600px;">
                    <fieldset >
                        <legend>Cadastro de banco - Cadastro das Conta Bancrias</legend>
                        <div class="row" style="margin-right: 0px;margin-left: 0px;">
                            <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/j_cZ6BAB0H4?si=mZQB1wLuvJdLlHFz" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                        </div>
                        <div></div>
                    </fieldset>
                </div>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>