<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$bancoContas = $this->get('bancoContas');
$empreendimentos = $this->get('empreendimentos');
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader('Associar','Empreendimento','fa fa-random'); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <div class="alert alert-danger alert-dismissable msgErros" hidden></div>
                <!-- MENSAGENS -->
                <?= ($_GET["msg"] == "success") ? '<div class="alert alert-success alert-dismissable">Empreendimento desassociado com sucesso.</div>'
                    : (($_GET['exception'] != '') ? '<div class="alert alert-danger alert-dismissable">' . $_GET['exception'] . '</div>' : '');
                ?>
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST">
                    <fieldset>
                        <legend>Associar Empreendimento</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="cdBanco">
                                        Conta: <span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2"
                                            id="idBancoConta" name="idBancoConta" required
                                            data-placeholder="Selecione a Conta">
                                        <option value=""></option>
                                        <?php foreach ($bancoContas as $bc) : ?>
                                            <option value="<?= $bc['id_banco_conta']; ?>" cdBanco="<?= $bc['cd_banco']; ?>">
                                                <?= $bc['descricao']
                                                .' - Ag:'.$bc['nr_agencia'].'-'.$bc['nr_agencia_dv']
                                                .' - Cc:'.$bc['nr_conta'].'-'.$bc['nr_conta_dv']
                                                .' - Cedente: '.$bc['nr_cedente']
                                                ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="idEmpreendimento">
                                        Empreendimento: <span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 associarBanco"
                                            id="idEmpreendimento" name="idEmpreendimento" required
                                            data-placeholder="Selecione o Empreendimento" disabled>
                                        <option value=""></option>
                                        <?php foreach ($empreendimentos as $e) : ?>
                                            <option value="<?= $e['id']; ?>">
                                                <?= $e['nm_empreendimento']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-4">
                                    <label class="control-label">
                                        Tipo de Multa:
                                    </label><br>
                                    <div class="checkbox">
                                        <label>
                                            <input class="icheck" type="radio" name="tpMulta" value="S" tabindex="-1"/>
                                            Sem Multa
                                        </label>
                                        <label>
                                            <input class="icheck" type="radio" name="tpMulta" value="P" checked id="tpPorcMulta" tabindex="-1"/>
                                            Porcentagem
                                        </label>
                                        <label id="labelValorFixo">
                                            <input class="icheck" type="radio" name="tpMulta" value="V" id="tpValorMulta" tabindex="-1"/>
                                            Valor Fixo
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-2" id="divMulta">
                                    <label class="control-label">
                                        <span id="spanMulta">Multa: </span><span id="spanMultaP" style="color: red">(% - nica)</span>
                                    </label>
                                    <input type="text" class="form-control porcentagem" id="multa" name="multa"
                                           placeholder="Ex: 2,0000"/>
                                </div>
                                <div class="form-group col-sm-4" id="divTpJuros">
                                    <label class="control-label">
                                        Tipo de Juros:
                                    </label><br>
                                    <div class="checkbox">
                                        <label>
                                            <input class="icheck" type="radio" name="tpJuros" value="S" tabindex="-1"/>
                                            Sem Juros
                                        </label>
                                        <label>
                                            <input class="icheck" type="radio" name="tpJuros" value="P" checked tabindex="-1"/>
                                            Porcentagem
                                        </label>
                                        <label>
                                            <input class="icheck" type="radio" name="tpJuros" value="V" tabindex="-1"/>
                                            Valor Fixo
                                        </label>
                                    </div>
                                </div>
                                <div class="form-group col-sm-2" id="divJuros">
                                    <label class="control-label">
                                        <span id="spanJuros">Juros: </span><span id="spanJurosP" style="color: red">(% - Ao dia)</span>
                                    </label>
                                    <input type="text" class="form-control porcentagem" id="juros" name="juros"
                                           placeholder="Ex: 0,0330"/>
                                </div>
                            </div>
                        </div>
                        <div class="row jurosMensalGrafeno" hidden>
                            <div class="col-sm-12">
                                <div class="form-group col-sm-10"></div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label">
                                        Juros: <span class="jurosMensalSpan" style="color: red">(% - Ao ms)</span>
                                    </label>
                                    <input type="text" class="form-control porcentagem" id="jurosMensal" name="jurosMensal"
                                            placeholder="Ex: 0,0330" value="<?= Helper::getMoney($b['jurosMensal'], 4)?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="dsBoleto1">
                                        Mensagem Boleto:
                                    </label>
                                    <input type="text" class="form-control" id="dsBoleto1" name="dsBoleto1"
                                           placeholder="Digite a mensagem que ser exibida no boleto"/>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="dsBoleto2">
                                        Mensagem Boleto:
                                    </label>
                                    <input type="text" class="form-control" id="dsBoleto2" name="dsBoleto2"
                                           placeholder="Digite a mensagem adicional que ser exibida no boleto"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <label class="control-label col-sm-6">Status:</label>
                            </div>
                            <div class="col-sm-12">
                                <div class="checkbox">
                                    <label for="statusC" class="control-label">
                                        <input class="checkbox icheck" type="checkbox" name="status[]" id="statusC" value="C" checked >Ativo contrato
                                    </label>
                                    <label for="statusB" class="control-label">
                                        <input class="checkbox icheck" type="checkbox" name="status[]" id="statusB" value="B" checked>Ativo boleto
                                    </label>
                                    <label for="statusR" class="control-label">
                                        <input class="checkbox icheck" type="checkbox" name="status[]" id="statusR" value="R" checked>Ativo remessa
                                    </label>
                                    <label for="statusBM" class="control-label">
                                        <input class="checkbox icheck" type="checkbox" name="status[]" id="statusBM" value="BM" checked>Ativo baixa manual
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="button" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Associar" id="btnAssociar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=lo&c=banco&a=listar" class="btn btn-danger col-sm-12">Cancelar</a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php';?>