<?php

class TaxasController extends Controller
{
    private $taxas;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->taxas = new TaxaValor();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "lo", "controller" => "taxas", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $totalItens = TaxaValor::findLista($_POST, true);
            $listaItem = TaxaValor::findLista($_POST);

            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $title = "return confirm('Tem certeza que deseja excluir a taxa " . $item['nm_pessoa'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $item['id'] . '" data-toggle="tooltip" title="EXCLUIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';

                $lista[] = array(
                    'id' => utf8_encode($item['id']),
                    'nm_empreendimento' => utf8_encode($item['nm_empreendimento']),
                    'descricao' => utf8_encode($item['descricao']),
                    'vl_taxa' => Helper::getMoney($item['vl_taxa']),
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalItens),
                'recordsFiltered' => count($totalItens),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarTaxaValor')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'taxas', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $tiposTaxa = Db_TabelaAgrupada::findByTabelaId(17);
        $this->set('tiposTaxa', $tiposTaxa);

        $empreendimentos = Empreendimento::getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimentos);

        if ($this->_isPost && $this->validar()) {
            try {
                $taxa = new TaxaValor();
                $taxa = $taxa->createRow();
                $taxa->id_empreendimento = $_POST['idEmpreendimento'];
                $taxa->id_tipo_taxa = $_POST['tpTaxa'];
                $taxa->vl_taxa = Helper::getInputMoney($_POST['vlTaxa']);
                $taxa->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                $taxa->save();
            } catch (PDOException $e) {
                $this->redir(array("modulo" => "lo", "controller" => "taxas", "action" => "listar"), array("exception" => "No foi possvel realizar a operao. Erro: " . $e->getMessage()));
            }
            $this->redir(array("modulo" => "lo", "controller" => "taxas", "action" => "listar"), array("msg" => "success"));
        }

        $this->display('form');
    }

    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'editarTaxaValor')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'taxas', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $tiposTaxa = Db_TabelaAgrupada::findByTabelaId(17);
        $this->set('tiposTaxa', $tiposTaxa);

        $empreendimentos = Empreendimento::getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimentos);

        $taxa = TaxaValor::findById($_GET['id']);
        $this->set('taxa', $taxa);

        if ($this->_isPost) {
            if ($this->validar()) {
                try {
                    $taxa = $this->taxas->fetchRow($this->taxas->select()->where('id_taxas = ?', $_GET['id']));
                    $taxa->id_empreendimento = $_POST['idEmpreendimento'];
                    $taxa->id_tipo_taxa = $_POST['tpTaxa'];
                    $taxa->vl_taxa = Helper::getInputMoney($_POST['vlTaxa']);
                    $taxa->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                    $taxa->save();
                } catch (PDOException $e) {
                    $this->redir(array("modulo" => "lo", "controller" => "taxas", "action" => "listar"), array("exception" => "No foi possvel realizar a operao. Erro: " . $e->getMessage()));
                }
                $this->redir(array("modulo" => "lo", "controller" => "taxas", "action" => "listar"), array("msg" => "success"));
            }
        }
        $this->display('form');
    }

    public function deletarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'excluirTaxaValor')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'taxas', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        $id = $_GET['id'];
        try {
            //Exclui a taxa selecionada do empreendimento
            $this->taxas->delete($this->taxas->getAdapter()->quoteInto('id_taxas = ?', $id));
            $this->redir(array("modulo" => "lo", "controller" => "taxas", "action" => "listar"), array("msg" => "success"));
        } catch (Exception $e) {
            $this->redir(array("modulo" => "lo", "controller" => "taxas", "action" => "listar"), array("exception" => "No foi possvel realizar a operao."));
        }
    }

    private function validar()
    {
        $campos = array("idEmpreendimento", "tpTaxa", 'vlTaxa');
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "idEmpreendimento" :
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case "tpTaxa" :
                        $msg = "O campo Tipo  obrigatrio.";
                        break;
                    case "vlTaxa" :
                        $msg = "O campo Valor  obrigatrio.";
                        break;
                }
                if (isset($msg))
                    $this->_helper->addMensagem($cp, $msg);
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

}