<?php

class TaxaController extends Controller
{
    private $taxa;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->taxa = new Taxa();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "lo", "controller" => "taxa", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $totalItens = Taxa::findLista($_POST, true);
            $listaItem = Taxa::findLista($_POST);
            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id_taxa'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $title = "return confirm('Tem certeza que deseja excluir a taxa " . $item['ds_taxa'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $item['id_taxa'] . '" data-toggle="tooltip" title="EXCLUIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';

                $lista[] = array(
                    'id_taxa' => $item['id_taxa'],
                    'ds_taxa' => utf8_encode($item['ds_taxa']),
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalItens),
                'recordsFiltered' => count($totalItens),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarTaxa')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'taxa', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        if ($this->_isPost && $this->validar()) {
            try {
                $taxa = new Taxa();
                $taxa = $taxa->createRow();
                $taxa->ds_taxa = $_POST['dsTaxa'];
                $taxa->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                $taxa->save();
            } catch (PDOException $e) {
                $this->redir(array("modulo" => "lo", "controller" => "taxa", "action" => "listar"), array("exception" => "No foi possvel realizar a operao. Erro: " . $e->getMessage()));
            }
            $this->redir(array("modulo" => "lo", "controller" => "taxa", "action" => "listar"), array("msg" => "success"));
        }
        $this->display('form');
    }

    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'editarTaxa')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'taxa', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $taxa = (new Taxa())->fetchRow('id_taxa  = '.$_GET['id']);
        if (!$taxa) {
            $this->redir(array("modulo" => "lo", "controller" => "taxa", "action" => "listar"), array("exception" => "Taxa no encontrada, tente novamente."));
        }
        $this->set('taxa', $taxa);
        if ($this->_isPost) {
            if ($this->validar()) {
                try {
                    $taxa->ds_taxa = $_POST['dsTaxa'];
                    $taxa->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                    $taxa->save();
                } catch (PDOException $e) {
                    $this->redir(array("modulo" => "lo", "controller" => "taxa", "action" => "listar"), array("exception" => "No foi possvel realizar a operao. Erro: " . $e->getMessage()));
                }
                $this->redir(array("modulo" => "lo", "controller" => "taxa", "action" => "listar"), array("msg" => "success"));
            }
        }
        $this->display('form');
    }

    public function deletarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'deletarTaxa')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'taxa', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        $id = $_GET['id'];
        try {
            //Exclui a taxa selecionada
            $this->taxa->delete('id_taxa = '. $id);
            $this->redir(array("modulo" => "lo", "controller" => "taxa", "action" => "listar"), array("msg" => "success"));
        } catch (Exception $e) {
            $this->redir(array("modulo" => "lo", "controller" => "taxa", "action" => "listar"), array("exception" => "No foi possvel realizar a operao."));
        }
    }

    private function validar()
    {
        $campos = array("dsTaxa");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "idEmpreendimento" :
                        $msg = "O campo <b>Taxa</b>  obrigatrio.";
                        break;
                }
                if (isset($msg))
                    $this->_helper->addMensagem($cp, $msg);
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

}