<?php

class ReservaLoteController extends Controller
{
    private $reserva_lote;
    private $lotes;
    private $empreendimentos;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->lotes = new Lote();
        $this->empreendimentos = new Empreendimento();
        $this->reserva_lote = new ReservaLote();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "lo", "controller" => "reservaLote", "action" => "listar"));
    }

    public function listarAction()
    {
        $empreendimentos = $this->empreendimentos->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento ASC')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);

        $this->display('listar');
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarReservaLote')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'reservaLote', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $empreendimentos = $this->empreendimentos->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento ASC')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);

        if ($this->_isPost && $this->validar()) {
            foreach($_POST['lote'] as $lote) {
                $reservaLote = $this->reserva_lote->fetchRow('cod_lote = '.$lote.' AND reservado = "1"');
                if($reservaLote) {
                    $lotesReservados[] = $lote;
                } else {
                    try {
                        if ($_POST['tipoReserva'] == 'cliente') {
                            $emp = $this->empreendimentos->fetchRow('id = '. $_POST['id_empreendimento'])->toArray();
                            $reservaCorretor = $this->reserva_lote->getDefaultAdapter()->select()
                            ->from(array('rl' => TB_RESERVA_LOTE), array('*'))
                            ->join(array('l' => TB_LOTES), 'rl.cod_lote = l.id', array('quadra', 'lote', 'reservaTecnica' => 'reservado'))
                            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('nm_empreendimento'))
                            ->where('rl.corretor = ?', $_POST['corretor'])
                            ->where('rl.reservado = 1')
                            ->where('e.id = ?', $_POST['id_empreendimento'])
                            ->query()->fetchAll ();
                            if ($emp['qtde_reserva_corretor'] > count($reservaCorretor) ) {
                                $reserva_lote_dt = $this->reserva_lote->createRow();
                                $reserva_lote_dt->corretor = $_POST['corretor'];
                                $reserva_lote_dt->cod_lote = $lote;
                                $reserva_lote_dt->reservado = '1';
                                $reserva_lote_dt->data_reserva = date("Y-m-d");
                                $reserva_lote_dt->nome_pessoa = $_POST['nome_pessoa'];
                                $reserva_lote_dt->telefone_pessoa = $_POST['telefone_pessoa'];

                                //muda status do lote para reserva cliente
                                $reserva_lote = new Lote();
                                $reserva_lote = $reserva_lote->fetchRow('id = ' . $lote);
                                $reserva_lote->status = 'RC';
                                
                                (new Relacionamento())->saveContato(250, date('Y-m-d'), $lote, 'Log: Reserva de cliente adicionada. ');
                            } else {
                                $this->redir(array("modulo" => "lo", "controller" => "reservaLote", "action" => "listar"), array("exception" => "No foi possvel realizar a operao. Corretor com limite de reserva excedido."));
                            }
                        } else {
                            if($_POST['dt_final']){
                                $reserva_lote_dt = $this->reserva_lote->createRow();
                                $reserva_lote_dt->cod_lote = $lote;
                                $reserva_lote_dt->reservado = '1';
                                $reserva_lote_dt->data_reserva = date("Y-m-d");
                                $reserva_lote_dt->observacao = $_POST['observacao']; 
                                $reserva_lote_dt->data_final = Helper::dataParaAmericano($_POST['dt_final']);
                                (new Relacionamento())->saveContato(251, date('Y-m-d'), $lote, 'Log: Reserva tcnica adicionada com data final ' . $_POST['dt_final'] . '.');
                                $reserva_lote = new Lote();
                                $reserva_lote = $reserva_lote->fetchRow('id = ' . $lote);
                                //$reserva_lote->reservado = '1';
                                $reserva_lote->data_reserva = date("Y-m-d");
                                $reserva_lote->obs_reserva = $_POST['observacao'];
                                $reserva_lote->status = 'RT';
                            }else{
                                $reserva_lote = new Lote();
                                $reserva_lote = $reserva_lote->fetchRow('id = ' . $lote);
                                $reserva_lote->reservado = '1';
                                $reserva_lote->data_reserva = date("Y-m-d");
                                $reserva_lote->obs_reserva = $_POST['observacao'];  
                                $reserva_lote->status = 'RT';
                                (new Relacionamento())->saveContato(251, date('Y-m-d'), $lote, 'Log: Reserva tcnica adicionada. ');
                            }

                        }
                        $reserva_lote->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                        $reserva_lote->save();
                        if ($_POST['tipoReserva'] == 'cliente' || $_POST['dt_final']) {
                         $reserva_lote_dt->save();
                        }
                        $lotesSalvos[] = $lote;                    
                    } catch (Exception $e) {
                        $this->redir(array("modulo" => "lo", "controller" => "reservaLote", "action" => "listar"), array("exception" => "No foi possvel realizar a operao."));
                    }
                }

            }
        }
        if($lotesReservados) {
            $this->redir(array("modulo" => "lo", "controller" => "reservaLote", "action" => "listar"), array("exception" => "J existe uma reserva ativa para os lotes "  .implode(", ",$lotesReservados). "."));
        } elseif($lotesSalvos) {
            $this->redir(array("modulo" => "lo", "controller" => "reservaLote", "action" => "listar"), array("msg" => "Sucesso"));
        }
        $this->display('form');
    }

    public function cancelarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'cancelarReservaLote')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'reservaLote', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        if ($this->_isPost) {
            try {
                $id = $_POST['id'];
                $idLote = $_POST['idLote'];
                if ($id) {
                    $reserva_lote = $this->reserva_lote->fetchRow("id = $id");
                    $reserva_lote->reservado = '0';
                    $reserva_lote->obs_cancelamento = $_POST['dsObservacao'];
                    $reserva_lote->data_cancelamento = date('Y-m-d');
                    $reserva_lote->id_usuario_cancelou = Login::getUsuario()->getId();
                    (new Relacionamento())->saveContato(252, date('Y-m-d'), $idLote, 'Log: Reserva de cliente cancelada. ');

                    $statusLote = new Lote();
                    $statusLote = $statusLote->fetchRow('id = ' . $idLote);
                    $statusLote->status = 'D';
                    $statusLote->save();

                } else {
                    $reserva_lote = new Lote();
                    $reserva_lote = $reserva_lote->fetchRow('id = ' . $idLote);
                    $reserva_lote->reservado = '0';
                    $reserva_lote->status = 'D';
                    $reserva_lote->obs_reserva .= ' Cancelamento: ' . $_POST['dsObservacao'] . ' ' . date('Y-m-d');
                    (new Relacionamento())->saveContato(253, date('Y-m-d'), $idLote, 'Log: Reserva tcnica cancelada. ');
                }
                $reserva_lote->save();
                $this->redir(array("modulo" => "lo", "controller" => "reservaLote", 'action' => 'listar'), array("msg" => "success"));
            } catch (Exception $e) {
                $this->redir(array("modulo" => "lo", "controller" => "reservaLote", 'action' => 'listar'), array("exception" => "Entre em contato com suporte Acade: ".$e->getMessage()));
            }
        }
    }

    public function cancelarVariasAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'cancelarVariasReservaLote')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'reservaLote', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        if ($this->_isPost) {

            if (isset($_POST['idReserva'])) {
                foreach ($_POST['idReserva'] as $idReserva) {
                    try {
                        $reserva_lote = $this->reserva_lote->fetchRow("id = $idReserva");
                        $reserva_lote->reservado = '0';
                        $reserva_lote->obs_cancelamento = $_POST['observacao'];
                        $reserva_lote->data_cancelamento = date('Y-m-d');
                        $reserva_lote->id_usuario_cancelou = Login::getUsuario()->getId();
                        $reserva_lote->save();
                        (new Relacionamento())->saveContato(252, date('Y-m-d'), $reserva_lote['cod_lote'], 'Log: Reserva de cliente cancelada. ');
                    } catch (Zend_Exception $e) {
                        $this->redir(array("modulo" => "lo", "controller" => "reservaLote", 'action' => 'listar'), array("exception" => "Entre em contato com suporte Acade: " . $e->getMessage()));
                    }
                }
            }

            if (isset($_POST['idLote'])) {
                foreach ($_POST['idLote'] as $idLote) {
                    try {
                        $reserva_tecnica = new Lote();
                        $reserva_tecnica = $reserva_tecnica->fetchRow('id = ' . $idLote);
                        $reserva_tecnica->reservado = '0';
                        $reserva_tecnica->obs_reserva .= ' Cancelamento: ' . $_POST['observacao'] . ' ' . date('Y-m-d');
                        $reserva_lote->status = 'D';
                        $reserva_tecnica->save();
                        (new Relacionamento())->saveContato(253, date('Y-m-d'), $idLote, 'Log: Reserva tcnica cancelada. ');
                    } catch (Zend_Exception $e) {
                        $this->redir(array("modulo" => "lo", "controller" => "reservaLote", 'action' => 'listar'), array("exception" => "Entre em contato com suporte Acade: " . $e->getMessage()));
                    }
                }
            }

            $this->redir(array("modulo" => "lo", "controller" => "reservaLote", 'action' => 'listar'), array("msg" => "success"));
        }
    }

    private function validar()
    {
        $campos = array("id_empreendimento", "lote", "tipoReserva");
        if ($_POST['tipoReserva'] == 'cliente') {
            $campos = array_merge($campos, array("nome_pessoa", "corretor", "telefone_pessoa"));
        }

        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "id_empreendimento" :
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case "lote" :
                        $msg = "O campo Lote  obrigatrio.";
                        break;
                    case "tipoReserva" :
                        $msg = "O campo Tipo de Reserva  obrigatrio.";
                        break;
                    case "nome_pessoa" :
                        $msg = "O campo Nome do Cliente  obrigatrio.";
                        break;
                    case "telefone_pessoa" :
                        $msg = "O campo telefone  obrigatrio.";
                        break;
                    case "corretor" :
                        $msg = "O campo Corretor  obrigatrio.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);

    }

    public function visualizarAction()
    {
        if ($_POST['id']) {
            $reservaLote = $this->lotes->getDefaultAdapter()->select()
                ->from(array('rl' => TB_RESERVA_LOTE), array('*'))
                ->join(array('l' => TB_LOTES), 'rl.cod_lote = l.id', array('quadra', 'lote', 'reservaTecnica' => 'reservado'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('nm_empreendimento'))
                ->joinLeft(array('p' => TB_PESSOA), 'rl.corretor = p.id', array('nm_pessoa'))
                ->where('rl.id = ?', $_POST['id'])
                ->query()->fetch();
        } else {
            $reservaLote = $this->lotes->getDefaultAdapter()->select()
                ->from(array('l' => TB_LOTES), array('quadra', 'lote', 'reservaTecnica' => 'reservado', 'obs_reserva','data_reserva'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('nm_empreendimento'))
                ->where('l.id = ?', $_POST['idLote'])
                ->query()->fetch();
        }
        $auxReserva = array();
        foreach ($reservaLote as $k => $r) {
            $auxReserva[$k] = utf8_encode($r);
        }

        echo json_encode($auxReserva);
    }

    public function loteByEmpreendimentoAction()
    {
        $tb_contratos = new Contrato();
        $contratos = $tb_contratos->getAdapter()->select()
            ->from(TB_CONTRATO, 'id_lote')
            ->where("fl_distrato = '0'")
            ->query()->fetchAll();

        $reservas = $this->reserva_lote->getAdapter()->select()
            ->from(TB_RESERVA_LOTE, 'cod_lote')
            ->where('reservado = "1"')
            ->query()->fetchAll();

        $lotes = $this->lotes->select()
            ->from(TB_LOTES, array('*'))
            ->order(array('quadra ASC', 'lote ASC'))
            ->where('reservado = "0"')
            ->where('id_empreendimento = ?', $_POST['id_empreendimento']);

        if ($contratos)
            $lotes = $lotes->where('id NOT IN(?)', $contratos);
        if ($reservas)
            $lotes = $lotes->where('id NOT IN(?)', $reservas);

        $lotes = $lotes->query()->fetchAll();
        $lista = array();
        foreach ($lotes as $lote) {
            $lista[] = array('id' => $lote['id'], 'text' => utf8_encode('Quadra: ' . $lote['quadra'] . ' - Lote: ' . $lote['lote']));
        }

        echo json_encode($lista);
    }

    public function loteByEmpreendimento2Action()
    {
        $reservas = $this->reserva_lote->getAdapter()->select()
            ->from(TB_RESERVA_LOTE, 'cod_lote')
            ->where('reservado = "1"')
            ->query()->fetchAll();

        $lotes = $this->lotes->select()
            ->from(TB_LOTES, array('*'))
            ->order(array('quadra ASC', 'lote ASC'))
            ->where('reservado = "0"')
            ->where('id_empreendimento = ?', $_POST['id_empreendimento']);

        
        if ($reservas)
            $lotes = $lotes->where('id NOT IN(?)', $reservas);

        $lotes = $lotes->query()->fetchAll();
        $lista = array();
        foreach ($lotes as $lote) {
            $lista[] = array('id' => $lote['id'], 'text' => utf8_encode('Quadra: ' . $lote['quadra'] . ' - Lote: ' . $lote['lote']));
        }

        echo json_encode($lista);
    }

    public function listaByEmpreendimentoLoteAction()
    {
        if ($this->isAjax()) {
            if ($_POST['quadraLote'] == 'todas') {
                $_POST['quadraLote'] = '';
            }
            $_POST['aprovar'] = $_GET['aprovar'];
            if (isset($_POST['empreendimento']) && $_POST['empreendimento'] != '') {
                $listaItem = [];
                $listaItemRT = [];
                if ($_POST['tipoReserva'] == 'AC' || $_POST['tipoReserva'] == 'T') {
                    $totalItens = ReservaLote::findLista($_POST, true);
                    $listaItem = ReservaLote::findLista($_POST); 
                }
                if ($_POST['tipoReserva'] == 'AT' || $_POST['tipoReserva'] == 'T') {
                    $totalItensRT = ReservaLote::findListaReservaTecnica($_POST, true);
                    $listaItemRT = ReservaLote::findListaReservaTecnica($_POST);
                    $totalItensRTFinal = ReservaLote::findListaReservaTecnicaFinal($_POST, true);
                    $listaItemRTFinal = ReservaLote::findListaReservaTecnicaFinal($_POST);
                    $totalItensRT = array_merge($totalItensRT, $totalItensRTFinal);
                    $listaItemRT = array_merge($listaItemRT, $listaItemRTFinal);
                    
                }

                $listaItem = array_merge($listaItem,$listaItemRT);
                $lista = array();
                foreach ($listaItem as $item) {
                    if (in_array($item['id_lote'], $uniqueLotes)) {
                        continue;
                    }
                    $uniqueLotes[] = $item['id_lote'];

                    $reservado = $item['reservado'] == '0' ? true : false;

                    if ($item['reservaTecnica'] == '0' && $item['obsReserva'] != '' && $reservado != false) {
                        $reservado = true;
                    }
                    $mDeletar = $item['reservado'] == '0' ? '' : '.mDeletar';
                    $acoes = '<div></div><div>';
                    $acoes .= '<span data-toggle="modal" data-target=".mVisualizar"><button type="button" value="' . $item['id'] . '" idLote="' . $item['id_lote'] . '" id="btnVisualizar" data-toggle="tooltip" title="VISUALIZAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-eye"></i> </button></span>';
                    $acoes .= '<span data-toggle="modal" data-target="'.$mDeletar.'"><button type="button" value="' . $item['id'] . '" idLote="' . $item['id_lote'] . '" id="btnDeletar"  data-toggle="tooltip" title="CANCELAR" class="btn btn-default btn-sm" '. ($reservado  ? 'disabled' : '') .'><i class="fa fa-times"></i> </button></span>';
                    $acoes .= '</div></div>';

                    if($item['reservaTecnica'] == '1' || $item['data_final']){
                        $cliente = utf8_encode('Reserva Tcnica');
                        $pessoa = utf8_encode('-');
                    }else{
                        $cliente = utf8_encode($item['nome_pessoa']);
                        $pessoa = utf8_encode($item['nm_pessoa']);
                    }
                    $cor = '';                   

                    if ($item['id'] != "") {
                        $checkbox = '<input name="idReserva[]" id="cancelarCheckbox" type="checkbox" value="' . $item['id'] . '">';
                    } else {
                        $checkbox = '<input name="idLote[]" id="cancelarCheckbox" type="checkbox" value="' . $item['id_lote'] . '">';
                    }

                    if ($reservado) {
                        $cor = 'style="color:red;"';
                        $checkbox = '<input name="idLote[]" id="cancelarCheckbox" type="checkbox" value="' . $item['id_lote'] . '" disabled>';
                    }

                    $lista[] = array(
                        'checkbox' => $checkbox,
                        'dataReserva' => '<div ' . $cor . ' >' . Helper::getDate($item['data_reserva']) . '</div>',
                        'empreendimento' => '<div ' . $cor . ' >' . utf8_encode($item['nm_empreendimento']) . '</div>',
                        'quadra' => '<div ' . $cor . ' >' . utf8_encode($item['quadra']) . '</div>',
                        'lote' => '<div ' . $cor . ' >' . utf8_encode($item['lote']) . '</div>',
                        'cliente' => '<div ' . $cor . ' >' . $cliente . '</div>',
                        'corretor' => '<div ' . $cor . ' >' . $pessoa . '</div>',
                        'acoes' => utf8_encode($acoes)
                    );
                }
                echo json_encode(array(
                    'draw' => $_POST['draw'],
                    'recordsTotal' => count($totalItens)+count($totalItensRT),
                    'recordsFiltered' => count($totalItens)+count($totalItensRT),
                    'tipoReserva' => $_POST['tipoReserva'],
                    'data' => $lista
                ));
            } else {
                echo json_encode(array(
                    'draw' => 1,
                    'recordsTotal' => count(0),
                    'recordsFiltered' => count(0),
                    'data' => array()
                ));
            }
        }
    }

    public function findQuadraLoteAction()
    {
        $findquadraLote = $this->lotes->select()
            ->from(TB_LOTES, array('id','quadra'))
            ->where('id_empreendimento = '. $_POST['id_empreendimento'])
            ->group('quadra')
            ->query()->fetchAll();
        
        $lista[] = array('id'=>'todas','text'=>'Todas');
        foreach ($findquadraLote as $quadraLote) {
            $lista[] = array('id' => utf8_encode($quadraLote['quadra']), 'text' => utf8_encode('Quadra: ' . $quadraLote['quadra']));
        }
        echo json_encode($lista);
    }
}

?>