<?php

class PessoaJuridicaController extends Controller
{
    private $pjs;
    private $cidades;
    private $pessoas;
    private $docs;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->pjs = new Pessoa_Juridica();
        $this->pessoas = new Pessoa();
        $this->docs = new Documento();
        $this->cidades = new Db_Cidade();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "lo", "controller" => "pessoaJuridica", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $totalItens = Pessoa_Juridica::findLista($_POST, true);
            $listaItem = Pessoa_Juridica::findLista($_POST);

            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                $lista[] = array(
                    'id' => utf8_encode($item['id']),
                    'nm_pessoa' => utf8_encode($item['nm_pessoa']),
                    'nr_cnpj' => utf8_encode($item['nr_cnpj']),
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalItens),
                'recordsFiltered' => count($totalItens),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarPessoaJuridica')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'pessoaJuridica', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        if ($this->_isPost) {
            if ($this->validar($_POST["nr_cnpj"])) {
                //insero em pessoa
                $pessoas = new Pessoa();
                $p = $pessoas->createRow();

                $p->nm_pessoa = $_POST["nm_pessoa"];
                $p->nr_telefone = $_POST["nr_telefone"];
                $p->nr_celular = $_POST["nr_celular"];
                $p->nr_fax = $_POST["nr_fax"];
                $p->email = $_POST["email"];
                $p->nr_recado = $_POST["nr_recado"];
                $p->nr_cep = $_POST["nr_cep"];
                $p->endereco = $_POST["endereco"];
                $p->nr_endereco = $_POST["nr_endereco"];
                $p->ds_complemento = $_POST["ds_complemento"];
                $p->nm_bairro = $_POST["nm_bairro"];
                $p->ds_observacao = $_POST["ds_observacao"];
                $p->cd_cidade = $_POST["cd_cidade"];
                $p->tp_pessoa = "J";
                $p->dt_cadastro = date("Y-m-d H:i:s");

                //pessoa jurdica
                $pjs = new Pessoa_Juridica();
                $pj = $pjs->createRow();
                $pj->nr_cnpj = $_POST["nr_cnpj"];
                $pj->nm_fantasia = $_POST["nm_fantasia"];
                $pj->nr_inscricao_municipal = $_POST["nr_inscricao_municipal"];
                $pj->nr_inscricao_estadual = $_POST["nr_inscricao_estadual"];
                $p->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i');

                $id = $p->save();
                $pj->id_pessoa = $id;
                $pj->save();

                //representantes
                $count = count($_POST["representantes"]);
                if ($count > 0) {
                    $reps = new Representante();
                    for ($i = 0; $i < $count; $i++) {
                        $rep = $reps->createRow();
                        $rep->id_pessoa = $_POST["representantes"][$i];
                        $rep->id_pessoa_juridica = $id;
                        $rep->save();
                    }
                }

                $this->redir(array("modulo" => "lo", "controller" => "pessoaJuridica", "action" => "listar"), array("msg" => "success"));
            }
        }

        $this->display('form');
    }

    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'editarPessoaJuridica')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'pessoaJuridica', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $p = Pessoa::findById($_GET['id']);
        $representantes = Representante::findByJuridica($_GET['id']);

        $this->set('pessoa', $p);
        $this->set('representantes', $representantes);

        if ($this->_isPost) {
            if ($this->validar($_POST["nr_cnpj"])) {
                //insero em pessoa
                $pessoas = new Pessoa();
                $p = $pessoas->fetchRow($pessoas->select()->where('id = ?', $_GET['id']));

                $p->nm_pessoa = $_POST["nm_pessoa"];
                $p->nr_telefone = $_POST["nr_telefone"];
                $p->nr_celular = $_POST["nr_celular"];
                $p->nr_fax = $_POST["nr_fax"];
                $p->email = $_POST["email"];
                $p->nr_recado = $_POST["nr_recado"];
                $p->nr_cep = $_POST["nr_cep"];
                $p->endereco = $_POST["endereco"];
                $p->nr_endereco = $_POST["nr_endereco"];
                $p->ds_complemento = $_POST["ds_complemento"];
                $p->nm_bairro = $_POST["nm_bairro"];
                $p->ds_observacao = $_POST["ds_observacao"];
                $p->cd_cidade = $_POST["cd_cidade"];
                $p->tp_pessoa = "J";
                $p->dt_cadastro = date("Y-m-d H:i:s");

                //pessoa jurdica
                $pjs = new Pessoa_Juridica();
                $pj = $pjs->fetchRow($pjs->select()->where('id_pessoa = ?', $_GET['id']));
                $pj->nr_cnpj = $_POST["nr_cnpj"];
                $pj->nm_fantasia = $_POST["nm_fantasia"];
                $pj->nr_inscricao_municipal = $_POST["nr_inscricao_municipal"];
                $pj->nr_inscricao_estadual = $_POST["nr_inscricao_estadual"];
                $p->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - u');

                $id = $p->save();
                $pj->id_pessoa = $id;
                $pj->save();

                //representantes
                $count = count($_POST["representantes"]);
                $reps = new Representante();
                $reps->delete($reps->getAdapter()->quoteInto('id_pessoa_juridica = ?', $id));
                if ($count > 0) {
                    for ($i = 0; $i < $count; $i++) {
                        $rep = $reps->createRow();
                        $rep->id_pessoa = $_POST["representantes"][$i];
                        $rep->id_pessoa_juridica = $id;

                        //Apenas a primeira pessoa da lista vai ser a representante principal
                        if ($i == 0)
                            $rep->fl_principal = 1;

                        $rep->save();
                    }
                }

                $this->redir(array("modulo" => "lo", "controller" => "pessoaJuridica", "action" => "listar"), array("msg" => "success"));
            }

        }

        $this->display('form');
    }

    private function validar($cnpj)
    {

        //checa se o CNPJ  vlido
        if ($cnpj)
            if ($this->_helper->validaCNPJ($cnpj)) {
                //checa se est duplicado
                $pjs = new Pessoa_Juridica();
                $_p = $pjs->fetchRow("nr_cnpj = '{$cnpj}'");

                if (($_p["id_pessoa"])) {
                    $id = $_GET['id'];
                    if ((!$id) || (($id) && ($_p["id_pessoa"] != $id))) {
                        $this->_helper->addMensagem("cnpj", "CNPJ j cadastrado");
                    }
                }
            } else {
                $this->_helper->addMensagem("cnpj", "CNPJ invalido");
            }


        $campos = array("nm_pessoa", "nm_fantasia", "nr_cnpj", 'representantes');
        foreach ($campos as $cp) {
            if ($_POST[$cp] == "") {
                switch ($cp) {
                    case "nm_pessoa" :
                        $msg = "O campo Razo Social  obrigatrio.";
                        break;
                    case "nm_fantasia" :
                        $msg = "O campo Nome Fantasia  obrigatrio.";
                        break;
                    case "nr_cnpj" :
                        $msg = "O campo CNPJ  obrigatrio.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);

            }
        }
        if (!count($_POST['representantes'])) {
            $msg = "A pessoa juridica necessita de representates.";
            $this->_helper->addMensagem($cp, $msg);
        } else {
            $proprioRepresentante = false;
            foreach ($_POST['representantes'] as $representante) {
                if($representante == $_GET['id']) {
                    $proprioRepresentante = true;
                }
            }
            if ($proprioRepresentante) {
                $this->_helper->addMensagem($cp, "O representante no pode ser a prpria pessoa jurdica.");
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function findPessoaJuridicaByCnpjAction()
    {
        echo json_encode($this->pessoas->findPessoaJuridicaByCnpj($_POST['cnpj'], ($_POST['id']) ? $_POST['id'] : null));
    }
}