<?php

class PessoaFisicaController extends Controller
{
    private $pessoa;
    private $cidades;
    private $sexos;
    private $estCivis;
    private $docs;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->pessoa = new Pessoa();
        $this->docs = new Documento();
        $this->cidades = new Db_Cidade();
        $this->sexos = new Db_TabelaAgrupada();
        $this->estCivis = new Db_TabelaAgrupada();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "lo", "controller" => "pessoaFisica", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $totalItens = Pessoa_Fisica::findLista($_POST, true);
            $listaItem = Pessoa_Fisica::findLista($_POST);

            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id'] . '" data-toggle="tooltip" 
                title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';

                $acoes .= '</div>';
                $acoes .= '</div>';

                $lista[] = array(
                    'id' => utf8_encode($item['id']),
                    'nm_pessoa' => utf8_encode($item['nm_pessoa']),
                    'nr_cpf' => utf8_encode($item['nr_cpf']),
                    'endereco' => utf8_encode($item['endereco']),
                    'nm_bairro' => utf8_encode($item['nm_bairro']),
                    'ds_complemento' => utf8_encode($item['ds_complemento']),
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalItens),
                'recordsFiltered' => count($totalItens),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarPessoaFisica')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'pessoaFisica', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $this->set("sexos", $this->sexos = Db_TabelaAgrupada::findByTabelaId(Db_TabelaAgrupada::TABLE_SEXO));
        $this->set("estCivis", $this->estCivis = Db_TabelaAgrupada::findByTabelaId(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL));
        $this->set("regCasamento", $this->regCasamento = Db_TabelaAgrupada::findByTabelaId(Db_TabelaAgrupada::TABLE_REGIME_CASAMENTO));
        $this->set("tipoArquivos", Db_TabelaAgrupada::findByTabelaId(Db_TabelaAgrupada::TABLE_TIPO_ARQUIVO));

        $tpDocumentosOpt = Db_TabelaAgrupada::findByTabelaId(Db_TabelaAgrupada::TABLE_TIPO_ARQUIVO);
        foreach ($tpDocumentosOpt as $k => $tpDoc) {
            if ($tpDoc['descricao'] == 'CPF' || $tpDoc['descricao'] == 'GERAL') {
                unset($tpDocumentosOpt[$k]);
            }
        }
        $this->set("tpDocumentos", $tpDocumentosOpt);

        if ($this->_isPost) {
            //insercao em pessoa
            $pessoas = new Pessoa();
            $p = $pessoas->createRow();

            $p->nm_pessoa = $_POST["nm_pessoa"];
            $p->email = $_POST["email"];
            $p->nr_telefone = $_POST["nr_telefone"];
            $p->nr_celular = $_POST["nr_celular"];
            $p->nr_fax = $_POST["nr_fax"];
            $p->nr_recado = $_POST["nr_recado"];
            $p->nr_cep = $_POST["nr_cep"];
            $p->endereco = $_POST["endereco"];
            $p->nr_endereco = $_POST["nr_endereco"];
            $p->ds_complemento = $_POST["ds_complemento"];
            $p->nm_bairro = $_POST["nm_bairro"];
            $p->ds_observacao = $_POST["ds_observacao"];
            $p->cd_cidade = ($_POST["cd_cidade"] ? $_POST["cd_cidade"] : null);
            $p->nm_cd_internacional = $_POST["nm_cd_internacional"];
            $p->tp_pessoa = "F";
            $p->dt_cadastro = date("Y-m-d H:i:s");

            //pessoa fsica
            $pfs = new Pessoa_Fisica();
            $pf = $pfs->createRow();
            $pf->nr_cpf = $_POST["nr_cpf"];
            $pf->dt_nascimento = $this->_helper->filters($_POST["dt_nascimento"], 'date');
            $pf->nr_rg = $this->_helper->filters($_POST["nr_rg"]);
            $pf->cd_documento = $this->_helper->filters($_POST["tpDocumento"]);
            $pf->nm_profissao = $this->_helper->filters($_POST["nm_profissao"]);
            $pf->tp_nacionalidade = $this->_helper->filters($_POST["tpNacionalidade"]);
            if ($_POST['tpNacionalidade'] == 'B')
                $pf->nm_nacionalidade = $this->_helper->filters('Brasileira');
            else
                $pf->nm_nacionalidade = $this->_helper->filters($_POST["nm_nacionalidade"]);
            $pf->cd_cidade_nasc = $this->_helper->filters($_POST["cidade_nasc"]);
            $pf->est_civil = $this->_helper->filters($_POST["est_civil"]);
            $pf->reg_casamento = $this->_helper->filters($_POST["reg_casamento"]);
            $pf->nm_pai = $this->_helper->filters($_POST["nm_pai"]);
            $pf->sexo = $this->_helper->filters($_POST["sexo"]);
            $pf->nm_mae = $this->_helper->filters($_POST["nm_mae"]);


            if (($_POST["est_civil"] == 'CAS' || $_POST["est_civil"] == 'UNE') && ($_POST["nrCpfConjuge"] ||
                    $_POST["nrRgConjuge"] || $_POST["dtNascimentoConjuge"] || $_POST["nmProfissaoConjuge"] ||
                    $_POST["nmNacionalidadeConjuge"] || $_POST["nrTelefoneConjuge"] || $_POST["nrCepConjuge"] ||
                    $_POST["enderecoConjuge"] || $_POST["nmBairroConjuge"])) {

                $pessoaConjuge = new Pessoa();
                $pessoaFisicaConjuge = new Pessoa_Fisica();

                //Se o conjuge ja esta cadastrado, ele sera pesquisado para modificar os dados do mesmo, caso nao, sera inserido
                if ($_POST["idConjuge"]) {
                    $pC = $pessoaConjuge->fetchRow('id = ' . $_POST["idConjuge"]);
                    $pfC = $pessoaFisicaConjuge->fetchRow('id_pessoa = ' . $_POST["idConjuge"]);
                } else {
                    $pC = $pessoaConjuge->createRow();
                    $pfC = $pessoaFisicaConjuge->createRow();
                }

                $pC->nm_pessoa = ($_POST["nmConjuge"]) ? $_POST["nmConjuge"] : null;
                $pC->nr_telefone = ($_POST["nrTelefoneConjuge"]) ? $_POST["nrTelefoneConjuge"] : null;
                $pC->tp_pessoa = 'F';

                $pC->nr_cep = ($_POST["utilizarEnderecoConjuge"] == 1) ? $_POST["nr_cep"] : $_POST["nrCepConjuge"];
                $pC->endereco = ($_POST["utilizarEnderecoConjuge"] == 1) ? $_POST["endereco"] : $_POST["enderecoConjuge"];
                $pC->nr_endereco = ($_POST["utilizarEnderecoConjuge"] == 1) ? $_POST["nr_endereco"] : $_POST["nr_enderecoConjuge"];
                $pC->ds_complemento = ($_POST["utilizarEnderecoConjuge"] == 1) ? $_POST["ds_complemento"] : $_POST["ds_complementoConjuge"];
                $pC->nm_bairro = ($_POST["utilizarEnderecoConjuge"] == 1) ? $_POST["nm_bairro"] : $_POST["nmBairroConjuge"];
                $pC->cd_cidade = ($_POST["utilizarEnderecoConjuge"] == 1) ? ($_POST["cd_cidade"] ? $_POST["cd_cidade"] : null) : $_POST["cd_cidade"];

                $pfC->nr_cpf = ($_POST["nrCpfConjuge"]) ? $_POST["nrCpfConjuge"] : null;
                $pfC->tp_nacionalidade = $this->_helper->filters($_POST["tpNacionalidadeConjuge"]);
                if ($_POST['tpNacionalidadeConjuge'] == 'B')
                    $pfC->nm_nacionalidade = $this->_helper->filters('Brasileira');
                else
                    $pfC->nm_nacionalidade = ($_POST["nmNacionalidadeConjuge"]) ? $_POST["nmNacionalidadeConjuge"] : null;
                $pfC->nr_rg = ($_POST["nrRgConjuge"]) ? $_POST["nrRgConjuge"] : null;
                $pfC->cd_documento = ($_POST["tpDocumentoConjuge"]) ? $_POST["tpDocumentoConjuge"] : null;
                $pfC->dt_nascimento = ($_POST["dtNascimentoConjuge"]) ? $this->_helper->getInputDate($_POST["dtNascimentoConjuge"]) : null;
                $pfC->cd_cidade_nasc = ($_POST['cidade_nascConjuge']) ? $this->_helper->filters($_POST["cidade_nascConjuge"]) : null;
                $pfC->nm_profissao = ($_POST["nmProfissaoConjuge"]) ? $_POST["nmProfissaoConjuge"] : null;
                $pfC->sexo = ($_POST["sexoConjuge"]) ? $_POST["sexoConjuge"] : null;

                if ($_POST["nrCpfConjuge"]) {
                    $arrayCpf[] = array('cpf' => $_POST["nrCpfConjuge"], 'campo' => 'nrCpfConjuge', 'id' => $_POST["idConjuge"]);
                }
            }

            $arrayCpf[] = array('cpf' => $_POST["nr_cpf"], 'campo' => 'cpf');

            $this->set("pessoa", $p->toArray());
            $this->set("pf", $pf);

            if ($this->validar($arrayCpf)) {
                $p->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i');
                $id = $p->save();

                if (($_POST["est_civil"] == 'CAS' || $_POST["est_civil"] == 'UNE') && ($_POST["nrCpfConjuge"] ||
                        $_POST["nrRgConjuge"] || $_POST["dtNascimentoConjuge"] || $_POST["nmProfissaoConjuge"] ||
                        $_POST["nmNacionalidadeConjuge"] || $_POST["nrTelefoneConjuge"] || $_POST["nrCepConjuge"] ||
                        $_POST["enderecoConjuge"] || $_POST["nmBairroConjuge"])) {

                    //salva a pessoa do conjuge
                    $idPessoaConjuge = $pC->save();

                    //salva a pessoa fisica do conjuge
                    $pfC->id_pessoa = $idPessoaConjuge;

                    if ($_POST["est_civil"] == 'CAS')
                        $pfC->est_civil = 'CAS';
                    if ($_POST["est_civil"] == 'UNE')
                        $pfC->est_civil = 'UNE';
                    $pfC->save();

                    $pf->cd_conjuge = $idPessoaConjuge;
                }

                $pf->id_pessoa = $id;
                $idPessoaFisica = $pf->save();

                if (($_POST["est_civil"] == 'CAS' || $_POST["est_civil"] == 'UNE') && ($_POST["nrCpfConjuge"] ||
                        $_POST["nrRgConjuge"] || $_POST["dtNascimentoConjuge"] || $_POST["nmProfissaoConjuge"] ||
                        $_POST["nmNacionalidadeConjuge"] || $_POST["nrTelefoneConjuge"] || $_POST["nrCepConjuge"] ||
                        $_POST["enderecoConjuge"] || $_POST["nmBairroConjuge"])) {
                    $pfC = $pessoaFisicaConjuge->fetchRow('id_pessoa = ' . $idPessoaConjuge);
                    $pfC->cd_conjuge = $idPessoaFisica;
                    $pfC->save();
                }

                if ($_FILES["doc"]["name"][0]) {
                    //arquivo
                    $docs = new Documento();
                    $up = new Filesystem();

                    $len = count($_FILES["doc"]["name"]);

                    for ($i = 0; $i < $len; $i++) {
                        if (filesize($_FILES["doc"]["name"][0]) < 10000000) {

                            $doc = $docs->createRow();

                            //Ajusta o nome para o padro novo (permitindo varios bancos de dados)
                            $arquivo = $this->_helper->removeAcentos($_FILES["doc"]["name"][$i]);
                            $ext = explode('.', $arquivo);
                            $ext = array_pop($ext);
                            $arquivo = str_replace('.' . $ext, '', $arquivo);
                            $arquivo = "DOC_" . $id . '_' . $arquivo . '_' . date('dmyHis') . '.' . $ext;

                            //Grava os dados no banco
                            $doc->nm_documento = $_FILES["doc"]["name"][$i];
                            $doc->cd_tipo = $_POST["tp_doc"][$i];
                            $doc->id_pessoa = $id;
                            $doc->path = "upload/arquivos/" . $arquivo;

                            if ($doc->save()) {
                                $tmp = $_FILES['doc']['tmp_name'][$i];
                                $to = "upload/arquivos/" . $arquivo;
                                $rs = $up->upload($tmp, $to);
                            }
                        }
                    }
                }
                $this->redir(array("modulo" => "lo", "controller" => "pessoaFisica", "action" => "listar"), array("msg" => "success"));
            } else {
                $_POST['utilizarEnderecoConjuge'] = ($_POST['nrCepConjuge'] == $_POST['nr_cep'] && $_POST['enderecoConjuge']
                == $_POST['endereco'] && $_POST['nmBairroConjuge'] == $_POST['nm_bairro'] && $_POST['cdCidadeConjuge'] == $_POST['cd_cidade']) ? 1 : 0;

                $this->set('params', $_POST);
            }
        }

        $this->display('form');
    }

    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'editarPessoaFisica')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'pessoaFisica', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $this->set("sexos", $this->sexos = Db_TabelaAgrupada::findByTabelaId(Db_TabelaAgrupada::TABLE_SEXO));
        $this->set("estCivis", $this->estCivis = Db_TabelaAgrupada::findByTabelaId(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL));
        $this->set("regCasamento", $this->regCasamento = Db_TabelaAgrupada::findByTabelaId(Db_TabelaAgrupada::TABLE_REGIME_CASAMENTO));
        $this->set("tipoArquivos", $this->estCivis = Db_TabelaAgrupada::findByTabelaId(Db_TabelaAgrupada::TABLE_TIPO_ARQUIVO));

        $tpDocumentosOpt = Db_TabelaAgrupada::findByTabelaId(Db_TabelaAgrupada::TABLE_TIPO_ARQUIVO);
        foreach ($tpDocumentosOpt as $k => $tpDoc) {
            if ($tpDoc['descricao'] == 'CPF' || $tpDoc['descricao'] == 'GERAL') {
                unset($tpDocumentosOpt[$k]);
            }
        }
        $this->set("tpDocumentos", $tpDocumentosOpt);

        if ($this->_isPost) {
            $arrayCpf[] = array('cpf' => $_POST["nr_cpf"], 'campo' => 'cpf');

            if ($_POST["nrCpfConjuge"])
                $arrayCpf[] = array('cpf' => $_POST["nrCpfConjuge"], 'campo' => 'nrCpfConjuge', 'id' => $_POST["idConjuge"]);

            if ($this->validar($arrayCpf)) {
                try {
                    //insercao em pessoa
                    $pessoas = new Pessoa();
                    
                    $p = $pessoas->fetchRow($pessoas->select()->where('id = ?', $_GET['id']));
                    $pClone = clone $p;
                    
                    $p->nm_pessoa = $_POST["nm_pessoa"];
                    $p->email = $_POST["email"];
                    $p->nr_telefone = $_POST["nr_telefone"];
                    $p->nr_celular = $_POST["nr_celular"];
                    $p->nr_recado = $_POST["nr_recado"];
                    $p->nr_cep = $_POST["nr_cep"];
                    $p->endereco = $_POST["endereco"];
                    $p->nr_endereco = $_POST["nr_endereco"];
                    $p->ds_complemento = $_POST["ds_complemento"];
                    $p->nm_bairro = $_POST["nm_bairro"];
                    $p->cd_cidade = ($_POST["cd_cidade"] ? $_POST["cd_cidade"] : null);
                    $p->nm_cd_internacional = $_POST["nm_cd_internacional"];
                    $p->ds_observacao = $_POST["ds_observacao"];
                    $p->tp_pessoa = "F";
                    $p->dt_cadastro = date("Y-m-d H:i:s");
                    $p->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - u');
                    
                    
                    //pessoa fisica
                    $pfs = new Pessoa_Fisica();
                    $pf = $pfs->fetchRow($pfs->select()->where('id_pessoa = ?', $_GET['id']));
                    $pfClone = clone $pf;

                    $pf->nr_cpf = $this->_helper->filters($_POST["nr_cpf"]);
                    $pf->dt_nascimento = $this->_helper->filters($_POST["dt_nascimento"], 'date');
                    $pf->nr_rg = $this->_helper->filters($_POST["nr_rg"]);
                    $pf->cd_documento = $this->_helper->filters($_POST["tpDocumento"]);
                    $pf->sexo = $this->_helper->filters($_POST["sexo"]);
                    $pf->nm_profissao = $this->_helper->filters($_POST["nm_profissao"]);
                    $pf->tp_nacionalidade = $this->_helper->filters($_POST["tpNacionalidade"]);
                    if ($_POST['tpNacionalidade'] == 'B')
                        $pf->nm_nacionalidade = $this->_helper->filters('Brasileira');
                    else
                        $pf->nm_nacionalidade = $this->_helper->filters($_POST["nm_nacionalidade"]);
                    $pf->cd_cidade_nasc = $this->_helper->filters($_POST["cidade_nasc"]);
                    $pf->est_civil = $this->_helper->filters($_POST["est_civil"]);
                    $pf->reg_casamento = $this->_helper->filters($_POST["reg_casamento"]);
                    $pf->nm_pai = $this->_helper->filters($_POST["nm_pai"]);
                    $pf->nm_mae = $this->_helper->filters($_POST["nm_mae"]);

                    if (($_POST["est_civil"] == 'CAS' || $_POST["est_civil"] == 'UNE') && ($_POST["nrCpfConjuge"] ||
                            $_POST["nrRgConjuge"] || $_POST["dtNascimentoConjuge"] || $_POST["nmProfissaoConjuge"] ||
                            $_POST["nmNacionalidadeConjuge"] || $_POST["nrTelefoneConjuge"] || $_POST["nrCepConjuge"] ||
                            $_POST["enderecoConjuge"] || $_POST["nmBairroConjuge"])) {

                        $pessoaConjuge = new Pessoa();
                        $pessoaFisicaConjuge = new Pessoa_Fisica();

                        //Se o conjuge ja esta cadastrado, ele sera pesquisado para modificar os dados do mesmo, caso nao, sera inserido
                        if ($_POST["idConjuge"]) {
                            $pC = $pessoaConjuge->fetchRow('id = ' . $_POST["idConjuge"]);
                            $pCClone = clone $pC;
                            $pfC = $pessoaFisicaConjuge->fetchRow('id_pessoa = ' . $_POST["idConjuge"]);
                            $pfCClone = clone $pfC;
                        } else {
                            $pC = $pessoaConjuge->createRow();
                            $pfC = $pessoaFisicaConjuge->createRow();
                        }

                        $pC->nm_pessoa = ($_POST["nmConjuge"]) ? $_POST["nmConjuge"] : null;
                        //$pC->nr_telefone = ($_POST["nrTelefoneConjuge"]) ? $_POST["nrTelefoneConjuge"] : null;

                        $pC->nr_cep = ($_POST["utilizarEnderecoConjuge"] == 1) ? $_POST["nr_cep"] : $_POST["nrCepConjuge"];
                        $pC->endereco = ($_POST["utilizarEnderecoConjuge"] == 1) ? $_POST["endereco"] : $_POST["enderecoConjuge"];
                        $pC->nr_endereco = ($_POST["utilizarEnderecoConjuge"] == 1) ? $_POST["nr_endereco"] : $_POST["nr_enderecoConjuge"];
                        $pC->ds_complemento = ($_POST["utilizarEnderecoConjuge"] == 1) ? $_POST["ds_complemento"] : $_POST["ds_complementoConjuge"];
                        $pC->nm_bairro = ($_POST["utilizarEnderecoConjuge"] == 1) ? $_POST["nm_bairro"] : $_POST["nmBairroConjuge"];
                        $pC->cd_cidade = ($_POST["utilizarEnderecoConjuge"] == 1) ? ($_POST["cd_cidade"] ? $_POST["cd_cidade"] : null) : $_POST["cd_cidade"];
                        $pC->tp_pessoa = "F";
                        $pC->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - u');

                        $pfC->nr_cpf = ($_POST["nrCpfConjuge"]) ? $_POST["nrCpfConjuge"] : null;
                        $pfC->tp_nacionalidade = $this->_helper->filters($_POST["tpNacionalidadeConjuge"]);
                        if ($_POST['tpNacionalidadeConjuge'] == 'B')
                            $pfC->nm_nacionalidade = $this->_helper->filters('Brasileira');
                        else
                            $pfC->nm_nacionalidade = ($_POST["nmNacionalidadeConjuge"]) ? $_POST["nmNacionalidadeConjuge"] : null;
                        $pfC->nr_rg = ($_POST["nrRgConjuge"]) ? $_POST["nrRgConjuge"] : null;
                        $pfC->cd_documento = ($_POST["tpDocumentoConjuge"]) ? $_POST["tpDocumentoConjuge"] : null;
                        $pfC->cd_cidade_nasc = ($_POST['cidade_nascConjuge']) ? $this->_helper->filters($_POST["cidade_nascConjuge"]) : null;
                        $pfC->dt_nascimento = ($_POST["dtNascimentoConjuge"]) ? $this->_helper->getInputDate($_POST["dtNascimentoConjuge"]) : null;
                        $pfC->nm_profissao = ($_POST["nmProfissaoConjuge"]) ? $_POST["nmProfissaoConjuge"] : null;
                        $pfC->sexo = ($_POST["sexoConjuge"]) ? $_POST["sexoConjuge"] : null;
                    }

                    //Diferena gerada para log
                    $pfDiferenca = array_diff($pf->toArray(), $pfClone->toArray());
                    $pDiferenca = array_diff($p->toArray(), $pClone->toArray());
                    
                    //Confirma se h conjuge e se a consulta retornou (evita erros)
                    if ($pC->id != '' && $pfC->id_pessoa != '') {
                        $pCDiferenca = array_diff($pC->toArray(), $pCClone->toArray());
                        $pfCDiferenca = array_diff($pfC->toArray(), $pfCClone->toArray());
                    } else {
                        $pCDiferenca = null;
                        $pfCDiferenca = null;
                    }

                    $diferencasArray = array("pfClone" => $pfDiferenca, "pClone" => $pDiferenca, "pCClone" => $pCDiferenca, "pfCClone" => $pfCDiferenca);
                    $logText = "";

                    foreach ($diferencasArray as $keyArray => $diferencaArray) {
                        foreach ($diferencaArray as $key => $diferenca) {                            
                            //Dois smbolos dlar ($$) transforma String em Varivel
                            if ($key != "dt_cadastro" && $key != "log") {
                                $logText .= "Alterado " . $key . " de: " . $$keyArray->$key . " para " . $diferenca . ". ";
                            }
                        }
                    }

                    //Salva a pessoa
                    $id = $p->save();

                    if (($_POST["est_civil"] == 'CAS' || $_POST["est_civil"] == 'UNE') && ($_POST["nrCpfConjuge"] ||
                            $_POST["nrRgConjuge"] || $_POST["dtNascimentoConjuge"] || $_POST["nmProfissaoConjuge"] ||
                            $_POST["nmNacionalidadeConjuge"] || $_POST["nrTelefoneConjuge"] || $_POST["nrCepConjuge"] ||
                            $_POST["enderecoConjuge"] || $_POST["nmBairroConjuge"])) {
                        //salva a pessoa do conjuge
                        $idPessoaConjuge = $pC->save();

                        $pfC->id_pessoa = $idPessoaConjuge;
                        $pfC->cd_conjuge = $_GET['id'];
                        if ($_POST["est_civil"] == 'CAS')
                            $pfC->est_civil = 'CAS';
                        if ($_POST["est_civil"] == 'UNE')
                            $pfC->est_civil = 'UNE';
                        $pfC->save();

                        $pf->cd_conjuge = $idPessoaConjuge;
                    } else {
                        if ($pf->cd_conjuge) {
                            $pessoaFisicaConjuge = new Pessoa_Fisica();
                            $pfC = $pessoaFisicaConjuge->fetchRow($pf->cd_conjuge);
                            if ($pfC) {
                                $pfC->cd_conjuge = null;
                                $pfC->est_civil = $this->_helper->filters($_POST["est_civil"]);
                                $pfC->save();
                            }
                        }
                        $pf->cd_conjuge = null;
                    }

                    $pf->id_pessoa = $id;
                    $pf->save();

                    if ($_FILES["doc"]["name"][0]) {
                        //arquivo
                        $up = new Filesystem();
                        $docs = new Documento();

                        $len = count($_FILES["doc"]["name"]);

                        for ($i = 0; $i < $len; $i++) {

                            $doc = $docs->createRow();

                            //Ajusta o nome para o padro novo (permitindo varios bancos de dados)
                            $arquivo = $this->_helper->removeAcentos($_FILES["doc"]["name"][$i]);
                            $ext = explode('.', $arquivo);
                            $ext = array_pop($ext);
                            $arquivo = str_replace('.' . $ext, '', $arquivo);
                            $arquivo = "DOC_" . $id . '_' . $arquivo . '_' . date('dmyHis') . '.' . $ext;

                            //Grava os dados no banco
                            $doc->nm_documento = $_FILES["doc"]["name"][$i];
                            $doc->cd_tipo = $_POST["tp_doc"][$i];
                            $doc->id_pessoa = $id;
                            $doc->path = "upload/arquivos/" . $arquivo;

                            if ($doc->save()) {
                                $tmp = $_FILES['doc']['tmp_name'][$i];
                                $to = "upload/arquivos/" . $arquivo;
                                $up->upload($tmp, $to);
                            }
                        }
                    }
                    //Adiciona log relacionamento
                    $contrato = new Contrato();
                    $contratosPessoa = $contrato->fetchAll('id_pessoa = ' . $p->id)->toArray();
                    foreach ($contratosPessoa as $contratoPessoa) {
                        if ($logText != "") {
                            (new Relacionamento())->saveContato(67, date('Y-m-d'), $contratoPessoa['id'], 'Log: Alteracao de dados pessoa - ' . $logText);
                        }
                    }
                    $this->redir(array("modulo" => "lo", "controller" => "pessoaFisica", "action" => "listar"), array("msg" => "success"));
                } catch (Exception $e) {
                    $this->redir(array("modulo" => "lo", "controller" => "pessoaFisica", "action" => "listar"), array("exception" => "No foi possvel realizar a operao."));
                }
            }
        }

        $p = Pessoa::findById($_GET['id']);
        $this->set('pessoa', $p);

        if ($p['cd_conjuge'])
            $pessoaConjuge = Pessoa::findById($p['cd_conjuge']);

        if (isset($pessoaConjuge)) {
            $conjuge['pessoa'] = $pessoaConjuge;

            if (isset($conjuge['pessoa']['cd_cidade'])) {
                $cidadeConjuge = new Cidade();
                $cidadeConjuge = $cidadeConjuge->find($conjuge['pessoa']['cd_cidade'])->current();
                $conjuge['nm_cidade'] = $cidadeConjuge['nome'];
            }
            $conjuge['conjugeEndereco'] = ($pessoaConjuge['endereco'] == $p['endereco'] && $pessoaConjuge['nr_cep'] == $p['nr_cep'] &&
                $pessoaConjuge['nm_bairro'] == $p['nm_bairro'] && $pessoaConjuge['cd_cidade'] == $p['cd_cidade']) ? 1 : 0;

            $this->set('conjuge', $conjuge);
        }

        $documentos = new Documento();
        $docs = $documentos->fetchAll("id_pessoa = " . $_GET['id']);

        $this->set("documentos", $docs);

        $cidadeNasc = $this->cidades->find($p['cidade_nasc']);
        $cidade = $this->cidades->find($p['cd_cidade']);
        $params = array();
        if ($cidade) {
            $params = array_merge($params, array('cidade' => $cidade->getNome() . ' - ' . $cidade->getUf(),
                'cd_cidade' => $cidade->getId()
            ));
        }
        if ($cidadeNasc) {
            $params = array_merge($params, array(
                'cidade_nasc' => $cidadeNasc->getNome() . ' - ' . $cidadeNasc->getUf(),
                'cd_cidade_nasc' => $cidadeNasc->getId()));
        }

        $this->set('params', $params);
        $this->display('form');
    }

    private function validar($arrayCpf)
    {
        //checa se o CPF esta valido no caso de ser brasileiro
        if ($_POST['tpNacionalidade'] == 'B') {
            if ($arrayCpf) {
                foreach ($arrayCpf as $cpf) {
                    if ($this->_helper->validaCPF($cpf['cpf'])) {
                        if (!isset($_POST['hiddenCpf']) || $cpf['cpf'] != $_POST['hiddenCpf']) {
                            $pessoa = $this->pessoa->findPessoaFisicaByCpf($cpf['cpf'], $cpf['id']);
                            if ($pessoa) {
                                $this->_helper->addMensagem($cpf['campo'], "CPF j cadastrado");
                            }
                        }
                    } else {
                        $this->_helper->addMensagem($cpf['campo'], "CPF invalido");
                    }
                }
            }
            if (!isset($_POST['nr_cpf']) || $_POST["nr_cpf"] == '') {
                $msg = "O campo CPF  obrigatrio.";
                $this->_helper->addMensagem('nr_cpf', $msg);
            }
        }

        if ($_POST["nrCpfConjuge"]) {
            if ($_POST["nr_cpf"] == $_POST["nrCpfConjuge"]) {
                $this->_helper->addMensagem('nrCpfConjuge', "CPF no pode ser igual ao da Pessoa Fsica");
            }
        }

        $campos = array("nm_pessoa", "nr_rg", "est_civil", "tpDocumento");

        if (($_POST["est_civil"] == 'CAS' || $_POST["est_civil"] == 'UNE') && ($_POST["nrCpfConjuge"] ||
                $_POST["nrRgConjuge"] || $_POST["dtNascimentoConjuge"] || $_POST["nmProfissaoConjuge"] ||
                $_POST["nmNacionalidadeConjuge"] || $_POST["nrTelefoneConjuge"] || $_POST["nrCepConjuge"] ||
                $_POST["enderecoConjuge"] || $_POST["nmBairroConjuge"])) {
            array_push($campos, 'nmConjuge');
            if (!isset($_POST['tpNacionalidadeConjuge']) || $_POST['tpNacionalidadeConjuge'] != 'E')
                array_push($campos, 'nrCpfConjuge');
            array_push($campos, 'sexoConjuge');
        }

        if (!$_POST["nm_nacionalidade"] && $_POST['tpNacionalidade'] == 'E') {
            $this->_helper->addMensagem('nm_nacionalidade', "O campo Nacionalidade  obrigatrio.");
        }

        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "nm_pessoa" :
                        $msg = "O campo Nome  obrigatrio.";
                        break;
                    case "nr_rg" :
                        $msg = "O campo Documento  obrigatrio.";
                        break;
                    case "est_civil" :
                        $msg = "Selecionar o Estado Civil  obrigatrio.";
                        break;
                    case "sexo":
                        $msg = "Sexo  obrigatrio.";
                        break;
                    case "nmConjuge" :
                        $msg = "O campo Nome Cnjuge  obrigatrio.";
                        break;
                    case "nrCpfConjuge" :
                        $msg = "O campo CPF Cnjuge  obrigatrio.";
                        break;
                    case "sexoConjuge" :
                        $msg = "O campo Sexo Cnjuge  obrigatrio.";
                        break;
                    case "tpDocumento" :
                        $msg = "Selecionar tipo de Documento.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function findPessoaFisicaByCpfAction()
    {
        $cpfExistente = ($this->pessoa->findPessoaFisicaByCpf($_POST['cpf'], ($_POST['id']) ? $_POST['id'] : null))?true:false;
        echo json_encode($cpfExistente);
    }
}