<?php

class ParceriaController extends Controller
{
    private $parceria;
    private $emps;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->parceria = new ParceriaComissao();
        $this->emps = new Empreendimento();
        $this->set("subtitulo", "Parceria");
    }

    public function indexAction()
    {
        $this->set("action", array('m' => 'lo', "c" => "parceria", "a" => "pesquisar"));

        // Conta a quantidade de linhas
        $count = $this->emps->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO), array('count(e.id) AS count'));
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario'] && $_SESSION['usuario']->getPerfilId() == 6) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $count->where("e.id IN({$id})");
                } else {
                    $count->where("e.id = 0");
                }
            } catch (Exception $e) {

            }
        }
        $count = $count->query()->fetch();

        // Total de linhas
        $totalItems = $count['count'];

        // Seta as opes do paginador
        $pager_options = array(
            'mode' => 'Sliding',   // Sliding or Jumping mode. See below.
            'perPage' => 10,   // Total rows to show per page
            'delta' => 4,   // See below
            'totalItems' => $totalItems,
        );

        // Instancia o paginador
        $pager = Pager::factory($pager_options);
        // Seta o offset para colocar na query
        list($from, $to) = $pager->getOffsetByPageId();
        // Ajuste para MySQL que comea o offset com 0
        $from = $from - 1;
        // A quanditade de linhas por query
        $perPage = $pager_options['perPage'];

        $empreendimentos = $this->emps->select()->from(TB_EMPREENDIMENTO, '*');
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario'] && $_SESSION['usuario']->getPerfilId() == 6) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("id IN({$id})");
                } else {
                    $empreendimentos->where("id = 0");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento ASC')->limit($perPage, $from)->query()->fetchAll();

        if (count($empreendimentos) == 0)
            $empreendimentos = array();
        $this->set('paginacao', $pager->links);
        $this->set('parcerias', $empreendimentos);

        if ($_GET["msg"] == "OK") {
            $this->_helper->addMensagem("ok", "Operao realizada com sucesso!");
        } elseif ($_GET["msg"]) {
            $this->_helper->addMensagem("fail", "Erro! No foi possvel continuar a operao!");
        }
        $this->set("botoes", array("Adicionar" => array("m" => "lo", "c" => "parceria", "a" => "adicionar")));
        $this->display("listar");
    }

    public function editarAction()
    {
        $this->set('nmbotao', 'Adicionar');
        $this->set('form', 'layout/forms/form-parceria.php');
        $this->set('back', $this->_helper->getLink(array('m' => 'lo', 'c' => 'parceria', 'a' => 'index')));

        if ($this->_isPost) {
            if ($this->validar()) {
                try {
                    $parceria = new ParceriaComissao();
                    $parceria = $parceria->createRow();
                    $parceria->id_pessoa = $_POST['cdParceiro'];
                    $parceria->id_empreendimento = $_GET['idE'];
                    $parceria->pc_comissao = Helper::getInputMoney($_POST['pcComissao']);
                    $parceria->tp_comissao = $_POST['tpComissao'];
                    $parceria->fl_parcela_normal = in_array('N', $_POST['tpParcelas']) ? '1' : '0';
                    $parceria->fl_parcela_sinal = in_array('S', $_POST['tpParcelas']) ? '1' : '0';
                    $parceria->fl_parcela_intercalada = in_array('I', $_POST['tpParcelas']) ? '1' : '0';
                    $parceria->fl_parcela_chave = in_array('C', $_POST['tpParcelas']) ? '1' : '0';
                    $parceria->fl_parcela_negociada = in_array('G', $_POST['tpParcelas']) ? '1' : '0';
                    $parceria->fl_parcela_quitacao = in_array('Q', $_POST['tpParcelas']) ? '1' : '0';
                    $parceria->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                    $parceria->save();
                } catch (Exception $e) {
                    $this->redir(array("modulo" => "lo", "controller" => "parceria"), array("msg" => $e->getMessage()));
                }
            }
        }

        if ($_GET['idE']) {
            $auxParcerias = $this->parceria->fetchAll("id_empreendimento = {$_GET['idE']}");

            //Seta o empreendimento se existe
            $instanceEmpreendimento = new Empreendimento();
            $empreendimento = $instanceEmpreendimento->fetchRow("id = {$_GET['idE']}");

            $parcerias = array();
            foreach ($auxParcerias as $k => $parceria) {
                $parcerias[$k] = $parceria->toArray();
                $parcerias[$k]['nm_pessoa'] = Pessoa::findNomeById($parceria['id_pessoa']);
            }

            $this->set('empreendimento', $empreendimento);
            $this->set('parcerias', $parcerias);
        } else {
            $this->redir(array("modulo" => "lo", "controller" => "parceria"), array("msg" => "Erro! No foi possvel continuar a operao!"));
        }

        $this->display("form");
    }

    public function deletarAction()
    {
        try {
            $parceria = $this->parceria->fetchRow("id_parceria_comissao = {$_POST['parceiro']}");
            $parceria->delete();
            echo json_encode(true);
        } catch (Exception $e) {
            echo json_encode(false);
        }
    }

    private function validar()
    {
        $campos = array('cdParceiro', 'pcComissao', 'tpComissao', 'tpParcelas', 'idE');
        if ($campos) {
            foreach ($campos AS $campo) {
                switch ($campo) {
                    case 'cdParceiro':
                        if ($_POST[$campo] == '') {
                            $msg = 'O Parceiro  obrigatrio.';
                        } else {
                            $parceriaPessoa = ParceriaComissao::getDefaultAdapter()->select()->from(TB_PARCERIA_COMISSAO)
                                ->where('id_pessoa = ' . $_POST['cdParceiro'])
                                ->where('id_empreendimento = ' . $_GET['idE'])
                                ->query()->fetchAll();
                            if (count($parceriaPessoa) > 0) {
                                $msg = 'O Parceiro j possui um vnculo com o empreendimento.';
                            }
                        }
                        break;
                    case 'pcComissao':
                        if ($_POST[$campo] == '') {
                            $msg = 'O valor da comisso  obrigatrio.';
                        }
                        break;
                    case 'tpComissao':
                        if ($_POST[$campo] == '') {
                            $msg = 'O tipo da comisso  obrigatrio.';
                        }
                        break;
                    case 'tpParcelas':
                        if (!isset($_POST[$campo]) || count($_POST[$campo]) == 0) {
                            $msg = 'Ao menos um tipo de parcela deve ser selecionado.';
                        }
                        break;
                    case 'idE':
                        if ($_GET[$campo] == '') {
                            $msg = 'O empreendimento  obrigatrio.';
                        }
                        break;
                }
                if ($msg && $campo) {
                    $this->_helper->addMensagem($campo, $msg);
                    unset($msg);
                }
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function pesquisarAction()
    {
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $where = "e.id IN({$id})";
                } else {
                    $where = '1';
                }
            } catch (Exception $e) {
            }
        }
        $count = Empreendimento::fullSearch($_GET["termo"], true, false, false, $where);

        // Total de linhas
        $totalItems = $count[0]['count'];
        // Seta as opes do paginador
        $pager_options = array(
            'mode' => 'Sliding',   // Sliding or Jumping mode. See below.
            'perPage' => 10,   // Total rows to show per page
            'delta' => 4,   // See below
            'totalItems' => $totalItems,
        );
        // Instancia o paginador
        $pager = Pager::factory($pager_options);
        // Seta o offset para colocar na query
        list($from, $to) = $pager->getOffsetByPageId();
        // Ajuste para MySQL que comea o offset com 0
        $from = $from - 1;
        // A quanditade de linhas por query
        $perPage = $pager_options['perPage'];
        //Termo a ser utilizado na pesquisa (por nome de corretor ou por nome do empreendimento
        $termo = "%" . strtoupper($_GET["termo"]) . "%";

        //acesso ao banco que faz a pesquisa (antes a pesquisa estava na classe empreendimento)
        $parcerias = Empreendimento::fullSearch($termo, false, $from, $perPage, $where);

        $this->set("action", array('m' => 'lo', "c" => "parceria", "a" => "pesquisar"));
        $this->set("subtitulo", "Parceria");
        $this->set("parceria", $parcerias);
        $this->set('paginacao', $pager->links);
        $this->set("botoes", array("voltar" => array('m' => 'lo', "c" => "parceria")));
        $this->display();
    }
}