<?php

class ModeloWordController extends Controller {

    public function __construct($request) 
    {
        parent::__construct($request);
    }

    public function indexAction() 
    {
        $this->redir(array("modulo" => "lo", "controller" => "modeloWord", "action" => "listar"));
    }

    public function listarAction() 
    {
        if ($this->isAjax()) {
            $modeloWord = new ModeloArquivo();
            $listaItens = $modeloWord->getAdapter()->select()
                ->from(array('m' => TB_MODELO_ARQUIVO))
                ->order('m.cd_modelo')
                ->query()->fetchAll();

            $lista = array();
            foreach ($listaItens as $item) {
                $acoes = '<div style="width: 90px;"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="index.php?m='
                . $this->modulo
                . '&c='
                . $this->controller
                . '&a=editar&id='
                . $item['cd_modelo']
                . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                if ($item['fl_status'] == '1')
                {
                    $title = "return confirm('Tem certeza que deseja inativar esse Modelo " . utf8_encode($item['nm_titulo']) . " ?')";
                    $acoes .= '<a onclick="'
                    . $title
                    . '"  href="index.php?m='
                    . $this->modulo
                    . '&c='
                    . $this->controller
                    . '&a=inativar&id='
                    . $item['cd_modelo']
                    . '" data-toggle="tooltip" title="INATIVAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                } else {
                    $acoes .= '<a disabled data-toggle="tooltip" title="INATIVAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                }
                //Boto Baixar
                if ($item['fl_status'] == '1')
                {
                    $acoes .= '<a onClick="baixarArquivo('.$item['cd_modelo'].')" href="' . $item['ds_path_modelo'] . '" target="_blank" download data-toggle="tooltip" title="BAIXAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-download"></i></a>';
                } else {
                    $acoes .= '<a disabled target="_blank" download data-toggle="tooltip" title="BAIXAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-download"></i></a>';
                }
                $acoes .= '</div>';
                $acoes .= '</div>';

                switch ($item['tp_modelo']) {
                    case 'CC':
                        $tpCarta = 'Carta Cobrana';
                        break;
                    case 'CD':
                        $tpCarta = 'Carta Distrato';
                        break;
                    case 'DE':
                        $tpCarta = 'Declaraes';
                        break;
                    /* case 'EM':
                        $tpCarta = 'Email'; */
                        break;
                    case 'AU':
                        $tpCarta = 'Autorizao';
                        break;
                    /* case 'SS':
                        $tpCarta = 'SMS'; */
                    case 'QR':
                        $tpCarta = 'Quadro Resumo Lei 13.786';
                        break;
                    case 'PR':
                        $tpCarta = 'Proposta de Compra';
                        break;
                    case 'PC':
                        $tpCarta = 'Portal do Cliente';
                        break;
                    case 'Q':
                        $tpCarta = 'Termo de Quitao';
                        break;
                    case 'T':
                        $tpCarta = 'Transferncia de Titularidade';
                        break;
                    default:
                        $tpCarta = '';
                        break;
                }

                switch ($item['fl_status']) {
                    case '0': 
                        $status = '<div class="label label-danger">Inativo</div>';
                        break;
                    case '1': 
                        $status = '<div class="label label-success">Ativo</div>';
                        break;
                }

                $lista[] = array(
                    'codigo' => $item['cd_modelo'],
                    'titulo' => utf8_encode($item['nm_titulo']),
                    'tpModelo' => utf8_encode($tpCarta),
                    'status' => $status,
                    'acoes' => $acoes
                );
            }

            echo json_encode(array(
                'draw' => 1,
                'recordsTotal' => count($lista),
                'recordsFiltered' => count($lista),
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction() 
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarModeloWord')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'modeloWord', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $tpModelos = array(
            'AU' => 'Autorizao',
            'CD' => 'Carta Distrato',
            'CC' => 'Cartas Cobrana',
            'DE' => 'Declaraes',
            //'EM' => 'E-mail',
            'QR' => 'Quadro Resumo Lei 13.786',
            'PR' => 'Proposta de Compra',
            'PC'=>'Portal do Cliente',
            'Q' => 'Termo de Quitao',
            'T' => 'Transferncia de Titularidade',
            //'SS' => 'SMS'
        );

        $this->set('modelos', $tpModelos);

        if ($this->_isPost && $this->validar()) {

            $modelo = new ModeloArquivo();
            $transacao = $modelo->getAdapter()->beginTransaction();

            try {
                $modelo = $modelo->createRow();
                $modelo->nm_titulo = ($_POST['nmTitulo']) ? $_POST['nmTitulo'] : null;
                $modelo->tp_modelo = ($_POST['tipoModelo']) ? $_POST['tipoModelo'] : null;
                $modelo->fl_status = ($_POST['status']) ? $_POST['status'] : null;
                $modelo->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                $modelo->save();
                
                if ($_FILES['arquivoWord']['name'])
                {
                    $modelo = $this->salvaArquivo($_FILES['arquivoWord'], $modelo);
                    $modelo->save();
                }
                
            } catch (Exception $e) {
                $transacao->rollBack();
                $_GET['exception'] = $e->getMessage();
            }

            $transacao->commit();
            $this->redir(array('modulo' => 'lo', 'controller' => 'modeloWord', 'action' => 'listar'), array('msg' => 'success'));
        }

        $this->display('form');
    }

    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'editarModeloWord')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'modeloWord', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $modelos = new ModeloArquivo();

        $modelo = $modelos->find($_GET['id'])->current();
        
        $tipoModelos = array(
            'AU' => 'Autorizao',
            'CD' => 'Carta Distrato',
            'CC' => 'Cartas Cobrana',
            'DE' => 'Declaraes',
            //'EM' => 'Email',
            'QR' => 'Quadro Resumo Lei 13.786',
            'PR' => 'Proposta de Compra',
            'PC'=>'Portal do Cliente',
            'Q' => 'Termo de Quitao',
            'T' => 'Transferncia de Titularidade',
            //'SS' => 'SMS'
        );

        $this->set('modelos', $tipoModelos);

        if ($this->_isPost && $this->validar($modelo['ds_path_modelo']))
        {
            $transacao = $modelos->getAdapter()->beginTransaction();

            try {
                $modelo->nm_titulo = ($_POST['nmTitulo']) ? $_POST['nmTitulo'] : null;
                $modelo->tp_modelo = ($_POST['tipoModelo']) ? $_POST['tipoModelo'] : null;
                $modelo->fl_status = $_POST['status'];
                $modelo->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                $modelo->save();

                if ($_FILES['arquivoWord']['name'])
                {   
                    $modelo = $this->salvaArquivo($_FILES['arquivoWord'], $modelo);
                    $modelo->save();
                }
                
            } catch (Exception $e) {
                $transacao->rollBack();
                $_GET['exception'] = $e->getMessage();
            }

            $transacao->commit();
            $this->redir(array('modulo' => 'lo', 'controller' => 'modeloWord', 'action' => 'listar'), array('msg' => 'success'));
        }

        $this->set('dadosModelo', $modelo);
        $this->display('form');
    }

    public function inativarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'apagarModeloWord')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'modeloWord', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        try {
            $modeloArquivo = (new ModeloArquivo())->fetchRow('cd_modelo = ' . $_GET['id']);
            $modeloArquivo->fl_status = '0';
            $modeloArquivo->ds_log = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u';

            $modeloArquivo->save();

            $this->redir(array('modulo' => 'lo', 'controller' => 'modeloWord', 'action' => 'listar'), array('msg' => 'success'));
        } catch (Exception $e) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'modelo', 'action' => 'listar'), array('exception' => 'No foi possvel inativar o modelo selecionado.'));
        }
    }

    public function validar($arquivo = null)
    {
        $campos = array(
            'tipoModelo' => 'O tipo do modelo  obrigatrio',
            'nmTitulo' => 'O ttulo  obrigatrio',
        );

        foreach ($campos as $campo => $msg)
        {
            if ($_POST[$campo] == '')
            {
                $this->_helper->addMensagem($campo, $msg);
            }
        }
        
        if (!$arquivo || $_FILES['arquivoWord']['name'])
        {
            $tipoArquivo = explode('.', $_FILES['arquivoWord']['name']);
            
            if ($tipoArquivo[1] != 'doc' && $tipoArquivo[1] != 'docx')
            {
                $this->_helper->addMensagem('arquivoWord', 'Apenas arquivos no formato DOC ou DOCX, so aceitos!');
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    private function salvaArquivo($arquivo, $objeto)
    {
        $upper = new Filesystem();

        //altera o nome do arquivo
        $name = $this->_helper->removeAcentos($arquivo['name']);
        $name = explode(".", $name);
        $name = 'arquivoWord_' . $objeto['cd_modelo'] . '.' . $name[1];
        //Armazena o arquivo fsico
        $tmp = $arquivo['tmp_name'];
        $path = explode('.', $_SERVER['HTTP_HOST']);
        if ($path[0] == 'www')
        {
            $path = $path[1];
        } else {
            $path = $path[0];
        }
        
        $pastaCliente = "upload/cliente/";
        
        if (!is_dir($pastaCliente))
        {
            mkdir($pastaCliente, 0777, true);
        }
        
        $pastaPath = $pastaCliente . $path;
        
        if (!is_dir($pastaCliente))
        {
            mkdir($pastaPath, 0777, true);
        }
        
        $fullPath = $pastaPath . '/' . $name;
        
        $rs = $upper->upload($tmp, $fullPath);

        if ($rs)
        {
            $objeto->ds_path_modelo = $fullPath;

            return $objeto;
        }
    }

    public function variaveisAction()
    {
        if ($this->isAjax()) {
            $listaItem = Dicionario::listar();

            $lista = array();
            foreach ($listaItem as $item) {
                if($item['fl_ativo'] != 0){
                    $lista[] = array(
                        'variavel' => '${' . utf8_encode($item['variavel']) . '}',
                        'descricao' => utf8_encode($item['descricao'])
                    );
                }
            }
            echo json_encode(array(
                'data' => $lista
            ));
        } else {
            $this->display('variaveis');
        }
    }
}