<?php

class ModeloController extends Controller
{

    public function __construct($request)
    {
        parent::__construct($request);
    }

    public function indexAction()
    {
        $this->redir(array('modulo' => 'lo', "controller" => "modelo", 'action' => 'listar'));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $loCartaCobranca = new Modelo();
            $listaItem = $loCartaCobranca->getAdapter()->select()
                ->from(array('co' => TB_MODELO))
                ->order('co.cd_modelo')
                ->query()->fetchAll();

            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="index.php?m='
                    . $this->modulo
                    . '&c='
                    . $this->controller
                    . '&a=editar&id='
                    . $item['cd_modelo']
                    . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $title = "return confirm('Tem certeza que deseja excluir a Carta " . utf8_encode($item['nm_titulo']) . " ?')";
                $acoes .= '<a onclick="'
                    . $title
                    . '"  href="index.php?m='
                    . $this->modulo
                    . '&c='
                    . $this->controller
                    . '&a=deletar&id='
                    . $item['cd_modelo']
                    . '" data-toggle="tooltip" title="EXCLUIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                switch ($item['tp_modelo']) {
                    case 'CC':
                        $tpCarta = 'Carta Cobrana';
                        break;
                    case 'CD':
                        $tpCarta = 'Carta Distrato';
                        break;
                    case 'DE':
                        $tpCarta = 'Declaraes';
                        break;
                    case 'EM':
                        $tpCarta = 'Email';
                        break;
                    case 'AU':
                        $tpCarta = 'Autorizao';
                        break;
                    case 'SS':
                        $tpCarta = 'SMS';
                    case 'QR':
                        $tpCarta = 'Quadro Resumo Lei 13.786';
                        break;
                    default:
                        $tpCarta = '';
                        break;
                }

                $lista[] = array(
                    'codigo' => $item['cd_modelo'],
                    'titulo' => utf8_encode($item['nm_titulo']),
                    'tp_carta' => utf8_encode($tpCarta),
                    'acoes' => $acoes
                );
            }

            echo json_encode(array(
                'draw' => 1,
                'recordsTotal' => count($lista),
                'recordsFiltered' => count($lista),
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'AdicionarModelo')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'modelo', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $this->set('back', $this->_helper->getLink(array('m' => 'lo', 'c' => 'modelo', 'a' => 'listar')));

        $tpCartas = array(
            'AU' => 'Autorizao',
            'CD' => 'Carta Distrato',
            'CC' => 'Cartas Cobrana',
            'DE' => 'Declaraes',
            'EM' => 'Email',
            'QR' => 'Quadro Resumo Lei 13.786',
            'SS' => 'SMS'
        );

        $this->set('tpCarta', $tpCartas);

        if ($this->_isPost && $this->validar()) {
            $modelo = new Modelo();
            $transacao = $modelo->getAdapter()->beginTransaction();

            try {
                $modelo = $modelo->createRow();
                $modelo->nm_titulo = ($_POST['nm_titulo_carta']) ? $_POST['nm_titulo_carta'] : null;
                $modelo->ds_texto_cima = ($_POST['ds_texto_cima']) ? $_POST['ds_texto_cima'] : null;
                $modelo->ds_texto_baixo = ($_POST['ds_texto_baixo']) ? $_POST['ds_texto_baixo'] : null;
                $modelo->tp_modelo = ($_POST['tp_carta']) ? $_POST['tp_carta'] : null;
                $modelo->tp_carta_distrato = ($_POST['tp_carta'] == 'CD') ? $_POST['tp_carta_cobranca'] : null;
                $modelo->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                $modelo->save();

                $transacao->commit();
                $this->redir(array("modulo" => "lo", "controller" => "modelo", 'action' => 'listar'), array("msg" => "success"));
            } catch (Exception $e) {
                $transacao->rollBack();
                $this->_helper->addMensagem('erro', $e->getMessage());
            }
        }

        //Enviando os dados de volta para os campos
        $this->set('cartaCobranca', $_POST);

        $this->display('form');
    }


    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'EditarModelo')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'modelo', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $modelos = new Modelo();

        $modelo = $modelos->find($_GET['id'])->current();

        $tpCartas = array(
            'AU' => 'Autorizao',
            'CD' => 'Carta Distrato',
            'CC' => 'Cartas Cobrana',
            'DE' => 'Declaraes',
            'EM' => 'Email',
            'QR' => 'Quadro Resumo Lei 13.786',
            'SS' => 'SMS'
        );

        $this->set('tpCarta', $tpCartas);

        $cartasPadrao = array();
        if ($modelo['tp_modelo'] == 'CD')
            $cartasPadrao = array(
                'TD' => 'Termo de Distrato',
                'CR' => 'Carta de Resciso'
            );

        $this->set('cartas', $cartasPadrao);

        $this->set('back', $this->_helper->getLink(array('m' => 'lo', 'c' => 'modelo', 'a' => 'listar')));

        if ($this->_isPost && $this->validar()) {
            $transacao = $modelos->getAdapter()->beginTransaction();

            try {
                $modelo->nm_titulo = ($_POST['nm_titulo_carta']) ? $_POST['nm_titulo_carta'] : null;
                $modelo->ds_texto_cima = ($_POST['ds_texto_cima']) ? $_POST['ds_texto_cima'] : null;
                //Comentado verificao do campo ds_texto_baixo, porque j  feita a visibilidade do campo para proteger edio.
//                $modelo->ds_texto_baixo = ($_POST['ds_texto_baixo'] && ($_POST['tp_modelo']=='CD' || $_POST['tp_modelo']=='CC')) ? $_POST['ds_texto_baixo'] : null;
                $modelo->ds_texto_baixo = ($_POST['ds_texto_baixo']) ? $_POST['ds_texto_baixo'] : null;
                $modelo->tp_modelo = ($_POST['tp_carta']) ? $_POST['tp_carta'] : null;
                $modelo->tp_carta_distrato = ($_POST['tp_carta'] == 'CD') ? $_POST['tp_carta_cobranca'] : null;
                $modelo->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                $modelo->save();

                $transacao->commit();
                $this->redir(array('modulo' => 'lo', "controller" => "modelo", 'action' => 'listar'), array("msg" => "success"));
            } catch (Exception $e) {
                $transacao->rollBack();
                $_GET['exception'] = $e->getMessage();
            }
        }

        //Enviando os dados de volta para os campos
        $this->set('cartaCobranca', $modelo);

        $this->display('form');
    }

    public function deletarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'ExcluirModelo')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'modelo', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        try {
            $loCartaCobranca = new Modelo();
            $loCartaCobranca->delete($loCartaCobranca->getAdapter()->quoteInto('cd_modelo = ?', $_GET['id']));
            $this->redir(array('modulo' => 'lo', "controller" => "modelo", 'action' => 'listar'), array("msg" => "success"));
        } catch (Exception $e) {
            if ($e->getCode() == 23000)
                $this->redir(array('modulo' => 'lo', "controller" => "modelo", 'action' => 'listar'), array('exception' => 'A carta no pode ser excluda pois possui registros de envio.'));
            else
                $this->redir(array('modulo' => 'lo', "controller" => "modelo", 'action' => 'listar'), array('exception' => 'No foi possvel realizar a operao. Erro: ' . $e->getCode()));
        }
    }

    public function validar()
    {
        //nome do campo e mensagem caso esteja vazio
        $campos = array(
            'tp_carta' => 'O campo tipo de carta  obrigatrio.',
            'nm_titulo_carta' => 'O campo ttulo de carta  obrigatrio.'
        );

        //Valida modelo apenas se for distrato
        if ($_POST['tp_carta'] == 'CD') {
            $campos['tp_carta_cobranca'] = 'O campo modelo de carta  obrigatrio.';
        }

        //Verificando se os campos esto vazios
        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == '') {
                $this->_helper->addMensagem($campo, $msg);
            }
        }

        //Exibe caso tenha algum canto vazio
        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function buscaModeloCartaAction()
    {
        if ($this->isAjax()) {
            $cartasPadrao = array(
                'TD' => utf8_encode('Termo de Distrato'),
                'CR' => utf8_encode('Carta de Resciso')
            );

            echo json_encode($cartasPadrao);
        }
    }

}