<?php

class LoteController extends Controller
{

    private $lotes;
    private $empreendimentos;
    private $tabela_preco_lote;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->lotes = new Lote();
        $this->empreendimentos = new Empreendimento();
        $this->tabela_preco_lote = new TabelaPrecoLote();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "lo", "controller" => "lote", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $totalItens = Lote::findLista($_POST, true);
            $listaItem = Lote::findLista($_POST);

            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $title = "return confirm('Tem certeza que deseja excluir o lote " . $item['quadra'] . ' - ' . $item['lote'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $item['id'] . '" data-toggle="tooltip" title="EXCLUIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                $scriptConstrucao = 'clickConstruir(' . $item['id'] . ')';
                $construcao = ($item['fl_construcao'] == '1') ? '<a onclick="' . $scriptConstrucao . '"  data-toggle="tooltip" title="DESMARCAR CONSTRUO" class="btn construcao label label-success">Sim</a>' : '<a onclick="' . $scriptConstrucao . '" data-toggle="tooltip" title="MARCAR CONSTRUO" class="btn construcao label label-danger">No</a>';

                $scriptCaucionado = 'clickCaucionar(' . $item['id'] . ')';
                $fl_caucionado = ($item['fl_caucionado'] == '1') ? '<a onclick="' . $scriptCaucionado . '"  data-toggle="tooltip" title="DESMARCAR CAUCIONADO" class="btn fl_caucionado label label-success">Sim</a>' : '<a onclick="' . $scriptCaucionado . '" data-toggle="tooltip" title="MARCAR CAUCIONADO" class="btn fl_caucionado label label-danger">No</a>';
                
                $lista[] = array(
                    'excluirCheckbox' => "<input type='checkbox' id='{$item['id']}' name='chk[]'>",
                    'id' => utf8_encode($item['id']),
                    'empreendimento' => utf8_encode($item['nm_empreendimento']),
                    'quadra' => utf8_encode($item['quadra']),
                    'lote' => utf8_encode($item['lote']),
                    'construcao' => '<div id="construir_' . $item['id'] . '" align="center" style="padding-top: 5px">' . utf8_encode($construcao) . '</div>',
                    'fl_caucionado' => '<div id="caucionar_' . $item['id'] . '" align="center" style="padding-top: 5px">' . utf8_encode($fl_caucionado) . '</div>',
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => '1',
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarLote')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'lote', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $empreendimentos = $this->empreendimentos->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento ASC')->query()->fetchAll();
        $tb_agrupada = new TabelaAgrupada();
        $tb_agrupada = $tb_agrupada->findListaAgrupada(null, false, '23'); //23 refere-se aos tipos de im�vel
        
        $this->set('empreendimentos', $empreendimentos);
        $this->set('tb_agrupada', $tb_agrupada);

        if ($this->_isPost) {
            try {
                $lotes = new Lote();
                $lote = $lotes->createRow();
                $lote->id_empreendimento = $_POST['id_empreendimento'];
                $lote->quadra = $_POST['quadra'];
                $lote->lote = $_POST['lote'];
                $lote->frente = Helper::getInputMoney2($_POST['frente']);
                $lote->fundo = Helper::getInputMoney2($_POST['fundo']);
                $lote->direita = Helper::getInputMoney2($_POST['direita']);
                $lote->esquerda = Helper::getInputMoney2($_POST['esquerda']);
                $lote->conf_frente = $_POST['conf_frente'];
                $lote->conf_fundo = $_POST['conf_fundo'];
                $lote->conf_direita = $_POST['conf_direita'];
                $lote->conf_esquerda = $_POST['conf_esquerda'];
                $lote->area = Helper::getInputMoney($_POST['area']);
                $lote->valor = $this->_helper->getInputMoney($_POST['valor']);
                $lote->rgi = $_POST['rgi'];
                $lote->fl_construcao = ($_POST["construcao"]) ? "1" : "0";
                $lote->fl_caucionado = ($_POST["fl_caucionado"]) ? "1" : "0";
                $lote->ds_geral = $_POST['ds_geral'];
                $lote->obs_lote = $_POST['obsLote'];
                $lote->tipo_imovel = $_POST['tipo_imovel'];
                $lote->latitude = $_POST['latitude'];
                $lote->longitude = $_POST['longitude'];
                $lote->status = 'D';

                if ($this->validar()) {
                    $lote->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                    $lote->save();
                    $this->redir(array("modulo" => "lo", "controller" => "lote", "action" => "listar"), array("msg" => "success"));
                } else {
                    $this->set("lote", $lote);
                }
            } catch (Exception $e) {
                $this->redir(array("modulo" => "lo", "controller" => "lote", "action" => "listar"), array("exception" => "No foi possvel realizar a operao. Erro: {$e->getMessage()}"));
            }
        }

        $this->display('form');
    }

    public function adicionarXmlAction()
    {
        $empreendimentos = $this->empreendimentos->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento ASC')->query()->fetchAll();
        $this->set("empOptions", $empreendimentos);
        // valida se o formulario foi enviado com os campos preenchidos corretamente
        if ($this->_isPost && $this->validar("addXls")) {
            try {
                // upload do arquivo
                $up = new Filesystem();
                $tmp = $_FILES['arquivo']['tmp_name'];
                $to = "upload/arquivos/file.xls";
                $up->upload($tmp, $to);
                // valida se o arquivo .xls est� nos padr�es
                if ($this->validarPadraoXls()) {
                    $data = new Spreadsheet_Excel_Reader();
                    $data->read("upload/arquivos/file.xls");
                    // l� linha por linha do arquivo enquanto as tr�s primeiras colunas forem diferentes de nulo
                    for ($i = 1; $data->val($i, 1) || $data->val($i, 2) || $data->val($i, 2); $i++) {
                        $lote = $this->lotes->createRow();
                        $lote->__set("id_empreendimento", $_POST["empreendimento"]);
                            $lote->__set("quadra", $data->val($i, 1));
                            $lote->__set("lote", $data->val($i, 2));

                        if ($_POST['medicao'] == 'mi') {
                            $lote->__set("frente", $data->val($i, 3));  
                            $lote->__set("fundo", $data->val($i, 4));
                            $lote->__set("esquerda", $data->val($i, 5));    
                            $lote->__set("direita", $data->val($i, 6));
                            $lote->__set("conf_frente", $data->val($i, 7));
                            $lote->__set("conf_fundo", $data->val($i, 8));
                            $lote->__set("conf_esquerda", $data->val($i, 9));
                            $lote->__set("conf_direita", $data->val($i, 10));
                            $lote->__set("area", $data->val($i, 11));
                            
                            //Verifica��o para se tiver 12 linhas no caso o RGI, exibir ele pr�prio
                            if ($data->val($i, 12)) {
                                $lote->__set("rgi", $data->val($i, 12));
                            }
                            //Verifica se existe a coluna de valor
                            if ($data->val($i, 13)) {
                                $lote->__set("valor", $data->val($i, 13));
                            }
                            //Verifica se existe a coluna de tipo im�vel
                            if ($data->val($i, 14)) {
                                $lote->__set("tipo_imovel", $data->val($i, 14));
                            }
                        } else {
                            $lote->__set("ds_geral", $data->val($i, 3));
                            $lote->__set("area", $data->val($i, 4));
                            
                            //Verifica��o para se tiver 12 linhas no caso o RGI, exibir ele pr�prio
                            if ($data->val($i, 5)) {
                                $lote->__set("rgi", $data->val($i, 5));
                            }
                            //Verifica se existe a coluna de valor
                            if ($data->val($i, 6)) {
                                $lote->__set("valor", $data->val($i, 6));
                            }
                            //Verifica se existe a coluna de tipo im�vel
                            if ($data->val($i, 7)) {
                                $lote->__set("tipo_imovel", $data->val($i, 7));
                            }
                        }

                        $lote->__set("log", (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i'));
                        $lote->save();
                    }
                    $this->redir(array("modulo" => "lo", "controller" => "lote", "action" => "listar"), array("msg" => "success"));
                }
            } catch (Exception $e) {
                $this->redir(array("modulo" => "lo", "controller" => "lote", "action" => "listar"), array("exception" => "No foi possvel realizar a operao."));
            }
        }
        $this->display();
    }

    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'editarLote')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'lote', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $empreendimentos = $this->empreendimentos->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }
        $empreendimentos = $empreendimentos->query()->fetchAll(null, 'nm_empreendimento ASC');
        $tb_agrupada = new TabelaAgrupada();
        $tb_agrupada = $tb_agrupada->findListaAgrupada(null, false, '23'); 
        $this->set('empreendimentos', $empreendimentos);
        $this->set('tb_agrupada', $tb_agrupada);

        $lotes = $this->lotes;
        $lote = $lotes->fetchRow($lotes->select()->where('id = ?', $_GET['id']));
        $oldArea = $lote->area;

        $tabela_preco_lote_exists = $this->tabela_preco_lote->fetchRow($this->tabela_preco_lote->select()->where('id_lote = ?', $_GET['id']));

        if ($this->_isPost) {
            try {
                if ($this->validar()) {
                    $lote->id_empreendimento = $_POST['id_empreendimento'];
                    $lote->quadra = $_POST['quadra'];
                    $lote->lote = $_POST['lote'];
                    $lote->frente = Helper::getInputMoney2($_POST['frente']);
                    $lote->fundo = Helper::getInputMoney2($_POST['fundo']);
                    $lote->direita = Helper::getInputMoney2($_POST['direita']);
                    $lote->esquerda = Helper::getInputMoney2($_POST['esquerda']);
                    $lote->conf_frente = $_POST['conf_frente'];
                    $lote->conf_fundo = $_POST['conf_fundo'];
                    $lote->conf_direita = $_POST['conf_direita'];
                    $lote->conf_esquerda = $_POST['conf_esquerda'];
                    $lote->ds_geral = $_POST['ds_geral'];
                    $lote->obs_lote = $_POST['obsLote'];
                    $lote->area = Helper::getInputMoney($_POST['area']);
                    $lote->valor = $this->_helper->getInputMoney($_POST['valor']);
                    $lote->rgi = $_POST['rgi'];
                    $lote->fl_construcao = ($_POST["construcao"]) ? "1" : "0";
                    $lote->fl_caucionado = ($_POST["fl_caucionado"]) ? "1" : "0";
                    $lote->tipo_imovel = $_POST['tipo_imovel'];
                    $lote->latitude = $_POST['latitude'];
                    $lote->longitude = $_POST['longitude'];
                    $lote->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');

                    $lote->save();
                    
                    if (Helper::getInputMoney($_POST['area']) != trim($oldArea)) {
                        if ($tabela_preco_lote_exists) {
                            $this->redir(array("modulo" => "lo", "controller" => "lote", "action" => "listar"), array("alert" => "attention", "msg" => "success"));
                        }
                        exit;
                    }

                    $this->redir(array("modulo" => "lo", "controller" => "lote", "action" => "listar"), array("msg" => "success"));
                }
            } catch (Exception $e) {
                $this->redir(array("modulo" => "lo", "controller" => "lote", "action" => "listar"), array("exception" => "No foi possvel realizar a operao.  Erro: {$e->getMessage()}"));
            }
        }
        $this->set("lote", $lote->toArray());

        $this->display('form');
    }
    
    public function deletarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'deletarLote')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'lote', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        $lotes = $this->lotes;
        $tbPrecoLote = new TabelaPrecoLote();
        $id = $_GET['id'];
        try {
            // Buscar o Id de Lote e comparar com o Id de Contrato
            $IdLote = $this->lotes->getAdapter()->select()
                ->from(array('l' => TB_LOTES), array('id'))
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', null)
                ->join(array('ch' => TB_CONTRATO_HISTORICO), 'l.id = ch.id_lote', null)
                ->where('c.id_lote = ' . $id)->query()->fetch();

            if ($IdLote) {
                $this->redir(array("modulo" => "lo", "controller" => "lote", "action" => "listar"), array("exception" => "O Lote no pode ser excludo pois possui registro em contrato e/ou histrico"));
            } else {
                $lotePreco = $tbPrecoLote->fetchRow('id_lote = ' . $id);
                if ($lotePreco) {
                    $tbPrecoLote->delete('id_lote = ' . $id);
                }

                $lotes->delete($lotes->getAdapter()->quoteInto('id = ?', $id));
                if ($this->isAjax()) {
                    echo true;
                } else {
                    $this->redir(array("modulo" => "lo", "controller" => "lote", "action" => "listar"), array("msg" => "success"));
                }
            }
        } catch (Exception $e) {
            $this->redir(array("modulo" => "lo", "controller" => "lote", "action" => "listar"), array("exception" => "No foi possvel realizar a operao."));
        }
    }

    private function validar($form = "add")
    {
        if ($form == "add") {
            //$campos = array("id_empreendimento", "quadra", "lote", "frente", "fundo", "direita", "esquerda",
                //"area", "conf_frente", "conf_fundo", "conf_direita", "conf_esquerda");
            $campos = array("id_empreendimento", "quadra", "lote", "area", "tipo_imovel");
            foreach ($campos as $cp) {
                if ($_POST [$cp] == "") {
                    switch ($cp) {
                        case "id_empreendimento" :
                            $msg = "O Empreendimento  obrigatrio.";
                            break;
                        case "quadra" :
                            $msg = "O campo Quadra  obrigatrio.";
                            break;
                        case "lote" :
                            $msg = "O campo Lote  obrigatrio.";
                            break;
                        case "area" :
                            $msg = "O campo rea  obrigatrio.";
                            break;
                        case "tipo_imovel" :
                            $msg = "O campo tipo imvel  obrigatrio.";
                            break;
                    }
                    $this->_helper->addMensagem($cp, $msg);
                }
            }

            if (count($this->_helper->getMensagens()) == 0) {
                //testa se esta cadastrando um mesmo lote numa mesma quadra de um mesmo empreendimento
                $id = $_GET["id"];
                $emp = $_POST["id_empreendimento"];
                $quadra = $_POST["quadra"];
                $lt = $_POST["lote"];

                $lote = new Lote();
                if ($lote->exist($emp, $quadra, $lt) && (!$id)) {
                    $this->_helper->addMensagem("erro", "Este lote j foi cadastrado para esse empreendimento!");
                }
            }

            // VALIDA O FORMULARIO PRA ENVIAR ARQUIVO XLS
        } elseif ($form == "addXls") {
            if (!$_POST["empreendimento"]) {
                $this->_helper->addMensagem("empreendimento", "Selecione um empreendimento!");
            }
            // testa se ta nulo o campo de arquivo
            if (!$_FILES["arquivo"]["name"]) {
                $this->_helper->addMensagem("arquivo", "Arquivo no Preenchido");
            }
            // verifica se o arquivo e no formato .xls
            $extensao = substr($_FILES["arquivo"]["name"], strlen($_FILES["arquivo"]["name"]) - 3);
            if ($extensao != "xls") {
                $this->_helper->addMensagem("arquivo", "No  possvel abrir arquivo com a extenso ." . $extensao . "!");
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function validarPadraoXls()
    {
        require_once 'library/ExcelReader.php';
        $data = new Spreadsheet_Excel_Reader();
        // verifica se e possivel abrir o arquivo, se ele nao esta protegido por senha
        if ($data->read("upload/arquivos/file.xls")) {
            // verifica se o namero de colunas bate com o padrao xls
            for ($linhas = 0; $data->val(1, $linhas + 1); $linhas++) ;
        } else {
            $this->_helper->addMensagem("fail", "No foi possvel ler o arquivo enviado!");
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function construirAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'construirLote')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'lote', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        $id = $_POST['id'];
        $tb_lote = $this->lotes->fetchRow("id = " . $id);

        if (!$_POST['construcao']) {
            if ($tb_lote['fl_construcao'] == 0)
                $tb_lote->fl_construcao = '1';
            else
                $tb_lote->fl_construcao = '0';
        } else {
            $tb_lote->fl_construcao = $_POST['construcao'];
        }

        $tb_lote->save();
        (new Relacionamento())->saveContato(49, date('Y-m-d'), Contrato::getIdByLote($id), 'Log: Status de construo alterado. ');

        echo $tb_lote->fl_construcao;
    }

    public function caucionadoAction() 
    {
        $id = $_POST['id'];
        $tb_lote = $this->lotes->fetchRow("id = " . $id);

        if (!$_POST['fl_caucionado']) {
            if ($tb_lote['fl_caucionado'] == 0)
                $tb_lote->fl_caucionado = '1';
            else
                $tb_lote->fl_caucionado = '0';
        } else {
            $tb_lote->fl_caucionado = $_POST['fl_caucionado'];
        }

        $tb_lote->save();
        (new Relacionamento())->saveContato(49, date('Y-m-d'), Contrato::getIdByLote($id), 'Log: Status de caucionado alterado. ');

        echo $tb_lote->fl_caucionado;
    }

    //Testa se existe o lote digitado para o empreendimento selecionado
    public function findQuadraLoteAction()
    {
        $lote = $this->lotes->findLotesByEmpreendimentoQuadraLote($_POST['empreendimento'], $_POST['quadra'], $_POST['lote']);
        if ($lote)
            $response = true;
        else
            $response = false;
        echo json_encode($response);
    }
}

?>