<?php

class IndiceController extends Controller
{

    private $meses;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->meses = array(
            '01' => 'Janeiro',
            '02' => 'Fevereiro',
            '03' => 'Maro',
            '04' => 'Abril',
            '05' => 'Maio',
            '06' => 'Junho',
            '07' => 'Julho',
            '08' => 'Agosto',
            '09' => 'Setembro',
            '10' => 'Outubro',
            '11' => 'Novembro',
            '12' => 'Dezembro'
        );
    }

    public function indexAction()
    {
        $this->redirect(array('modulo' => 'lo', 'controller' => 'indice', 'action' => 'listar'));
    }

    public function listarAction($termo = null)
    {
        if ($this->isAjax()) {
            $listaItem = IndiceGeral::getIndices();

            $lista = array();
            foreach ($listaItem as $item) {
                $title = "return confirm('Tem certeza que deseja excluir o indice " . $item['descricao'] . "?')";

                $lista[] = array(
                    'ano' => utf8_encode($item['ano']),
                    'mes' => '<div hidden>' . $item['mes'] . '</div>' . utf8_encode($this->meses[$item['mes']]),
                    'descricao' => utf8_encode($item['descricao']),
                    'valor' => $item['valor'] . '%'
                );
            }
            echo json_encode(array(
                'draw' => 1,
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        $this->set("subtitulo", "ndices de Reajuste");
        $tb_indice = new Indice();
        if ($this->_isPost) {

            if ($this->validar()) {
                $data = [];
                $data['agr_descricaoIndice'] = $_POST['agr_descricaoIndice'];
                $data['mes'] = $_POST['mes'];
                $data['ano'] = $_POST['ano'];
                $data['valor'] = str_replace(',', '.', $_POST['valor']);
                $data['log'] = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                if (Controller::getAdapterAcadeGeral()->insert(TB_INDICE_GERAL, $data)) {
                    $this->redir(array('modulo' => 'lo', 'controller' => 'indice', 'action' => 'listar'), array('msg' => 'success'));
                } else {
                    $this->redir(array('modulo' => 'lo', 'controller' => 'indice', 'action' => 'listar'), array('exception' => 'No foi possvel realizar a operao'));
                }
            } else {
                $this->set("indice", $_POST);
            }
        }
        $indices = $tb_indice->getAdapter()->select()->from(TB_AGRUPADA)
            ->where("idTabela = " . Db_TabelaAgrupada::TABLE_INDICE)
            ->order('descricao')->query()->fetchAll();
        $this->set('indices', $indices);
        $this->set("meses", $this->meses);
        $this->display('form');
    }

    public function editarAction()
    {
        $tb_indice = new Indice();
        $indice = $tb_indice->fetchRow("id = {$_GET['id']}");
        $indice = Controller::getAdapterAcadeGeral()->select()
            ->from(array('i' => TB_INDICE_GERAL), array('*'))
            ->where("id = {$_GET['id']}")
            ->query()->fetch();

        if ($this->_isPost) {
            if ($this->validar(true)) {
                $data = [];
                $data['agr_descricaoIndice'] = $_POST['agr_descricaoIndice'];
                $data['mes'] = $_POST['mes'];
                $data['ano'] = $_POST['ano'];
                $data['valor'] = str_replace(',', '.', $_POST['valor']);
                $data['log'] = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');

                $where = array('id = ?' => $_GET['id']);

                if (Controller::getAdapterAcadeGeral()->update(TB_INDICE_GERAL, $data, $where)) {
                    $this->redir(array('modulo' => 'lo', 'controller' => 'indice', 'action' => 'listar'), array('msg' => 'success'));
                } else {
                    $this->redir(array('modulo' => 'lo', 'controller' => 'indice', 'action' => 'listar'), array('exception' => 'No foi possvel realizar a operao'));
                }
            } else {
                $indice = $_POST;
            }
        }

        $indices = $tb_indice->getAdapter()->select()->from(TB_AGRUPADA)
            ->where("idTabela = " . Db_TabelaAgrupada::TABLE_INDICE)
            ->order('descricao')->query()->fetchAll();

        $this->set('indices', $indices);
        $this->set("indice", $indice);
        $this->set("meses", $this->meses);
        $this->display('form');
    }

    public function deletarAction()
    {
        try {
            Controller::getAdapterAcadeGeral()->delete(TB_INDICE_GERAL, "id = {$_GET["id"]}");
            $this->redir(array('modulo' => 'lo', 'controller' => 'indice', 'action' => 'listar'), array('msg' => 'success'));
        } catch (Exception $e) {
            $this->redir(array("modulo" => "lo", "controller" => "indice", 'action' => 'listar'), array("exception" => "No foi possvel realizar a operao"));
        }
    }

    public function validar($edit = false)
    {
        $campos = array(
            'agr_descricaoIndice' => 'Selecione o ndice!',
            'mes' => 'Selecione o ms do reajuste',
            'ano' => 'O campo ano  obrigatrio',
            'valor' => 'O campo Percentual  obrigatrio'
        );

        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == '') {
                $this->_helper->addMensagem($campo, $msg);
            }
        }
        //testa se no exite indice j cadastrado para o ms e ano
        if (!(count($this->_helper->getMensagens()) > 0)) {
            $tb_indice = new Indice();
            //Acrescentado condio para verificar por ID e modificado a consulta.
            $id = '';
            if (isset($_GET['id'])) {
                $id = ' AND id != '.$_GET['id'];
            }
            $indice = Controller::getAdapterAcadeGeral()->select()
                ->from(array('i' => TB_INDICE_GERAL), array('*'))
                ->where("mes = {$_POST['mes']} and ano = {$_POST['ano']} and agr_descricaoIndice = {$_POST['agr_descricaoIndice']}".$id)
                ->query()->fetch();
            if ($indice) {
                $this->_helper->addMensagem('mes', 'J foi cadastrado esse ndice para esse ms e ano!');
            }
        }


        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function pesquisarAction()
    {
        $termo = "'%" . strtoupper($_GET['termo']) . "%'";
        $this->listarAction($termo);
        exit;
    }

}

?>
