<?php

class EmpreendimentoController extends Controller
{
    private $emps;
    private $empreendimentoImagens;
    private $pessoa;
    private $periodos;
    private $parcerias;
    private $assinatura;
    private $representante;
    private $cidades;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->emps = new Empreendimento();
        $this->empreendimentoImagens = new EmpreendimentoImagens();
        $this->parcerias = new Parceria();
        $this->parceriaComissao = new ParceriaComissao();
        $this->cidades = new Db_Cidade();
        $this->pessoa = new Pessoa();
        $this->assinatura = new Assinatura();
        $this->representante = new Representante();
        $this->indiceEmp = new IndiceEmpreendimento();

        $this->periodos = array(
            'A' => 'Anual',
            'AM' => 'Anual+Mensal',
            'B' => 'Bimestral',
            'M' => 'Mensal',
            'S' => 'Semestral',
            'T' => 'Timestral',
            'SP' => 'Sem Periodo',
        );
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "lo", "controller" => "empreendimento", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = Empreendimento::findLista($_POST);
            $totalItems = Empreendimento::findLista($_POST, true);

            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $title = "return confirm('Tem certeza que deseja excluir o empreendimento " . $item['nm_empreendimento'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $item['id'] . '" data-toggle="tooltip" title="EXCLUIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=parceria&id=' . $item['id'] . '" data-toggle="tooltip" title="PARCERIAS" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-user"></i></a>';
                $acoes .= '<a target="_blank" href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=imprimir&id=' . $item['id'] . '" data-toggle="tooltip" title="IMPRIMIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-o"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                $lista[] = array(
                    'codigo' => utf8_encode($item['id']),
                    'empreendimento' => utf8_encode($item['nm_empreendimento']),
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalItems),
                'recordsFiltered' => count($totalItems),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarEmpreendimento')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'empreendimento', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $cliente = Db_Cliente::getCliente();
        $this->set("cliente", $cliente);
        $sc_usuario = Login::getUsuario()->getSuper();
        $this->set("sc_usuario", $sc_usuario);

        //Redireciona o usuario para tela de listagem se nao possuir a quantidade de empreendimentos do seu plano de sistema
        if (Login::getUsuario()->getSuper() == 0 && count($this->emps->fetchAll()) >= (int)$cliente['cd_plano_cliente']) {
            $this->redir(
                array(
                    "modulo" => "lo",
                    "controller" => "empreendimento",
                    "action" => "listar"
                ),
                array('exception' => 'O limite de empreendimentos foi alcanado.')
            );
        }
        $this->set("periodos", $this->periodos);
        $indices = AgrupadaGeral::listar('12');
        $this->set("indices", $indices);

        if ($this->getAdapterIntegracao()) {
            $this->set('conneccao', true);
            $contasCredito = $this->getAdapterIntegracao()->select()->from('afn005')
                ->where('tp_plano_conta = "C"')
                ->order('ds_plano_conta')
                ->query()->fetchAll();
            if ($contasCredito)
                $this->set('listaContaCredito', $contasCredito);

            $contasDebito = $this->getAdapterIntegracao()->select()->from('afn005')
                ->where('tp_plano_conta = "D"')
                ->order('ds_plano_conta')
                ->query()->fetchAll();
            if ($contasDebito)
                $this->set('listaContaDebito', $contasDebito);

            $centroCusto = $this->getAdapterIntegracao()->select()->from('afn008')
                ->query()->fetchAll();
            if ($centroCusto)
                $this->set('centroCusto', $centroCusto);

            $contaMovimento = $this->getAdapterIntegracao()->select()->from('afn010')
                ->query()->fetchAll();
            if ($contaMovimento)
                $this->set('contaMovimento', $contaMovimento);

            $empFinan = $this->getAdapterIntegracao()->select()->from('afn019')
                ->query()->fetchAll();
            if ($empFinan)
                $this->set('empFinan', $empFinan);
        }
        $tbTipo = new TipoLoteamento();
        $infoTipo = $tbTipo->getDefaultAdapter()->select()
            ->from(array('t' => TB_TIPO_LOTEAMENTO), '*')->query()->fetchAll();
        $this->set('infoTipo', $infoTipo);
        if ($this->_isPost) {
            if ($this->validar()) {
                try {
                    $tbEmpreendimento = new Empreendimento();
                    $transacaoEmpreendimento = $tbEmpreendimento->getAdapter()->beginTransaction();
                    $emp = $tbEmpreendimento->createRow();
                    $emp->nm_empreendimento = $_POST['nm_empreendimento'];
                    $emp->bairro = $_POST['bairro'];
                    $emp->nr_cep = $_POST['nr_cep'];
                    $emp->cd_cidade = $_POST['cd_cidade'];
                    $emp->fl_integracao = $_POST['fl_integracao'];
                    $emp->fl_contrato_digital = $_POST['fl_contrato_digital'];
                    $emp->telefoneContato = $_POST['telefoneContato'];
                    $emp->emailContato = $_POST['emailContato'];
                    $emp->cnpjContato = $_POST['cnpjContato'];
                    $emp->negociacao_portal = $_POST['negociacaoPortal'];
                    
                    if($_POST['latitude']&&$_POST['longitude']){
                        $emp->latitude = $_POST['latitude'];
                        $emp->longitude = $_POST['longitude'];
                    }
                    if ($_POST['fl_integracao'] == '1') {
                        $emp->cd_conta_tesouraria = $_POST['contaTesouraria'];
                        $emp->cd_centro_custo = $_POST['centroCusto'];
                        $emp->cd_conta_credito = $_POST['contaCredito'];
                        $emp->cd_conta_debito = $_POST['contaDebito'];
                        $mp->cd_empreendimento = $_POST['empFinan'];
                    } else {
                        $emp->cd_conta_tesouraria = null;
                        $emp->cd_centro_custo = null;
                        $emp->cd_conta_credito = null;
                        $emp->cd_conta_debito = null;
                        $emp->cd_empreendimento = null;
                    }
                    //Inserindo 9999 quando o fl_painel_venda foi igual a 0
                    if ($cliente['fl_painel_venda'] == '0') {
                        $emp->temp_reserva = '9999';
                        $emp->qtde_reserva_corretor = '9999';
                    } else {
                        $emp->temp_reserva = $this->_helper->filters($_POST['tempReserva']);
                        $emp->qtde_reserva_corretor = $this->_helper->filters($_POST['qtdeReservaCorretor']);
                    }
                    $emp->dt_conclusao = ($_POST['dt_conclusao'] ? Helper::getInputDate($_POST['dt_conclusao']) : null);
                    $emp->porcAdmin = Helper::getInputMoney($_POST['porcAdmin']);
                    $emp->porcDev = Helper::getInputMoney($_POST['porcDev']);
                    $emp->porcFru = Helper::getInputMoney($_POST['porcFru']);
                    $emp->rgi = $_POST['rgi'];
                    //Alterado condio para insercao da fl_tabela_preco, inserindo 0 quando nao tiver acesso a outros programas
                    if ($_POST['fl_tabela_preco'] == '' || $_POST['fl_tabela_preco'] == null) {
                        $emp->fl_tabela_preco = '0';
                    } else {
                        $emp->fl_tabela_preco = $_POST['fl_tabela_preco'];
                    }
                    if ($_POST['porcAdmin'] == '') {
                        $emp->porcAdmin = '0';
                    }
                    $emp->fl_assinatura = $_POST['fl_assinatura'];
                    $emp->max_parcela = $this->_helper->filters($_POST['maxParcela']);
                    $emp->id_tipo_loteamento = $_POST['tipo'];
                    $emp->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                    $lastId = $emp->save();
                    $socios = $_POST['socios'];
                    if (isset($socios)) {
                        foreach ($socios as $socio) {
                            $parceria = $this->parcerias->createRow();
                            $parceria->id_pessoa = $socio;
                            $parceria->id_empreendimento = $lastId;
                            $parceria->save();
                        }
                    }
                    $assinaturas = $_POST['assinaturas'];
                    foreach ($assinaturas as $ass) {
                        $row = $this->assinatura->createRow();
                        $row->id_empreendimento = $lastId;
                        $row->id_pessoa = $ass;
                        $row->save();
                    }

                    /*
                     * Adiciona logo e pe o caminho da imagem em Empreendimento/ds_path_logo.
                     */

                    if ($_FILES['dsPathLogo']['name']) {
                        $upper = new Filesystem();

                        //alterar o nome do arquivo
                        $name = $this->_helper->removeAcentos($_FILES['dsPathLogo']['name']);
                        $name = explode(".", $name);
                        $dataHr = new DateTime();
                        $dataHr = $dataHr->format('YmdHis');
                        $name = 'logoEmpreendimento_' . $dataHr . '_' . $emp["id"] . '.' . $name[1];

                        // Armazena o arquivo fisico
                        $tmp = $_FILES['dsPathLogo']['tmp_name'];

                        $path = explode('.', $_SERVER['HTTP_HOST']);
                        if ($path[0] == 'www') {
                            $path = $path[1];
                        } else {
                            $path = $path[0];
                        }

                        $pastaCliente = "upload/cliente/";
                        if (!is_dir($pastaCliente)) {
                            mkdir($pastaCliente, 0777, true);
                        }

                        $pastaPath = $pastaCliente . $path;
                        if (!is_dir($pastaCliente)) {
                            mkdir($pastaPath, 0777, true);
                        }
                        $fullPath = $pastaPath . '/' . $name;

                        $rs = $upper->upload($tmp, $fullPath);

                        if ($rs) {
                            $emp->ds_path_logo = $fullPath;
                            $emp->save();
                        }
                    }
                    //Arquivos
                    if (is_array($_FILES['ds_imagens']['name'])) {
                        // Arquivo
                        $up = new Filesystem();
                        foreach ($_FILES['ds_imagens']['name'] as $k => $img) {
                            //alterar o nome do arquivo
                            $name = $this->_helper->removeAcentos($img);
                            // Armazena o arquivo fisico
                            $tmp = $_FILES['ds_imagens']['tmp_name'][$k];
                            $path = explode('.', $_SERVER['HTTP_HOST']);
                            if ($path[0] == 'www') {
                                $path = $path[1];
                            } else {
                                $path = $path[0];
                            }
                            $to = "upload/cliente/" . $path . '/' . $name;
                            $rs = $up->upload($tmp, $to);
                            if ($rs) {
                                $imagem = $this->empreendimentoImagens->createRow();
                                $imagem->id_empreendimento = $lastId;
                                $imagem->ds_path = $to;
                                $imagem->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                                $imagem->save();
                            }
                        }
                    }

                    $tbIndiceEmpreendimento = new IndiceEmpreendimento();
                    foreach ($_POST['listaIndices'] as $dados) {
                        $indice = explode('_', $dados);
                        $indiceEmpreendimento = $tbIndiceEmpreendimento->createRow();
                        $indiceEmpreendimento->id_empreendimento = $lastId;
                        $indiceEmpreendimento->id_indice = $indice[0];
                        $indice[1] != '' ? $indiceEmpreendimento->fl_periodo = $indice[1] : null;
                        $indiceEmpreendimento->fl_residuo = $indice[3];
                        $indiceEmpreendimento->indice_adicional = $this->_helper->filters($indice[2], 'money');
                        $indice[4] != '' ? $indiceEmpreendimento->fl_periodo_adc = $indice[4] : null;
                        $indiceEmpreendimento->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                        $indiceEmpreendimento->save();
                    }

                    $transacaoEmpreendimento->commit();
                    $this->redir(array("modulo" => "lo", "controller" => "empreendimento", "action" => "listar"), array("msg" => "success"));
                } catch (Exception $e) {
                    $transacaoEmpreendimento->rollBack();
                    $this->_helper->addMensagem('danger', 'Houve algum problema, entre em contato com suporte. ' . $e->getMessage());
                }
            } else {
                $this->set('empreendimento', $_POST);
            }
        }
        $this->display('form');
    }

    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'editarEmpreendimento')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'empreendimento', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        //Recebe os registros do banco caso exista integrao com Finan
        $bancos = new Banco();
        $bancosIds = $bancos->findByEmpreendimento($_GET['id']);
        foreach ($bancosIds as $key => $banco) {
            $bancoReg[$key]['nm_banco'] = $bancos->findBancoNome($banco['cd_banco']);
            $bancoReg[$key]['id'] = $banco['id'];
            $bancoReg[$key]['id_finan'] = $banco['id_finan'];
            $bancoReg[$key]['conta_corrente'] = $banco['conta_corrente'];
            $bancoReg[$key]['conta_corrente_dv'] = $banco['conta_corrente_dv'];
        }
        $this->set('bancos', $bancoReg);

        if ($this->getAdapterIntegracao()) {
            $this->set('conneccao', true);
            $contasCredito = $this->getAdapterIntegracao()->select()->from('afn005')
                ->where('tp_plano_conta = "C"')
                ->order('ds_plano_conta')
                ->query()->fetchAll();
            if ($contasCredito)
                $this->set('listaContaCredito', $contasCredito);

            $contasDebito = $this->getAdapterIntegracao()->select()->from('afn005')
                ->where('tp_plano_conta = "D"')
                ->order('ds_plano_conta')
                ->query()->fetchAll();
            if ($contasDebito)
                $this->set('listaContaDebito', $contasDebito);

            $centroCusto = $this->getAdapterIntegracao()->select()->from('afn008')
                ->query()->fetchAll();
            if ($centroCusto)
                $this->set('centroCusto', $centroCusto);

            $contaMovimento = $this->getAdapterIntegracao()->select()->from('afn010')
                ->query()->fetchAll();
            if ($contaMovimento)
                $this->set('contaMovimento', $contaMovimento);

            $empFinan = $this->getAdapterIntegracao()->select()->from('afn019')
                ->query()->fetchAll();
            if ($empFinan)
                $this->set('empFinan', $empFinan);
        }

        $cliente = Db_Cliente::getCliente();
        $this->set("cliente", $cliente);

        $id_empreendimento = $_GET['id'];

        $tbTipo = new TipoLoteamento();
        $infoTipo = $tbTipo->getDefaultAdapter()->select()
            ->from(array('t' => TB_TIPO_LOTEAMENTO), '*')->query()->fetchAll();
        $this->set('infoTipo', $infoTipo);

        if ($this->_isPost) {
            if ($this->validar()) {
                try {
                    $tbEmpreendimento = new Empreendimento();
                    $transacaoEmpreendimento = $tbEmpreendimento->getAdapter()->beginTransaction();
                    $emp = $tbEmpreendimento->fetchRow('id = ' . $id_empreendimento);
                    $emp->nm_empreendimento = $_POST['nm_empreendimento'];
                    $emp->bairro = $_POST['bairro'];
                    $emp->nr_cep = $_POST['nr_cep'];
                    $emp->cd_cidade = $_POST['cd_cidade'];
                    $emp->fl_integracao = $_POST['fl_integracao'];
                    $emp->fl_contrato_digital = $_POST['fl_contrato_digital'];
                    $emp->cnpjContato = $_POST['cnpjContato'];
                    $emp->telefoneContato = $_POST['telefoneContato'];
                    $emp->emailContato = $_POST['emailContato'];
                    $emp->negociacao_portal = $_POST['negociacaoPortal'];
                    
                    if($_POST['latitude']&&$_POST['longitude']){
                        $emp->latitude = $_POST['latitude'];
                        $emp->longitude = $_POST['longitude'];
                    }
                    if ($_POST['fl_integracao'] == '1') {
                        $emp->cd_conta_tesouraria = $_POST['contaTesouraria'];
                        $emp->cd_centro_custo = $_POST['centroCusto'];
                        $emp->cd_conta_credito = $_POST['contaCredito'];
                        $emp->cd_conta_debito = $_POST['contaDebito'];
                        $emp->cd_empreendimento = $_POST['empFinan'];
                    } else {
                        $emp->cd_conta_tesouraria = null;
                        $emp->cd_centro_custo = null;
                        $emp->cd_conta_credito = null;
                        $emp->cd_conta_debito = null;
                        $emp->cd_empreendimento = null;
                    }
                    //Inserindo 9999 quando o fl_painel_venda foi igual a 0
                    if ($cliente['fl_painel_venda'] == '0') {
                        $emp->temp_reserva = '9999';
                        $emp->qtde_reserva_corretor = '9999';
                        $emp->fl_tabela_preco = 0;
                    } else {
                        $emp->temp_reserva = $_POST['tempReserva'];
                        $emp->qtde_reserva_corretor = $_POST['qtdeReservaCorretor'];
                        $emp->fl_tabela_preco = $_POST['fl_tabela_preco'];
                    }
                    $emp->porcAdmin = Helper::getInputMoney($_POST['porcAdmin']);
                    $emp->porcDev = Helper::getInputMoney($_POST['porcDev']);
                    $emp->porcFru = Helper::getInputMoney($_POST['porcFru']);
                    $emp->dt_conclusao = ($_POST['dt_conclusao'] ? Helper::getInputDate($_POST['dt_conclusao']) : null);
                    $emp->rgi = $_POST['rgi'];
                    $emp->fl_assinatura = $_POST['fl_assinatura'];
                    $emp->max_parcela = $this->_helper->filters($_POST['maxParcela']);
                    $emp->id_tipo_loteamento = strtoupper($_POST['tipo']);

                    $this->parcerias->delete($this->parcerias->getAdapter()->quoteInto('id_empreendimento = ?', $id_empreendimento));
                    foreach ($_POST['socios'] as $socio) {
                        $parceria = $this->parcerias->createRow();
                        $parceria->id_pessoa = $socio;
                        $parceria->id_empreendimento = $id_empreendimento;
                        $parceria->save();
                    }

                    $this->assinatura->delete($this->assinatura->getAdapter()->quoteInto('id_empreendimento = ?', $id_empreendimento));
                    $assinaturas = $_POST['assinaturas'];
                    foreach ($assinaturas as $ass) {
                        $row = $this->assinatura->createRow();
                        $row->id_empreendimento = $id_empreendimento;
                        $row->id_pessoa = $ass;
                        $row->save();
                    }

                    $emp->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');


                    /*
                     * Altera a logo e pe o caminho da imagem em Empreendimento/ds_path_logo.
                     */
                    if ($_FILES['dsPathLogo']['name']) {
                        $upper = new Filesystem();
                        //alterar o nome do arquivo
                        $name = $this->_helper->removeAcentos($_FILES['dsPathLogo']['name']);
                        $name = explode(".", $name);
                        $dataHr = new DateTime();
                        $dataHr = $dataHr->format('YmdHis');
                        $name = 'logoEmpreendimento_' . $dataHr . '_' . $emp["id"] . '.' . $name[1];

                        // Armazena o arquivo fisico
                        $tmp = $_FILES['dsPathLogo']['tmp_name'];

                        $path = explode('.', $_SERVER['HTTP_HOST']);
                        if ($path[0] == 'www') {
                            $path = $path[1];
                        } else {
                            $path = $path[0];
                        }

                        $pastaCliente = "upload/cliente/";
                        if (!is_dir($pastaCliente)) {
                            mkdir($pastaCliente, 0777, true);
                        }

                        $pastaPath = $pastaCliente . $path;
                        if (!is_dir($pastaCliente)) {
                            mkdir($pastaPath, 0777, true);
                        }
                        $fullPath = $pastaPath . '/' . $name;

                        $rs = $upper->upload($tmp, $fullPath);
                        if ($rs) {
                            $emp->ds_path_logo = $fullPath;
                        }
                    }

                    $emp->save();
                    //Arquivos
                    if (is_array($_FILES['ds_imagens']['name'])) {
                        $up = new Filesystem();
                        foreach ($_FILES['ds_imagens']['name'] as $k => $img) {
                            //alterar o nome do arquivo
                            $name = $this->_helper->removeAcentos($img);

                            // Pega a extensao
                            $extensao = pathinfo($img, PATHINFO_EXTENSION);
                            $extensao = strtolower($extensao);

                            // Somente imagens, .jpg;.jpeg;.gif;.png
                            if (strstr('.jpg;.jpeg;.gif;.png;.bmp', $extensao)) {
                                // Armazena o arquivo fisico
                                $tmp = $_FILES['ds_imagens']['tmp_name'][$k];

                                $path = explode('.', $_SERVER['HTTP_HOST']);
                                if ($path[0] == 'www') {
                                    $path = $path[1];
                                } else {
                                    $path = $path[0];
                                }
                                $to = "upload/cliente/" . $path . '/' . $name;
                                $rs = $up->upload($tmp, $to);
                                if ($rs) {
                                    $imagem = $this->empreendimentoImagens->createRow();
                                    $imagem->id_empreendimento = $emp->id;
                                    $imagem->ds_path = $to;
                                    $imagem->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                                    $imagem->save();
                                }
                            }
                        }
                    }

                    //Salvando todos indices do empreendimento
                    $tbIndiceEmpreendimento = new IndiceEmpreendimento();
                    if (isset($_POST['listaIndices'])) {
                        $notInIndices = '';
                        $listIndices = [];
                        //Salva no array os ids de indices que possuem contrato associado
                        foreach ($_POST['listaIndices'] as $dados) {
                            $indice = explode('_', $dados);
                            if ($indice[5]) {
                                $listIndices[] = $indice[5];
                            }
                        }
                        if ($listIndices) {
                            $notInIndices = 'AND id_indice_empreendimento NOT IN (' . implode(',', $listIndices) . ')';
                        }
                        //Deleta apenas os indices que nao possuirem contratos associados
                        $tbIndiceEmpreendimento->delete('id_empreendimento = ' . $_GET['id'] . ' ' . $notInIndices);
                        //Cadastra todos indices que no possuirem contratos associados
                        foreach ($_POST['listaIndices'] as $dados) {
                            $indice = explode('_', $dados);
                            if (!$indice[5]) {
                                $indiceEmpreendimento = $tbIndiceEmpreendimento->createRow();
                                $indiceEmpreendimento->id_empreendimento = $_GET['id'];
                                $indiceEmpreendimento->id_indice = $indice[0];
                                $indice[1] != '' ? $indiceEmpreendimento->fl_periodo = $indice[1] : null;
                                $indiceEmpreendimento->fl_residuo = $indice[3];
                                $indiceEmpreendimento->indice_adicional = $this->_helper->filters($indice[2], 'money');
                                $indice[4] != '' ? $indiceEmpreendimento->fl_periodo_adc = $indice[4] : null;
                                $indiceEmpreendimento->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                                $indiceEmpreendimento->save();
                            }
                        }
                    }
                    $transacaoEmpreendimento->commit();
                    $this->redir(array("modulo" => "lo", "controller" => "empreendimento", "action" => "listar"), array("msg" => "success"));
                } catch (Exception $e) {
                    $transacaoEmpreendimento->rollBack();
                    $this->_helper->addMensagem('danger', 'Houve algum problema, entre em contato com suporte. ' . $e->getMessage());
                }
            }
        }

        $socios = array();
        $parceria = $this->parcerias->fetchAll($this->parcerias->select()->where('id_empreendimento = ?', $id_empreendimento))->toArray();
        foreach ($parceria as $parc) {
            $id_pessoa = $parc['id_pessoa'];
            $socios[] = Pessoa::findPessoaById($id_pessoa);
        }

        $emp = $this->emps->fetchRow('id = ' . $id_empreendimento);
        $emp['dt_conclusao'] = Helper::getDate($emp['dt_conclusao']);

        $pessoas_envolvidas = array();
        $responsaveis = array();
        foreach ($this->assinatura->fetchAll($this->assinatura->select()->where('id_empreendimento = ?', $id_empreendimento))->toArray() as $ass) {
            $pessoa = $this->pessoa->fetchRow('id = ' . $ass['id_pessoa']);
            $responsaveis[] = $pessoa['id'];
            $pessoas_envolvidas[$pessoa['id']] = $pessoa;
        }
        foreach ($this->parcerias->fetchAll($this->parcerias->select()->where('id_empreendimento = ?', $id_empreendimento))->toArray() as $parc) {
            $pes = $this->pessoa->fetchRow('id = ' . $parc['id_pessoa']);
            if ($pes['tp_pessoa'] == 'F') {
                $pessoas_envolvidas[$pes['id']] = $pes;
            } elseif ($pes['tp_pessoa'] == 'J') {
                $ids = $this->representante->fetchAll($this->representante->select()->where('id_pessoa_juridica = ?', $pes['id']))->toArray();
                foreach ($ids as $id) {
                    $exist = false;
                    foreach ($pessoas_envolvidas as $pe) {
                        if ($id['id_pessoa'] == $pe['id']) {
                            $exist = true;
                            break;
                        }
                    }
                    if (!$exist)
                        $pessoas_envolvidas[$id['id_pessoa']] = $this->pessoa->fetchRow('id = ' . $id['id_pessoa']);
                }
            }
        }

        $indices = AgrupadaGeral::listar('12');

        $cidade = $this->cidades->find($emp['cd_cidade']);
        if ($cidade != '') {
            $cidades = array(
                'cidade' => $cidade->getNome() . ' - ' . $cidade->getUf(),
                'cd_cidade' => $cidade->getId()
            );
        }
        $tbIndiceEmpreendimento = new IndiceEmpreendimento();
        $this->set('listaIndiceEmpreendimento', $tbIndiceEmpreendimento->getIndiceEmpreendimento($_GET['id']));
        $this->set('params', $cidades);
        $this->set('empreendimento', $emp);
        $this->set('empreendimentoImagens', EmpreendimentoImagens::findImagens($id_empreendimento));
        $this->set('socios', $socios);
        $this->set("periodos", $this->periodos);
        $this->set('pessoas_envolvidas', $pessoas_envolvidas);
        $this->set('responsaveis', $responsaveis);
        $this->set("indices", $indices);

        $this->display('form');
    }

    public function deletarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'deletarEmpreendimento')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'empreendimento', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        $id = $_GET['id'];

        $tbContrato = new Contrato();
        $listaContrato = $tbContrato->getDefaultAdapter()->select()
            ->from(array('l' => TB_LOTES), '*')
            ->join(array('c' => TB_CONTRATO), 'c.id_lote = l.id', '*')
            ->where('l.id_empreendimento = ' . $id)
            ->query()->fetchall();

        if (!$listaContrato) {
            try {
                Assinatura::getDefaultAdapter()->update(
                    TB_ASSINATURA,
                    array('id_empreendimento' => NULL),
                    'id_empreendimento = "' . $id . '"'
                );
                //Deletando os corretores associados ao empreendimento
                $tbCorretorEmpreendimento = new Corretor_Empreendimento();
                $tbCorretorEmpreendimento->delete('id_empreendimento = ' . $id);
                //Deletando as parcerias
                $tbParceria = new Parceria();
                $tbParceria->delete('id_empreendimento = ' . $id);
                //Deletando os indices do empreendimento
                $tbIndiceEmpreendimento = new IndiceEmpreendimento();
                $tbIndiceEmpreendimento->delete('id_empreendimento = ' . $id);
                //Deletando o empreendimento
                $tbEmpreendimento = new Empreendimento();
                $tbEmpreendimento->delete($tbEmpreendimento->getAdapter()->quoteInto('id = ?', $id));
                $this->redir(
                    array("modulo" => "lo", "controller" => "empreendimento", "action" => "listar"),
                    array("msg" => "success")
                );
            } catch (Exception $e) {
                $this->redir(
                    array("modulo" => "lo", "controller" => "empreendimento", "action" => "listar"),
                    array("exception" => "Ocorreu algum erro, entre em contato com suporte.  " . $e->getMessage())
                );
            }
        } else {
            $this->redir(
                array("modulo" => "lo", "controller" => "empreendimento", "action" => "listar"),
                array("exception" => "O empreendimento no pode ser excludo pois possui contrato associado.")
            );
        }
    }

    public function parceriaAction()
    {
        if ($this->_isPost) {
            if ($this->validarParceria()) {
                try {
                    $parceria = new ParceriaComissao();
                    $parceria = $parceria->createRow();
                    $parceria->id_pessoa = $_POST['cdParceiro'];
                    $parceria->id_empreendimento = $_GET['id'];
                    $parceria->pc_comissao = Helper::getInputMoney($_POST['pcComissao']);
                    $parceria->tp_comissao = $_POST['tpComissao'];
                    $parceria->fl_parcela_normal = $_POST['fl_parcela_normal'] ? $_POST['fl_parcela_normal'] : 0;
                    $parceria->fl_parcela_intercalada = $_POST['fl_parcela_intercalada'] ? $_POST['fl_parcela_intercalada'] : 0;
                    $parceria->fl_parcela_chave = $_POST['fl_parcela_chave'] ? $_POST['fl_parcela_chave'] : 0;
                    $parceria->fl_parcela_sinal = $_POST['fl_parcela_sinal'] ? $_POST['fl_parcela_sinal'] : 0;
                    $parceria->fl_parcela_quitacao = $_POST['fl_parcela_quitacao'] ? $_POST['fl_parcela_quitacao'] : 0;
                    $parceria->fl_parcela_negociada = $_POST['fl_parcela_negociada'] ? $_POST['fl_parcela_negociada'] : 0;
                    $parceria->fl_parcela_avulsa = $_POST['fl_parcela_avulsa'] ? $_POST['fl_parcela_avulsa'] : 0;
                    $parceria->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                    $parceria->save();

                    $this->redir(array("modulo" => "lo", "controller" => "empreendimento", "action" => "parceria"), array("msg" => "success", "id" => $_GET['id']));
                } catch (Exception $e) {

                    $this->redir(array("modulo" => "lo", "controller" => "empreendimento", "action" => "parceria"), array("id" => $_GET['id'], 'exception' => 'No foi possvel realizar a operao. Erro: ' . $e->getMessage()));
                }
            }
        } else {
            $auxParcerias = $this->parceriaComissao->fetchAll("id_empreendimento = {$_GET['id']}");

            //Seta o empreendimento se existe
            $instanceEmpreendimento = new Empreendimento();
            $empreendimento = $instanceEmpreendimento->fetchRow("id = {$_GET['id']}");

            $parcerias = array();
            foreach ($auxParcerias as $k => $parceria) {
                $parcerias[$k] = $parceria->toArray();
                $parcerias[$k]['nm_pessoa'] = Pessoa::findNomeById($parceria['id_pessoa']);
            }

            $this->set('empreendimento', $empreendimento);
            $this->set('parcerias', $parcerias);

            $this->display("parceria");
        }
    }

    public function removerParceriaAction()
    {
        try {
            $parceria = $this->parceriaComissao->fetchRow("id_parceria_comissao = {$_POST['parceiro']}");
            $parceria->delete();

            echo json_encode(true);
        } catch (Exception $e) {
            echo json_encode(array(false, $e->getMessage()));
        }
    }

    public function excluirImagemAction()
    {
        $id = $_GET['id'];
        try {
            //Exclui o empreendimento
            $empImg = $this->empreendimentoImagens->fetchRow('id_empreendimento_imagens = ' . $id);
            Filesystem::delete($empImg->ds_path);
            $this->empreendimentoImagens->delete('id_empreendimento_imagens = ' . $id);

            $this->redir(array(
                "modulo" => "lo",
                "controller" => "empreendimento",
                "action" => 'editar'
            ), array("id" => $_GET['id_empreendimento']));
        } catch (Exception $e) {

            $this->redir(array("modulo" => "lo", "controller" => "empreendimento", "action" => "listar"), array("exception" => "No foi possvel realizar a operao. Erro: " . $e->getCode()));
        }
    }

    public function excluirImagemLogoAction()
    {

        $id = $_GET['id'];
        $tb_cliente = $this->emps->fetchRow('id = ' . $id);

        //remove o aquivo

        if (file_exists($tb_cliente->ds_path_logo))

            Filesystem::delete($tb_cliente->ds_path_logo);
        //Remove o registro
        $tb_cliente->ds_path_logo = '';
        $tb_cliente->save();

        $this->redir(array("modulo" => "lo", "controller" => "empreendimento", "action" => "editar"), array("id" => $_GET['id']));
    }
    public function imprimirAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        $empOpts = $this->emps->fetchAll(null, "nm_empreendimento")->toArray();
        $this->set("empOpts", $empOpts);

        $empreendimento = $this->emps->getAdapter()->select()->from(array("e" => TB_EMPREENDIMENTO), "*")
            ->join(array("c" => TB_CIDADE), "e.cd_cidade = c.id", array("cidade" => "nome", "uf"))
            ->where("e.id = " . $_GET["id"])->query()->fetch();

        //Consulta para exibir os indices
        $indices = $this->indiceEmp->getAdapter()->select()
            ->from(array("ie" => TB_INDICE_EMPREENDIMENTO), array('*'))
            ->where("ie.id_empreendimento = ?", $_GET["id"])->query()->fetchAll();

        foreach ($indices as &$indice) {
            $tbAgrupada = AgrupadaGeral::buscar('12', $indice['id_indice']);
            $indice['descricao'] = $tbAgrupada['descricao'];
        }

        $this->set("indices", $indices);

        $tipoLoteamento = (new TipoLoteamento())->fetchRow('id_tipo_loteamento = ' . $empreendimento['id_tipo_loteamento']);
        $empreendimento['dsGrupo'] = ($tipoLoteamento['ds_grupo']) ? $tipoLoteamento['ds_grupo'] : '';
        $empreendimento['dsSubgrupo'] = ($tipoLoteamento['ds_subgrupo']) ? $tipoLoteamento['ds_subgrupo'] : '';


        $responsaveis = array();
        foreach ($this->assinatura->fetchAll($this->assinatura->select()->where('id_empreendimento = ?', $_GET["id"]))->toArray() as $ass) {
            $p = $this->pessoa->getAdapter()->select()->from(array("p" => TB_PESSOA), "*")
                ->join(array("pf" => TB_PESSOA_FISICA), "p.id = pf.id_pessoa", "*")
                ->where("p.id = " . $ass['id_pessoa'])->query()->fetch();
            if (!$p) {
                $p = $this->pessoa->getAdapter()->select()->from(array("p" => TB_PESSOA), "*")
                    ->join(array("pj" => TB_PESSOA_JURIDICA), "p.id = pj.id_pessoa", "*")
                    ->where("p.id = " . $ass['id_pessoa'])->query()->fetch();
            }

            $responsaveis[] = $p;
        }

        $parcerias = $this->parcerias->getAdapter()->select()->from(array("p" => TB_PARCERIA), "")
            ->join(array("pe" => TB_PESSOA), "p.id_pessoa = pe.id", array("nm_pessoa", "email", "nr_telefone", "nr_celular", "nr_fax", "nr_recado", "nr_cep", "endereco", "nm_bairro"))
            ->join(array("c" => TB_CIDADE), "pe.cd_cidade = c.id", array("cidade" => "nome", "uf"))
            ->joinLeft(array("pf" => TB_PESSOA_FISICA), "p.id_pessoa = pf.id_pessoa", "nr_cpf")
            ->joinLeft(array("pj" => TB_PESSOA_JURIDICA), "p.id_pessoa = pj.id_pessoa", "nr_cnpj")
            ->where("p.id_empreendimento = " . $_GET["id"])->query()->fetchAll();

        $this->set("responsaveis", $responsaveis);
        $this->set("empreendimento", $empreendimento);
        $this->set("parcerias", $parcerias);
        $this->display("imprimir");
        $this->displayPDF("empreendimento_" . rand() . ".pdf");
    }

    private function validar()
    {
        $campos = array("nm_empreendimento", "cd_cidade");
        foreach ($campos as $cp) {
            if ($_POST[$cp] == "") {
                switch ($cp) {
                    case "nm_empreendimento":
                        $msg = "O campo nome deve ser preenchido.";
                        break;
                    case "cd_cidade":
                        $msg = "O campo cidade deve ser preenchido.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }
        $socios = $_POST['socios'];
        if (!$socios || !is_array($socios))
            $this->_helper->addMensagem('socios', 'O empreendimento deve possuir pessoas interessada(s) escolhida(s).');

        $assinaturas = $_POST['assinaturas'];
        if (!$assinaturas || !is_array($assinaturas))
            $this->_helper->addMensagem('assinaturas', 'O empreendimento deve haver pessoas envolvidas responsveis associadas.');

        if (!isset($_POST['listaIndices'])) {
            $this->_helper->addMensagem('danger', ' obrigatrio ter pelo menos um ndice cadastrado.');
        }

        $cliente = Db_Cliente::getCliente();
        if ($cliente['fl_painel_venda'] == '1') {
            if ($_POST['tempReserva'] == '' || $_POST['qtdeReservaCorretor'] == '') {
                $this->_helper->addMensagem('danger', 'O campo Reserva Dias e o campo Reserva por Corretor so obrigatrio.');
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    private function validarParceria()
    {
        $campos = array("cdParceiro", "pcComissao", 'tpComissao');
        foreach ($campos as $cp) {
            if ($_POST[$cp] == "") {
                switch ($cp) {
                    case "cdParceiro":
                        $msg = "O campo nome deve ser preenchido.";
                        break;
                    case "pcComissao":

                        $msg = "O campo comisso deve ser preenchido";
                        break;
                    case "tpComissao":
                        $msg = "O campo tipo de comisso deve ser preenchido.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function findIndicePeriodoAction()
    {
        $this->set("periodos", $this->periodos);

        $indice = AgrupadaGeral::buscar('12', $_POST['indice']);

        echo json_encode(array('indice' => $indice['descricao'], 'periodo' => $this->periodos[$_POST['periodo']], 'residuo' => $indice['fl_residuo']));
    }

    public function findPessoaResponsavelAction()
    {
        $pessoas = new Pessoa();
        $representantes = new Representante();

        $list = array();
        $pes = $pessoas->fetchRow('id = ' . $_POST['pessoa']);

        if ($pes) {
            $pes = $pes->toArray();
            if ($pes['tp_pessoa'] == 'F') {
                $list[] = array('id' => $pes['id'], 'nm_pessoa' => utf8_encode($pes['nm_pessoa']));
            } elseif ($pes['tp_pessoa'] == 'J') {
                $ids = $representantes->fetchAll('id_pessoa_juridica = ' . $pes['id'])->toArray();
                foreach ($ids as $id) {
                    $pes = $pessoas->fetchRow('id = ' . $id['id_pessoa'])->toArray();
                    $list[] = array('id' => $pes['id'], 'nm_pessoa' => utf8_encode($pes['nm_pessoa']));
                }
            }
        }
        echo json_encode($list);
    }

    public function removeContaAction()
    {
        if ($this->isAjax()) {
            $bancos = new Banco();
            $bancos = $bancos->fetchAll('id = ' . $_POST['id_banco']);
            foreach ($bancos as $banco) {
                $banco->id_finan = NULL;
                $result = $banco->save();
            }
            if ($result)
                echo json_encode(true);
        }
    }

    public function clickAtivoAction()
    {
        if ($this->isAjax()) {
            $indicesEmp = new IndiceEmpreendimento();
            $indicesEmp = $indicesEmp->fetchAll('id_indice_empreendimento = ' . $_POST['id']);

            foreach($indicesEmp as $indiceEmp){
                if($indiceEmp->fl_ativo == '0'){
                    $indiceEmp->fl_ativo = '1';
                }else{
                    $indiceEmp->fl_ativo = '0';
                }
                $indiceEmp->ds_log = Login::getUsuario()->getLogin() . ' - '. date('d/m/Y H:m:s') . ' - u';
                $indiceEmp->save();
                (new RelEmpreendimento())->saveContato(2, date('Y-m-d'), $indiceEmp['id_empreendimento'], 'Status do ndice alterado');
                echo $indiceEmp->fl_ativo;
            }
        }
    }
    
    public function addContaAction()
    {
        if ($this->isAjax()) {
            $bancos = new Banco();
            $bancos = $bancos->fetchAll('id = ' . $_POST['id_banco']);
            foreach ($bancos as $banco) {
                if (!$banco->id_finan) {
                    $banco->id_finan = $_POST['id_finan'];
                    $result = $banco->save();
                }
            }
            if ($result)
                echo json_encode(true);
        }
    }
    public function gerarLinkAction()
    {
        if ($this->isAjax()) {
            $_POST['titulo'];
            // Caminho do arquivo a ser enviado
            $file_path = "upload/formularioRenderizado".$_POST['empreendimento'].time().".php";
            $myfile = fopen($file_path , "w") or die("Unable to open file!");
            fwrite($myfile, $this->render("formulario.php",$_POST,false));
            fclose($myfile);

            // Definir as credenciais de FTP
            $ftp_servidor = "acadelotear.com.br";
            $ftp_usuario = "engenharia@acadelotear.com.br";
            $ftp_senha = "acade123#!%";
            $pasta_destino = $_POST['diretorio'];

            // Conectar-se ao servidor FTP
            $conn_id = ftp_connect($ftp_servidor);

            // Autenticar com as credenciais do usurio
            $login_result = ftp_login($conn_id, $ftp_usuario, $ftp_senha);

            ftp_pasv($conn_id, true);
            // Verificar se a pasta de destino existe e, se no existir, criar a pasta
            if (!ftp_chdir($conn_id, $pasta_destino)) {
                $this->ftp_mksubdirs($conn_id, "", $pasta_destino);
                //ftp_mkdir($conn_id, $pasta_destino);
                ftp_chdir($conn_id, $pasta_destino);
            }

            // Definir o caminho do arquivo a ser enviado
            $arquivo_origem = $file_path;

            // Definir o nome do arquivo na pasta de destino
            $arquivo_destino = $_POST['diretorio'].$_POST['nomeArquivo'];

            // Enviar o arquivo para a pasta de destino
            if (ftp_put($conn_id, "/".$arquivo_destino, $arquivo_origem, FTP_BINARY)) {
                echo "Arquivo enviado com sucesso!";
            } else {
                echo "Erro ao enviar o arquivo.";
            }

            // Fechar a conexo FTP
            ftp_close($conn_id);

            unlink($file_path) ;
        }
    }
    function ftp_mksubdirs($ftpcon,$ftpbasedir,$ftpath){
        @ftp_chdir($ftpcon, $ftpbasedir); // /var/www/uploads
        $parts = explode('/',$ftpath); // 2013/06/11/username
        foreach($parts as $part){
           if(!@ftp_chdir($ftpcon, $part)){
              ftp_mkdir($ftpcon, $part);
              ftp_chdir($ftpcon, $part);
              //ftp_chmod($ftpcon, 0777, $part);
           }
        }
     }

    function render($modelo,$parametros = [], $utf=true){
        $html = file_get_contents($modelo);
        foreach($parametros as $index=>$p){
            if($utf){
                $html = str_replace('${'.$index.'}',utf8_decode($p),$html);
            }
            else{
                $html = str_replace('${'.$index.'}',$p,$html);
            }
        }
        return $html;
    }
}
