<?php

/**
 * Classe que representa o controller do boletim
 */
class DownloadController extends Controller
{

    protected $tb_download;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_download = new Download();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "lo", "controller" => "download", "action" => "listar"));
    }

    /**
     * Action index do controller
     */
    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = Download::findLista($_POST);
            $totalItens = Download::findLista($_POST, true);

            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $acoes .= '<a download href="upload/arquivos/' . $item['nm_path'] . '" data-toggle="tooltip" title="DOWNLOAD" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-download"></i></a>';
                $title = "return confirm('Tem certeza que deseja excluir o arquivo " . $item['nm_download'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $item['id'] . '" data-toggle="tooltip" title="EXCLUIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                if(!$item['dt_cadastro']){
                    $data ='<div align="center"> - <div>';
                }else{
                    $data = '<div align="center">' . Helper::dataParaBrasil($item['dt_cadastro']) . '<div>' ;
                }

                $lista[] = array(
                    'empreendimento' => utf8_encode($item['nm_empreendimento']),
                    'arquivo' => utf8_encode($item['nm_download']),
                    'dt_cadastro' => $data,
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalItens),
                'recordsFiltered' => count($totalItens),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        
        if ($this->_isPost) {
            if ($this->validarForm()) {
                
                if (Download::buscaQtdDownloads($_POST['id_emp']) < (new Empreendimento())->verificaQuantidadeDownloads($_POST['id_emp']))
                {
                    $download = $this->tb_download->createRow();
                    $download->id_emp = $_POST['id_emp'];
                    $download->nm_download = $_POST['nome_arquivo'];
                    $download->dt_cadastro = date('Y-m-d');
                    $download->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                    // Procedimentos para baixar arquivo
                    if ($_FILES["arquivo"]["name"]) {
                        try {
                            // Arquivo
                            $path = explode('.', $_SERVER['HTTP_HOST']);
                            if ($path[0] == 'www') {
                                $path = $path[1];
                            } else {
                                $path = $path[0];
                            }
                            $path = $path . '/';
                            $pathCompleta = DIRETORIO_DOWNLOAD . "arquivos/" . $path; 
                            $extensao = explode('.', $_FILES['arquivo']['name']);
                            $extensao = strtolower(end($extensao));
                            $download->nm_path = $path . date('Ymd_H_i_s') . '_' . Helper::removeCaracteresEspeciais($download->nm_download) . '.' . $extensao;
                            $up = new Filesystem();
                            $tmp = $_FILES['arquivo']['tmp_name'];
                            $to = DIRETORIO_DOWNLOAD . "arquivos/" . $download->nm_path;

                            if (!is_dir($pathCompleta)) {
                                mkdir($pathCompleta, 0777, true);
                            }
    
                            $up->upload($tmp, $to);
                            $download->save();
    
                            $this->redir(array("modulo" => "lo", "controller" => "download", "action" => "listar"), array("msg" => "success"));
                        } catch (Exception $e) {
                            $this->redir(array("modulo" => "lo", "controller" => "download", "action" => "listar"), array("exception" => "No foi possvel armazenar o arquivo."));
                        }
                    }
                } else {
                    $this->redir(array("modulo" => "lo", "controller" => "download", "action" => "listar"), array("exception" => "No foi possvel salvar o arquivo, pois o limite de downloads foi atingido, para esse empreendimento."));
                }
            }
        }

        $empreendimentos = Empreendimento::getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento ASC')->query()->fetchAll();

        $this->set("empreendimentos", $empreendimentos);
        $this->display('form');
    }

    public function editarAction()
    {
        $download = $this->tb_download->fetchRow("id = " . $_GET["id"]);
        if ($this->_isPost) {
            $download->id_emp = $_POST["id_emp"];
            $download->nm_download = $_POST["nome_arquivo"];
            $download->save();

            $this->redir(array("modulo" => "lo", "controller" => "download", "action" => "listar"), array("msg" => "success"));
        }
        $tb_emp = new Empreendimento();
        $this->set("empreendimentos", $tb_emp->fetchAll(null, "nm_empreendimento")->toArray());
        $this->set('download', $download->toArray());
        $this->display('form');
    }

    public function deletarAction()
    {
        $id = $_GET['id'];
        $download = $this->tb_download->fetchRow("id = " . $id);
        $this->tb_download->delete($this->tb_download->getAdapter()->quoteInto('id = ?', $id));

        $up = new Filesystem();
        if ($download->nm_path) {
            $caminho = explode('/', $download->nm_path);
            $dir = DIRETORIO_DOWNLOAD . "cliente/" . $path . "arquivos/" . $caminho[1];
            $up->delete($dir);
        }

        $this->redir(array("modulo" => "lo", "controller" => "download", "action" => "listar"), array("msg" => "success"));
    }

    private function validarForm()
    {
        if (count($_POST) && is_array($_POST)) {
            if ($_POST['nome_arquivo'] == "") {
                $msg = "Informe algum nome para o arquivo.";
                $this->_helper->addMensagem('fail', $msg);
            }
            //Testa a extenso do arquivo enviado
            $extensao = explode('.', $_FILES['arquivo']['name']);
            if (!in_array(end($extensao), array('pdf', 'txt', 'docx', 'doc'))) {
                $msg = "Extenso do arquivo invlida.";
                $this->_helper->addMensagem('fail', $msg);
            }

            if ($_FILES['size'] > (1024 * 1024 * 10)) {
                $msg = "Tamanho do arquivo invlido.";
                $this->_helper->addMensagem('fail', $msg);
            }

            if ($_POST['id_emp'] == "") {
                $msg = "Informe algum empreendimento.";
                $this->_helper->addMensagem('fail', $msg);
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

}

?>
