<?php

class CorretorController extends Controller
{

    private $pessoa_fisica;
    private $corretorEmpreendimento;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->corretorEmpreendimento = new Corretor_Empreendimento();
        //Setando objeto do tipo Tabela pre�o!
        $this->tabelaPreco = new TabelaPreco();
        $this->pessoa_fisica = new Pessoa_Fisica();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "lo", "controller" => "corretor", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = Corretor_Empreendimento::findLista($_POST);
            $totalItens = Corretor_Empreendimento::findLista($_POST, true);

            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id_corretor_empreendimento'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $title = "return confirm('Tem certeza que deseja excluir o corretor " . $item['nm_pessoa'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $item['id_corretor_empreendimento'] . '" data-toggle="tooltip" title="EXCLUIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                //Flag ativo/inativo
                if ($item['fl_ativo'] == '1') {
                    $status = '<div align="center"><span class="label label-success">Ativo</span></div>';
                } else {
                    $status = '<div align="center"><span class="label label-danger">Inativo</span></div>';
                }

                $lista[] = array(
                    'empreendimento' => utf8_encode($item['nm_empreendimento']),
                    'corretor' => utf8_encode($item['nm_pessoa']),
                    'imobiliaria' => utf8_encode($item['nm_fantasia']),
                    'status' => '<div align="center">'.$status.'</div>',
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalItens),
                'recordsFiltered' => count($totalItens),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarCorretor')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'corretor', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $empreendimentos = Empreendimento::getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }
        
        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimentos);

        if ($this->_isPost) {
            if ($this->validar()) {
                try {                
                    foreach ($_POST['hempreendimento_corretor'] as $corretorEmpreendimentoIndice) {
                        $corretorEmpreendimento = $this->corretorEmpreendimento->createRow();
                    
                        $corretorEmpreendimento->id_corretor = $_POST['corretor_pessoa_fisica'];
                        $corretorEmpreendimento->id_empreendimento = $corretorEmpreendimentoIndice;
                        
                        $corretorEmpreendimento->nr_creci = $_POST['creci'];
                        $corretorEmpreendimento->nr_creci_pj = ($_POST['cdCreciPJ']) ? $_POST['cdCreciPJ'] : null;
                        $corretorEmpreendimento->id_imobiliaria = ($_POST['himobiliaria_corretor']) ? $this->_helper->filters($_POST['himobiliaria_corretor']) : null;
                        $corretorEmpreendimento->pc_comissao = ($_POST['pcComissao']) ? Helper::getInputMoney($_POST['pcComissao']) : null;
                        // Inclus�o dentro do banco no campo id_tabela_preco
                        $corretorEmpreendimento->id_tabela_preco = ($_POST['tpComissao'] == 'PT') ? $_POST['tb_precos'] : null;
                        $corretorEmpreendimento->tp_comissao = ($_POST['tpComissao']) ? $_POST['tpComissao'] : null;
                        $corretorEmpreendimento->fl_parcela_normal = in_array('N', $_POST['tpParcelas']) ? '1' : '0';
                        $corretorEmpreendimento->fl_parcela_sinal = in_array('S', $_POST['tpParcelas']) ? '1' : '0';
                        $corretorEmpreendimento->fl_parcela_intercalada = in_array('I', $_POST['tpParcelas']) ? '1' : '0';
                        $corretorEmpreendimento->fl_parcela_chave = in_array('C', $_POST['tpParcelas']) ? '1' : '0';
                        $corretorEmpreendimento->fl_parcela_negociada = in_array('G', $_POST['tpParcelas']) ? '1' : '0';
                        $corretorEmpreendimento->fl_parcela_quitacao = in_array('Q', $_POST['tpParcelas']) ? '1' : '0';
                        $corretorEmpreendimento->fl_ativo = $_POST['flStatus'];
                        $corretorEmpreendimento->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                        $corretorEmpreendimento->save();
                    }

                    $this->redir(array("modulo" => "lo", "controller" => "corretor", "action" => "listar"), array("msg" => "success"));
                } catch (Exception $e) {
                    $this->redir(array("modulo" => "lo", "controller" => "corretor", "action" => "listar"), array("exception" => "No foi possvel realizar a operao."));
                }
            }
        }
        $this->display("form");
    }

    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'editarCorretor')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'corretor', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        /*buscar somente os empreendimentos do corretor*/
        $empreendimentos = Empreendimento::getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        // //verifica se o usuario tem o perfil de usuario de empreendimento
        // if ($_SESSION['usuario']) {
        //     try {
        //         $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
        //         $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
        //         if (count($ids)) {
        //             $id = implode(',', $ids);
        //             $empreendimentos->where("e.id IN({$id})");
        //         } else {
        //             $empreendimentos->where("1");
        //         }
        //     } catch (Exception $e) {
        //     }
        // }
        // $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();
        $empreendimentos = $this->corretorEmpreendimento->fetchRow('id_corretor_empreendimento = ' . $_GET['id']);

        $empreendimentos = Empreendimento::getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO))
            ->where('e.id IN ("' . $empreendimentos['id_empreendimento'] . '")')
            ->order('e.nm_empreendimento')
            ->query()->fetchAll();
        
        $this->set('empreendimentos', $empreendimentos);

        $corretorEmpreendimento = Corretor_Empreendimento::findCorretorEmpreendimentoDados($_GET['id']);
        $corretorEmpreendimento['tiposParcelas'] = Corretor_Empreendimento::getArrayTiposParcela($_GET['id']);

        $this->set('dados', $corretorEmpreendimento);
        // Faz a busca na tabela pre�o pelo campo do id_empreendimento que existe tamb�m no corretor!
        $tabelaPreco = $this->tabelaPreco->fetchAll('id_empreendimento = ' . $corretorEmpreendimento['id_empreendimento']);
        $this->set('tabelaPreco', $tabelaPreco);
        
        if ($this->_isPost) {
            if ($this->validar(true)) {
                try {

                    $corretorEmpreendimento = $this->corretorEmpreendimento->fetchRow('id_corretor_empreendimento = ' . $_GET['id']);

                    $listaCorretores[] = $corretorEmpreendimento['id_empreendimento'];
                    
                    //cria uma lista de empreendimentos que foram removidos do campo.
                    $empRemovidos = array_diff($listaCorretores, $_POST['hempreendimento_corretor']);
                    $empRemovidos = implode('","', $empRemovidos);
                    
                    $corretorEmpreendimento = $this->corretorEmpreendimento->delete('id_corretor = "' . $_POST['corretor_pessoa_fisica'] . '" AND id_empreendimento IN ("' . $empRemovidos . '")');
                    
                    foreach ($_POST['hempreendimento_corretor'] as $corretorEmpreendimentoIndice) {
                        
                        $corretorEmpreendimento = $this->corretorEmpreendimento->fetchRow('id_empreendimento = "' . $corretorEmpreendimentoIndice . '" AND id_corretor = "' . $_POST['corretor_pessoa_fisica'] . '"');
                        
                        if (!$corretorEmpreendimento) {
                            $corretorEmpreendimento = $this->corretorEmpreendimento->createRow();
                        }

                        $corretorEmpreendimento->id_corretor = $_POST['corretor_pessoa_fisica'];
                        $corretorEmpreendimento->id_empreendimento = $corretorEmpreendimentoIndice;
                        $corretorEmpreendimento->id_imobiliaria = ($_POST['himobiliaria_corretor'] != '')? $_POST['himobiliaria_corretor'] : null;
                        $corretorEmpreendimento->nr_creci = $_POST['creci'];
                        $corretorEmpreendimento->nr_creci_pj = ($_POST['cdCreciPJ'])? $_POST['cdCreciPJ'] : null;
                        $corretorEmpreendimento->pc_comissao = ($_POST['pcComissao']) ? Helper::getInputMoney($_POST['pcComissao']) : null;
                        // Incluso dentro do banco no campo id_tabela_preco
                        $corretorEmpreendimento->id_tabela_preco = ($_POST['tpComissao'] == 'PT') ? $_POST['tb_precos'] : null;
                        $corretorEmpreendimento->tp_comissao = ($_POST['tpComissao']) ? $_POST['tpComissao'] : null;
                        $corretorEmpreendimento->fl_parcela_normal = in_array('N', $_POST['tpParcelas']) ? '1' : '0';
                        $corretorEmpreendimento->fl_parcela_sinal = in_array('S', $_POST['tpParcelas']) ? '1' : '0';
                        $corretorEmpreendimento->fl_parcela_intercalada = in_array('I', $_POST['tpParcelas']) ? '1' : '0';
                        $corretorEmpreendimento->fl_parcela_chave = in_array('C', $_POST['tpParcelas']) ? '1' : '0';
                        $corretorEmpreendimento->fl_parcela_negociada = in_array('G', $_POST['tpParcelas']) ? '1' : '0';
                        $corretorEmpreendimento->fl_parcela_quitacao = in_array('Q', $_POST['tpParcelas']) ? '1' : '0';
                        $corretorEmpreendimento->fl_ativo = $_POST['flStatus'];
                        $corretorEmpreendimento->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                        
                        $corretorEmpreendimento->save();
                    }

                    $this->redir(array("modulo" => "lo", "controller" => "corretor", "action" => "listar"), array("msg" => "success"));
                } catch (Exception $e) {
                    $this->redir(array("modulo" => "lo", "controller" => "corretor", "action" => "listar"), array("exception" => "No foi possvel realizar a operao."));
                }
            }
        }
        $this->display("form");
    }

    public function deletarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'deletarCorretor')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'corretor', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        try {
            $corretor = $this->corretorEmpreendimento->fetchRow('id_corretor_empreendimento = ' . $_GET['id'])->toArray();
            $contratos = Contrato::findByIdCorretor($corretor['id_corretor'], $corretor['id_empreendimento']);
            if (count($contratos) == 0) {
                $this->corretorEmpreendimento->delete('id_corretor_empreendimento = "' . $_GET['id'] . '"');
                $this->redir(array("modulo" => "lo", "controller" => "corretor", 'action' => 'listar'), array("msg" => "success"));
            } else {
                $this->redir(array("modulo" => "lo", "controller" => "corretor", 'action' => 'listar'), array("exception" => "No foi possvel excluir o corretor pois ele possui contratos relacionados."));
            }
        } catch (Exception $e) {
            $this->redir(array("modulo" => "lo", "controller" => "corretor", 'action' => 'listar'), array("exception" => "No foi possvel realizar a operao."));
        }
    }

    private function validar($edit = false)
    {
        $campos = array("creci", "corretor_pessoa_fisica");

        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "corretor_pessoa_fisica" :
                        $msg = "A pessoa deve ser selecionada.";
                        break;
                    case "creci" :
                        $msg = "O campo CRECI deve ser preenchido.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);

            }
        }

        if ($_POST['hempreendimento_corretor'] == null ){
            $msg = "O empreendimento deve ser selecionado.";
            $this->_helper->addMensagem($_POST['hempreendimento_corretor'], $msg);
        }
        //Inserido valida��o especifica para campo de tabela pre�o, pois � obrigat�rio
        if ($_POST['tpComissao'] == 'PT' && $_POST['tb_precos'] == '')
            $this->_helper->addMensagem('tb_precos', 'O campo Tabela de Preo  obrigatrio');


        foreach ($_POST['hempreendimento_corretor'] as $corretorEmpreendimentoIndice) {    
            if (!$edit)
                if ($_POST['corretor_pessoa_fisica'] && $corretorEmpreendimentoIndice) {
                    if (Corretor_Empreendimento::verificaByPessoaEmpreendimento($_POST['corretor_pessoa_fisica'], $corretorEmpreendimentoIndice))
                        $this->_helper->addMensagem('corretor_pessoa_fisica', 'O corretor j est associado ao empreendimento.');
                }
        }        

        return !(count($this->_helper->getMensagens()) > 0);
    }
    //A��o para o ajax, para setar informa��es da tabela pre�o no adicionar!
    public function tabelaPrecoByEmpreendimentoAction()
    {
        $ids = str_replace(',', '","', $_POST['empreendimento']);
       
        // Faz a busca na tabela pre�o pelo campo do id_empreendimento que existe tamb�m no corretor!
        $tabelaPrecos = $this->tabelaPreco->fetchAll('id_empreendimento IN ("' . $ids . '")');
        //Gera a lista que sr� passada para o ajax e fazer a lista na tela de adicionar!
        $lista = array();
        foreach ($tabelaPrecos as $tabelaPreco) {
            $lista[] = array('id' => $tabelaPreco['id_tabela_preco'], 'text' => utf8_encode($tabelaPreco['nm_tabela']));
        }

        echo json_encode($lista);
    }

    public function findPessoaFisicaAction()
    {
        //Buscando a lista de lotes para exibir na tela
        $listaPessoa = Pessoa::findPessoaFisicaByNome(utf8_decode($_GET['term']));
        $dados = array();
        foreach ($listaPessoa as $pessoa) {
            $dados[] = array('text' => utf8_encode($pessoa['nm_pessoa']) . ' (' . $pessoa['nr_cpf'] . ')', 'value' => $pessoa['idPessoa']);
        }
        echo json_encode($dados);
    }
}