<?php

class CidadeController extends Controller
{

    public function __construct($request)
    {
        $this->tb_cidade = new Cidade();
        parent::__construct($request);
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "lo", "controller" => "cidade", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = $this->tb_cidade->getAdapter()->select()
                ->from(array("c" => TB_CIDADE), array('*'))
                ->order('c.nome')
                ->query()->fetchAll();

            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $title = "return confirm('Tem certeza que deseja excluir a cidade " . $item['nome'] . " - " . $item['uf'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $item['id'] . '" data-toggle="tooltip" title="EXCLUIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                $lista[] = array(
                    'nome' => utf8_encode($item['nome']),
                    'uf' => utf8_encode($item['uf']),
                    'acoes' => utf8_encode($acoes)
                );
            }

            echo json_encode(array(
                'draw' => 1,
                'recordsTotal' => count($lista),
                'recordsFiltered' => count($lista),
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        $this->set("ufs", Db_TabelaAgrupada::findByTabelaId(1));

        if ($this->_isPost && $this->validar()) {
            $c = new Db_Cidade();
            $c->setNome(ucfirst($_POST["nome"]));
            $c->setUf($_POST["uf"]);
            $c->setLog(Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y') . ' - i');

            try{
                $c->save();
                $this->redir(array("modulo" => "lo", "controller" => "cidade", "action" => "listar"), array("msg" => "success"));
            } catch (Exception $e){
                $this->redir(array("modulo" => "lo", "controller" => "cidade", "action" => "listar"), array("exception" => "Não foi possível realizar a operação: ".$e->getMessage()));
            }
        }

        $this->display("form");
    }

    public function editarAction()
    {
        $this->set("ufs", Db_TabelaAgrupada::findByTabelaId(1));
        $this->set("cidade", Db_Cidade::find($_GET["id"])->toArray());
        $this->display("form");

        if ($this->_isPost && $this->validar()) {
            $c = Db_Cidade::find($_GET['id']);
            $c->setNome(ucfirst($_POST["nome"]));
            $c->setUf($_POST["uf"]);
            $c->setLog(Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y') . ' - u');

            try{
                $c->save();
                $this->redir(array("modulo" => "lo", "controller" => "cidade", "action" => "listar"), array("msg" => "success"));
            } catch (Exception $e){
                $this->redir(array("modulo" => "lo", "controller" => "cidade", "action" => "listar"), array("exception" => "Não foi possível realizar a operação: ".$e->getMessage()));
            }
        }
    }

    private function validar()
    {
        $campos = array("nome", "uf");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "nome" :
                        $msg = "O campo nome deve ser preenchido.";
                        break;
                    case "uf" :
                        $msg = "O campo uf deve ser preenchido.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function deletarAction()
    {
        try {
            Db_Cidade::delete($_GET["id"]);
            $this->redir(array("modulo" => "lo", "controller" => "cidade", "action" => "listar"), array("msg" => "success"));
        } catch (Exception $e) {
            $this->redir(array("modulo" => "lo", "controller" => "cidade", "action" => "listar"), array("exception" => "Cidade possui registros."));
        }

    }
}
