<?php

class BancoController extends Controller
{
    protected $empreendimentos;
    private $bancos;
    private $empreendimento;
    private $layout;
    public function __construct($request)
    {
        parent::__construct($request);
        $this->bancos = new Banco();
        $this->empreendimento = new Empreendimento();
        $this->layout = new Layout();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "lo", "controller" => "banco", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = (new BancoConta())->findLista($_POST);
            $listaItemCount = (new BancoConta())->findLista($_POST, true);

            $lista = [];
            foreach ($listaItem as $item) {

                $acoes = '<div style="width: 105px"></div><div align="center" style="width: 105%;">';
                //Visualizar
                $acoes .= '<span data-toggle="modal" data-target=".modalVisualizar"><button type="button" 
                    value="' . $item['id_banco_conta'] . '" data-toggle="tooltip" title="VISUALIZAR" 
                    class="btn btn-default btn-sm btn-visualizar" style="margin-right:5px"><i class="fa fa-eye"></i>
                    </button></span>';
                //Editar
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' .
                    $item['id_banco_conta'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" 
                    style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                //Deletar
                $title = "return confirm('Tem certeza que deseja deletar a conta: " . $item['descricao'] .
                    ' - Ag: ' . $item['nr_agencia'] . '-' . $item['nr_agencia_dv'] . " - Cc: ".$item['nr_conta']
                    . '-' . $item['nr_conta_dv']."?')";
                $acoes .= '<a onclick="' . $title . '"  href="?m=' . $this->modulo . '&c=' .
                    $this->controller . '&a=deletar&id=' . $item['id_banco_conta'] . '" data-toggle="tooltip" title="DELETAR" 
                    class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';

                //Flag ativo/inativo
                if ($item['fl_ativo'] == '1') {
                    $status = '<div align="center"><span class="label label-success">Ativo</span></div>';
                } else {
                    $status = '<div align="center"><span class="label label-danger">Inativo</span></div>';
                }

                $dvAgencia = ($item['nr_agencia_dv'] != null)?'-'.$item['nr_agencia_dv']:'';
                $dvConta = ($item['nr_conta_dv'] != null)?'-'.$item['nr_conta_dv']:'';

                //Busca os empreendimento associados a cada banco.
                $empreendimentos = $this->empreendimento->getAdapter()->select()
                    ->from(array('e' => TB_EMPREENDIMENTO), 'nm_empreendimento')
                    ->join(array('b' => TB_BANCO), 'e.id = b.id_empreendimento', null)
                    ->where('b.id_banco_conta = ' . $item['id_banco_conta'])
                    ->query()->fetchAll();

                $emp = array();

                foreach ($empreendimentos as $aux) {
                    $emp[] = $aux['nm_empreendimento'];
                }

                $lista[] = [
                    'codigo' => '<div align="center">'.$item['cd_banco'].'</div>',
                    'empreendimento' => '<div align="left">'. utf8_encode(implode(' - ', $emp)) .'</div>',
                    'banco' => '<div align="center">'. utf8_encode($item['descricao']) .'</div>',
                    'cedente' => '<div align="left">'. utf8_encode($item['nm_cedente']) .'</div>',
                    'agencia' => '<div align="center">'.$item['nr_agencia'] . $dvAgencia .'</div>',
                    'conta' => '<div align="center">'.$item['nr_conta'] . $dvConta .'</div>',
                    'status' => '<div align="center">'.$status.'</div>',
                    'acoes' => utf8_encode($acoes)
                ];
            }
            echo json_encode([
                'draw' => $_POST['draw'],
                'recordsTotal' => count($listaItemCount),
                'recordsFiltered' => count($listaItemCount),
                'data' => $lista
            ]);
        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarBanco')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'banco', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc� n�o tem permiss�o para acessar essa funcionalidade.'));
        }

        $listaLayoutRem = $this->layout->getListaRemessaLayoutBanco();

        $this->set('listaLayoutsRem', $listaLayoutRem);
        $listaLayoutRet = $this->layout->getListaRetornoLayoutBanco();
        $this->set('listaLayoutsRet', $listaLayoutRet);
        //Setando o Select com o tipo de Layout API
         $listaLayoutApi = $this->layout->getListaApiLayoutBanco();
         $this->set('listaLayoutsApi', $listaLayoutApi);
        $agrupadaBancos = (new TabelaAgrupada())->fetchAll('idTabela = "9"', 'descricao');
        $this->set('agrupadaBancos', $agrupadaBancos);

        if ($this->_isPost && $this->validarAction()) {
            try {
                $db = Zend_Db_Table::getDefaultAdapter();
                $db->beginTransaction();

                $banco = (new BancoConta())->createRow();
                $banco->cd_banco = $this->_helper->filters($_POST['cdBanco']);
                $banco->cod_layout_rem = $this->_helper->filters($_POST['cod_layout_rem']);
                $banco->cod_layout_ret = $this->_helper->filters($_POST['cod_layout_ret']);
                // $banco->cod_layout_api = $this->_helper->filters($_POST['cod_layout_api']);
                $banco->nr_conta = $this->_helper->filters($_POST['nrConta']);
                $banco->nr_conta_dv = $this->_helper->filters($_POST['nrContaDv']);
                $banco->nr_agencia = $this->_helper->filters($_POST['nrAgencia']);
                $banco->nr_agencia_dv = $this->_helper->filters($_POST['nrAgenciaDv']);
                $banco->nr_cedente = $this->_helper->filters($_POST['nrCedente']);
                $banco->nr_cooperativa = $this->_helper->filters($_POST['nr_cooperativa']);
                $banco->nm_cedente = $this->_helper->filters($_POST['nmCedente']);
                // $banco->cod_cedente_api = $this->_helper->filters($_POST['codCedenteApi']);
                $banco->cpf_cedente = $this->_helper->filters($_POST['cpfCedente']);
                $banco->cnpj_cedente = $this->_helper->filters($_POST['cnpjCedente']);
                $banco->ds_especie = $this->_helper->filters($_POST['dsEspecie']);
                $banco->nr_carteira = $this->_helper->filters($_POST['nrCarteira']);
                $banco->nr_carteira_variacao = $this->_helper->filters($_POST['nrCarteiraVariacao']);
                $banco->nr_dias_permanencia = $this->_helper->filters($_POST['nrDiasPermanencia']);

                $banco->fl_ativo = $this->_helper->filters($_POST['flStatus']);
                $banco->fl_boleto = "2";
                $banco->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                $banco->save();

                $db->commit();

                $this->redir(array("modulo" => "lo", "controller" => "banco", 'action' => 'listar'), array('msg' => 'success'));
            } catch (Exception $e) {
                $this->redir(array("modulo" => "lo", "controller" => "banco", 'action' => 'adicionar'), array('exception' => $e->getMessage()));
            }
        }
        $this->display('form');
    }

    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'editarBanco')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'banco', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc� n�o tem permiss�o para acessar essa funcionalidade.'));
        }

        $listaLayoutRem = $this->layout->getListaRemessaLayoutBanco();
        $this->set('listaLayoutsRem', $listaLayoutRem);
        $listaLayoutRet = $this->layout->getListaRetornoLayoutBanco();
        $this->set('listaLayoutsRet', $listaLayoutRet);
        $listaLayoutApi = $this->layout->getListaApiLayoutBanco();
        $this->set('listaLayoutsApi', $listaLayoutApi);

        $bancoConta = (new BancoConta())->getBancoContas($this->_helper->filters($_GET['id']));

        if (!$bancoConta) {
            $this->redir(array("modulo" => "lo", "controller" => "banco", "action" => "listar"), array("exception" => "Conta n�o encontrada!"));
        }

        $this->set('bancoConta', $bancoConta);

        $agrupadaBancos = (new TabelaAgrupada())->fetchAll('idTabela = "9"');
        $this->set('agrupadaBancos', $agrupadaBancos);

        $bancos = (new Banco())->getBanco(false, $this->_helper->filters($_GET['id']));
        $this->set('bancos', $bancos);

        if ($this->_isPost && $this->validarAction()) {
            try {
                $db = Zend_Db_Table::getDefaultAdapter();
                $db->beginTransaction();

                $bancoConta = (new BancoConta())->fetchRow('id_banco_conta = '.$this->_helper->filters($_GET['id']));
                $bancoConta->cd_banco = $this->_helper->filters($_POST['cdBanco']);
                $bancoConta->cod_layout_rem = $this->_helper->filters($_POST['cod_layout_rem']);
                $bancoConta->cod_layout_ret = $this->_helper->filters($_POST['cod_layout_ret']);
                $bancoConta->cod_layout_api = $this->_helper->filters($_POST['cod_layout_api']);
                $bancoConta->nr_conta = $this->_helper->filters($_POST['nrConta']);
                $bancoConta->nr_conta_dv = $this->_helper->filters($_POST['nrContaDv']);
                $bancoConta->nr_agencia = $this->_helper->filters($_POST['nrAgencia']);
                $bancoConta->nr_agencia_dv = $this->_helper->filters($_POST['nrAgenciaDv']);
                $bancoConta->nr_cooperativa = $this->_helper->filters($_POST['nr_cooperativa']);
                $bancoConta->nr_cedente = $this->_helper->filters($_POST['nrCedente']);
                $bancoConta->nm_cedente = $this->_helper->filters($_POST['nmCedente']);
                $bancoConta->cod_cedente_api = $this->_helper->filters($_POST['codCedenteApi']);
                $bancoConta->cpf_cedente = $this->_helper->filters($_POST['cpfCedente']);
                $bancoConta->cnpj_cedente = $this->_helper->filters($_POST['cnpjCedente']);
                $bancoConta->ds_especie = $this->_helper->filters($_POST['dsEspecie']);
                $bancoConta->nr_carteira = $this->_helper->filters($_POST['nrCarteira']);
                $bancoConta->nr_carteira_variacao = $this->_helper->filters($_POST['nrCarteiraVariacao']);
                $bancoConta->nr_dias_permanencia = $this->_helper->filters($_POST['nrDiasPermanencia']);
                $bancoConta->fl_ativo = $this->_helper->filters($_POST['flStatus']);
                if (Login::isSuper()) {
                    $bancoConta->fl_boleto = $_POST['fl_boleto'];
                }
                $bancoConta->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                $bancoConta->save();

                foreach ($_POST['idEmpreendimento'] as $idEmp) {
                    $banco = (new Banco())->fetchRow('id_banco_conta = '.$this->_helper->filters($_GET['id']).' AND id_empreendimento = '.$idEmp);
                    $cloneBanco = clone $banco;
                    // Campos temporarios que ir�o ser removidos da removidos

                    $banco->conta_corrente = $bancoConta->nr_conta;
                    $banco->conta_corrente_dv = $bancoConta->nr_conta_dv;
                    $banco->agencia = $bancoConta->nr_agencia;
                    $banco->agencia_dv = $bancoConta->nr_agencia_dv;
                    $banco->cd_cedente = $bancoConta->nr_cedente;
                    $banco->nm_cedente = $bancoConta->nm_cedente;
                    $banco->cnpj_cedente = $bancoConta->cnpj_cedente;
                    $banco->cpf_cedente = $bancoConta->cpf_cedente;
                    $banco->especie_documento = $bancoConta->ds_especie;
                    $banco->carteira = $bancoConta->nr_carteira;
                    $banco->carteira_variacao = $bancoConta->nr_carteira_variacao;
                    $banco->qt_dias_permanencia = $bancoConta->nr_dias_permanencia;

                    // Campos que permanecer�o na tabela
                    $banco->tp_juros = $this->_helper->filters($_POST['tpJuros_'.$idEmp]);
                    $banco->tp_multa = $this->_helper->filters($_POST['tpMulta_'.$idEmp]);

                    if ($banco->tp_juros == 'S') {
                        $banco->juros = null;
                        if ($bancoConta['cd_banco'] == '274') {
                            $banco->jurosMensal = null;
                        }
                    } else {
                        $banco->juros = $this->_helper->filters($_POST['juros_'.$idEmp], 'money');
                        /**
                         * O banco Grafeno s recebe juros ao ms, porm nosso sistema utiliza juros ao dia.
                         * Para contornar esse problema foi implementado um novo campo na assossiao de empreendimentos,
                         * somente para esse banco, onde o usurio informa o valor do juros ao ms.
                         * Esse valor de juros ao ms, ser enviado para a API do banco Grafeno somente na emisso de boletos,
                         * quando for feita a baixa da parcela atravz do webhook, a porcentagem de juros utilizado para calcular
                         * o valor do juros em reais,  o valor contido na coluna juros (juros ao dia) da tabela BANCO.
                         */
                        if ($bancoConta['cd_banco'] == '274') {
                            $banco->jurosMensal = $this->_helper->filters($_POST['jurosMensal'], 'money');
                        }
                    }

                    if ($banco->tp_multa == 'S') {
                        $banco->multa = null;
                    } else {
                        $banco->multa = $this->_helper->filters($_POST['multa_'.$idEmp], 'money');
                    }

                    $banco->msg_boleto = $this->_helper->filters($_POST['dsBoleto1_'.$idEmp]);

                    $banco->msg_adicional = $this->_helper->filters($_POST['dsBoleto2_'.$idEmp]);
                    // Define o status da associa��o
                
                    
                    $banco->fl_ativo_banco = $this->_helper->filters('0');
                    $banco->fl_ativo_boleto = $this->_helper->filters('0');
                    $banco->fl_ativo_remessa = $this->_helper->filters('0');
                    $banco->fl_ativo_baixamanual = $this->_helper->filters('0');

                    foreach ($_POST['status_'.$idEmp] as $status) {
                        switch($status){
                            case 'C':
                                $banco->fl_ativo_banco = $this->_helper->filters('1');
                                break;
                            case 'B':
                                $banco->fl_ativo_boleto = $this->_helper->filters('1');
                                break;
                            case 'R':
                                $banco->fl_ativo_remessa = $this->_helper->filters('1');
                                break;
                            case 'BM':
                                $banco->fl_ativo_baixamanual = $this->_helper->filters('1');
                                break;
                        }
                    }
                    $banco->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');

                    //Compara os arrays para saber quais dados foram alterados
                    $diff_result[$idEmp] = array_diff_assoc($banco->toArray(), $cloneBanco->toArray());
                    //Remove os registros de 'log' do array pois o mesmo sempre est� modificado por culpa dos segundos do hor�rio salvo
                    unset($diff_result[$idEmp]['log']);

                    foreach ($diff_result[$idEmp] as $key => $result) {
                        //Renomeia as colunas mais ileg�veis ao usu�rio para o log
                        switch ($key) {
                            case 'tp_multa':     $tipo = 'tipo multa'; break;
                            case 'tp_juros':     $tipo = 'tipo juros'; break;
                            case 'nm_cedente':   $tipo = 'nome cedente'; break;
                            case 'fl_ativo':     $tipo = 'status (1 = ativo, 0 = inativo)'; break;
                            case 'cd_cedente':   $tipo = 'cedente'; break;
                            case 'cnpj_cedente': $tipo = 'cnpj'; break;
                            default:             $tipo = $key;
                        }
                        if (!$result) $result = '0';
                        $logs[$idEmp][] = $tipo . ' de ' . $cloneBanco[$key] . ' para ' . $result;
                    }

                    $banco->save();
                }

                //Adiciona o log
                foreach ($logs as $key => $result) {
                    (new RelEmpreendimento())->saveContato(14, date('Y-m-d'), $key, 'Log: Banco Alterado - ' . implode(', ',$result));
                }

                $db->commit();
                $this->redir(array("modulo" => "lo", "controller" => "banco", "action" => "listar"), array("msg" => "success"));
            } catch (Exception $e) {
                $this->_helper->addMensagem('danger', "Ocorreu algum erro, entre em contato com suporte. ".$e->getMessage());
            }
        }
        $this->display('form');
    }

    public function associarEmpreendimentoAction()
    {
        $bancoContas = (new BancoConta())->getBancoContas();
        $this->set('bancoContas', $bancoContas);

        $empreendimentos = Empreendimento::getEmpreendimentos();
        $this->set('empreendimentos', $empreendimentos);

        if ($this->_isPost && $this->validarAssociarAction()) {

            try {
                $bancoConta = (new BancoConta())->fetchRow('id_banco_conta = '.$_POST['idBancoConta']);

                //Inicia transa��o
                $db = Zend_Db_Table::getDefaultAdapter();
                $db->beginTransaction();

                $banco = (new Banco())->createRow();
                $banco->id_empreendimento = $this->_helper->filters($_POST['idEmpreendimento']);
                $banco->id_banco_conta = $this->_helper->filters($_POST['idBancoConta']);
                $banco->cd_banco = $bancoConta['cd_banco'];
              //  $banco->cod_layout_rem = $this->_helper->filters($_POST['cod_layout_rem']);
              //  $banco->cod_layout_ret = $this->_helper->filters($_POST['cod_layout_ret']);
                $banco->conta_corrente = $bancoConta['nr_conta'];
                $banco->conta_corrente_dv = $bancoConta['nr_conta_dv'];
                $banco->agencia = $bancoConta['nr_agencia'];
                $banco->agencia_dv = $bancoConta['nr_agencia_dv'];
                $banco->cd_cedente = $bancoConta['nr_cedente'];
                $banco->nm_cedente = $bancoConta['nm_cedente'];
                $banco->cnpj_cedente = $bancoConta['cnpj_cedente'];
                $banco->cpf_cedente = $bancoConta['cpf_cedente'];
                $banco->especie_documento = $bancoConta['ds_especie'];
                $banco->carteira = $bancoConta['nr_carteira'];
                $banco->carteira_variacao = $bancoConta['nr_carteira_variacao'];
                $banco->tp_multa = $this->_helper->filters($_POST['tpMulta']);
                $banco->tp_juros = $this->_helper->filters($_POST['tpJuros']);

                if ($banco->tp_multa == 'S') {
                    $banco->multa = null;
                } else {
                    $banco->multa = $this->_helper->filters($_POST['multa'], 'money');
                }

                if ($banco->tp_juros == 'S') {
                    $banco->juros = null;
                    if ($bancoConta['cd_banco'] == '274') {
                        $banco->jurosMensal = null;
                    }
                } else {
                    $banco->juros = $this->_helper->filters($_POST['juros'], 'money');
                    /**
                     * O banco Grafeno s recebe juros ao ms, porm nosso sistema utiliza juros ao dia.
                     * Para contornar esse problema foi implementado um novo campo na assossiao de empreendimentos,
                     * somente para esse banco, onde o usurio informa o valor do juros ao ms.
                     * Esse valor de juros ao ms, ser enviado para a API do banco Grafeno somente na emisso de boletos,
                     * quando for feita a baixa da parcela atravz do webhook, a porcentagem de juros utilizado para calcular
                     * o valor do juros em reais,  o valor contido na coluna juros (juros ao dia) da tabela BANCO.
                     */
                    if ($bancoConta['cd_banco'] == '274') {
                        $banco->jurosMensal = $this->_helper->filters($_POST['jurosMensal'], 'money');
                    }
                }

                $banco->msg_boleto = $this->_helper->filters($_POST['dsBoleto1']);
                $banco->msg_adicional = $this->_helper->filters($_POST['dsBoleto2']);
                $banco->qt_dias_permanencia = $bancoConta['nr_dias_permanencia'];
                $banco->fl_ativo_banco = $this->_helper->filters('0');
                $banco->fl_ativo_boleto = $this->_helper->filters('0');
                $banco->fl_ativo_remessa = $this->_helper->filters('0');
                $banco->fl_ativo_baixamanual = $this->_helper->filters('0');
                
                foreach ($_POST['status'] as $status) {
                    switch($status){
                        case 'C':
                            $banco->fl_ativo_banco = $this->_helper->filters('1');
                            break;
                        case 'B':
                            $banco->fl_ativo_boleto = $this->_helper->filters('1');
                            break;
                        case 'R':
                            $banco->fl_ativo_remessa = $this->_helper->filters('1');
                            break;
                        case 'BM':
                            $banco->fl_ativo_baixamanual = $this->_helper->filters('1');
                            break;
                    }
                }

                $banco->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                $banco->save();

                //Grava o log
                (new RelEmpreendimento())->saveContato(13, date('Y-m-d'), $_POST['idEmpreendimento'],
                'Log: Banco Cadastrado/Associado - Banco Conta(ID): '.$_POST['idBancoConta'].', Ag: '.$bancoConta['nr_agencia'].', C.C: '.$bancoConta['nr_conta'].', '.
                'com multa: '.$this->_helper->filters($_POST['multa'], 'money').($this->_helper->filters($_POST['tpMulta'])=='S'?'nenhuma':$this->_helper->filters($_POST['tpMulta'])).
                ', juros: '.$this->_helper->filters($_POST['juros'], 'money').($this->_helper->filters($_POST['tpJuros'])=='S'?'nenhum':$this->_helper->filters($_POST['tpJuros'])).
                ' e status: ' . ($_POST['flStatus'] == 1 ? 'ativo':'inativo') . '.');

                //Finaliza transa��o
                $db->commit();
                $this->redir(array("modulo" => "lo", "controller" => "banco", "action" => "listar"), array("msg" => "success"));
            } catch (PDOException $e) {
                $this->redir(array("modulo" => "lo", "controller" => "banco", "action" => "associarEmpreendimento"), array("exception" => "N�o foi poss�vel realizar a opera��o. Erro: " . $e->getMessage()));
            }
        }
        $this->display('associarEmpreendimento');
    }

    public function visualizarAction()
    {
        header("Content-type: text/html; charset=ISO-8859-1");

        $bancoConta = (new BancoConta())->getBancoContas($this->_helper->filters($_POST['id']));

        $this->set('bancoConta', $bancoConta);

        $bancos = (new Banco())->getBanco(false, $this->_helper->filters($_POST['id']));
        $this->set('bancos', $bancos);

        $this->display();
    }

    public function deletarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'deletarBanco')) {
            $this->redir(array('modulo' => 'lo', 'controller' => 'banco', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc� n�o tem permiss�o para acessar essa funcionalidade.'));
            exit;
        }

        try {
            $banco = (new Banco())->fetchRow('id_banco_conta = '.$this->_helper->filters($_GET['id']));
            if ($banco) {
                $this->redir(array("modulo" => "lo", "controller" => "banco", "action" => "listar"), array("exception" => "N�o � poss�vel deletar, pois tem empreendimento associado."));
            } else {
                (new BancoConta())->delete('id_banco_conta = '. $this->_helper->filters($_GET['id']));
                $this->redir(array("modulo" => "lo", "controller" => "banco", "action" => "listar"), array("msg" => "success"));
            }
        } catch (Exception $e) {
            $this->redir(array("modulo" => "lo", "controller" => "banco", "action" => "listar"), array("exception" => "Entre em contato com Suporte Acade: ".$e->getMessage()));
        }
    }

    public function desassociarAction()
    {
        try {
            $banco = (new Banco())->fetchRow('id_banco_conta = '.$this->_helper->filters($_GET['id']).' AND id_empreendimento = '.$_GET['idEmp']);

            $contrato = (new Contrato())->fetchRow('id_banco = '.$banco['id']);

            if ($contrato) {
                $this->redir(array("modulo" => "lo", "controller" => "banco", "action" => "editar"), array('id' => $_GET['id'], "exception" => "N�o � poss�vel remover o empreendimento pois tem contrato sendo utilizado pelo mesmo"));
            } else {
                //Grava o log
                (new RelEmpreendimento())->saveContato(14, date('Y-m-d'), $_GET['idEmp'],
                'Log: Banco Retirado - Banco Conta(ID): '.$banco['id'].', Ag: '.$banco['agencia'].', C.C: '.$banco['conta_corrente'].'.');
                $banco->delete();
                $this->redir(array("modulo" => "lo", "controller" => "banco", "action" => "editar"), array('id' => $_GET['id'], "msg" => "success"));
            }
        } catch (Exception $e) {
            $this->redir(array("modulo" => "lo", "controller" => "banco", "action" => "editar"), array('id' => $_GET['id'], "exception" => "N�o � poss�vel desassociar um banco em uso."));
        }
    }

    public function findBancoAction()
    {
        $tbBanco = new Banco();
        $listaBanco = $tbBanco->fetchAll('cd_banco = "'.$_POST['idBanco'].'"');
        $lista=[];
        foreach ($listaBanco as $banco) {
            $agencia = ($banco['agencia'])?'AND agencia = "'.$banco['agencia'].'"':'';
            $agencia_dv = ($banco['agencia_dv'])?'AND agencia_dv = "'.$banco['agencia_dv'].'"':'';
            $conta_corrente = ($banco['conta_corrente'])?'AND conta_corrente = "'.$banco['conta_corrente'].'"':'';
            $conta_corrente_dv = ($banco['conta_corrente_dv'])?'AND conta_corrente_dv = "'.$banco['conta_corrente_dv'].'"':'';

            $listaBancosIguais = $tbBanco->getAdapter()->select()
                ->from(array('b' => TB_BANCO), array('id', 'agencia', 'conta_corrente', 'cd_banco', 'agencia_dv', 'conta_corrente_dv', 'cd_cedente'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'b.id_empreendimento = e.id', array('e.nm_empreendimento'))
                ->join(array('a' => Db_TabelaAgrupada::TABLE_NAME), 'a.idCampo = b.cd_banco', array('a.descricao'))
                ->where('b.cd_banco = "'.$_POST['idBanco'].'" '.$agencia.' '.$agencia_dv.' '.$conta_corrente.' '.$conta_corrente_dv)
                ->order('descricao ASC')
                ->query()->fetchAll();

            if(count($listaBancosIguais) > 1) {
                $lista[] = array('id' => '', 'text' => '');
                foreach ($listaBancosIguais as $bancoigual) {
                    $agenciaDv = ($bancoigual['agencia_dv'])? '-' . $bancoigual['agencia_dv'] : '';
                    $contaDv = ($bancoigual['conta_corrente_dv'])? '-' . $bancoigual['conta_corrente_dv'] : '';
                    $cedenteDv = ($bancoigual['cd_cedente'])?  $bancoigual['cd_cedente'] : '';
                    $lista[] = array(
                        'id' => $bancoigual['id'],
                        'text' => utf8_encode($bancoigual['nm_empreendimento']) . ' - Ag: ' . $bancoigual['agencia'] . $agenciaDv . ' Cc: ' . $bancoigual['conta_corrente'] . $contaDv . ' Ced: ' . $cedenteDv,
                    );
                }
                break;
            }
        }
        echo json_encode($lista);
    }

    public function buscaEmpNaoAssociadosAction()
    {
        $empreendimentos = Empreendimento::getEmpreendimentos();

        foreach ($empreendimentos as $e) {
            $banco = (new Banco())->fetchRow('id_banco_conta = '.$_POST['idBancoConta'].' AND id_empreendimento = '.$e['id']);
            $disabled = ($banco)?true:false;
            $texto = ($banco)?' (Associado � conta)':'';
            $lista[] = [
                'id' => $e['id'],
                'text' => utf8_encode($e['nm_empreendimento'].$texto),
                'disabled' => $disabled,
            ];
        }
        echo json_encode($lista);
    }
    public function homologarAction()
    {

        $banco = new Banco();
        $bancoConta = $banco->buscarBancosContaComId($_POST['id']);
        var_dump($bancoConta) ;

        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.e-unicred.com.br/homolog/oauth2/v2/grant-token',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>json_encode(array("nomeUsuario"=> $bancoConta['pp_token'], "senha"=>$bancoConta['password'])),
        CURLOPT_HTTPHEADER => array(
            'apiKey: '.$bancoConta['gerar_token'],
            'Content-Type: application/json'
        ),
        ));
        $response = curl_exec($curl);
        $autenticacao = json_decode($response);
        curl_close($curl);
        var_dump($autenticacao);
        if(!$autenticacao->accessToken){
            echo "falha na autenticao ".$response;
            die;
        }

        $curl = curl_init();
        $Date = date('Y-m-d');

        for($i = 1;$i<6;$i++){
            curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.e-unicred.com.br/homolog/cobranca/v2/beneficiarios/'.$bancoConta['req_cliente_id'].'/titulos',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS =>'{
                "beneficiarioVariacaoCarteira": '.$bancoConta['nr_carteira'].',
                "seuNumero": "'.$i.'",
                "valor": '.($i*2).',
                "vencimento": "'.date('Y-m-d', strtotime($Date. ' + '.$i.' days')).'",
                "indicacaoTituloDescontavel": false,
                
                "enviaBoletoEmail": false,
                "desconto": {
                    "indicador": 1,
                    "dataLimite": "'.date('Y-m-d', strtotime($Date. ' + '.$i.' days')).'",
                    "valor": 0.2
                },
                "juros": {
                    "codigo": 2,
                    "dataInicio": "'.date('Y-m-d', strtotime($Date. ' + '.($i+1).' days')).'",
                    "valor": 0.98
                },
                "multa": {
                    "codigo": 2,
                    "dataInicio": "'.date('Y-m-d', strtotime($Date. ' + '.($i+1).' days')).'",
                    "valor": 5
                },
                "mensagensFichaCompensacao": [
                    "string 1",
                    "string 2"
                ],
                "pagador": {
                    "nomeRazaoSocial": "Fulano de Tal",
                    "tipoPessoa": "F",
                    "tipoDocumento": "CPF",
                    "numeroDocumento": "10599862483",
                    "nomeFantasia": "Fulano",
                    "email": "fulano@detal.com",
                    "endereco": {
                        "tipoLogradouro": "Rua",
                        "logradouro": "Rua IV",
                        "numero": "1001",
                        "complemento": "Casa 01",
                        "bairro": "Centro",
                        "cidade": "Porto Alegre",
                        "uf": "RS",
                        "cep": "92000100"
                    }
                }
            }
            ',
            CURLOPT_HTTPHEADER => array(
                'apiKey: '.$bancoConta['gerar_token'],
                'cooperativa: '.$bancoConta['nr_cooperativa'],
                'Content-Type: application/json',
                'Authorization: Bearer '.$autenticacao->accessToken,
            ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);
            echo $response;
        }
    }
    public function validarAssociarAction()
    {
        $campoBanco = array("idBancoConta","idEmpreendimento");
        foreach ($campoBanco as $cb) {
            if ($_POST [$cb] == "") {
                switch ($cb) {
                    case "idBancoConta" :
                        $msg = "Conta";
                        break;
                    case "idEmpreendimento" :
                        $msg = "Empreendimento";
                        break;
                }
                $this->_helper->addMensagem($cb, 'O campo <b>'.$msg.'</b> � obrigat�rio.');
            }
        }

        if ($_POST['tpMulta'] != 'S' && (!$_POST['multa'] || Helper::getInputMoney($_POST['multa']) <= '0')) {
            $this->_helper->addMensagem('tpMulta', 'O campo <b>Multa</b> deve ser preenchido com valor 
                maior que zero, se selecionado <b>Porcentagem ou Valor Fixo</b>');
        }

        if ($_POST['tpJuros'] != 'S' && (!$_POST['juros'] || Helper::getInputMoney($_POST['juros']) <= '0')) {
            $this->_helper->addMensagem('tpJuros', 'O campo <b>Juros</b> deve ser preenchido com valor 
                maior que zero, se selecionado <b>Porcentagem ou Valor Fixo</b>');
        }

        //Realiza a valida��o tanto em javascript/php
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
            exit;
        } else {
            return true;
        }
    }

    /**
     * Realiza valida��o das telas Adicionar e Editar
     * @return bool
     */
    public function validarAction()
    {
        // Campos que s�o obrigat�rios em adicionar/editar
        $campos = array("nrAgencia", "nrConta", "dsEspecie", "nrCedente", "nrCarteira", "nrDiasPermanencia", "nmCedente");

        // Campo de banco � obrigat�rio apenas na tela de adicionar
        if ($_POST['a'] == 'adicionar') {
            $campos[] = 'cdBanco';
        }
        $idBancoConta = '';
        if ($_POST['a'] == 'editar') {

            // Verifica se a multa e juros est�o com valores se for porcentagem ou valor fixo
            foreach ($_POST['idEmpreendimento'] as $e) {

                $empreendimento = (new Empreendimento())->fetchRow('id = '.$e);
                $nmEmpreendimento = utf8_encode($empreendimento['nm_empreendimento']);

                if ($_POST['tpMulta_'.$e] != 'S' && (!$_POST['multa_'.$e] || Helper::getInputMoney($_POST['multa_'.$e]) <= '0')) {
                    $this->_helper->addMensagem('tpMulta_'.$e, 'O campo <b>Multa</b> ('.$nmEmpreendimento.') 
                        deve ser preenchido com valor maior que zero, se selecionado <b>Porcentagem ou Valor Fixo</b>');
                }

                if ($_POST['tpJuros_'.$e] != 'S' && (!$_POST['juros_'.$e] || Helper::getInputMoney($_POST['juros_'.$e]) <= '0')) {
                    $this->_helper->addMensagem('tpJuros_'.$e, 'O campo <b>Juros</b> ('.$nmEmpreendimento.') 
                        deve ser preenchido com valor maior que zero, se selecionado <b>Porcentagem ou Valor Fixo</b>');
                }
            }
            $idBancoConta = $_POST['id'];
        }

        if ($_GET['a'] == 'editar') {
            $idBancoConta = $_GET['id'];
        }
        // Pesquisa se h� uma conta com mesmo banco, agencia, conta e cedente iguais cadastrados
        // Caso seja no editar, verifica se h� conta igual sem ser a conta editada
        $where  = ($_POST['cdBanco'])?'cd_banco = '.$_POST['cdBanco']:'';
        $where .= ($_POST['nrAgencia'])?' AND nr_agencia = "'.$_POST['nrAgencia'].'"':'';
        $where .= ($_POST['nrAgenciaDv'])?' AND nr_agencia_dv = "'.$_POST['nrAgenciaDv'].'"':'';
        $where .= ($_POST['nrConta'])?' AND nr_conta = "'.$_POST['nrConta'].'"':'';
        $where .= ($_POST['nrContaDv'])?' AND nr_conta_dv = "'.$_POST['nrContaDv'].'"':'';
        $where .= ($_POST['nrCedente'])?' AND nr_cedente = "'.$_POST['nrCedente'].'"':'';
        $where .= ($idBancoConta != '')?' AND id_banco_conta != "'.$idBancoConta.'"':'';

        if ($where != '' && (new BancoConta())->fetchRow($where)) {
            $this->_helper->addMensagem('contaIguais', 'J� existe uma conta cadatrada com este <b>banco, ag�ncia, conta e cedente</b>.');
        }
        // Libera obrigatoriedade para campo CPF/CNPJ Cedente de acordo com a
        // op��o Pessoa Fisica/Juridica selecionada
        if ($_POST['cpfcnpj'] == 'F') {
            $campos[] = 'cpfCedente';
            // Verifica se o CPF � v�lido
            if ($_POST['cpfCedente'] && !$this->_helper->validaCPF($_POST['cpfCedente'])) {
                $this->_helper->addMensagem('cpfCnpjInvalido', 'O <b>CPF Cedente</b> � inv�lido');
            }
        } else {
            $campos[] = 'cnpjCedente';
            // Verifica se o CNPJ � v�lido
            if ($_POST['cnpjCedente'] && !$this->_helper->validaCNPJ($_POST['cnpjCedente'])) {
                $this->_helper->addMensagem('cpfCnpjInvalido', 'O <b>CNPJ Cedente</b> � inv�lido');
            }
        }
        // Valida os campos obrigat�rios que estiverem vazios
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "cdBanco":
                        $msg = "Banco";
                        break;
                    case "nrAgencia":
                        $msg = "Ag�ncia";
                        break;
                    case "nrConta":
                        $msg = "Conta Corrente";
                        break;
                    case "dsEspecie":
                        $msg = "Esp�cie Documento";
                        break;
                    case "nrCedente":
                        $msg = "Cedente/Contrato";
                        break;
                    case "nmCedente":
                        $msg = "Nome Cedente";
                        break;
                    case "nrCarteira":
                        $msg = "Carteira";
                        break;
                    case "nrDiasPermanencia":
                        $msg = "Dias Perman�ncia";
                        break;
                    case "cdBanco":
                        $msg = "Banco";
                        break;
                    case "cpfCedente":
                        $msg = "CPF Cedente";
                        break;
                    case "cnpjCedente":
                        $msg = "CNPJ Cedente";
                        break;
                }
                $this->_helper->addMensagem($cp, 'O campo <b>'.$msg.'</b> � obrigat�rio.');
            }
        }
        // Realiza a valida��o tanto em javascript/php
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
            exit;
        } else {
            return true;
        }
    }
}