<?php

class AjaxController extends Controller
{

    public function __construct($request)
    {
        parent::__construct($request);

        $this->tb_pessoa = new Pessoa();

    }

    public function lote_by_empreendimentoAction()
    {
        $lotes = new Lote();
        $tb_contratos = new Contrato();
        $contratos = $tb_contratos->getAdapter()->select()->from(TB_CONTRATO, 'id_lote')->where("fl_distrato = '0'")->query()->fetchAll();

        if ($contratos != null) {
            $this->set('lotes', $lotes->fetchAll($lotes->select()->order(array('quadra ASC', 'lote ASC'))->where('reservado = "0"')->where('id_empreendimento = ?', $_POST['id_empreendimento'])->where('id NOT IN(?)', $contratos), array('id_empreendimento', 'id_lote')));
        } else {
            $this->set('lotes', $lotes->fetchAll($lotes->select()->order(array('quadra ASC', 'lote ASC'))->where('reservado = "0"')->where('id_empreendimento = ?', $_POST['id_empreendimento']), array('id_empreendimento', 'id_lote')));
        }

        $this->display();
    }

    public function loteByEmpreendimentoContratoAction()
    {
        $lotes = new Lote();
        $tb_contratos = new Contrato();
        $contratos = $tb_contratos->getAdapter()->select()->from(TB_CONTRATO, 'id_lote')->query()->fetchAll();

        if ($contratos != null) {
            $this->set('lotes', $lotes->fetchAll($lotes->select()->order(array('quadra ASC', 'lote ASC'))->where('id_empreendimento = ?', $_POST['id_empreendimento'])->where('id IN(?)', $contratos), array('id_empreendimento', 'id_lote')));
        } else {
            $this->set('lotes', array());
        }

        $this->display();
    }

    //pega lotes por empreendimento, pode ser passado boolean de reserva ou nao
    public function loteByEmpreendimentoAction()
    {
        $id_empreendimento = $_POST['id_empreendimento'];

        $lotes = new Lote();
        //busca contratos no distratados e retorna lista com os ids dos lotes
        $contratos = (new Contrato())->getAdapter()->select()->from(TB_CONTRATO, 'id_lote')->where("fl_distrato = '0'")->query()->fetchAll();
        //monta o query para os lotes
        $lotes = $lotes->getAdapter()->select()->from(array('l' => TB_LOTES), array('l.id', 'l.quadra', 'l.lote'))->where('id_empreendimento = ?', $id_empreendimento);


        //adiciona o teste para no incluir os lotes com contratos no distratados
        if ($contratos != null) {
            $lotes = $lotes->where('l.id NOT IN(?)', $contratos);
        }
        $reservaLote = new ReservaLote();
        $reservaLote = $reservaLote->getDefaultAdapter()->select()->from(array('rl' => TB_RESERVA_LOTE), array('cod_lote', 'reservado'))->where('rl.reservado = "1" ')->query()->fetchAll();

        //exclui os lotes que j possuem reserva de algum tipo
        if (count($reservaLote) > 0) {
            $lotes = $lotes->where('l.reservado = "0" AND l.id NOT IN(?)', $reservaLote)
                ->order(array('quadra', 'lote'))
                ->query()->fetchAll();
        } else {
            $lotes = $lotes->where('l.reservado = "0"')
                ->order(array('quadra', 'lote'))
                ->query()->fetchAll();
        }

        echo json_encode($lotes);
    }


    public function banco_by_empreendimentoAction()
    {
        $banco = new Banco();
        $bancos = $banco->fetchAll($banco->select()->where('id_empreendimento = ?', $_POST['id_empreendimento']))->toArray();
        foreach ($bancos as &$banco) {
            $banco['nmBanco'] = Banco::findBancoNome($banco['cd_banco']);
        }
        $this->set('bancos', $bancos);
        $this->display();
    }

    /**
     * Lista em ajax dos nomes dos bancos cadastrados no empreendimento
     */
    public function bancoByEmpreendimentoAction()
    {
        $bancos = new Banco();
        $bancos = $bancos->fetchAll($bancos->select()->where('id_empreendimento = ?', $_POST['id_empreendimento']))->toArray();
        foreach ($bancos as &$banco) {
            $banco['nmBanco'] = Banco::findBancoNome($banco['cd_banco']);
        }
        $this->set('bancos', $bancos);
        $this->display();
    }

    /**
     * Lista em ajax dos nomes dos bancos cadastrados no empreendimento
     */
    public function bancoByContratoAction()
    {
        $banco = new Banco();
        $banco = $banco->fetchRow('id = ' . $_POST['id_banco'])->toArray();
        $banco['nmBanco'] = Banco::findBancoNome($banco['cd_banco']);
        $this->set('banco', $banco);
        $this->display();
    }

    public function find_pessoaAction()
    {
        $pessoas = new Pessoa();
        $pfs = new Pessoa_Fisica();
        $pjs = new Pessoa_Juridica();
        $list = $pessoas->select()->where('nm_pessoa LIKE ?', $_GET['term'] . '%')->limit(20)->query()->fetchAll();
        $listaPessoas = array();
        foreach ($list as $lt) {
            $nome = utf8_encode($lt['nm_pessoa']);
            if ($lt['tp_pessoa'] == 'F') {
                $pf = $pfs->find($lt['id'])->current();
                if ($pf) {
                    $pf = $pf->toArray();
                    $cpf = $pf['nr_cpf'];
                    $value = $nome . ' - CPF:' . $cpf;
                } else {
                    $cpf = '';
                    $value = $nome;
                }
            } else {
                $pj = $pjs->find($lt['id'])->current();
                if ($pj) {
                    $pj = $pj->toArray();
                    $cpf = $pj['nr_cnpj'];
                    $value = $nome . ' - CNPJ:' . $cpf;
                }
            }
            $listaPessoas[] = array(
                'value' => $value,
                'nome' => $nome,
                'id' => $lt['id'],
                'cpf' => $cpf
            );
        }
        echo json_encode($listaPessoas);
    }

    public function find_pessoasAction()
    {
        $pessoas = new Pessoa();

        $list = $pessoas->getAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('id', 'nm_pessoa', 'tp_pessoa', 'cpfCnpj' => '(IF(pf.nr_cpf is not null,pf.nr_cpf,pj.nr_cnpj))'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', null)
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id', null)
            ->where('nm_pessoa LIKE ?', '%' . $_GET['term'] . '%')
            ->order('id')->limit(20)->query()->fetchAll();
        $response = array();
        foreach ($list as $lt) {
            $value = utf8_encode($lt['nm_pessoa']);
            if ($lt['tp_pessoa'] == 'F') {
                $value .= ' - CPF:' . $lt['cpfCnpj'];
            } else {
                $value .= ' - CNPJ:' . $lt['cpfCnpj'];
            }

            $response[] = array(
                'value' => $value,
                'nome' => utf8_encode($lt['nm_pessoa']),
                'id' => utf8_encode($lt['id']),
                'doc' => utf8_encode($lt['cpfCnpj'])
            );
        }
        echo json_encode($response);
    }

    public function FisicaAction()
    {
        $pessoas = new Pessoa();
        $pfs = new Pessoa_Fisica();
        $list = $pessoas->select()->where('nm_pessoa LIKE ?', '%' . $_GET['q'] . '%')->where('tp_pessoa = ?', 'F')->limit(20)->query()->fetchAll();
        foreach ($list as $lt) {
            echo utf8_encode(trim($lt['nm_pessoa']));
            if ($lt['tp_pessoa'] == 'F') {
                $pf = $pfs->find($lt['id'])->current()->toArray();
                echo ' - CPF:' . trim($pf['nr_cpf']);
            }
            echo '|' . utf8_encode($lt['id']) . "\n";
        }
    }

    public function corretorByEmpreendimentoAction()
    {
        $corretores = new Corretor_Empreendimento();

        $corretores = $corretores->getAdapter()->select()->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), '')->join(array('p' => TB_PESSOA), 'ce.id_corretor = p.id', array('id', 'nm_pessoa'))->where('ce.id_empreendimento = ' . $_POST['id_empreendimento'])->order('nm_pessoa')->query()->fetchAll();

        //Corrige erro de acentuao para exibir nomes
        foreach ($corretores as &$corretor) {
            $corretor['nm_pessoa'] = utf8_encode($corretor['nm_pessoa']);
        }

        echo json_encode($corretores);
    }

    public function corretor_by_empreendimentoAction()
    {
        $corretores = new Corretor_Empreendimento();

        $corretores = $corretores->getAdapter()->select()->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), '')->join(array('p' => TB_PESSOA), 'ce.id_corretor = p.id', array('id', 'nm_pessoa'))->where('ce.id_empreendimento = ' . $_POST['id_empreendimento'])->order('nm_pessoa')->query()->fetchAll();
        $this->set('pessoas', $corretores);
        $this->display();
    }

    // para gerar parcela
    public function contrato_by_empreendimentoAction()
    {
        $empreedimento = $_POST['id_empreendimento'];
        $contratos = Contrato::byEmpreendimento($empreedimento, Contrato::CONTRATO_NAO_GERADO, 2, array("nm_pessoa", "lote", "quadra", "id"), true);
        $this->set('contratos', $contratos);
        $this->display();
    }

    // para gerar remessa
    public function contratoByBancoEmpreendimentoRemessaAction()
    {
        $empreedimento = $_POST['id_empreendimento'];
        $banco = $_POST['idBanco'];
        $contratos = Contrato::byBancoEmpreendimento($empreedimento, $banco, Contrato::CONTRATO_GERADO, true, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lote = new Lote();
        $saida = '';
        if (count($contratos) > 0) {
            foreach ($contratos as $contrato) {
                $lot = $lote->find($contrato['id_lote'])->current();
                $selected = "";
                if ($_POST["id_contrato"] == $contrato['id']) {
                    $selected = 'selected';
                }
                $cor = '';
                if ($contrato['fl_distrato'] == '1') {
                    $cor = 'style="color: red"';
                }
                $saida .= '<option ' . $cor . ' value="'.$contrato['id'].'" '.$selected.' >' . substr_replace(utf8_encode($contrato['nm_pessoa']), "...", 30) . ' - Quadra: '.utf8_encode($lot['quadra']).' - Lote: '.utf8_encode($lot['lote']).' - Contrato: '.$contrato['id'].'</option>';
            }
        }
        if ($_POST["id_contrato"]) {
            return $saida;
        }
        echo utf8_encode($saida);
    }

    // para gerar boleto 2 via
    public function contratoByBancoEmpreendimento2ViaAction()
    {
        $empreedimento = $_POST['id_empreendimento'];
        $banco = $_POST['idBanco'];
        $contratos = Contrato::byBancoEmpreendimento($empreedimento, $banco, Contrato::CONTRATO_GERADO, true, array("nm_pessoa", "lote", "quadra", "id"), true);
        $this->set('contratos', $contratos);
        $this->display();
    }

    public function contrato_by_empreendimento_geradoAction()
    {
        header('Content-Type: text/html; charset=utf-8');
        $empreedimento = $_POST['id_empreendimento'];
        $contratos = Contrato::byEmpreendimento($empreedimento, Contrato::CONTRATO_GERADO, 0, array("nm_pessoa", "lote", "quadra", "id"));
        foreach($contratos as $keyContrato=>$contrato){
            foreach($contrato as $atributoContrato=>$index){
                $contratos[$keyContrato][$atributoContrato] = utf8_encode($index);
            }
        }
        $this->set('contratos', $contratos);
        $this->display();
    }

    public function parcelaByContratoAction()
    {
        $contrato = $_POST['contrato_emp'];
        $parcelas = new Parcela();
        $parcelas = $parcelas->parcelaByContrato($contrato);

        echo json_encode($parcelas);
    }

    /**
     * BOLETO 2 VIA
     */
    public function parcelaByContrato2ViaAction()
    {
        $contrato = $_POST['contrato_emp'];
        $parcelas = new Parcela();
        $parcelas = $parcelas->parcelaByContrato($contrato, false, false, '("S","N","I","C","G","Q")');
        foreach ($parcelas as &$parcela) {
            $parcela['dt_parcela'] = Helper::getDate($parcela['dt_parcela']);
        }

        echo json_encode($parcelas);
    }

    public function parcelaByIdAction()
    {
        $parcelaId = $_POST['parcelaId'];
        $parcela = new Parcela();
        $parcela = $parcela::parcelaById($parcelaId);
        //busca o banco atravz do id do contrato.
        $contrato = new Contrato();
        $contrato = $contrato->getContrato($parcela['id_contrato']);
        //Inserido alterao de encoding para exibir os campos
        $parcela['log'] = $parcela['log'];
        $parcela['obs'] = $parcela['obs'];
        $parcela['tx_juros'] = $contrato['tx_juros'];
        $parcela['fl_desc_normal'] = $contrato['fl_desc_normal'];
        $parcela['fl_desc_sinal'] = $contrato['fl_desc_sinal'];
        $parcela['fl_desc_intercalada'] = $contrato['fl_desc_intercalada'];
        $parcela['fl_desc_chave'] = $contrato['fl_desc_chave'];
        
        $banco = new Banco();
        //busca a quantidade de dias de permanencia (qt_dias_permanencia).
        $banco = $banco->getAdapter()->select()
            ->from(array('b' => TB_BANCO), array('qt_dias_permanencia'))
            ->where('b.id = ' . $contrato['id_banco'])
            ->query()->fetch();

        //concatena a quantidade de dias de permanencia com a palavra ' days'.
        $somaDatas = $banco['qt_dias_permanencia'].' days';
        //converte o formato da data de brasileiro para americano
        $vencimentoParcela = Helper::dataParaAmericano($parcela['dt_parcela']);
        //soma a data da parcela com a quantidade de dias de permanencia.
        $data = date_create($vencimentoParcela);
        $data = date_add($data, date_interval_create_from_date_string($somaDatas));
        $data = (date_format($data, 'Y-m-d'));
        //verifica se a data  maior do que a data atual.
        if ($data >= date('Y-m-d')) {
            $parcela['validaBoleto'] = true;
        }
        $parcela["nm_pessoa"]=utf8_decode($parcela["nm_pessoa"]);
        foreach($parcela as $key=>$p){
            $parcela[$key]=utf8_encode($parcela[$key]);
        }
        //CDIGOS PARA VERIFICAR A VALIDADE DO BOLETO
        echo json_encode($parcela);
        switch (json_last_error()) {
            case JSON_ERROR_DEPTH:
                echo ' - Maximum stack depth exceeded';
            break;
            case JSON_ERROR_STATE_MISMATCH:
                echo ' - Underflow or the modes mismatch';
            break;
            case JSON_ERROR_CTRL_CHAR:
                echo ' - Unexpected control character found';
            break;
            case JSON_ERROR_SYNTAX:
                echo ' - Syntax error, malformed JSON';
            break;
            case JSON_ERROR_UTF8:
                echo ' - Malformed UTF-8 characters, possibly incorrectly encoded';
            break;
        }
    }

    //Busca dados para preenchimento do fomulrio de distrato
    public function cidadeAssinaturaByEmpreendimentoAction()
    {
        $empreendimento = Empreendimento::findEmpreendimento($_POST['empreendimento_distrato']);
        $cidade = Cidade::byId($empreendimento->cd_cidade);
        $cidade = $cidade['nome'] . ' - ' . $cidade['uf'];
        $contrato = Contrato::findContratoById($_POST['contrato_id']);
        $parcelas = Parcela::findParcelasPagasById($_POST['contrato_id']);
        $sinal = 0;
        $valorPago = 0;
        $qtd = count($parcelas);

        foreach ($parcelas as $parcela) {
            if ($parcela['tp_parcela'] != 'S' && $parcela['tp_parcela'] != 'SE') {
                $valorPago += $parcela['vl_parcela'];
            } elseif ($parcela['tp_parcela'] == 'S') {
                $qtd--;
                $sinal += $parcela['vl_parcela'];
            }
        }
        $valorDevolucao = $valorPago * $empreendimento->porcDev * 0.01;
        if ($qtd > 0) $valorParcela = $valorDevolucao / $qtd;

        echo json_encode(array(
            'cidade' => $cidade,
            'sinal' => $sinal,
            'qtdparcelas' => $qtd,
            'valorParcela' => $valorParcela,
            'valor' => $valorDevolucao,
            'cpf' => $contrato['nr_cpf'],
            'nome' => utf8_encode($contrato['nm_pessoa']),
            'porcDev' => $empreendimento->porcDev
        ));
    }

    public function contrato_by_empreendimento_baixar_parcelaAction()
    {
        $empreedimento = $_POST['id_empreendimento'];
        $contratos = Contrato::byEmpreendimentoParcelasAbertas($empreedimento, Contrato::CONTRATO_GERADO, array("nm_pessoa", "lote", "quadra", "id_contrato"));
        $this->set('contratos', $contratos);
        $this->display();
    }

    public function contrato_by_empreendimento_quitacaoAction()
    {
        $empreedimento = $_POST['id_empreendimento'];
        $contratos = Contrato::byEmpreendimentoParcelasAbertasQuitacao($empreedimento, Contrato::CONTRATO_GERADO, array("nm_pessoa", "lote", "quadra", "id_contrato"));
        $this->set('contratos', $contratos);
        $this->display();
    }

    public function contrato_parcela_nao_pagaAction()
    {
        $tb_parcela = new Parcela();
        $contrato = (int)$_POST['contrato'];
        $this->set('parcelas', $tb_parcela->fetchAll("id_contrato = {$contrato} AND pago = '0'", 'dt_parcela ASC')->toArray());
        $this->display();
    }

    public function contrato_parcela_pagaAction()
    {
        $tb_parcela = new Parcela();
        $tb_parcelaH = new ParcelaHistorico();
        $contrato = (int)$_POST['contrato'];
        $contrato2 = (int)$_POST['contrato'];
        $teste = $tb_parcela->fetchAll("id_contrato = {$contrato} AND pago = '1'")->toArray();
        $teste2 = $tb_parcelaH->fetchAll("id_contrato = {$contrato2} AND pago = '1'")->toArray();

        if ($teste) {

            $this->set('parcelas', $teste);

        } else {

            $this->set('parcelas', $teste2);
        }

        $this->display();
    }

    public function contrato_per_yearAction()
    {
        $contrato = $_POST['contrato'];
        $contratos = new Contrato();
        $query = $contratos->getAdapter()->select()->from(TB_PARCELA, 'count(*)')->where('id_contrato = ?', $contrato)->query()->fetch();
        $numRows = $query['count(*)'];
        $anos = ($numRows > 12) ? ceil($numRows / 12) : 1;
        $this->set('anos', $anos);
        $this->display();
    }

    public function fetchPessoaResponsavelAction()
    {
        $pessoas = new Pessoa();
        $representantes = new Representante();

        $list = array();
        $pes = $pessoas->fetchRow('id = '.$_POST['pessoa']);
        if ($pes) {
            if ($pes['tp_pessoa'] == 'F') {
                $list[] = array('id' => $pes['id'], 'nm_pessoa' => utf8_encode($pes['nm_pessoa']));
            } elseif ($pes['tp_pessoa'] == 'J') {
                $ids = $representantes->fetchAll($representantes->select()->where('id_pessoa_juridica = ?', $pes['id']))->toArray();
                foreach ($ids as $id) {
                    $pes = $pessoas->fetchRow('id = '.$id['id_pessoa']);
                    $list[] = array('id' => $pes['id'], 'nm_pessoa' => utf8_encode($pes['nm_pessoa']));
                }
            }
        }
        echo json_encode($list);
    }

    public function calcula_totalAction()
    {
        $total = Helper::getInputMoney($_POST['vl_parcela']) * Helper::getInputMoney($_POST['qtd_parcela']);
        $total += Helper::getInputMoney($_POST['sinal']) * Helper::getInputMoney($_POST['qtd_parcela_sinal']);
        $total += Helper::getInputMoney($_POST['intercalada']) * Helper::getInputMoney($_POST['qtd_parcela_intercalada']);
        $total += Helper::getInputMoney($_POST['vl_chave']) * Helper::getInputMoney($_POST['qt_chave']);

        echo  $_SESSION['simboloMoeda']. ' '. number_format($total, 2, ',', '.');
        return;
    }

    /*
     * Calcula os dados da parcela de acordo com as datas
     */
    public function calculaMultaJurosParcelaAction()
    {
        if ($_POST['nrBaixa']) {
            $nParcela = $_POST['nrBaixa'];
        } else {
            $nParcela = $_POST['parcela'];
        }
        $instanceParcela = new Parcela();
        $parcela = $instanceParcela->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_parcela', 'id_negociacao', 'tp_parcela', 'dt_parcela', 'vl_parcela', 'desconto', 'acrescimo'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('nr_parcela', 'idDoContrato' => 'id'))
            ->join(array('b' => TB_BANCO), 'b.id = c.id_banco', array('juros', "multa"))
            ->where('id_parcela_contrato = ?', $nParcela)
            ->query()->fetch();

        if (isset($_POST['desconto']))
            $parcela["desconto"] = Helper::getInputMoney($_POST['desconto']);

        //Data de pagamento
        if ($_POST['dataPagamento'] && Helper::dateIsValid(Helper::getInputDate($_POST['dataPagamento'])))
            $dataBase = $_POST['dataPagamento'];
        else
            $dataBase = date("d/m/Y", strtotime("now"));

        $atraso = Helper::date_diff($parcela["dt_parcela"], Helper::getInputDate($dataBase));
        if ($atraso > 0) {
            $multa = round($parcela["vl_parcela"] * (float)($parcela["multa"] / 100), 2);
            $juros = round($parcela["vl_parcela"] * (float)($parcela["juros"] / 100), 2);
            $juros *= $atraso;
            $total = $parcela["vl_parcela"] + $juros + $multa - $parcela["desconto"] + $parcela['acrescimo'];
        } else {
            $multa = "0";
            $juros = "0";
            $total = $parcela["vl_parcela"] - $parcela["desconto"] + $parcela['acrescimo'];
        }
        if ($_POST['contrato'] && $_POST['parcela']) {
            echo json_encode(array(
                'valorParcela' => $parcela["vl_parcela"],
                'valor' => Helper::getMoney($total),
                'dt_vencimento' => Helper::getDate($parcela['dt_parcela']),
                'multa' => Helper::getMoney($multa),
                'juros' => Helper::getMoney($juros),
                'acrescimo' => Helper::getMoney($parcela['acrescimo']),
                'desconto' => Helper::getMoney($parcela['desconto'])
            ));
        } else {
            $jurosUsuario = Helper::parseFloat($_POST['juros']);
            $valorParcela = Helper::parseFloat($parcela["vl_parcela"]);
            $multaUsuario = Helper::parseFloat($_POST['multa']);
            $total = $valorParcela + $multaUsuario + $jurosUsuario - $parcela["desconto"] + $parcela['acrescimo'];
            echo Helper::getMoney($total);
        }

        return;
    }

    public function extornaParcAction()
    {

        $instanceParcela = new Parcela();
        $select = $instanceParcela->getAdapter()->select();
        $parcelas = $select->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_parcela', 'id_negociacao', 'tp_parcela', 'dt_parcela', 'vl_parcela', 'acrescimo', 'desconto', 'pago', 'tp_baixa'))->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('nr_parcela', 'idDoContrato' => 'id'))->where('id_parcela_contrato = ?', $_POST['parcela'])->query()->fetch();


        echo json_encode(array('tipoBaixa' => $parcelas['tp_baixa']));

        $tb_parcela = new Parcela();

        $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$_POST['parcela']}");
        $parcela->acrescimo = 0.00;
        $parcela->desconto = 0.00;
        $parcela->pago = '0';
        $parcela->tp_baixa = null;
        $parcela->vl_juros = 0.00;
        $parcela->vl_multa = 0.00;
        $parcela->vl_total_pago = 0.00;
        $parcela->dt_pagamento = null;
        $parcela->dt_credito = null;
        $parcela->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - u');
        $parcela->save();


    }

    public function calculaTotalParcelaAction()
    {

        $instanceParcela = new Parcela();
        $select = $instanceParcela->getAdapter()->select();
        $parcelas = $select->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_parcela', 'id_negociacao', 'tp_parcela', 'dt_parcela', 'vl_parcela',))->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('nr_parcela', 'idDoContrato' => 'id'))->join(array('b' => TB_BANCO), 'b.id = c.id_banco', array('juros', "multa"))->where('id_contrato = ?', $_POST['contrato'])->query()->fetchAll();

        foreach ($parcelas as $parcela) {
            $dataBase = date("d/m/Y", strtotime("now"));
            $atraso = Helper::date_diff($parcela["dt_parcela"], Helper::getInputDate($dataBase));
            if ($atraso > 0) {
                $multa = $parcela["vl_parcela"] * (float)($parcela["multa"] / 100);
                $juros = $parcela["vl_parcela"] * (float)($parcela["juros"] / 100);
                $juros *= $atraso;
                $total = $parcela["vl_parcela"] + $juros + $multa;
            } else {
                $multa = "0";
                $juros = "0";
                $total = $parcela["vl_parcela"];
            }
            if ($_POST['contrato'] && $_POST['parcela']) {
                echo json_encode(array('valorParcela' => $parcela["vl_parcela"], 'valor' => number_format($total, 2, ',', '.'), 'dt_vencimento' => Helper::getDate($parcela['dt_parcela']), 'multa' => number_format($multa, 2, ',', '.'), 'juros' => number_format($juros, 2, ',', '.'), 'desconto' => number_format($parcela['desconto'], 2, ',', '.')));
            } else {
                $jurosUsuario = Helper::parseFloat($_POST['juros']);
                $valorParcela = Helper::parseFloat($parcela["vl_parcela"]);
                $valorUsuario = Helper::parseFloat($_POST['valor']);
                $multaUsuario = Helper::parseFloat($_POST['multa']);
                $total = 0;
                if (($multaUsuario == $multa) && ($jurosUsuario == $juros)) {
                    $total = $valorUsuario;
                } elseif ($multaUsuario == 0 && $jurosUsuario == 0) {
                    $total = $valorParcela;
                } else {
                    if (($multaUsuario != $multa) && ($jurosUsuario == $juros)) {
                        $total = ($valorUsuario - $multa) + $multaUsuario;
                    } elseif (($multaUsuario == $multa) && ($jurosUsuario != $juros)) {
                        $total = ($valorUsuario - $juros) + $jurosUsuario;
                    } else {
                        $total = $multaUsuario + $jurosUsuario + $valorParcela;
                    }
                }
                echo number_format($total, 2, ',', '.');
            }
        }
        return;
    }

    public function calculaValorTotalBaixaParcelaAction()
    {
        if ($_POST['contrato'] && $_POST['parcela']) {
            $instanceParcela = new Parcela;

            $parcela = $instanceParcela->select()->where('id_parcela_contrato = ?', $_POST['parcela'])->query()->fetch();

            echo json_encode(array('valor' => number_format($parcela['vl_parcela'], 2, ',', '.'), 'dt_vencimento' => Helper::getDate($parcela['dt_parcela'])));

        } else {
            $total = Helper::getInputMoney($_POST['valor']);
            $total += Helper::getInputMoney($_POST['multa']);
            $total += Helper::getInputMoney($_POST['juros']);
            echo number_format($total, 2, ',', '.');
        }
        return;
    }

    public function calculaValorTotalBaixaParcelaPeloNumeroAction()
    {
        if ($_POST['numero']) {
            $parcela = Parcela::getParcelaCompletaById($_POST['numero']);
            $dataBase = date("d/m/Y", strtotime("now"));
            $atraso = Helper::date_diff(Helper::getInputDate($parcela["dt_parcela"]), Helper::getInputDate($dataBase));
            $juros = Helper::parseFloat(($parcela['juros'] / 100) * $atraso * $parcela['vl_parcela']);
            $multa = Helper::parseFloat(($parcela['multa'] / 100) * $parcela['vl_parcela']);
            $total = Helper::parseFloat($parcela['vl_parcela']) + $juros + $multa;
            echo json_encode(array('valor' => number_format($parcela['vl_parcela'], 2, ',', '.'), 'dt_vencimento'
            => $parcela['dt_parcela'], 'juros'
            => $juros, 'multa'
            => $multa, 'total'
            => $total));
        } else {
            $total = Helper::getInputMoney($_POST['valor']);
            $total += Helper::getInputMoney($_POST['multa']);
            $total += Helper::getInputMoney($_POST['juros']);
            echo number_format($total, 2, ',', '.');
        }
        return;
    }

    public function lote_cliente_by_empreendimentoAction()
    {
        $select = Zend_Db_Table::getDefaultAdapter()->select();
        $rows = $select->from(array('L' => TB_LOTES), array('loteId' => 'id', 'lote', 'quadra'))
            ->join(array('C' => TB_CONTRATO), 'C.id_lote = L.id', array('id'))
            ->join(array('P' => TB_PESSOA), 'P.id = C.id_pessoa', array('nm_pessoa'))
            ->join(array('ph' => TB_PARCELA), 'ph.id_contrato = C.id', array())
            ->where('L.id_empreendimento = ?', $_POST['id_empreendimento'])
            ->where("fl_distrato = '0'")
            ->where('C.fl_gerado = ?', '1')
            ->order('P.nm_pessoa ASC')->group('L.id');

        $rows = $rows->query()->fetchAll();

        $this->set('lotes', $rows);
        $this->display();
    }

    //busca dados de lotes e pessoas com as parcelas geradas ou no
    public function lote_cliente_by_empreendimento_parcelasAction()
    {
        $select = Zend_Db_Table::getDefaultAdapter()->select();
        $rows = $select->from(array('L' => TB_LOTES), array('loteId' => 'id', 'lote', 'quadra'))
            ->join(array('C' => TB_CONTRATO), 'C.id_lote = L.id', array('id'))
            ->join(array('P' => TB_PESSOA), 'P.id = C.id_pessoa', array('nm_pessoa', 'idPessoa' => 'id'))
            ->joinLeft(array('ph' => TB_PARCELA), 'ph.id_contrato = C.id')
            ->where('L.id_empreendimento = ?', $_POST['id_empreendimento'])
            ->where("fl_distrato = '0'")->where("fl_aprovar_contrato = '1'")
            ->distinct()->order(array('nm_pessoa ASC', 'L.quadra ASC', 'L.lote ASC'))
            ->group('L.id');

        $rows = $rows->query()->fetchAll();
        $rowJson = array();
        foreach ($rows as &$row) {
            $rowsJson[] = array(
                'idPessoa' => $row['idPessoa'],
                'id' => $row['id'],
                'id_contrato' => $row['id_contrato'],
                'nm_pessoa' => utf8_encode($row['nm_pessoa']),
                'quadra' => utf8_encode($row['quadra']),
                'lote' => utf8_encode($row['lote']),
            );
        }

        echo json_encode($rowsJson);
    }

    public function lote_quitacao_by_empreendimentoAction()
    {
        $select = Zend_Db_Table::getDefaultAdapter()->select();
        $rows = $select
            ->from(array('L' => TB_LOTES), array('loteId' => 'id', 'lote', 'quadra'))
            ->join(array('C' => TB_CONTRATO), 'C.id_lote = L.id', array('id'))
            ->join(array('P' => TB_PESSOA), 'P.id = C.id_pessoa', array('nm_pessoa'))
            ->join(array('ph' => TB_PARCELA), 'ph.id_contrato = C.id', array())
            ->where('ph.pago = ?', '1')
            ->where('C.fl_gerado = ?', '1')
            ->where("fl_distrato = '0'")
            ->where('L.id_empreendimento = ?', $_POST['id_empreendimento'])
            ->order('P.nm_pessoa ASC')
            ->order('L.lote ASC')
            ->order('L.quadra ASC')
            ->group('C.id')->query()->fetchAll();
        $this->set('lotes', $rows);
        $this->display();
    }

    public function cliente_by_empreendimentoAction()
    {
        $select = Zend_Db_Table::getDefaultAdapter()->select();
        $rows = $select->from(array('L' => TB_LOTES), array())
            ->join(array('C' => TB_CONTRATO), 'C.id_lote = L.id', array('id'))
            ->join(array('P' => TB_PESSOA), 'P.id = C.id_pessoa', array('nm_pessoa', 'id'))
            ->where('C.fl_gerado = ?', '1')
            ->where('L.id_empreendimento = ?', $_POST['id_empreendimento'])
            ->where('fl_distrato = "0"')
            ->order('P.nm_pessoa ASC')
            ->distinct()->query()->fetchAll();
        $this->set('clientes', $rows);

        $this->display();
    }

    public function cliente_by_empreendimento2Action()
    {
        $select = Zend_Db_Table::getDefaultAdapter()->select();
        $rows = $select->from(array('L' => TB_LOTES), null)->join(array('C' => TB_CONTRATO), 'C.id_lote = L.id', null)->join(array('P' => TB_PESSOA), 'P.id = C.id_pessoa', array('nm_pessoa', 'id'))->where('C.fl_gerado = ?', '1')->where('L.id_empreendimento = ?', $_POST['id_empreendimento'])->where('fl_distrato = "0"')->order('P.nm_pessoa ASC')->distinct()->query()->fetchAll();
        $this->set('clientes', $rows);

        $this->display();
    }

    public function lotes_by_clienteAction()
    {
        $select = Zend_Db_Table::getDefaultAdapter()->select();
        $rows = $select->from(array('L' => TB_LOTES), array('lote', 'quadra', 'id'))->join(array('C' => TB_CONTRATO), 'C.id_lote = L.id', null)->join(array('P' => TB_PESSOA), 'P.id = C.id_pessoa', null)->where('C.fl_gerado = ?', '1')->where('L.id_empreendimento = ?', $_POST['id_empreendimento'])->where('C.id_pessoa = ?', $_POST['id_pessoa'])->where('fl_distrato = "0"')->order('L.lote ASC')->distinct()->query()->fetchAll();
        $this->set('lotes', $rows);
        $this->display();
    }

    public function corretor_by_empreendimentosAction()
    {
        $e = new Empreendimento();
        $empreendimentos = $e->select()->where('nm_empreendimento LIKE ?', '%' . $_GET['term'] . '%');
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimentos = $empreendimentos->limit(20)->query()->fetchAll();
        $response = array();
        foreach ($empreendimentos AS $empreendimento) {
            $response[] = array(
                'value' => utf8_encode($empreendimento['nm_empreendimento']),
                'nome' => utf8_encode($empreendimento['nm_empreendimento']),
                'id' => utf8_encode($empreendimento['id'])
            );
        }
        echo json_encode($response);
    }

    public function empreendimentoAction()
    {
        $instanceEmpreendimento = new Empreendimento();
        $adapter = $instanceEmpreendimento->getDefaultAdapter();
        $empreendimentos = $adapter->select()->from(array(TB_EMPREENDIMENTO), array('nm_empreendimento', 'id'))->where('nm_empreendimento LIKE ?', '%' . $_GET['q'] . '%')->query()->fetchAll();
        foreach ($empreendimentos AS $empreendimento) {
            echo utf8_encode($empreendimento['nm_empreendimento']) . '|' . utf8_encode($empreendimento['id']) . "\n";
        }
    }

    public function usuarioAction()
    {
        $instancePessoa = new Pessoa();
        $adapter = $instancePessoa->getDefaultAdapter();
        $pessoas = $adapter->select()->distinct('p.id')->from(array('p' => TB_PESSOA), array('p.*'))->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('pf.*'))->order('p.nm_pessoa')->query()->fetchAll();
        $response = array();
        foreach ($pessoas AS $pessoa) {
            $response[] = array(
                'value' => $pessoa['nm_pessoa'],
                'nome' => $pessoa['nm_pessoa'],
                'id' => $pessoa['id_pessoa']
            );
        }
        echo json_encode($response);
    }

    public function corretor_by_contratoAction()
    {
        $id_empreendimento = $_GET['idE'];
        $id_corretor = $_GET['idC'];
        $lote = new Lote();
        $lote = $lote->getDefaultAdapter();
        $result = $lote->select()->from(array('l' => TB_LOTES), array('l.id'))->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', '*')->where('l.id_empreendimento = ?', $id_empreendimento)->where('c.id_corretor = ?', $id_corretor)->query()->fetchAll();
        echo count($result);
    }

    public function contrato_by_empreendimento_alterar_parcelaAction()
    {
        $empreedimento = $_POST['id_empreendimento'];
        $contratos = Contrato::byEmpreendimento($empreedimento, Contrato::CONTRATO_GERADO, 0, array("nm_pessoa", "lote", "quadra", "id"));
        $this->set('contratos', $contratos);
        $this->display();
    }

    public function contrato_by_empreendimento_alterar_parcela_novoAction()
    {
        $empreedimento = $_POST['id_empreendimento'];
        $contratos = Contrato::byEmpreendimento($empreedimento, Contrato::CONTRATO_GERADO, 0, array("nm_pessoa", "lote", "quadra", "id"));
        
        foreach ($contratos as $k => $contrato)
        {
            $contratos[$k]['nm_pessoa'] = ($contrato['nm_pessoa']);
        }
        
        $this->set('contratos', $contratos);
        $this->display();
    }

    public function parcela_by_empreendimento_alterar_parcelaAction()
    {
        $parcelas = Parcela::getDefaultAdapter()->select()
            ->from(array('p' => TB_PARCELA), '*')
            ->where('p.id_contrato = ?', $_POST['id_contrato'])
            ->where('p.pago = "0"')
            ->where('id_remessa IS NULL')
            ->where('p.tp_parcela NOT IN("E","NE","SE","CE","IE")')
            ->order('p.dt_parcela');
        
        if (isset($_POST['tpParcela']) && $_POST['tpParcela'] != '*') {
            $parcelas = $parcelas->where("p.tp_parcela = '{$_POST['tpParcela']}'");
        }
        
        $parcelas = $parcelas->query()->fetchAll();
        $this->set('parcelas', $parcelas);
        unset($parcelas);
        $this->display();
    }

    public function login_by_empreendimentoAction()
    {
        echo Db_Usuario::loginIsAvailable($_POST['login']);
    }

    public function remessaAtualizarBancosAction()
    {
        $tb_banco = new Banco();
        $bancos = $tb_banco->getAdapter()->select()->from(array("b" => TB_BANCO), "")->join(array("tba" => TB_AGRUPADA), "tba.idCampo = b.cd_banco AND tba.idTabela = " . Db_TabelaAgrupada::TABLE_BANCO, array("idCampo", "descricao"))->where("b.id_empreendimento = " . $_POST["id_empreendimento"])->query()->fetchAll();
        $conteudo = '';
        foreach ($bancos as $banco) {
            $conteudo .= "<option value='" . $banco["idCampo"] . "'>" . $banco["descricao"] . "</option>";
        }
        echo $conteudo;
    }

    public function find_cidadeAction()
    {
        $tbCidade = new Cidade();
        $list = $tbCidade->select()
            ->from(array('c' => TB_CIDADE), array('nome', 'uf', 'id'))
            ->where("c.nome LIKE ?", $_GET['term'] . '%')
            ->where('c.uf = "'.$_GET['uf'].'"')
            ->order('c.nome')
            ->query()->fetchAll();
        $response = array();
        foreach ($list as $lt) {
            $response[] = array(
                'value' => $lt['nome'] . ' - ' . $lt['uf'],
                'nome' => $lt['nome'] . ' - ' . $lt['uf'],
                'id' => $lt['id']
            );
        }
        echo json_encode($response);
    }

    public function findCidadeAction()
    {
        $tbCidade = new Cidade();
        $list = $tbCidade->select()
            ->from(array('c' => TB_CIDADE), array('nome', 'uf', 'id'))
            ->where("c.nome LIKE ?", utf8_decode($_GET['term']) . '%')->order('c.nome')
            ->query()->fetchAll();
        $response = array();
        foreach ($list as $lt) {
            $response[] = array(
                'text' => utf8_encode($lt['nome']) . ' - ' . $lt['uf'],
                'value' => $lt['id']
            );
        }
        echo json_encode($response);
    }

    public function pesquisaExibeTitulosAction()
    {
        if ($_POST['numero']) {
            $select = Zend_Db_Table::getDefaultAdapter();
            $query = 'SELECT DISTINCT "ATIVO" as situacao, e.nm_empreendimento, e.id, h.nm_pessoa, l.lote, l.quadra, p.id_contrato,
          					p.id_parcela, c.nr_parcela,  p.tp_parcela, p.dt_parcela, p.vl_parcela, p.pago
	                        FROM PARCELA AS p LEFT JOIN CONTRATO as c ON c.id = p.id_contrato
	                        LEFT JOIN LOTES as l ON l.id = c.id_lote
	                        LEFT JOIN PESSOA as h ON h.id = c.id_pessoa
	                        LEFT JOIN EMPREENDIMENTO as e on e.id = l.id_empreendimento';
            if ($_POST['migradas'] == '1')
                $query .= ' WHERE p.id_parcela_contrato_antigo = "' . $_POST['numero'] . '"';
            else
                $query .= ' WHERE p.id_parcela_contrato = "' . $_POST['numero'] . '"';

            $row = $select->query($query);
            $resultado = $row->fetchAll();

            //Pesquisa na tabela PARCELA_HISTORICO as parcelas que ja foram pagas
            if (!$resultado) {
                $queryHistorico = 'SELECT DISTINCT "INATIVO" as situacao, e.nm_empreendimento, e.id, h.nm_pessoa, l.lote, l.quadra, p.id_contrato,
          					p.id_parcela, c.nr_parcela,  p.tp_parcela, p.dt_parcela, p.vl_parcela, p.pago
	                        FROM PARCELA_HISTORICO AS p
	                        LEFT JOIN CONTRATO_HISTORICO as c ON c.id = p.id_contrato
	                        LEFT JOIN LOTES as l ON l.id = c.id_lote
	                        LEFT JOIN PESSOA as h ON h.id = c.id_pessoa
	                        LEFT JOIN EMPREENDIMENTO as e on e.id = l.id_empreendimento';
                if ($_POST['migradas'] == '1')
                    $queryHistorico .= ' WHERE p.id_parcela_contrato_antigo = "' . $_POST['numero'] . '"';
                else
                    $queryHistorico .= ' WHERE p.id_parcela_contrato = "' . $_POST['numero'] . '"';

                $row = $select->query($queryHistorico);
                $resultado = $row->fetchAll();
            }

            //Pesquisa na tabela PARCELA_2VIA as parcelas que ja foram pagas
            if (!$resultado) {
                $row = $select->query('SELECT DISTINCT "EXCLUIDO" as situacao, e.nm_empreendimento, e.id, h.nm_pessoa, l.lote, l.quadra, p.id_contrato,
          					p.id_parcela, c.nr_parcela,  p.tp_parcela, p.dt_parcela, p.vl_parcela, p.pago
	                        FROM PARCELA_2VIA AS p
	                        LEFT JOIN CONTRATO as c ON c.id = p.id_contrato
	                        LEFT JOIN LOTES as l ON l.id = c.id_lote
	                        LEFT JOIN PESSOA as h ON h.id = c.id_pessoa
	                        LEFT JOIN EMPREENDIMENTO as e on e.id = l.id_empreendimento
	                        WHERE p.id_parcela_contrato = "' . $_POST['numero'] . '"');

                $resultado = $row->fetchAll();
            }

            //percorrer o array e preencher os campos
            foreach ($resultado AS $res) {
                echo json_encode(array(
                    'situacao' => utf8_encode($res['situacao']),
                    'empreendimento' => utf8_encode($res['nm_empreendimento']),
                    'idEmpreendimento' => $res['id'],
                    'cliente' => utf8_encode($res['nm_pessoa']),
                    'pago' => $res['pago'],
                    'lote' => utf8_encode($res['lote']),
                    'quadra' => utf8_encode($res['quadra']),
                    'num_contrato' => utf8_encode($res['id_contrato']),
                    'parcela' => utf8_encode($res['id_parcela']) . ' / ' . utf8_encode($res['nr_parcela']) . ' ' . utf8_encode($res['tp_parcela']),
                    'data' => Helper::getDate(utf8_encode($res['dt_parcela'])),
                    'valor' => utf8_encode($res['vl_parcela'])
                ));

            }
        }
        return;
    }

    /**
     * Recebe o numero do CPF do conjuge e retorna a pesquisa com todas informacoes da mesma
     */
    public function verificaCpfConjugeAction()
    {
        $pessoaConjuge = $this->tb_pessoa->getAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('nm_pessoa', 'nr_telefone', 'id', 'endereco', 'nr_cep', 'nm_bairro', 'cd_cidade','nr_endereco','ds_complemento'))
            ->join(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('nr_cpf', 'nr_rg', 'dt_nascimento', 'nm_profissao', 'nm_nacionalidade', 'sexo', 'cd_cidade_nasc', 'cd_documento'))
            ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', array('nm_cidade' => 'nome', 'uf'))
            ->joinLeft(array('ci' => TB_CIDADE), 'ci.id = pf.cd_cidade_nasc', array('nm_cidade_nasc' => 'nome', 'uf_nasc' => 'uf'))
            ->where('pf.nr_cpf = "' . $_POST['nrCpfConjuge'] . '" ')->where('p.fl_status = 1')->query()->fetch();

        if ($pessoaConjuge) {
            $pessoaConjuge['nm_pessoa'] = ($pessoaConjuge['nm_pessoa']) ? utf8_encode($pessoaConjuge['nm_pessoa']) : '';
            $pessoaConjuge['endereco'] = ($pessoaConjuge['endereco']) ? utf8_encode($pessoaConjuge['endereco']) : '';
            $pessoaConjuge['ds_complemento'] = ($pessoaConjuge['ds_complemento']) ? utf8_encode($pessoaConjuge['ds_complemento']) : '';
            $pessoaConjuge['nr_endereco'] = ($pessoaConjuge['nr_endereco']) ? utf8_encode($pessoaConjuge['nr_endereco']) : '';
            $pessoaConjuge['nr_cep'] = ($pessoaConjuge['nr_cep']) ? utf8_encode($pessoaConjuge['nr_cep']) : '';
            $pessoaConjuge['nm_bairro'] = ($pessoaConjuge['nm_bairro']) ? utf8_encode($pessoaConjuge['nm_bairro']) : '';
            $pessoaConjuge['nm_profissao'] = ($pessoaConjuge['nm_profissao']) ? utf8_encode($pessoaConjuge['nm_profissao']) : '';
            $pessoaConjuge['nm_nacionalidade'] = ($pessoaConjuge['nm_nacionalidade']) ? utf8_encode($pessoaConjuge['nm_nacionalidade']) : '';
            $pessoaConjuge['nm_cidade'] = ($pessoaConjuge['nm_cidade']) ? utf8_encode($pessoaConjuge['nm_cidade']) : '';
            $pessoaConjuge['nm_cidade_nasc'] = ($pessoaConjuge['nm_cidade_nasc']) ? utf8_encode($pessoaConjuge['nm_cidade_nasc']) : '';

            $pessoaConjuge['dt_nascimento'] = Helper::getDate($pessoaConjuge['dt_nascimento']);
            $pessoaConjuge['enderecoConjuge'] = ($pessoaConjuge['nr_cep'] || $pessoaConjuge['endereco'] || $pessoaConjuge['nm_bairro'] || $pessoaConjuge['cd_cidade']) ? true : false;
        } else {
            $pessoaConjuge = false;
        }

        echo json_encode($pessoaConjuge);

    }

    public function buscaParcelasEmissaoMultiAction() {

        $parcelas = new Parcela();
        $parcelas = $parcelas::buscaParcelasPeloIdParacelaContrato($_POST['idParcelas'], $_POST['idBanco']);

        echo json_encode($parcelas);
    }
}
