<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$params = $this->get('params');
$emps = $this->get('empreendimentos');
$mesesOptions = $this->get('meses');
?>
<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Gerar','Relatrio Reajuste', 'fa fa-file-o'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <!-- MENSAGENS -->
            <div class="alert alert-danger alert-dismissable msgErros" hidden></div>
            <div class="alert alert-success alert-dismissable msgSucess" hidden>Operao realizada com sucesso.
            </div>
            <form action="#" method="POST" id="form" target="_blank">
                <input type="hidden" name="action" value="listarContratos"/>
                <fieldset>
                    <legend>
                        Informaes do Relatrio de Reajuste <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                    </legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="id_empreendimento">
                                    Empreendimento:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 idEmpreendimentoReajuste" required="required" id="idEmpreendimento" name="idEmpreendimento" data-placeholder="Escolha o empreendimento">
                                    <option value=""></option>
                                    <?php foreach ($emps as $emp) : ?>
                                        <option value="<?php echo $emp['empreendimento_id']; ?>"><?php echo $emp['empreendimento_nome']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="id_empreendimento" id="tprelatorio">
                                    Tipos de relatrio:
                                </label><br>
                                <div class="form-group col-sm-1" style="width: 150px;">
                                    <input type="radio" class="form-control icheck" name="tp_relatorio" id="tipoRel" value="R" checked/>
                                    <label for="tipoRel">Reajustados</label>
                                </div>
                                <div class="form-group col-sm-1" style="width: 130px;">
                                    <input type="radio" class="form-control icheck" name="tp_relatorio" id="tipoRea" value="A" />
                                    <label for="tipoRea">A reajustar</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="id_empreendimento">
                                    Ms do reajuste:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2" required="required"
                                        id="mesReajuste" name="mes_reajuste"
                                        data-placeholder="Escolha o ms">
                                    <option value=""></option>
                                    <?php
                                    foreach ($mesesOptions as $k => $option):
                                        $selected = '';
                                        if ($params['mes_inicial'] == $k) {
                                            $selected = "selected";
                                        }
                                        ?>
                                        <option <?php echo $selected; ?> value="<?php echo $k; ?>"><?php echo $option; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-3">
                                <label for="data" class="control-label">Ano: </label>
                                <input type="text" class="form-control ano" id="anoInicial"
                                    name="ano_inicial"
                                    placeholder="Ano."
                                    value="<?= $params['ano_inicial']; ?>"
                                >
                            </div>
                            <div class="form-group col-sm-6" id="divinfo">
                                <label class="control-label" for="id_empreendimento">
                                    Informaes:
                                </label><br>
                                <div class="form-group col-sm-1" style="width: 150px;">
                                    <input type="radio" class="form-control icheck" name="informacoes" id="resumido" value="R" checked/>
                                    <label for="resumido">Resumido</label>
                                </div>
                                <div class="form-group col-sm-1" style="width: 130px;">
                                    <input type="radio" class="form-control icheck" name="informacoes" id="completo" value="C" />
                                    <label for="completo">Completo</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6" id="divIndice">
                                <label class="control-label" for="idIndice">
                                    ndice:<span style="color: red">*</span>
                                </label>
                                <select 
                                    class="form-control select2"
                                    id="idIndice"
                                    name="idIndice"
                                    data-placeholder="Selecione o empreendimento para listar os ndices"
                                >
                            </select>
                            </div>
                        </div>
                    </div>
                    </table>
                </fieldset>
                <fieldset>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <input type="button" id="gerar" class="btn btn-primary col-sm-12 fDesabilitaBtn"
                                       value="Gerar">
                            </div>
                            <div class="form-group col-sm-2">
                                <a href="?m=fin&c=reajuste"
                                   class="btn btn-danger col-sm-12">Cancelar </a>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>
