<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$listaContratos = $this->get('listaContratos');
$infoIndice = $this->get('infoIndice');
$post = $this->get('post');
$mesesOptions = $this->get('meses');
$dadosReajuste = $this->get('dadosReajuste');
$parcelasDados = $this->get('parcelasDados');
$indicePosEntrega = ($infoIndice['fl_periodo']=='AM')?$infoIndice['indice_pos_entrega']:0;
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader('Adicionar', 'Reajuste', 'icon-plus-2'); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <?php
                //MENSAGENS
                foreach ($this->_helper->getMensagens() as $tipo => $message) {
                    if($tipo == 'danger') {
                        echo '<div class="alert alert-danger alert-dismissable">'.$message.'</div><br>';
                    } else {
                        echo '<div class="alert alert-warning alert-dismissable">'.$message.'</div><br>';
                    }
                }

                if ($post['warningParcelasPagas'] != '') {
                    echo '<div class="alert alert-warning alert-dismissable">'.$post['warningParcelasPagas'].'</div><br>';
                }

                if (isset($infoIndice['warningIndices'])) {
                    echo '<div class="alert alert-warning alert-dismissable">'.$infoIndice['warningIndices'].'</div><br>';
                }

                ?>
                <input type="hidden" name="idEmpreendimento" value="<?= $_POST['idEmpreendimento']; ?>"/>
                <input type="hidden" name="mes_inicial" value="<?= $_POST['mes_inicial']; ?>"/>
                <input type="hidden" name="ano_inicial" value="<?= $_POST['ano_inicial']; ?>"/>
                <input type="hidden" name="calculo" value="true">
                <form action="" method="POST" id="form">
                    <legend><?= ($post['tpReajuste'] == 'A')?'Reajuste Automtico':'Reajuste Manual'?></legend>
                    <div class="row">
                        <div class="form-group col-sm-12">
                            <div class="form-group col-sm-12" >
                                <div class="table-responsive tableFix">
                                    <table id="TabelaListar" class="table  table-hover table-condensed order-column" cellspacing="0" width="100%">
                                        <thead>
                                        <tr>
                                            <?php if($post['tpReajuste'] == 'A'): ?>
                                                <th width="20px">
                                                    <div align="center"><input checked id="checkPrincipal" type="checkbox" name="checkPrincipal"></div>
                                                </th>
                                            <?php endif; ?>
                                            <th>
                                                <div align="center">Contrato</div>
                                            </th>
                                            <th>
                                                <div align="center">Cliente</div>
                                            </th>
                                            <th width="10px;">
                                                <div align="center">Qdr</div>
                                            </th>
                                            <th width="10px;">
                                                <div align="center">Lt</div>
                                            </th>
                                            <th width="140">Parcela a ser reajustada</th>
                                            <th width="90">ltimo reaj.</th>
                                            <?php if ($infoIndice['fl_residuo'] == '1'): ?>
                                                <th width="100">Total resduo</th>
                                                <th width="120">Resduo por parcela</th>
                                            <?php endif; ?>
                                            <th width="90">Tipo de parcela</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach ($listaContratos as $contrato) : ?>
                                            <tr>
                                                <?php if($post['tpReajuste'] == 'A'): ?>
                                                    <td align="center">
                                                        <input checked id="contrato_<?= $contrato['id'] ?>" type="checkbox" name="contratos[]" value="<?= $contrato['id'] ?>">
                                                    </td>
                                                <?php else: ?>
                                                    <input id="contrato_<?= $contrato['id'] ?>" type="hidden" name="contratos[]" value="<?= $contrato['id'] ?>">
                                                <?php endif; ?>
                                                <td align="center">
                                                    <?= $contrato['id'] ?>
                                                </td>
                                                <td align="center">
                                                    <?= $contrato['nm_pessoa'] ?>
                                                </td>
                                                <td align="center">
                                                    <?= $contrato['quadra']?>
                                                </td>
                                                <td align="center">
                                                    <?= $contrato['lote']?>
                                                </td>
                                                <td align="center">
                                                    <?= $contrato['id_parcela'] . $contrato['tp_parcela'] . ' - ' . Helper::getDate($contrato['dt_parcela']) ?>
                                                </td>
                                                <td align="center">
                                                    <?= $contrato['ultimoReajuste']; ?>
                                                </td>
                                                <?php if ($infoIndice['fl_residuo'] == '1'): ?>
                                                    <td align="center">
                                                        <input type="text" class="form-control money calculaResiduo"
                                                               name="vlResiduo_<?= $contrato['id'] ?>"
                                                               qtdeParc="<?= $contrato['qtdeTotalParcNaoPagas']?>"
                                                               value="<?= Helper::getMoney($contrato['vlResiduo'])?>">
                                                    </td>
                                                    <td align="center" id="vlResiduoIndividual_<?= $contrato['id'] ?>">
                                                        <?= Helper::getMoney($contrato['vlResiduoIndividual']).' (x'.$contrato['qtdeTotalParcNaoPagas'].')'?>
                                                    </td>
                                                <?php endif; ?>
                                                <td align="center">
                                                    <?= $parcelasDados[1]; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="parcela_valor">
                                    Indice(%): <span style="color: red;">(<?= $infoIndice['nome']?>)</span></label>
                                <input type="text" class="form-control percent" name="vlIndice"
                                       placeholder="% ndice" value="<?= $infoIndice['percReajuste']?>">
                                <input type="hidden" name="idIndice" value="<?= $infoIndice['id']?>">
                            </div>
                            <?php if ($infoIndice['flPeriodo'] == 'AM'):?>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="parcela_valor">
                                        Indice ps entrega(%): <span style="color: red;">*</span></label>
                                    <input type="text" class="form-control percent" name="vlIndicePosEntrega"
                                           placeholder="% ndice ps entrega" value="<?= str_replace('.',',',$infoIndice['indicePosEntrega'])?>">
                                </div>
                            <?php endif;?>
                            <?php if ($indicePosEntrega && $indicePosEntrega > 0): ?>
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="parcela_valor">
                                        Indice ps entrega:
                                        <strong><?= Helper::getMoney($indicePosEntrega, 3) ?> %</strong>
                                    </label>
                                </div>
                            <?php endif; ?>
                            <div class="form-group col-sm-4">
                                <label class="control-label" for="id_empreendimento">
                                    Reajustar a partir de:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2" required="required"
                                        id="mesReajuste" name="mes_reajuste"
                                        data-placeholder="Escolha o ms">
                                    <option value=""></option>
                                    <?php
                                    foreach ($mesesOptions as $k => $option):
                                        $selected = '';
                                        if ($k == $post['mes_inicial']) {
                                            $selected = "selected";
                                        }
                                        ?>
                                        <option <?= ($k < $post['mes_inicial'])? 'enable': '';?><?= $selected; ?> value="<?= $k; ?>"><?= $option; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="data" class="control-label">Ano:<span class="require" style="color: red">*</span> </label>
                                <input type="text" class="form-control ano" id="anoInicial"
                                       name="ano_reajuste" placeholder="Ano" value="<?= $post['ano_inicial'] ?>">
                                <input type="hidden" name='anoDefault' id='anoDefault' value="<?= $post['ano_inicial'] ?>"/>
                            </div>
                        </div>
                    </div>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 DesabilitaBtn" value="Reajustar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=fin&c=reajuste&a=reajuste"
                                       class="btn btn-danger col-sm-12">Cancelar</a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>