<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$emps = $this->get('empreendimentos');
$mesesOptions = $this->get('meses');
$TiposParcela = $this->get('tiposParcela');
?>
<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Adicionar', 'Reajuste', 'icon-plus-2'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <!-- MENSAGENS -->
            <?php if (count($this->_helper->getMensagens()) > 0) : ?>
                <div class="alert alert-danger alert-dismissable">
                    <?php foreach ($this->_helper->getMensagens() as $message) : ?>
                        <?= $message ?><br>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            <?= (isset($_GET["exception"])) ? '<div class="alert alert-danger alert-dismissable">' . $_GET["exception"] . '</div>' : ''; ?>
            <form action="" method="POST" id="form" name="frmReajuste">
                <fieldset>
                    <legend>
                        Informaes do Reajuste Parcelas <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                        <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                            <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                            </svg>
                        </span>
                    </legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="id_empreendimento">
                                    Empreendimento:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 idEmpreendimentoReajuste" required="required" id="idEmpreendimento" name="idEmpreendimento" data-placeholder="Escolha o empreendimento">
                                    <option value=""></option>
                                    <?php foreach ($emps as $emp) : ?>
                                        <option value="<?php echo $emp['id']; ?>"><?php echo $emp['nm_empreendimento']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-6" id="tabelaReajuste">
                                <label class="control-label">
                                    Tipos de reajuste:<span class="require" style="color: red">*</span>
                                </label><br>
                                <div class="form-group col-sm-1" style="width: 130px;">
                                    <input type="radio" class="form-control icheck reajAdicionar" name="tpReajuste" id="auto" value="A" checked />
                                    <label for="auto">Grupo</label>
                                </div>
                                <div class="form-group col-sm-1" style="width: 150px;">
                                    <input type="radio" class="form-control icheck reajAdicionar" name="tpReajuste" id="manual" value="M" />
                                    <label for="manual">Individual</label>
                                </div>
                            </div>
                            <div class="form-group col-sm-6" id="divContrato" hidden>
                                <label class="control-label" for="id_empreendimento">
                                    Contrato:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2" name="idContrato" id="idContrato" data-placeholder="Escolha o contrato" style="width: 100%;">
                                    <option value=""></option>
                                    <?php echo $this->get("contratos"); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="id_empreendimento">
                                    Ms do reajuste:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2" required="required" id="mesInicial" name="mes_inicial" data-placeholder="Escolha o ms">
                                    <option value=""></option>
                                    <?php
                                    foreach ($mesesOptions as $k => $option) : ?>
                                        <option <?php echo $selected; ?> value="<?php echo $k; ?>"><?php echo $option; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-3">
                                <label for="data" class="control-label">Ano:<span class="require" style="color: red">*</span> </label>
                                <input type="text" class="form-control ano" id="anoInicial" name="ano_inicial" placeholder="Ano" value="" required="required">
                            </div>
                            <div class="form-group col-sm-3" id="divIndice">
                                <label class="control-label" for="idIndice">
                                    ndice:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2" id="idIndice" name="idIndice" data-placeholder="Escolha o ndice">
                                    <option value=""></option>
                                </select>
                            </div>
                            <div class="form-group col-sm-3" id="divReajusteFora" hidden>
                                <label for="reajusteFora">
                                    Reajustar fora do perodo:
                                </label>
                                <div>
                                    <input class="form-control icheck" id="reajusteFora" name="reajusteFora" type="checkbox" disabled>
                                </div>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="id_empreendimento">
                                    Tipos de parcela:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2" required="required" id="tipoParcela" name="tipoParcela" data-placeholder="Escolha o tipo">
                                    <option value=""></option>
                                    <?php
                                    foreach ($TiposParcela as $k => $option) : ?>
                                        <option <?php echo $selected; ?> value="<?php echo $k; ?>"><?php echo $option; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group col-sm-8" id="divAtencao" style="display: none;">
                            <label class="control-label" style="color: red" id="dataReajusteForaPrazo">
                            </label>
                        </div>
                    </div>
                </fieldset>
                <fieldset>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <input type="submit" id="btnSalvar" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Avanar">
                            </div>
                            <div class="form-group col-sm-2">
                                <a href="?m=fin&c=reajuste" class="btn btn-danger col-sm-12">Cancelar </a>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>
        </div>
    </div>
</div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Reajuste de Parcelas - Painel de Reajustes de Parcelas</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/p3A4EEyrvBU?si=LEbsTL_WL0JRtBY5" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>