<?php
$empreendimento = $this->get('empreendimento');
$lote = $this->get('lote');
$cliente = $this->get('cliente');
$clienteAcade = $this->get("clienteAcade");
$parceria = $this->get('parceria');
$contrato = $this->get('contrato');
$assinatura = $this->get('assinatura');
$outrosCompradores = $this->get('pessoas_envolvidas');
$tipoPagamento = $this->get('tipoPagamento');

$isVista = ($contrato['nr_parcela'] == 1);

$arrData = explode("/", $_POST['data']);
$dia = $arrData[0];
$mes = $arrData[1];
$ano = $arrData[2];

$dataAssinatura = explode('-', $contrato['dt_contrato']);

$diaAssinatura = $dataAssinatura[2];
$mesAssinatura = $dataAssinatura[1];
$anoAssinatura = $dataAssinatura[0];

$cidadeEmpreedimento = array();
if ($cidadeEmpreedimento = Db_Cidade::find($empreendimento['cd_cidade']))
    $cidadeEmpreedimento = $cidadeEmpreedimento->toArray();

$pessoas = new Pessoa();
$pfs = new Pessoa_Fisica();
$pjs = new Pessoa_Juridica();

$tipo = 'IMVEL RESIDENCIAL NO EDIFICADO (LOTE)';
$loteLoja = 'Lote';
if ($_POST['tipo'] == 'c') {
    $loteLoja = 'Loja';
    $tipo = 'LOJA COMERCIAL EDIFICADA';
}

$estadoCivil = Db_TabelaAgrupada::find( Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $cliente['est_civil']);
function gerarCitacao(array $pessoa)
{
    if ($cidade = Db_Cidade::find($pessoa['cd_cidade']))
        $cidade = $cidade->toArray();

    $pfs = new Pessoa_Fisica();
    $pjs = new Pessoa_Juridica();

    if ($pessoa['tp_pessoa'] == 'F') {
        $pf = $pfs->fetchRow('id_pessoa = ' . $pessoa['id']);
        $pessoa['nr_cpf'] = $pf->nr_cpf;
    } else {
        $pj = $pjs->fetchRow('id_pessoa = ' . $pessoa['id']);
        $pessoa['nr_cnpj'] = $pj->nr_cnpj;
    }
    $cpfCnpj = ($pessoa['tp_pessoa'] == 'F') ? "CPF/MF sob n {$pessoa['nr_cpf']}" : "CNPJ/MF {$pessoa['nr_cnpj']}";
    $str = '<b> 1.1 VENDEDOR (A) ' . Helper::str2Upper($pessoa['nm_pessoa']) . '</b>, sediada na ' . $pessoa['endereco'] . ', ' . $pessoa['nr_endereco'] . ', ' . $pessoa['ds_complemento'] . ' - ' . $pessoa['nm_bairro'] . ' - ' . $cidade['nome'] . ' / ' . Db_Cidade::getEstados($cidade['uf']) . ',
            devidamente inscrita no ' . $cpfCnpj . '.';
    return $str;
}

?>
<page backtop="10mm" backbottom="10mm">
    <page_header></page_header>
    <page_footer></page_footer>
    <style type="text/css">
        div.espaco {
            margin-top: 100px;
        }

        body {
            font-family: arial;
            font-size: 12px;
        }

        div {
            font-size: 12px;
        }

        h2 {
            text-align: center;
            font-size: 13px;
        }

        table tr td.h3 {
            font-size: 12px;
        }

        h4 {
            font-size: 11px;
        }

        table {
            width: 100%;
            font-size: 11px;
        }

        .grid {
            border-collapse: collapse;
            width: 700px;
        }

        .grid tr td {
            border: 2px solid #000000;
        }

        table.parcelas {
            border-collapse: collapse;
            width: 700px;
            margin-top: 10px;
        }

        table.parcelas tr td {
            border: 2px solid #000000;
            width: 80px;
            font-size: 11px;
            text-align: center;
        }

        table.parcelas2 {
            border-collapse: collapse;
            width: 700px;
        }

        table.parcelas2 tr td {
            border: 2px solid #000000;
            width: 100px;
            font-size: 11px;
            text-align: center;
        }

        table.vista {
            border-collapse: collapse;
        }

        table.vista tr td {
            border: 2px solid #000000;
            width: 175px;
            font-size: 11px;
            text-align: center;
        }

        .table_bordas {
            border-collapse: collapse;
            width: 730px;
        }

        .table_bordas tr td {
            border: 1px solid #000000;
            font-size: 11px;
        }
    </style>

    <div style="text-align: left;font-size: 20px;">
        <!-- Logomarca Cliente Acade -->
        <?php        
            $dsEmpreendimentoPathLogo = $empreendimento['ds_path_logo'];
            $dsEndLogomarca = $clienteAcade['ds_end_logomarca'];

            if ($dsEmpreendimentoPathLogo && file_exists($dsEmpreendimentoPathLogo)) {
                echo '<img src="' . $dsEmpreendimentoPathLogo . '" alt="' . $cabecalho['empreendimento'] . '" height="120" />';
            }
            elseif ($dsEndLogomarca && file_exists($dsEndLogomarca)) {
                echo '<img src="' . $dsEndLogomarca . '" alt="' . $cliente['nm_fantasia'] . '" height="120" />';
            } else {
                echo '<img style="float: left; " src="' . LOGOMARCA_DEFAULT . '" alt="LogoPadrao" height="80" />';
            }
        ?>
    </div>
    <br>
    <br>
    <table>
        <tr>
            <td style="width:730px;" align="center"><strong style="font-size:12px;">TERMO DE QUITAO</strong>
            </td>
        </tr>
    </table>
    <?php
    foreach ($parceria as $parc) {
        $str .= gerarCitacao($pessoas->find($parc['id_pessoa'])->current()->toArray());
    }
    ?>
    <table border="1" style="background-color: #CCCCCC; margin-top: 20px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;">1.
                    PARTES:</strong>
            </td>

        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="744px;" style="padding-left: 5px;">
                <p style="text-align:justify; "><?= $str; ?></p>

                <p style="text-align:justify; ">
                    <?php if ($cliente['tp_pessoa'] == 'F') : ?>
                        <b>1.2 COMPRADOR
                            (A): <?= $cliente['nm_pessoa']; ?></b>, <?= $cliente['nm_nacionalidade']; ?>,
                        <?= ($estadoCivil) ? $estadoCivil->getDescricao() : ''; ?>,
                        <?= $cliente['nm_profissao']; ?>, portador da Cdula de Identidade n <?= $cliente['nr_rg']; ?>,
                        CPF <?= $cliente['nr_cpf']; ?>, residente domiciliado em <?= $cliente['cidade']['nome']; ?> / <?= Db_Cidade::getEstados($cliente['cidade']['uf']); ?>,
                        na <?= $cliente['endereco']; ?>, <?= $cliente['nr_endereco'] ?>, <?= $cliente['ds_complemento'] ?>, <?= $cliente['nm_bairro']; ?>  - Cep: <?= $cliente['nr_cep']; ?>.

                    <?php elseif ($cliente['tp_pessoa'] == 'J') : ?>
                    <b>1.2 COMPRADOR
                        (A): <?= $cliente['nm_pessoa'] . '</b>, pessoa jurdica de direito privado, inscrita no CNPJ/MF sob n <b>' . $cliente['nr_cnpj'] . '</b>, com sede ' .
                        'na ' . $cliente['endereco'] . ', ' . $cliente['nr_endereco'] . ', ' . $cliente['ds_complemento'] . ', ' . $cliente['nm_bairro'] . ' - ' . $cliente['cidade']['nome'] . '/' .
                        Db_Cidade::getEstados($cliente['cidade']['uf']) . '.' ?>
                        <?php endif; ?>
                        <?php if ($outrosCompradores): ?>
                        <?php $i=2; ?>
                        <?php foreach ($outrosCompradores as $comprador):  ?>
                            <?php $estadoCivilOutros = Db_TabelaAgrupada::find( Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $comprador['est_civil']);?>
                        <?php if ($comprador['tp_pessoa'] == 'F') : ?>
                            <b>COMPRADOR
                                (A): <?= $comprador['nm_pessoa']; ?></b>, <?= $comprador['nm_nacionalidade']; ?>,  
                            <?= ($estadoCivilOutros) ? $estadoCivilOutros->getDescricao() : ''; ?>,
                            <?= $comprador['nm_profissao']; ?>, portador da Cdula de Identidade n <?= $comprador['nr_rg']; ?>,
                            CPF <?= $comprador['nr_cpf']; ?>, residente domiciliado em <?= $comprador['cidade']['nome']; ?> / <?= Db_Cidade::getEstados($comprador['cidade']['uf']); ?>, na <?= $comprador['endereco']; ?>, <?= $comprador['nm_bairro']; ?>  - Cep: <?= $comprador['nr_cep']; ?>.

                        <?php elseif ($comprador['tp_pessoa'] == 'J') : ?>
                        <b>COMPRADOR
                            (A): <?= $comprador['nm_pessoa'] . '</b>, pessoa jurdica de direito privado, inscrita no CNPJ/MF sob n <b>' . $comprador['nr_cnpj'] . '</b>, com sede ' . 'na ' . $comprador['endereco'] . ', ' . $comprador['nm_bairro'] . '-' . $comprador['cidade']['nome'] . '/' .    Db_Cidade::getEstados($comprador['cidade']['uf']) . '.' ?>
                            <?php endif; ?>
                            <?php endforeach; ?>
                            <?php endif; ?>
                </p>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC; margin-top: 20px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;">2. DO
                    CONTRATO:</strong>
            </td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="744px;" style="padding-left: 5px;">
                <p style="text-align:justify; ">Contrato de Promessa de Compra e Venda, datado
                    de <?= "$diaAssinatura de " . strtolower(Helper::getMes(str_pad($mesAssinatura, 2, '0', STR_PAD_LEFT))) . " de $anoAssinatura."; ?></p>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC; margin-top: 20px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;">3. OBJETO -
                    IMVEL:</strong></td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="744px;" style="padding-left: 5px;">
                <p style="text-align:justify; "><?= $empreendimento['dsSubgrupo']?> <?= $lote['lote']; ?>, <?= $empreendimento['dsGrupo']?> <?= $lote['quadra'] ?>,
                    Contrato <?= $contrato['id'] ?>, localizado no
                    Empreendimento <?= Helper::str2Upper($empreendimento['nm_empreendimento']); ?>, <?= $empreendimento['cidade']; ?></p>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC; margin-top: 20px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;">4. VALOR PARA
                    A
                    QUITAO:</strong></td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="744px;" style="padding-left: 5px;">
                <p style="text-align:justify; ">O valor nominal do contrato objeto da presente quitao perfaz o total
                    de
                    <?php
                    $total = $contrato['vl_pago'];
                    if ($total > 0) {
                        echo "R$ <strong style='float:left;'>" . number_format($total, 2, ',', '.') . "</strong> <strong style='float:left;font-weight: normal;'>( " . utf8_decode(Helper::valorPorExtenso($total)) . " )</strong>";
                    }
                    ?> pago e recebido 
                    <?= $tipoPagamento; ?>

                </p>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC; margin-top: 20px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;">5. FINS DA
                    QUITAO:</strong></td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="744px;" style="padding-left: 5px;">
                <p style="text-align:justify; ">Pelo presente, fica estabelecido a <b>DEVIDA E COMPLETA</b>
                    quitao do valor pactuado.
                </p>
            </td>
        </tr>
    </table>
    <?php if($cliente['obs']) : ?>
    <table border="1" style="background-color: #CCCCCC; margin-top: 20px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;">6. OBSERVAO:</strong></td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="744px;" style="padding-left: 5px;">
                <p style="text-align: justify;"><?= $cliente['obs'] ?></p>                
            </td>
        </tr>
    </table>
    <?php endif; ?>
    <table style="margin-top:30px;">
        <tr>
            <td style="width:750px;border: 1px #fff solid;" align="right">
                <?= $cidadeEmpreedimento['nome'] . ", $dia de " . strtolower(Helper::getMes(str_pad($mes, 2, '0', STR_PAD_LEFT))) . " de $ano."; ?></td>
        </tr>
    </table>
    <table style="margin-top: -10px;" align='center'>
        <?php if ($empreendimento['fl_assinatura'] == 'PE') : ?>
            <?php
            $assinaturas = $this->get('assinatura');
            $listaAssinaturas = array_chunk($assinaturas, 2);

            foreach ($listaAssinaturas as $assinaturas) : ?>
                <tr>
                    <?php foreach ($assinaturas as $ass): ?>
                        <td style="padding-top: 30px;width:350px;" align="center">__________________________________________________
                        </td>
                    <?php endforeach; ?>
                </tr>
                <tr>
                    <?php foreach ($assinaturas as $ass) : ?>
                        <td style="padding-top: -10px; font-size: 13px;width:350px;" align="center">
                            <?php
                            $id = $ass['id_pessoa'];
                            $pes = $pessoas->find($id)->current();
                            $pf = $pfs->find($id)->current();
                            if ($pf) {
                                echo '<br />' . $pes['nm_pessoa'] . '<br /> CPF/MF:' . $pf['nr_cpf'];
                            } else {
                                $pj = $pjs->find($id)->current();
                                echo '<br />' . $pes['nm_pessoa'] . '<br /> CNPJ/MF:' . $pj['nr_cnpj'];
                            }
                            ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach; ?>
        <?php elseif ($empreendimento['fl_assinatura'] == 'E') : ?>
            <tr>
                <td style="padding-top: 30px;width:350px;" align="center">__________________________________________________
                </td>
            </tr>
            <tr>
                <td style="padding-top: 01px; font-size: 13px;width:350px;" align="center">
                    <?= Helper::str2Upper($empreendimento['nm_empreendimento']) ?>
                </td>
            </tr>
        <?php elseif ($empreendimento['fl_assinatura'] == 'PI') : ?>
            <?php
            $parceria = $this->get('parceria');
            $listaAssinaturas = array_chunk($parceria, 2);

            foreach ($listaAssinaturas as $assinaturas) : ?>
                <tr>
                    <?php foreach ($assinaturas as $ass): ?>
                        <td style="padding-top: 30px;width:350px;" align="center">__________________________________________________
                        </td>
                    <?php endforeach; ?>
                </tr>
                <tr>
                    <?php foreach ($assinaturas as $ass) : ?>
                        <td style="padding-top: -10px; font-size: 13px;width:350px;" align="center">
                            <?php
                            $id = $ass['id_pessoa'];
                            $pes = $pessoas->find($id)->current();
                            $pf = $pfs->find($id)->current();
                            if ($pf) {
                                echo '<br />' . $pes['nm_pessoa'] . '<br /> CPF/MF:' . $pf['nr_cpf'];
                            } else {
                                $pj = $pjs->find($id)->current();
                                echo '<br />' . $pes['nm_pessoa'] . '<br /> CNPJ/MF:' . $pj['nr_cnpj'];
                            }
                            ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
    </table>
</page>