<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$contrato = $this->get('contrato');
?>

<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Adicionar', 'Quitao', 'fa fa-plus'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <form action="?m=fin&c=quitacao&a=salvar" method="POST">
                <input type="hidden" id="totalGeral" value="<?= $contrato['total']; ?>"/>
                <input type="hidden" id="qtdParcelas" value="<?= count($contrato['parcelasNovas']); ?>"/>
                <input type="hidden" class="desconto" name="desconto"/>
                <input type="hidden" class="acrescimo" name="acrescimo"/>
                
                <legend>Passo 4 (Finalizao) <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span></legend>
                <fieldset>
                    <legend>Negociao de Parcelas em Atraso</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-4" style="padding-top: 10px;font-size: 17px;right: 15px;">
                                Cliente: <strong><?= $contrato['nm_pessoa'] ?></strong><br>
                                Contrato: <strong><?= $contrato['numero'] ?></strong> /
                                Quadra: <strong><?= $contrato['quadra'] ?></strong> /
                                Lote: <strong><?= $contrato['lote'] ?></strong><br>
                                Total geral: <b id="total">R$ <?= $contrato['total']; ?></b><br>
                                <?php foreach ($contrato['parcelas'] as $parcela) : ?>
                                    <?php ($parcela['desconto'] > 0) ? $desc += $parcela['desconto'] : 0; ?>
                                    <?php ($parcela['acrescimo'] > 0) ? $acres += $parcela['acrescimo'] : 0; ?>
                                <?php endforeach; ?>
                                Desconto: <b id="desconto" class="desconto" style="color: #FF0000">R$ <?= Helper::getMoney($desc); ?></b><br>
                                Acrscimo: <b id="acrescimo" class="acrescimo" style="color: #008000">R$ <?= Helper::getMoney($acres); ?></b>
                            </div>
                        </div>
                    </div>
                </fieldset>
                <div class="table-responsive" style="max-height: 300px">
                    <table id="TabelaListarPasso4" class="table  table-hover table-condensed order-column" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th width="40px">
                                    Parcela
                                </th>
                                <th width="40px">
                                    Vencimento
                                </th>
                                <th width="40px">
                                    Tipo
                                </th>
                                <th width="40px">
                                    Valor
                                </th>
                            </tr>
                        </thead>
                        <tbody class="table-responsive" style="max-height: 100px">
                            <?php $i = 1; ?>
                            <?php foreach ($contrato['parcelasNovas'] as $parcela) : ?>
                                <tr>
                                    <td align="center">
                                        <?= $i ?>
                                    </td>
                                    <td align="center">
                                        <input class="data datepicker-input" type="text" size="8" name="data[]" value="<?= $parcela['dt_parcela']; ?>" required/>
                                    </td>
                                    <td align="center">
                                        Q
                                    </td>
                                    <td align="center">
                                        R$ <input class="money" type="text" size="8" name="valor[]" value="<?= $parcela['vl_parcela']; ?>" required/>
                                    </td>
                                </tr>
                                <?php $i++; ?>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <!--HIDDENs-->
                <input type="hidden" id="valorParcela" value="<?= $parcela['vl_parcela'] ?>" />
                <input type="hidden" name="passo" value="4" />
                <!--SOLUO ENCONTRADA PARA PEGAR OS VALORES DE DESCONTO, MULTA, JUROS E ACRESCIMO! COPIADA DE NEGOCIACAO -->
                <?php foreach ($contrato['parcelas'] as $dados) : ?>
                    <input type="hidden" name="multa_<?php echo $dados['id_parcela_contrato']; ?>" value="<?php echo $dados['vl_multa']; ?>">
                    <input type="hidden" name="juros_<?php echo $dados['id_parcela_contrato']; ?>" value="<?php echo $dados['vl_juros']; ?>">
                    <input type="hidden" name="acrescimo_<?php echo $dados['id_parcela_contrato']; ?>" value="<?php echo $dados['acrescimo']; ?>">
                    <input type="hidden" name="desconto_<?php echo $dados['id_parcela_contrato']; ?>" value="<?php echo $dados['desconto']; ?>">
                <?php endforeach; ?>
                <fieldset>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <input type="submit" id="btnPasso4" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Avanar">
                            </div>
                            <div class="form-group col-sm-2">
                                <a href="?m=fin&c=quitacao&a=passo3" class="btn btn-danger col-sm-12">Voltar </a>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>
        </div>
        <?php require_once 'layout/includes/footer.php'; ?>