<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$contrato = $this->get('contrato');
$valoresSomados = $this->get('valoresSomados');
?>

<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Adicionar', 'Quitao', 'fa fa-plus'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <form action="?m=fin&c=quitacao&a=passo4" method="POST">
                <legend>Passo 3 (Clculo) <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span></legend>
                <fieldset>
                    <legend>Negociao de Parcelas em Atraso</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-4" style="padding-top: 10px;font-size: 15px;right: 15px;">
                                Cliente: <strong><?= $contrato['nm_pessoa'] ?></strong><br>
                                Contrato: <strong><?= $contrato['numero'] ?></strong> /
                                Quadra: <strong><?= $contrato['quadra'] ?></strong> /
                                Lote: <strong><?= $contrato['lote'] ?></strong>
                                <br>
                                <span style="color: red; font-size: 12px">Obs: Juros e multa com base na data da primeira parcela!</span>
                            </div>
                            <div class="form-group col-sm-8" style="left: 240px;">
                                <div class="form-group col-sm-4">
                                    <label class="control-label">
                                        Qtd parcelas<?= ($contrato['tipo'] == 'N' ? ' negociadas' : ' renegociadas') ?>:<span style="color: red">*</span>
                                    </label>
                                    <input class="form-control" type="number" min="1" max="<?= ($contrato['maxParcelasEmp'] ? $contrato['maxParcelasEmp'] : 300) ?>" id="database" name="vezes" value="" required>
                                    <span style="color: red; font-size: 12px">(O limite maximo de parcelas  o cadastrado no empreedimento!)</span>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label class="control-label">
                                        Data primeira parcela:<span style="color: red">*</span>
                                    </label>
                                    <input class="form-control data datepicker-input" id="database" name="dtPrimParc" value="<?= $contrato['data'] ?>" required>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>
                <div class="table-responsive" style="max-height: 300px">
                    <table id="TabelaListarPasso3" class="table  table-hover table-condensed order-column" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th width="40px">
                                    Parcela
                                </th>
                                <th width="40px">
                                    Vencimento
                                </th>
                                <th width="40px">
                                    Dias atrasados
                                </th>
                                <th width="40px">
                                    Tipos
                                </th>
                                <th width="40px">
                                    Valor
                                </th>
                                <th width="30px">
                                    Multa
                                </th>
                                <th width="40px">
                                    Juros
                                </th>
                                <th width="40px">
                                    Desc.
                                </th>
                                <th width="40px">
                                    Acres.
                                </th>
                                <th width="40px">
                                    Total
                                </th>
                            </tr>
                        </thead>
                        <tbody class="table-responsive" style="max-height: 300px">
                            <?php $ids = ''; ?>
                            <?php foreach ($contrato['parcelas'] as $parcela) : ?>
                                <?php $ids .= $parcela['id_parcela_contrato'] . ':'; ?>
                                <tr>
                                    <td align="center">
                                        <?= $parcela['id_parcela'] ?>
                                    </td>
                                    <td align="center">
                                        <?= Helper::getDate($parcela['dt_parcela']); ?>
                                    </td>
                                    <td align="center">
                                        <?= $parcela['dias']; ?>
                                    </td>
                                    <td align="center">
                                        <?= $parcela['tp_parcela'] ?>
                                    </td>
                                    <td width="40px">
                                        <?= number_format($parcela['vl_parcela'], 2, ',', '.'); ?>
                                    </td>
                                    <td width="40px;">
                                        <?php echo str_replace('.', ',', $parcela['vl_multa']); ?>
                                    </td>
                                    <td width="45px;">
                                        <?php echo str_replace('.', ',', $parcela['vl_juros']); ?>
                                    </td>
                                    <td width="60px;">
                                        <input placeholder="R$ 0,00" type="text" size="4" class="money" id="desconto_<?php echo $parcela['id_parcela_contrato']; ?>" name="desconto_<?php echo $parcela['id_parcela_contrato']; ?>" value="<?= $parcela['desconto'] != '' ? Helper::getMoney($parcela['desconto']) : '' ?>">
                                    </td width="60px;">
                                    <td align="center" width="60px;">
                                        <input placeholder="R$ 0,00" type="text" size="4" class="money" id="acrescimo_<?php echo $parcela['id_parcela_contrato']; ?>" name="acrescimo_<?php echo $parcela['id_parcela_contrato']; ?>" value="<?= $parcela['acrescimo'] != '' ? Helper::getMoney($parcela['acrescimo']) : '' ?>">
                                    </td width="60px;">
                                    <td align="center" width="60px;" id="tdTotal_<?php echo $parcela['id_parcela_contrato']; ?>">
                                        <?php echo $parcela['total']; ?>
                                    </td>
                                    <!--SOLUO ENCONTRADA PARA PEGAR VALOR TOTAL!-->
                                    <input type="hidden" id="total_<?php echo $parcela['id_parcela_contrato']; ?>" value="<?php echo $parcela['total']; ?>">
                                    <input type="hidden" id="multa_<?php echo $parcela['id_parcela_contrato']; ?>" value="<?php echo $parcela['vl_multa']; ?>">
                                    <input type="hidden" id="juros_<?php echo $parcela['id_parcela_contrato']; ?>" value="<?php echo $parcela['vl_juros']; ?>">
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <!-- DIV QUE MOSTRA O TOTAL DE CADA VALOR! -->
                        <tr align="center">
                            <td colspan='4'> Total dos Valores: </td>
                            <td><b><?= number_format($contrato['valoresSomados']['vl_parcelas'], 2, ',', '.'); ?></b></td>
                            <td><b><?= number_format($contrato['valoresSomados']['vl_multa'], 2, ',', '.'); ?></b></td>
                            <td><b><?= number_format($contrato['valoresSomados']['vl_juros'], 2, ',', '.'); ?></b></td>
                            <td colspan="2"></td>
                            <td><b id="total"><?= $contrato['total']; ?></b></td>
                        </tr>
                    </table>
                </div>
                <!--HIDDENs-->
                <input type="hidden" name="total" id="hidden_total" value="<?php echo $contrato['total']; ?>">
                <input type="hidden" name="parcelas" id="parcelas" value="<?php echo substr($ids, 0, -1); ?>">
                <input type="hidden" name="passo" value="3" />
                <fieldset>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <input type="submit" id="btnPasso3" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Avanar">
                            </div>
                            <div class="form-group col-sm-2">
                                <a href="?m=fin&c=quitacao&a=passo2&idContratoQuitacao=<?php echo $contrato['parcelas'][0]['id_contrato']; ?>" class="btn btn-danger col-sm-12">Voltar </a>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>
        </div>
        <?php require_once 'layout/includes/footer.php'; ?>