<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$contrato = $this->get('contrato');
$parcelas = $this->get('parcelas');
$tx_juros = $this->get('tx_juros');
?>

<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Adicionar', 'Quitao', 'fa fa-plus'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <form action="?m=fin&c=quitacao&a=passo3" method="POST">
                <legend>Passo 2 (Parcelas) <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span></legend>
                <fieldset>
                    <legend>Negociao de Parcelas em Atraso</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-4" style="padding-top: 10px;font-size: 15px;right: 15px;">
                                Cliente: <strong><?= $contrato['nm_pessoa'] ?></strong><br>
                                Contrato: <strong><?= $contrato['numero'] ?></strong> /
                                Quadra: <strong><?= $contrato['quadra'] ?></strong> /
                                Lote: <strong><?= $contrato['lote'] ?></strong>
                                <input type="hidden" id="tx_juros" name="tx_juros" value="<?=$tx_juros?>">
                            </div>
                            <?php if($contrato['tx_juros']): ?>
                                <div class="form-group col-sm-3" id="divDescontoBoleto" hidden>
                                    <label class="control-label" for="validadeBoleto" style="color: red">
                                        Este contrato possui taxas de juros. Deseja calcular
                                        desconto de antecipao?
                                    </label><br/>
                                    <div class="form-group col-sm-1" style="width: 100px;">
                                        <label for="sim">Sim</label>
                                        <input type="radio" class="form-control icheck modelo" name="descontoBoleto" id="sim" value="S"/>
                                    </div>
                                    <div class="form-group col-sm-1" style="width: 100px;">
                                        <label for="nao">No</label>
                                        <input type="radio" class="form-control icheck modelo" name="descontoBoleto" id="nao" value="N" checked/>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="form-group col-sm-3" style="left: 180px;">
                                <label class="control-label">
                                    Data base:<span style="color: red">*</span>
                                    <span style="font-size: 11px; color:red;">(Data para o clculo dos juros e multa)</span>
                                </label>
                                <input class="form-control data datepicker-input" id="database" name="dataBase" value="<?= date('d/m/Y') ?>" required="true">
                            </div>
                        </div>
                    </div>
                </fieldset>

                <div class="table-responsive" style="max-height: 300px">
                    <table id="tabelaListarParcelas" class="table table-hover table-condensed order-column" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>
                                    <div align="center">N parcela</div>
                                </th>
                                <th>
                                    <div align="center">Data de vencimento</div>
                                </th>
                                <th>Tipo</th>
                                <th>Valor</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($parcelas as $parcela) : ?>
                                <tr>
                                    <td align="center">
                                        <?= $parcela['id_parcela'] ?>
                                        <input checked id="contrato_<?= $parcela['id_parcela_contrato'] ?>" class="variosCheckbox hide" type="checkbox" name="parcelas[]" value="<?php echo $parcela['id_parcela_contrato']; ?>">
                                    </td>
                                    <td align="center">
                                        <?= Helper::getDate($parcela['dt_parcela']); ?>
                                    </td>
                                    <td>
                                        <?= $parcela['tp_parcela'] ?>
                                    </td>
                                    <td width="40px">
                                        <?= number_format($parcela['vl_parcela'], 2, ',', '.'); ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
        </div>
    </div>
    <fieldset>
        <legend>Operaes</legend>
        <div class="row">
            <div class="col-sm-12">
                <div class="form-group col-sm-2">
                    <input disabled type="submit" id="btnPasso2" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Avanar">
                </div>
                <div class="form-group col-sm-2">
                    <a href="?m=fin&c=quitacao&a=adicionar" class="btn btn-danger col-sm-12">Voltar </a>
                </div>
            </div>
        </div>
    </fieldset>
    </form>
</div>
<?php require_once 'layout/includes/footer.php'; ?>