<?php
$negociacao = $this->get("negociacao");
$pessoasEnvolvidas = $this->get("pessoasEnvolvidas");
$parcelaSelecionada =  $this->get("parcelaSelecionada");
$parcelaNegociadas = $this->get("listaNegociadas");
$qtdeParcelas = $this->get("qtdeParcelas");
$empreendimentoInfo = $this->get("empreendimentoInfo");
//cliente
$clienteAcade = $this->get("clienteAcade");
$cliente = $negociacao['nm_pessoa'];
$cpfCliente = $negociacao['cpfCli'];
$cnpjCliente = $negociacao['nr_cnpj'];
$empresa = $negociacao['nm_empreendimento'];
$cidadeCli = $negociacao["cidadeCli"] . "/" . $negociacao["ufCli"];
$loteNum = $negociacao['lote'];
$quadra = $negociacao['quadra'];
$parcNome = array(
    'N' => 'Normal',
    'NE' => 'Normal',
    'C' => 'Chaves',
    'CE' => 'Chaves',
    'I' => 'Intercalada',
    'IE' => 'Intercalada',
    'S' => 'Sinal',
    'SE' => 'Sinal',
    'G' => 'Negociao',
    'Q' => 'Quitada'
);
?>
<page backtop="10mm" backbottom="10mm">

    <style type="text/css">
        table.bordasimples {
            border-collapse: collapse;
        }

        table.bordasimples thead tr th, table.bordasimples tbody tr td {
            border: 1px solid #000000;
            width: 200px;
        }
    </style>

    <div style="text-align: left;font-size: 20px;">
        <!-- Logomarca Cliente Acade -->
        <?php

        $dsEmpreendimentoPathLogo = $negociacao['ds_path_logo'];
        $dsEndLogomarca = $clienteAcade['ds_end_logomarca'];

        if ($dsEmpreendimentoPathLogo && file_exists($dsEmpreendimentoPathLogo)) {
            echo '<img src="' . $dsEmpreendimentoPathLogo . '" alt="' . $cabecalho['empreendimento'] . '" height="120" />';
        }
        elseif ($dsEndLogomarca && file_exists($dsEndLogomarca)) {
            echo '<img src="' . $dsEndLogomarca . '" alt="' . $clienteAcade['nm_fantasia'] . '" height="120" />';
        } else {
            echo '<img style="float: left; " src="' . LOGOMARCA_DEFAULT . '" alt="LogoPadrao" height="80" />';
        }

        ?>
    </div>

    <div style="width: 650px; text-align: right;margin-left: 60px;">
        <span
                style="margin-top: -30px;">
            <?php
            $mes = array(
                1 => 'janeiro',
                2 => 'fevereiro',
                3 => 'mar&ccedil;o',
                4 => 'abril',
                5 => 'maio',
                6 => 'junho',
                7 => 'julho',
                8 => 'agosto',
                9 => 'setembro',
                10 => 'outubro',
                11 => 'novembro',
                12 => 'dezembro'
            );
            echo $negociacao["cidade"] . ", " . utf8_decode(date("d") . ' de ' . $mes[date("n")] . ' de ' . date("Y"). "."); ?>
        </span>
    </div>
    <p style="font-weight: bold">AO(A)<br/>
        SR(A). <?= $this->_helper->str2Upper($cliente); ?><br/>
        <?= $this->_helper->str2Upper($negociacao['enderecoCli']); ?>
        , <?= $this->_helper->str2Upper($negociacao['bairroCli']); ?><br/>
        <?= $this->_helper->str2Upper($cidadeCli); ?><br/>
        CEP: <?= $negociacao['nrCepCli']; ?>
    </p>

    <p style="font-weight: bold">Quitao n <?= str_pad($negociacao['idNegociacao'], 5, '0', STR_PAD_LEFT) . '
            - ' . $negociacao['nm_empreendimento']; ?>
        <?= Helper::exibeAbreviacao(($empreendimentoInfo['ds_subgrupo'] != '') ? $empreendimentoInfo['ds_subgrupo'] : '')?><?= ' - '. $negociacao['lote']?>
        <?= Helper::exibeAbreviacao(($empreendimentoInfo['ds_grupo'] != '') ? $empreendimentoInfo['ds_grupo']: '')?><?= ' - '. $negociacao['quadra']?>
        <?= ' - Contrato: ' . $negociacao['contrato'];
        ?></p>

    <p>Prezado(a) Cliente: <b><?= $negociacao['nm_pessoa']; ?> </b></p>

    <p>Ref. Quitao nmero: <b><?= str_pad($negociacao['idNegociacao'], 5, '0', STR_PAD_LEFT); ?>,</b>
    realizada em: <b><?= Helper::getDate($negociacao['data']) ?></b></p>

    <p>Pela presente solicitamos a cincia de V. Sa.  Quitao abaixo: </p>

    <p>
        Parcelas  <?= ($negociacao['tp_operacao'] == 'R'? 'refinanciadas':'negociadas') ?>: <br/>
        <?php
        $totalFinal = 0;
        foreach ($parcelaSelecionada as $parcela):
            $total = 0;
            $total += ($parcela['vl_parcela']) ? $parcela['vl_parcela'] : 0;
            $total += ($parcela['vl_juros']) ? $parcela['vl_juros'] : 0;
            $total += ($parcela['vl_multa']) ? $parcela['vl_multa'] : 0;
            $total += ($parcela['acrescimo']) ? $parcela['acrescimo'] : 0;
            $total -= ($parcela['desconto']) ? $parcela['desconto'] : 0;
            $totalFinal += $total;
            ?>
        <?php endforeach; ?>
        <?php
        $vlParcela = 0;
        $vlTotalMulta = 0;
        $vlTotalJuros = 0;
        $vlTotalDesconto = 0;
        $vlTotalacrescimo = 0;
        foreach ($parcelaSelecionada as $negociada):
            $vlTotalMulta += $negociada['vl_multa'];
            $vlTotalJuros += $negociada['vl_juros'];
            $vlTotalDesconto += $negociada['desconto'];
            $vlTotalacrescimo += $negociada['acrescimo'];
            $vlParcela += $negociada['vl_parcela'];
            $qtdParcelas = count($parcelaSelecionada);
            ?>
        <?php endforeach; ?>
    </p>
    <table>
        <tr>
            <th align="center">Quant.<br>Parcelas</th>
            <th></th>
            <th align="center">Total Multa</th>
            <th align="center">Total Juros</th>
            <th align="center">Total Desconto</th>
            <th align="center">Total Acrescimo</th>
            <th align="center">Total Final</th>
        </tr>
        <tr>
            <td align='center' width="60"><?= $qtdParcelas?></td>
            <td  width="100"></td>
            <td width="100" align="center">R$ <?= Helper::getMoney($vlTotalMulta)?></td>
            <td width="100" align="center">R$ <?= Helper::getMoney($vlTotalJuros)?></td>
            <td width="120" align="center">R$ <?= Helper::getMoney($vlTotalDesconto)?></td>
            <td width="120" align="center">R$ <?= Helper::getMoney($vlTotalacrescimo)?></td>
            <td width="120" align='center'>R$ <?= Helper::getMoney($totalFinal); ?></td>
        </tr>
    </table>
    <hr/>
    <?php 
    $vlTotalNegociada = 0;
    foreach ($parcelaNegociadas as $negociada) {
        $vlTotalNegociada += $negociada['vl_parcela'];
    }
    ?>
    <!--    Forma de Negociao ou Refinanciamento-->
    Forma de Quitao: <br/>
    <p>
    <table>
        <tr>
            <th align='center'>Quant.<br>Parcelas</th>
            <th align='center'>Vencimento<br> a partir</th>
            <th align="center"></th>
            <th align="center"></th>
            <th align="center"></th>
            <th align="center"></th>
            <th align="center">Total Final</th>
        </tr>
        <?php
        $dtPrimeira = Helper::getDate($parcelaNegociadas[0]['dt_parcela']);
        $nrParcelas = count($parcelaNegociadas);         
        ?>
        <tr>
            <td align='center' width="60"><?= $nrParcelas; ?></td>
            <td width="100" align='center'><?= $dtPrimeira ?></td>
            <td width="100" align="center"></td>
            <td width="100" align="center"></td>
            <td width="120" align="center"></td>
            <td width="120" align="center"></td>
            <td width="120" align="center">R$ <?= Helper::getMoney($vlTotalNegociada) ?></td>
        </tr>

    </table>
    </p>
    <hr/>
    <p>Atenciosamente, Data: _____/_____/______</p>
    <table style="margin-top:-10px;margin-left:40px;">
        <?php if ($negociacao['fl_assinatura'] == 'PE') : ?>
            <?php
            $assinaturas = $this->get('assinaturas');
            $listaAssinaturas = array_chunk($assinaturas, 2);

            foreach ($listaAssinaturas as $assinaturas) : ?>
                <tr>
                    <?php foreach ($assinaturas as $ass) : ?>
                        <td style="padding-top: 30px;width:350px;"> ______________________________________________</td>
                    <?php endforeach; ?>
                </tr>
                <tr>
                    <?php foreach ($assinaturas as $ass) : ?>
                        <td style="font-size: 10px;width:350px; text-align: center">
                            <?php
                            if ($ass['nr_cpf']) {
                                echo '<br />' . $ass['nm_pessoa'] . '<br /> CPF/MF:' . $ass['nr_cpf'];
                            } else {
                                echo '<br />' . $ass['nm_pessoa'] . '<br /> CNPJ/MF:' . $ass['nr_cnpj'];
                            }
                            ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach;?>
        <?php elseif ($negociacao['fl_assinatura'] == 'E') : ?>
            <tr>
                <td style="padding-top: 30px;width:350px;">__________________________________________________
                </td>
            </tr>
            <tr>
                <td style="font-size: 10px;width:350px; text-align: center">
                    <?= Helper::str2Upper($negociacao['nm_empreendimento']) ?>
                </td>
            </tr>
        <?php elseif ($negociacao['fl_assinatura'] == 'PI') : ?>
            <?php
            $parceria = $this->get('parceria');
            $listaAssinaturas = array_chunk($parceria, 2);

            foreach ($listaAssinaturas as $parceria) : ?>
                <tr>
                    <?php foreach ($parceria as $parc) : ?>
                        <td style="padding-top: 30px;width:350px;"> ______________________________________________</td>
                    <?php endforeach; ?>
                </tr>
                <tr>
                    <?php foreach ($parceria as $parc) : ?>
                        <td style="font-size: 10px;width:350px; text-align: center">
                            <?php
                            if ($parc['nr_cpf']) {
                                echo '<br />' . $parc['nm_pessoa'] . '<br /> CPF/MF:' . $parc['nr_cpf'];
                            } else {
                                echo '<br />' . $parc['nm_pessoa'] . '<br /> CNPJ/MF:' . $parc['nr_cnpj'];
                            }
                            ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach;?>
        <?php endif;?>
    </table>
    <table style="margin-top:-10px;margin-left:40px;">
        <tr>
            <td style="padding-top: 30px;width:350px;"> Ciente: ________________________________________</td>
        </tr>
        <tr>
            <td style="font-size: 10px;width:350px; text-align: center">
                <?= '<br>'.Helper::str2Upper($cliente) . '<br> CPF/MF:' . $negociacao['cpfCli'] ?>
            </td>
        </tr>
        <?php foreach ($pessoasEnvolvidas as $pessoaEnvolvida) : ?>
            <tr>
                <td style="padding-top: 30px;width:350px;"> Ciente: _________________________________________</td>
            </tr>
            <tr>
                <td style="font-size: 10px;width:350px; text-align: center">
                    <?= '<br>'.Helper::str2Upper($pessoaEnvolvida['nm_pessoa']) . '<br> CPF/MF:' . $pessoaEnvolvida['nr_cpf'] ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
</page>