<!-- Condio para gerar modelo novo -->
<?php if ($this->get("negociacao") != '') : ?>

<?php
$negociacao = $this->get("negociacao");
$pessoasEnvolvidas = $this->get("pessoasEnvolvidas");
$parcelaSelecionada =  $this->get("parcelaSelecionada");
$parcelaNegociadas = $this->get("listaNegociadas");
$qtdeParcelas = $this->get("qtdeParcelas");
$empreendimentoInfo = $this->get("empreendimentoInfo");
//cliente
$clienteAcade = $this->get("clienteAcade");
$cliente = $negociacao['nm_pessoa'];
$cpfCliente = $negociacao['cpfCli'];
$cnpjCliente = $negociacao['nr_cnpj'];
$empresa = $negociacao['nm_empreendimento'];
$cidadeCli = $negociacao["cidadeCli"] . "/" . $negociacao["ufCli"];
$loteNum = $negociacao['lote'];
$quadra = $negociacao['quadra'];
$parcNome = array(
    'N' => 'Normal',
    'NE' => 'Normal',
    'C' => 'Chaves',
    'CE' => 'Chaves',
    'I' => 'Intercalada',
    'IE' => 'Intercalada',
    'S' => 'Sinal',
    'SE' => 'Sinal',
    'G' => 'Negociao',
    'Q' => 'Quitada'
);
?>
<page backtop="5mm" backbottom="10mm">

    <style type="text/css">
        table.bordasimples {
            border-collapse: collapse;
        }

        table.bordasimples thead tr th, table.bordasimples tbody tr td {
            border: 1px solid #000000;
            width: 200px;
        }
    </style>

    <div style="text-align: left;font-size: 20px;">
        <!-- Logomarca Cliente Acade -->
        <?php

        $dsEmpreendimentoPathLogo = $negociacao['ds_path_logo'];
        $dsEndLogomarca = $clienteAcade['ds_end_logomarca'];

        if ($dsEmpreendimentoPathLogo && file_exists($dsEmpreendimentoPathLogo)) {
            echo '<img src="' . $dsEmpreendimentoPathLogo . '" alt="' . $negociacao['nm_empreendimento'] . '" height="120" />';
        }
        elseif ($dsEndLogomarca && file_exists($dsEndLogomarca)) {
            echo '<img src="' . $dsEndLogomarca . '" alt="' . $clienteAcade['nm_fantasia'] . '" height="120" />';
        } else {
            echo '<img style="float: left; " src="' . LOGOMARCA_DEFAULT . '" alt="LogoPadrao" height="80" />';
        }
        ?>
    </div>

    <div style="width: 650px; text-align: right;margin-left: 60px;">
        <span
                style="margin-top: -30px;">
            <?php
            $mes = array(
                1 => 'janeiro',
                2 => 'fevereiro',
                3 => 'mar&ccedil;o',
                4 => 'abril',
                5 => 'maio',
                6 => 'junho',
                7 => 'julho',
                8 => 'agosto',
                9 => 'setembro',
                10 => 'outubro',
                11 => 'novembro',
                12 => 'dezembro'
            );
            echo $negociacao["cidade"] . ", " . utf8_decode(date("d") . ' de ' . $mes[date("n")] . ' de ' . date("Y"). "."); ?>
        </span>
    </div>
    <p style="font-weight: bold">AO(A)<br/>
        SR(A). <?= $this->_helper->str2Upper($cliente); ?><br/>
        <?= $this->_helper->str2Upper($negociacao['enderecoCli']); ?>
        , <?= $this->_helper->str2Upper($negociacao['bairroCli']); ?><br/>
        <?= $this->_helper->str2Upper($cidadeCli); ?><br/>
        CEP: <?= $negociacao['nrCepCli']; ?>
    </p>

    <p style="font-weight: bold">Quitao n <?= str_pad($negociacao['idNegociacao'], 5, '0', STR_PAD_LEFT) . '
            - ' . $negociacao['nm_empreendimento']; ?>
        <?= Helper::exibeAbreviacao(($empreendimentoInfo['ds_subgrupo'] != '') ? $empreendimentoInfo['ds_subgrupo'] : '')?><?= ' - '. $negociacao['lote']?>
        <?= Helper::exibeAbreviacao(($empreendimentoInfo['ds_grupo'] != '') ? $empreendimentoInfo['ds_grupo']: '')?><?= ' - '. $negociacao['quadra']?>
        <?= ' - Contrato: ' . $negociacao['contrato'];
        ?></p>

    <p>Prezado(a) Cliente: <b><?= $negociacao['nm_pessoa']; ?> </b></p>

    <p>Ref. Quitao nmero: <b><?= str_pad($negociacao['idNegociacao'], 5, '0', STR_PAD_LEFT); ?>,</b>
    realizada em: <b><?= Helper::getDate($negociacao['data']) ?></b></p>

    <p>Pela presente solicitamos a cincia de V. Sa.  Quitao abaixo: </p>

    <p>
        Parcelas  <?= ($negociacao['tp_operacao'] == 'R'? 'refinanciadas':'em atraso') ?>: <br/>
    <table>
        <tr>
            <th>Parc.</th>
            <th align="center">Tipo</th>
            <th align='center'>Vencimento</th>
            <th align="right">Valor</th>
            <th align="right">Juros</th>
            <th align="right">Multa</th>
            <th align="right">Desconto</th>
            <th align="right">Acrsc.</th>
            <th align="right">Vl. Final</th>
        </tr>
        <?php
        $totalFinal = 0;
        foreach ($parcelaSelecionada as $parcela):
            $total = 0;
            $total += ($parcela['vl_parcela']) ? $parcela['vl_parcela'] : 0;
            $total += ($parcela['vl_juros']) ? $parcela['vl_juros'] : 0;
            $total += ($parcela['vl_multa']) ? $parcela['vl_multa'] : 0;
            $total += ($parcela['acrescimo']) ? $parcela['acrescimo'] : 0;
            $total -= ($parcela['desconto']) ? $parcela['desconto'] : 0;
            $totalFinal += $total;
            ?>
            <tr>
                <td width="60"><?= str_pad($parcela['id_parcela'], 2, '0', STR_PAD_LEFT); ?></td>
                <td width="100" align='center'><?= $parcNome[$parcela['tp_parcela']] ?></td>
                <td width="120" align='center'><?= Helper::getDate($parcela['dt_parcela']) ?></td>
                <td width="60" align="right"><?= Helper::getMoney($parcela['vl_parcela']) ?></td>
                <td width="60" align="right"><?= Helper::getMoney($parcela['vl_juros']) ?></td>
                <td width="60" align="right"><?= Helper::getMoney($parcela['vl_multa']) ?></td>
                <td width="75" align="right"><?= Helper::getMoney($parcela['desconto']) ?></td>
                <td width="60" align="right"><?= Helper::getMoney($parcela['acrescimo']) ?></td>
                <td width="60" align="right"><?= Helper::getMoney($total) ?></td>
            </tr>
        <?php endforeach; ?>
        <tr>
            <td align="right" colspan="9" style="padding-top: 5px;"><b>TOTAL:
                    R$ <?= Helper::getMoney($totalFinal); ?></b></td>
        </tr>
    </table>
    </p>
    <p>
    </p>
    <hr/>
    Forma de quitao: <br/>
    <table>
        <tr>
            <?php if (count($parcelaNegociadas) == 2) : ?>
                <th>Parc.</th>
                <th width="50" align="right">Tipo</th>
                <th width="150" align="right">Vencimento</th>
                <th width="100" align="center">Valor</th>
                <th align="center">Parc.</th>
                <th width="50" align="right">Tipo</th>
                <th width="190" align='right'>Vencimento</th>
                <th width="70" align="right">Valor</th>
            <?php else: ?>
                <th>Parc.</th>
                <th width="50" align="right">Tipo</th>
                <th width="150" align="right">Vencimento</th>
                <th width="100" align="center">Valor</th>
                <th align="center">Parc.</th>
                <th align="right">Tipo</th>
                <th></th>
                <th align='left'>Vencimento</th>
                <th align="left">Valor</th>
            <?php endif; ?>
        </tr>
        <?php
        $vlParcela = 0;
        $dtPrimeira = Helper::getDate($parcelaNegociadas[0]['dt_parcela']);
        $nrParcelas = count($parcelaNegociadas);
        $i = 1;
        foreach ($parcelaNegociadas as $negociada):
            $vlParcela += $negociada['vl_parcela'];
            ?>
            <?php if($i%2 == 0): ?>
            <tr>
            <td><b>|</b></td>
        <?php endif ?>
            <td width="60"><?= str_pad($negociada['id_parcela'], 2, '0', STR_PAD_LEFT) . '/' . str_pad($nrParcelas, 2, '0', STR_PAD_LEFT); ?></td>
            <td width="100" align='left'>Quitao</td>
            <td width="100" align='left'><?= Helper::getDate($negociada['dt_parcela']) ?></td>
            <td width="60" style="padding: 0;"><?= Helper::getMoney($negociada['vl_parcela']) ?></td>
            <?php if($i%2 == 0): ?>
            </tr>
        <?php endif; $i++; ?>

        <?php endforeach; ?>
    </table>
    <p> Total Geral: <b><?= Helper::getMoney($vlParcela) ?></b></p>

    <p>Atenciosamente, Data: _____/_____/_____</p>

    <table style="margin-top:-10px;margin-left:50px;">
        <?php if ($negociacao['fl_assinatura'] == 'PE') : ?>
            <?php
            $assinaturas = $this->get('assinaturas');
            $listaAssinaturas = array_chunk($assinaturas, 2);

            foreach ($listaAssinaturas as $assinaturas) : ?>
                <tr>
                    <?php foreach ($assinaturas as $ass) : ?>
                        <td style="padding-top: 30px;width:350px;"> ______________________________________________</td>
                    <?php endforeach; ?>
                </tr>
                <tr>
                    <?php foreach ($assinaturas as $ass) : ?>
                        <td style="font-size: 10px;width:350px; text-align: center">
                            <?php
                            if ($ass['nr_cpf']) {
                                echo '<br />' . $ass['nm_pessoa'] . '<br /> CPF/MF:' . $ass['nr_cpf'];
                            } else {
                                echo '<br />' . $ass['nm_pessoa'] . '<br /> CNPJ/MF:' . $ass['nr_cnpj'];
                            }
                            ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach;?>
        <?php elseif ($negociacao['fl_assinatura'] == 'E') : ?>
            <tr>
                <td style="padding-top: 30px;width:350px;">__________________________________________________
                </td>
            </tr>
            <tr>
                <td style="font-size: 10px;width:350px; text-align: center">
                    <?= Helper::str2Upper($negociacao['nm_empreendimento']) ?>
                </td>
            </tr>
        <?php elseif ($negociacao['fl_assinatura'] == 'PI') : ?>
            <?php
            $parceria = $this->get('parceria');
            $listaAssinaturas = array_chunk($parceria, 2);

            foreach ($listaAssinaturas as $parceria) : ?>
                <tr>
                    <?php foreach ($parceria as $parc) : ?>
                        <td style="padding-top: 30px;width:350px;"> ______________________________________________</td>
                    <?php endforeach; ?>
                </tr>
                <tr>
                    <?php foreach ($parceria as $parc) : ?>
                        <td style="font-size: 10px;width:350px; text-align: center">
                            <?php
                            if ($parc['nr_cpf']) {
                                echo '<br />' . $parc['nm_pessoa'] . '<br /> CPF/MF:' . $parc['nr_cpf'];
                            } else {
                                echo '<br />' . $parc['nm_pessoa'] . '<br /> CNPJ/MF:' . $parc['nr_cnpj'];
                            }
                            ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach;?>
        <?php endif;?>
    </table>
    <table style="margin-top:-10px;margin-left:40px;">
        <tr>
            <td style="padding-top: 30px;width:350px;"> Ciente: _________________________________________</td>
        </tr>
        <tr>
            <td style="font-size: 10px;width:350px; text-align: center">
                <?= '<br>'.Helper::str2Upper($cliente) . '<br> CPF/MF:' . $negociacao['cpfCli'] ?>
            </td>
        </tr>
        <?php foreach ($pessoasEnvolvidas as $pessoaEnvolvida) : ?>
        <tr>
            <td style="padding-top: 30px;width:350px;"> Ciente: _________________________________________</td>
        </tr>
        <tr>
            <td style="font-size: 10px;width:350px; text-align: center">
                <?= '<br>'.Helper::str2Upper($pessoaEnvolvida['nm_pessoa']) . '<br> CPF/MF:' . $pessoaEnvolvida['nr_cpf'] ?>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</page>

<!-- Gera modelo antigo -->
<?php else : ?>

<?php
$cliente = $this->get("cliente");
$contrato = $this->get("contrato");
$contratos = $this->get("contratos");
$header = $this->get("cabecalho");
$descontoQuitacao = $this->get("descontoQuitacao");
$parcelaHistorico = $this->get("parcelaHistorico");
$valores = $this->get("valores");
$valorAcrescimo = $this->get("valorAcrescimo");
$empreendimentoInfo = $this->get("empreendimentoInfo");
?>

<page backtop="10mm" backbottom="10mm">
    <page_footer>
        <div align="center" style="padding-bottom:0;width: 620px;padding-left: 30px;">
        </div>
        <table align="center" style="width:95%; border-top: solid 1px black;font-size:10px;margin-top:0px;">
            <tr style="font-style: italic;font-size: 9pt;">
                <td style="text-align:left;width:50%;border-top: 1px #000;">Acade Lotear / Acade Sistemas</td>
                <td style="text-align:right;width:50%;border-top: 1px #000;">Impresso em: <?= date('d/m/Y'); ?> as <?= date('H:i') ?> - Pgina: [[page_cu]]/[[page_nb]]</td>
            </tr>
        </table>
    </page_footer>

    <style type="text/css">
        table {border-collapse: collapse;font-family: arial;}
        .tbl_listagem td{
            border: 1px #FFF solid;
            font-family: arial;
        }

    </style>

    <div style="padding-left:33px;text-align: left;font-size: 20px;">
        <!-- Logomarca Cliente Acade -->
        <?php
            $dsEmpreendimentoPathLogo = $contrato['ds_path_logo'];
            $dsEndLogomarca = $cliente['ds_end_logomarca'];

            if ($dsEmpreendimentoPathLogo && file_exists($dsEmpreendimentoPathLogo)) {
                echo '<img src="' . $dsEmpreendimentoPathLogo . '" alt="' . $cabecalho['empreendimento'] . '" height="120" />';
            }
            elseif ($dsEndLogomarca && file_exists($dsEndLogomarca)) {
                echo '<img src="' . $dsEndLogomarca . '" alt="' . $cliente['nm_fantasia'] . '" height="120" />';
            } else {
                echo '<img style="float: left; " src="' . LOGOMARCA_DEFAULT . '" alt="LogoPadrao" height="80" />';
            }
        ?>
    </div>

    <div style="padding-left: 500px; font-size: 14px; margin-top: -37px;"><?= $cliente["nome"].$this->get("data"); ?></div>

    <table style="padding-left: 25px;font-size: 14px; margin-top: 100px;">
        <tr>
            <td style="padding-left: 685px;" align="center" colspan="4"><h4>Quitao</h4></td>
        </tr>
    </table>

    <table style="padding-left: 25px;font-size: 14px; margin-top: 60px;">

        <tr>
            <td><strong>Cliente: </strong><?= $contrato['nm_pessoa']; ?></td>
        </tr>

        <tr>
            <td><strong>Empreendimento: </strong>
                <?= $contrato['nm_empreendimento']; ?> - <strong><?= ($empreendimentoInfo['ds_subgrupo'] != '') ? $empreendimentoInfo['ds_subgrupo'] : ''?></strong> <?= $contrato['lote']; ?> - <strong><?= ($empreendimentoInfo['ds_grupo'] != '') ? $empreendimentoInfo['ds_grupo']: ''?> </strong><?= $contrato['quadra']; ?> - <strong>Contrato: </strong><?= $contrato['id']; ?>
            </td>
        </tr>

        <tr>
            <td><strong>Valor Contrato: </strong> <?= $header['vl_inicial']; ?> - <strong>Saldo Devedor: </strong><?= helper::getMoney($parcelaHistorico['SomaVlParcelaHistorico']); ?> - <strong>Valor Pago: </strong><?= $header['vl_pago']; ?>
            </td>
        </tr>

        <tr>
            <td><strong>Valor Quitao:  </strong><?= number_format($contrato['SomaVlParcela'], 2, ',', '.'); ?> <strong><br>Desconto Quitao: </strong><?= number_format($descontoQuitacao, 2, ',', '.'); ?>
                <strong>Valor Acrscimo: </strong><?= number_format($valorAcrescimo, 2, ',', '.'); ?>
            </td>
        </tr>
    </table>
    <br/>

    <table class="tbl_listagem" style="border-collapse: collapse; border: 1px #000000 solid; width: 620px;font-family: arial;font-size: 14px;;margin-left:25px;">
        <tr style="text-align: center;">
            <td style="background-color: #B8B8B8; width: 227px;border-left: 1px #000 solid;border-bottom: 1px #000 solid;border-top: 1px #000 solid;">Parcela</td>
            <td style="background-color: #B8B8B8; width: 227px;border-top: 1px #000 solid;border-bottom: 1px #000 solid;">Vencimento</td>
            <td style="background-color: #B8B8B8; width: 227px;border-right: 1px #000;border-top: 1px #000 solid;border-bottom: 1px #000 solid;">Valor</td>
        </tr>
        <?php
        $total = count($contratos);
        $i = 1;
        $totais['vl_parcela'] = 0;
        $totais['vl_total_pago'] = 0;
        foreach ($contratos as $cont):
            if ($i % 2 == 0) {
                $cor = "#F2F2F2";
            } else {
                $cor = "#FFF";
            }
            $i++;

            $totais['vl_parcela'] += $cont['vl_parcela'];
            $totais['vl_total_pago'] += $cont['vl_total_pago'];

            ?>
            <tr class="corpo">
                <td style="background-color: <?= $cor; ?>;text-align: center;"><?= $cont['id_parcela']."/".$cont['tp_parcela']; ?></td>
                <td style="background-color: <?= $cor; ?>;text-align: center;"><?=  $this->_helper->getDate($cont['dt_parcela']); ?></td>
                <td style="background-color: <?= $cor; ?>;text-align: center;"><?= number_format($cont['vl_parcela'],2,',','.'); ?></td>
            </tr>

        <?php endforeach; ?>

        <tr>
            <td align="right" colspan="2" style="font-weight: bold">Total:</td>
            <td style="font-weight: bold;padding-left: 85px; text-align:left;"><?= number_format($totais['vl_parcela'],2,',','.'); ?></td>
        </tr>

    </table>

</page>

<?php endif;?>