<?php /* FORM DEFAULT */ ?>
<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php';
$emps = $this->get("empreendimentos");
$contratos = $this->get('contratos');
$dados = $this->get('param');
$lotes = $this->get('lotes');
$listaModelos = $this->get('listaModelos');
$listaArquivoWord = $this->get('listaArquivoWord');
if ($contrato['fl_gerado'] == '1')
    $gerado = 'disabled';
else
    $gerado = '';
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader('Gerar', 'Termo de Quitao','fa fa-file-o'); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?= ($_GET["msg"] == "success") ? '<div class="alert alert-success alert-dismissable">Operao realizada com sucesso.</div>'
                    : (($_GET['exception'] != '') ? '<div class="alert alert-danger alert-dismissable">' . $_GET['exception'] . '</div>' : '');
                ?>
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form" target="_blank">
                    <fieldset>
                        <legend>Informaes do Termo de Quitao <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span></legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label " for="id_empreendimento">
                                        Empreendimento:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 empreendimentoQuitacao"
                                            data-placeholder="Selecione o Empreendimento"
                                            id="id_empreendimento" required="required"
                                            name="id_empreendimento">
                                        <option value=""></option>
                                        <?php foreach ($emps as $emp):?>
                                            <option value="<?php echo $emp['id']; ?>" <?php if ($emp['id'] == $contato['id_empreendimento']): ?> selected <?php endif; ?>><?php echo $emp['nm_empreendimento']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="id_contrato">
                                        Contrato:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select disabled class="form-control select2 contratos"
                                            name="id_contrato" id="id_contrato" required="required" data-placeholder="Selecione o Contrato"
                                    <option value="">Selecione ...</option>
                                    <?php if(count($contrato) == 0): ?><?php endif; ?>>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="data">
                                        Data:
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="data"
                                           name="data" <?= $gerado ?>
                                           value="<?= isset($contrato['dt_contrato']) ? Helper::getDate($contrato['dt_contrato']) : date('d/m/Y'); ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12"> 
                                <div class="form-group col-sm-6">
                                    <label for="campo">Observao:</label>
                                    <div>
                                        <textarea name="obs" id="campo" rows="3" cols="87" style="resize: none;width: 100%"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label for="tpLote" class="control-label" style="padding-bottom: 10px;">Tipo de Impresso:</label>
                                        <br>
                                        <div class="col-sm-4">
                                            <label for="tipoImpressaoPadrao" class="control-label">
                                                Padro do sistema
                                                <input class="form-control icheck autorizacao" id="tipoImpressaoPadrao" type="radio"
                                                       name="tipoImpressao" value="P" checked/>
                                            </label>
                                        </div>
                                        <div class="col-sm-3">
                                            <label for="tipoImpressaoArquivo" class="control-label">
                                                Modelo Word
                                                <input class="form-control icheck autorizacao" id="tipoImpressaoArquivo" type="radio"
                                                       name="tipoImpressao" value="A"/>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" id="divArquivoWord" hidden>
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3" id="divArquivoWord">
                                        <label class="control-label" for="tpArquivo">
                                            Modelo Word:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select name="cdArquivo" id="cdArquivo" class="form-control select2">
                                            <?php if ($listaArquivoWord) : ?>
                                                <?php foreach ($listaArquivoWord as $arquivo) : ?>
                                                    <option value="<?= $arquivo['ds_path_modelo'] ?>">
                                                        <?= $arquivo['nm_titulo'] ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>                                    
                                </div>
                            </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                        <label class="control-label">Incluir parcelas avulsas:</label><br>
                                        <div class="checkbox">
                                            <label><input type="radio" name="tp_avulsa" class="icheck" value="S" checked/>Sim</label>
                                            <label><input type="radio" name="tp_avulsa" class="icheck" value="N" />No</label>
                                        </div>
                                </div>
                            </div>
                        </div>        
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2" id="btnPdf">
                                    <input type="submit" id="gerar" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Emitir">
                                </div>
                                <div class="form-group col-sm-2" id="btnWord" hidden>
                                    <input type="submit" id="word" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Emitir">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=fin&c=quitacao&a=listar"
                                       class="btn btn-danger col-sm-12">Cancelar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>                    
                </form>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>