<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$contrato = $this->get('contrato');
?>
<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Adicionar', 'Negociao/Refinanciamento', 'fa fa-plus'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <!-- MENSAGENS -->
            <?php if (count($this->_helper->getMensagens()) > 0)
                foreach ($this->_helper->getMensagens() as $tipo => $message)
                    echo '<div class="alert alert-' . $tipo . ' alert-dismissable">' . $message . '</div>'; ?>
            <!-- MENSAGENS -->
            <form action="" method="POST" id="form">
                <input type="hidden" id="totalGeral" value="<?= $contrato['total']; ?>"/>
                <input type="hidden" id="qtdParcelas" value="<?= count($contrato['parcelasNovas']); ?>"/>
                <input type="hidden" class="desconto" name="desconto"/>
                <input type="hidden" class="acrescimo" name="acrescimo"/>

                <legend><a href="?m=fin&c=negociacao&a=passo1" style="color: #0b0b0b">Passo 1(Contrato)</a> - <a
                        href="?m=fin&c=negociacao&a=passo2" style="color: #0b0b0b">Passo 2(Parcelas)</a> - <a
                        href="?m=fin&c=negociacao&a=passo3" style="color: #0b0b0b">Passo 3(Calculo)</a> - <b>Passo 4(Finalizao)</b>
                </legend>
                <fieldset>
                    <legend><?= ($contrato['tipo'] == 'N'? 'Negociao de Parcelas em Atraso':'Refinanciamento de Parcelas') ?></legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-4" style="padding-top: 10px;font-size: 17px;right: 15px;">
                                Cliente: <strong><?= $contrato['nm_pessoa'] ?></strong><br>
                                Contrato: <strong><?= $contrato['numero'] ?></strong> /
                                Quadra: <strong><?= $contrato['quadra'] ?></strong> /
                                Lote: <strong><?= $contrato['lote'] ?></strong><br>
                                Total geral: <b id="total">R$ <?= $contrato['total']; ?></b><br>
                                <?php foreach ($contrato['parcelas'] as $parcela): ?>
                                    <?php ($parcela['desconto'] > 0) ? $desc += $parcela['desconto'] : 0; ?>
                                    <?php ($parcela['acrescimo'] > 0) ? $acres += $parcela['acrescimo'] : 0; ?>
                                <?php endforeach; ?>
                                Desconto: <b id="desconto" class="desconto" style="color: #FF0000">R$ <?= Helper::getMoney($desc); ?></b><br>
                                Acrscimo: <b id="acrescimo" class="acrescimo" style="color: #008000">R$ <?= Helper::getMoney($acres); ?></b>
                            </div>
                            <!-- Observao Negociao -->
                            <div style="right: 60px; display: inline-block; margin: 15px" >
                                <label for="campo">Observao:</label>
                                <div>
                                    <textarea name="obs" id="campo" rows="2" cols="90" style="resize: none"></textarea>
                                </div>
                            </div>
                            <!-- Observao de parcela -->
                            <div style="display: inline-block; margin: 15px">   
                                <label for="campoParcela">Observao na parcela:</label>
                                <div>
                                    <textarea name="obsParcela" id="obsParcela" maxlength="10" rows="2" style="resize: none"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>
                <div class="table-responsive" style="max-height: 300px">
                    <table id="TabelaListarPasso4"
                           class="table  table-hover table-condensed order-column"
                           cellspacing="0" width="100%">
                        <thead>
                        <tr>
                            <th width="40px">
                                Parcela
                            </th>
                            <th width="40px">
                                Vencimento
                            </th>
                            <th width="40px">
                                Tipo
                            </th>
                            <?php if ($_SESSION['contrato']['tipo'] == 'N') : ?>
                                <th width="40px">
                                    Porcentagem
                                </th>
                            <?php endif; ?>
                            <th width="40px">
                                Valor
                            </th>
                        </tr>
                        </thead>
                        <tbody class="table-responsive" style="max-height: 100px">
                        <?php $i=1; ?>
                        <?php foreach ($contrato['parcelasNovas'] as $parcela) : ?>
                            <tr>
                                <td align="center">
                                    <?= $i ?>
                                </td>
                                <td align="center">
                                    <input type="text" size="8" name="data[]" value="<?= $parcela['dt_parcela']; ?>" />
                                </td>
                                <td align="center">
                                    <?= ($contrato['tipo'] == 'N'? 'G':'N') ?>
                                </td>
                                <?php if ($_SESSION['contrato']['tipo'] == 'N') : ?>
                                <td align="center">
                                    <input id="porcentagem" class="integer" type="number" min="0" max="100" maxlength="3" name="porcentagem[]" value="" /> % 
                                </td>
                                <?php endif; ?>
                                <td align="center">
                                    R$ <input id="vlParcela" class="money" type="text" size="8" name="valor[]" value="<?= $parcela['vl_parcela']; ?>" />
                                </td>
                            </tr>
                            <?php $i++; ?>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <!--HIDDENs-->
                <input type="hidden" id="valorParcela" value="<?= $parcela['vl_parcela']?>"/>
                <input type="hidden" name="passo" value="4"/>
                <!--SOLUO ENCONTRADA PARA PEGAR OS VALORES DE DESCONTO, MULTA, JUROS E ACRESCIMO!-->
                <?php foreach ($contrato['parcelas'] as $dados) :?>
                    <input type="hidden" name="multa_<?php echo $dados['id_parcela_contrato']; ?>"
                           value="<?php echo $dados['vl_multa']; ?>">
                    <input type="hidden" name="juros_<?php echo $dados['id_parcela_contrato']; ?>"
                           value="<?php echo $dados['vl_juros']; ?>">
                    <input type="hidden" name="acrescimo_<?php echo $dados['id_parcela_contrato']; ?>"
                           value="<?php echo $dados['acrescimo']; ?>">
                    <input type="hidden" name="desconto_<?php echo $dados['id_parcela_contrato']; ?>"
                           value="<?php echo $dados['desconto']; ?>">
                <?php endforeach; ?>

                <fieldset>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" id="avanca" value="Avanar">
                            </div>
                            <div class="form-group col-sm-2">
                                <a href="?m=fin&c=negociacao&a=passo3" class="btn btn-danger col-sm-12">Voltar</a>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>





