<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$contato = $this->get('contato');
$emps = $this->get("empreendimentos");
$contratos = $this->get("contratos");
?>
<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Adicionar', 'Negociao/Refinanciamento', 'fa fa-plus'); ?>
    </div>
    <!-- MENSAGENS -->
    <?php if (count($this->_helper->getMensagens()) > 0)
        foreach ($this->_helper->getMensagens() as $tipo => $message)
            echo '<div class="alert alert-' . $tipo . ' alert-dismissable">' . $message . '</div>'; ?>
    <div class="widget">
        <div class="widget-content padding">
            <form action="" method="POST" id="form">
                <input type="hidden" name="passo" value="1"/>
                <legend><b>Passo 1(Contrato)</b> - Passo 2(Parcelas) - Passo 3(Clculo) - Passo 4(Finalizao)<span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                    <span data-toggle="modal" data-target=".mVisualizarNegociacao" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Parte 1 - Negociao">
                        <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                            <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                        </svg>
                    </span>
                    <span data-toggle="modal" data-target=".mVisualizarRefinanciamento" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Parte 2 - Refinanciamento ">
                        <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                            <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                        </svg>
                    </span>    
                </legend>
                <fieldset>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="empreendimento_adicionar_negociacao">
                                    Empreendimento:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 empreendimento_negociacao"
                                        data-placeholder="Selecione o empreendimento"
                                        id="empreendimento" required="required"
                                        name="negociacao_empreendimento" <?= isset($_GET['idEmpreendimento']) ? 'readonly' : '' ?>>
                                    <option value=""></option>
                                    <?php foreach ($emps as $empreendimento) : ?>
                                        <option value="<?= $empreendimento['id']; ?>" <?= (isset($_GET['idEmpreendimento']) && $_GET['idEmpreendimento'] == $empreendimento['id']) ? 'selected' : '';?>>
                                            <?= $empreendimento['nm_empreendimento']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="contrato_adicionar_negociacao">
                                    Contrato:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 contrato_negociacao"
                                        name="negociacao_contrato" id="contrato" required="required"
                                        data-placeholder="Selecione o contrato" <?= isset($_GET['idContrato']) ? 'readonly' : '' ?>>
                                    <option value=""></option>
                                    <?php
                                    if (isset($_GET['idEmpreendimento'])) {
                                        foreach ($contratos as $contrato) : ?>
                                            <option value="<?= $contrato['id']; ?>"
                                                <?= ($_GET['idContrato'] == $contrato['id']) ? 'selected' : '' ?>>
                                                <?= $contrato['text']; ?>
                                            </option>
                                        <?php endforeach;
                                    }?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label" for="tipo_negociacao">
                                    Tipo de operao:<span class="require" style="color: red">*</span>
                                </label><br>
                                <div class="col-sm-12">
                                    <div class="col-sm-4">
                                        <label for="tipoN"><input type="radio" class="form-control icheck tipoN"
                                                                  name="tipo" checked value="N"/>Negociao</label>
                                    </div>
                                    <div class="col-sm-5">
                                        <label for="tipoR"><input type="radio" class="form-control icheck tipoR"
                                                                  name="tipo" value="R"/>Refinanciamento</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group col-sm-3" id="divAtrasadas">
                            <label class="control-label"> Exibio de parcelas:</label><br>
                            <div class="col-sm-12">
                                <div class="col-sm-4">
                                    <label for="tipoA"><input type="radio" class="form-control icheck tipoA" name="tipos" checked value="A"/>Atrasadas</label>
                                </div>
                                <div class="col-sm-4">
                                    <label for="tipoT"><input type="radio" class="form-control icheck tipoT" name="tipos" value="T"/>Todas</label>
                                </div>
                            </div>
                        </div>
                        <div class="form-group col-sm-3" id="incluirSinal">
                            <label class="control-label"> Incluir sinal?</label><br>
                            <div class="col-sm-12">
                                <div class="col-sm-4">
                                    <label for="sinalS"><input type="radio" class="form-control icheck tipoA" name="sinal" value="S"/>Sim</label>
                                </div>
                                <div class="col-sm-4">
                                    <label for="sinalN"><input type="radio" class="form-control icheck tipoT" name="sinal" value="N" checked/>No</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>
                <fieldset>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" id="avanca" value="Avanar">
                            </div>
                            <div class="form-group col-sm-2">
                                <a href="?m=fin&c=negociacao&a=listar" class="btn btn-danger col-sm-12">Cancelar</a>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>
        </div>
    </div>
</div>
<div class="modal fade mVisualizarNegociacao " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Parte 1 - Negociao/Refinanciamento - Negociao de Parcelas em atraso</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/j2Sq9QjHanQ?si=qxWVqnW8gPIbj8EY" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<div class="modal fade mVisualizarRefinanciamento " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Parte 2 - Negociao/Refinanciamento - Refinanciando Saldo Devedor</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/W8i7nmI4EuI?si=KSUa5F8DtIHwd6Ce" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>





